/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.SpectralSpecCollection;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.editors.schedblock.TargetEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.misc.SummaryTableModel;
import alma.obsprep.ot.models.schedblock.FieldSourceModel;
import alma.obsprep.ot.models.schedblock.OpticalCameraSpecModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterTabModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class TargetModel
extends Model {
    private FieldSourceModel fieldSourceModel = new FieldSourceModel(null);
    private SpectralSpecModel spectralSpecModel = new SpectralSpecModel(null);
    private OpticalCameraSpecModel opticalCameraSpecModel = new OpticalCameraSpecModel(null);
    private ObservingParameterTabModel observingParameterTabModel = new ObservingParameterTabModel(null);
    private SummaryTableModel fieldSourceSummaryTableModel = null;
    private SummaryTableModel spectralSpecSummaryTableModel = null;

    public TargetModel(Object object, ObservingToolController observingToolController) {
        super(object);
        this.fieldSourceSummaryTableModel = new SummaryTableModel(null, observingToolController);
        this.spectralSpecSummaryTableModel = new SummaryTableModel(null, observingToolController);
        this.registerSubModel(this.fieldSourceModel);
        this.registerSubModel(this.spectralSpecModel);
        this.registerSubModel(this.opticalCameraSpecModel);
        this.registerSubModel(this.observingParameterTabModel);
        this.registerSubModel(this.fieldSourceSummaryTableModel);
        this.registerSubModel(this.spectralSpecSummaryTableModel);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == TargetModel.this.spectralSpecModel.getRestFrequencyModel()) {
                    TargetModel.this.fieldSourceModel.getFieldPatternModel().updateBeamsizeFields();
                }
            }
        };
        this.spectralSpecModel.getRestFrequencyModel().subscribe(modelChangeSubscriber);
        final ValueUnitPairModel valueUnitPairModel = this.observingParameterTabModel.getScienceModel().getSubScanDurationModel();
        ModelChangeSubscriber modelChangeSubscriber2 = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == valueUnitPairModel) {
                    TargetModel.this.fieldSourceModel.getFieldPatternModel().updateScanVelocityField();
                }
            }
        };
        valueUnitPairModel.subscribe(modelChangeSubscriber2);
    }

    public Target getTarget() {
        return (Target)this.getDocument();
    }

    @Override
    public void publish() {
        this.publish(TargetEditor.DOCUMENT_FID, this.document);
        if (this.document != null) {
            this.fieldSourceModel.publish();
            this.spectralSpecModel.publish();
            this.opticalCameraSpecModel.publish();
            this.observingParameterTabModel.publish();
            this.fieldSourceSummaryTableModel.publish();
            this.spectralSpecSummaryTableModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        return string;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        Target target = this.getTarget();
        this.observingParameterTabModel.setDocument(target);
        this.fieldSourceModel.setDocument(target);
        this.spectralSpecModel.setDocument(target);
        this.opticalCameraSpecModel.setDocument(target);
        SchedBlock schedBlock = this.getTarget().getSchedBlock();
        FieldSourceCollection fieldSourceCollection = new FieldSourceCollection(schedBlock);
        this.fieldSourceSummaryTableModel.setDocument(fieldSourceCollection);
        SpectralSpecCollection spectralSpecCollection = new SpectralSpecCollection(schedBlock);
        this.spectralSpecSummaryTableModel.setDocument(spectralSpecCollection);
        this.publish();
    }

    public void duplicateFieldSource() {
        Target target = this.getTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        FieldSource fieldSource = target.getFieldSource();
        FieldSource fieldSource2 = fieldSource.deepCopy();
        fieldSource2.setName("Copy of " + fieldSource.getNameOrDefault());
        schedBlock.addFieldSource(fieldSource2);
        target.setFieldSource(fieldSource2);
        this.setDocument(target);
    }

    public void duplicateSpectralSpec() {
        this.duplicateInstrumentSpec();
    }

    public void duplicateInstrumentSpec() {
        Target target = this.getTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        AbstractInstrumentSpec abstractInstrumentSpec = target.getAbstractInstrumentSpec();
        AbstractInstrumentSpec abstractInstrumentSpec2 = abstractInstrumentSpec.deepCopy();
        abstractInstrumentSpec2.setName("Copy of " + abstractInstrumentSpec.getNameOrDefault());
        if (abstractInstrumentSpec.isOpticalCameraSpec()) {
            schedBlock.addOpticalCameraSpec((OpticalCameraSpec)((Object)abstractInstrumentSpec2));
            target.setOpticalCameraSpec((OpticalCameraSpec)((Object)abstractInstrumentSpec2));
        } else {
            schedBlock.addSpectralSpec((SpectralSpec)((Object)abstractInstrumentSpec2));
            target.setSpectralSpec((SpectralSpec)((Object)abstractInstrumentSpec2));
        }
        this.setDocument(target);
    }

    public ObservingParameters duplicateObservingParameters(AddInteractor.ObjectType objectType) {
        Target target = this.getTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        ObservingParameters observingParameters = target.getObservingParameters(objectType);
        ObservingParameters observingParameters2 = observingParameters.deepCopy();
        observingParameters2.setName("Copy of " + observingParameters.getNameOrDefault());
        schedBlock.addObservingParameters(observingParameters2);
        target.removeObservingParameters(observingParameters);
        target.addObservingParameters(observingParameters2);
        this.setDocument(target);
        return observingParameters2;
    }

    public FieldSourceModel getFieldSourceModel() {
        return this.fieldSourceModel;
    }

    public SpectralSpecModel getSpectralSpecModel() {
        return this.spectralSpecModel;
    }

    public OpticalCameraSpecModel getOpticalCameraSpecModel() {
        return this.opticalCameraSpecModel;
    }

    public ObservingParameterTabModel getObservingParameterTabModel() {
        return this.observingParameterTabModel;
    }

    public SummaryTableModel getFieldSourceSummaryTableModel() {
        return this.fieldSourceSummaryTableModel;
    }

    public SummaryTableModel getSpectralSpecSummaryTableModel() {
        return this.spectralSpecSummaryTableModel;
    }
}

