/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.CalibratorParameterEditor;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Time;
import java.util.Arrays;

public abstract class CalibratorParameterModel
extends ObservingParameterModel {
    private ValueUnitPairModel cycleTimeModel;
    private ValueUnitPairModel repeatIntervalTimeModel;
    private ValueUnitPairModel defaultIntegrationTimeModel;
    private ExpertParametersModel expertParametersModel;
    private ValueUnitPairModel subScanDurationModel;
    private Time repeatInterval = Time.createTimeSec(15.0);
    private String dataOrigin;

    public CalibratorParameterModel(CalibratorParameters calibratorParameters) {
        super((ObservingParameters)((Object)calibratorParameters));
        this.cycleTimeModel = new ValueUnitPairModel(null, CalibratorParameterEditor.FID_CYCLETIME_VALUE, CalibratorParameterEditor.FID_CYCLETIME_UNIT);
        this.repeatIntervalTimeModel = new ValueUnitPairModel(null, CalibratorParameterEditor.FID_REPEATINTERVALTIME_VALUE, CalibratorParameterEditor.FID_REPEATINTERVALTIME_UNIT);
        this.repeatIntervalTimeModel.setDocument(this.repeatInterval);
        this.defaultIntegrationTimeModel = new ValueUnitPairModel(null, CalibratorParameterEditor.FID_DEFAULTINTEGRATIONTIME_VALUE, CalibratorParameterEditor.FID_DEFAULTINTEGRATIONTIME_UNIT);
        this.subScanDurationModel = new ValueUnitPairModel(null, CalibratorParameterEditor.FID_SUBSCANDURATION_VALUE, CalibratorParameterEditor.FID_SUBSCANDURATION_UNIT);
        this.subScanDurationModel.subscribe((Model model, FieldID fieldID, Object object) -> this.publishRepeatInterval());
        this.cycleTimeModel.subscribe((Model model, FieldID fieldID, Object object) -> this.publishRepeatInterval());
        this.registerSubModel(this.cycleTimeModel);
        this.registerSubModel(this.defaultIntegrationTimeModel);
        this.registerSubModel(this.subScanDurationModel);
        this.setDocument((Object)calibratorParameters);
    }

    private void publishRepeatInterval() {
        if (this.getDocument() == null || this.repeatIntervalTimeModel == null) {
            return;
        }
        this.repeatIntervalTimeModel.setDocument(this.getRepeatInterval());
    }

    public CalibratorParameters getCalibratorParameters() {
        return (CalibratorParameters)((Object)this.getDocument());
    }

    public String[] getKnownDataOriginList() {
        return CalibratorParameters.getKnownDataOriginList();
    }

    public String getDataOrigin() {
        CalibratorParameters calibratorParameters = this.getCalibratorParameters();
        return calibratorParameters.getDataOrigin();
    }

    @Override
    public void publish() {
        if (this.getDocument() == null) {
            return;
        }
        this.publish(CalibratorParameterEditor.FID_NAME, this.getCalibratorParameters().getName());
        this.publish(CalibratorParameterEditor.FID_DATA_ORIGIN, this.getCalibratorParameters().getDataOrigin());
        this.publish(ExpertParametersEditor.KEYWORDVALUE_TABLE_FID, Arrays.asList(this.getCalibratorParameters().getExpertParameter()));
        this.publish(CalibratorParameterEditor.FID_FORCEATMCAL, this.getCalibratorParameters().getForceAtmCal());
        this.publish(CalibratorParameterEditor.FID_FORCEEXECUTION, this.getCalibratorParameters().getForceExecution());
        if (this.repeatIntervalTimeModel != null) {
            this.repeatIntervalTimeModel.setDocument(this.getRepeatInterval());
        }
        if (this.cycleTimeModel != null) {
            this.cycleTimeModel.publish();
        }
        if (this.defaultIntegrationTimeModel != null) {
            this.defaultIntegrationTimeModel.publish();
        }
        if (this.expertParametersModel != null) {
            this.expertParametersModel.publish();
        }
        if (this.repeatIntervalTimeModel != null) {
            this.repeatIntervalTimeModel.publish();
        }
        if (this.subScanDurationModel != null) {
            this.subScanDurationModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        CalibratorParameters calibratorParameters = this.getCalibratorParameters();
        if (fieldID.equals(CalibratorParameterEditor.FID_NAME)) {
            String string = (String)object;
            calibratorParameters.setName(string);
            return string;
        }
        if (fieldID.equals(CalibratorParameterEditor.FID_DATA_ORIGIN)) {
            String string = (String)object;
            calibratorParameters.setDataOrigin(string);
            return string;
        }
        if (fieldID.equals(CalibratorParameterEditor.FID_CPADJUST_BUTTON)) {
            Target[] targetArray = this.getCalibratorParameters().getTargetList();
            if (targetArray.length > 0 && targetArray[0].getAbstractInstrumentSpec() != null && !(targetArray[0].getAbstractInstrumentSpec() instanceof OpticalCameraSpec)) {
                SpectralSpec spectralSpec = (SpectralSpec)((Object)targetArray[0].getAbstractInstrumentSpec());
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
                if (abstractCorrelatorConfiguration == null) {
                    return object;
                }
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
                double d = calibratorParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
                double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
                double d3 = correlatorExpert.calcSubscanDuration(d, d2, 1);
                calibratorParameters.getSubScanDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d3));
                this.getSubScanDurationModel().publish();
            }
        } else if (fieldID.equals(CalibratorParameterEditor.FID_FORCEATMCAL)) {
            Boolean bl = (Boolean)object;
            this.getCalibratorParameters().setForceAtmCal(bl);
        } else if (fieldID.equals(CalibratorParameterEditor.FID_FORCEEXECUTION)) {
            Boolean bl = (Boolean)object;
            this.getCalibratorParameters().setForceExecution(bl);
        } else if (fieldID.equals(CalibratorParameterEditor.FID_CYCLETIME_UNIT) || fieldID.equals(CalibratorParameterEditor.FID_CYCLETIME_VALUE) || fieldID.equals(CalibratorParameterEditor.FID_SUBSCANDURATION_UNIT) || fieldID.equals(CalibratorParameterEditor.FID_SUBSCANDURATION_VALUE) || fieldID.equals(CalibratorParameterEditor.FID_DEFAULTINTEGRATIONTIME_UNIT) || fieldID.equals(CalibratorParameterEditor.FID_DEFAULTINTEGRATIONTIME_VALUE)) {
            Time time = this.getRepeatInterval();
        }
        return object;
    }

    abstract Time getRepeatInterval();

    public ValueUnitPairModel getCycleTimeModel() {
        return this.cycleTimeModel;
    }

    public ValueUnitPairModel getDefaultIntegrationTimeModel() {
        return this.defaultIntegrationTimeModel;
    }

    public ValueUnitPairModel getSubScanDurationModel() {
        return this.subScanDurationModel;
    }

    @Override
    public void setDocument(Object object) {
        CalibratorParameters calibratorParameters;
        super.setDocument(object);
        if (object != null && object instanceof CalibratorParameters && (calibratorParameters = (CalibratorParameters)((Object)object)) != null) {
            this.cycleTimeModel.setDocument(calibratorParameters.getCycleTime());
            this.defaultIntegrationTimeModel.setDocument(calibratorParameters.getDefaultIntegrationTime());
            this.getUsedByTargetModel().setDocument((AttachableToTarget)((Object)calibratorParameters), this.isTargetContext());
            this.getExpertParametersModel().setDocument((Object)calibratorParameters);
            this.subScanDurationModel.setDocument(calibratorParameters.getSubScanDuration());
        }
    }

    public ValueUnitPairModel getRepeatIntervalTimeModel() {
        return this.repeatIntervalTimeModel;
    }
}

