/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.observingparameters.HolographyParameterEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Frequency;

public class HolographyParameterModel
extends Model {
    private ValueUnitPairModel frequencyModel;
    private ValueUnitPairModel speedModel;
    private ValueUnitPairModel calTimeModel;
    private ValueUnitPairModel rowSizeModel;
    String[] stdFreqsGHz;

    public HolographyParameterModel(HolographyParameters holographyParameters) {
        super((Object)holographyParameters);
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        this.stdFreqsGHz = OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getStandardHolographyFrequencies(), Frequency.UNIT_GHZ);
        this.frequencyModel = new ValueUnitPairModel(null, HolographyParameterEditor.FID_FREQUENCY_VALUE, HolographyParameterEditor.FID_FREQUENCY_UNIT);
        this.registerSubModel(this.frequencyModel);
        this.speedModel = new ValueUnitPairModel(null, HolographyParameterEditor.FID_SPEED_VALUE, HolographyParameterEditor.FID_SPEED_UNIT);
        this.registerSubModel(this.speedModel);
        this.calTimeModel = new ValueUnitPairModel(null, HolographyParameterEditor.FID_CALTIME_VALUE, HolographyParameterEditor.FID_CALTIME_UNIT);
        this.registerSubModel(this.calTimeModel);
        this.rowSizeModel = new ValueUnitPairModel(null, HolographyParameterEditor.FID_ROWSIZE_VALUE, HolographyParameterEditor.FID_ROWSIZE_UNIT);
        this.registerSubModel(this.rowSizeModel);
        this.setDocument((Object)holographyParameters);
    }

    public HolographyParameters getHolographyParameters() {
        return (HolographyParameters)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        if (this.getDocument() == null) {
            return;
        }
        this.publish(HolographyParameterEditor.FID_NAME, this.getHolographyParameters().getName());
        this.publish(HolographyParameterEditor.FID_TOWERNAME, this.getHolographyParameters().getTowerName());
        this.publish(HolographyParameterEditor.FID_SCANDIRECTION, this.getHolographyParameters().getScanDirection());
        this.publish(HolographyParameterEditor.FID_STARTFRACTION, this.getHolographyParameters().getStartFraction());
        this.publish(HolographyParameterEditor.FID_CALMODE, this.getHolographyParameters().getCalMode());
        this.publish(HolographyParameterEditor.FID_ROWSCAL, this.getHolographyParameters().getRowsCal());
        this.publish(HolographyParameterEditor.FID_NROWS, this.getHolographyParameters().getNRows());
        if (this.frequencyModel != null) {
            this.frequencyModel.publish();
            String[] stringArray = this.getFrequencyOptions();
            String string = "Not found";
            String string2 = String.valueOf(this.getHolographyParameters().getFrequency().getContentInGHz());
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].contains(string2)) continue;
                string = stringArray[i];
            }
            this.publish(HolographyParameterEditor.FID_FREQUENCY_OPTIONS, string);
        }
        if (this.speedModel != null) {
            this.speedModel.publish();
        }
        if (this.calTimeModel != null) {
            this.calTimeModel.publish();
        }
        if (this.rowSizeModel != null) {
            this.rowSizeModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2 = null;
        if (fieldID.equals(HolographyParameterEditor.FID_NAME)) {
            String string = (String)object;
            this.getHolographyParameters().setName(string);
            object2 = string;
        } else if (fieldID.equals(HolographyParameterEditor.FID_TOWERNAME)) {
            String string = (String)object;
            this.getHolographyParameters().setTowerName(string);
            object2 = string;
        } else if (fieldID.equals(HolographyParameterEditor.FID_FREQUENCY_OPTIONS)) {
            String string = (String)object;
            for (int i = 0; i < this.stdFreqsGHz.length; ++i) {
                String string2 = this.stdFreqsGHz[i];
                if (!string.equals(string2)) continue;
                this.frequencyModel.update(editor, HolographyParameterEditor.FID_FREQUENCY_VALUE, string2);
                this.frequencyModel.publish(HolographyParameterEditor.FID_FREQUENCY_VALUE, string2);
                this.frequencyModel.update(editor, HolographyParameterEditor.FID_FREQUENCY_UNIT, "GHz");
                this.frequencyModel.publish(HolographyParameterEditor.FID_FREQUENCY_UNIT, "GHz");
            }
            object2 = string;
        } else if (fieldID.equals(HolographyParameterEditor.FID_SCANDIRECTION)) {
            String string = (String)object;
            this.getHolographyParameters().setScanDirection(string);
            object2 = string;
        } else if (fieldID.equals(HolographyParameterEditor.FID_STARTFRACTION)) {
            Double d = Double.valueOf((String)object);
            this.getHolographyParameters().setStartFraction(d);
            object2 = d;
        } else if (fieldID.equals(HolographyParameterEditor.FID_CALMODE)) {
            String string = (String)object;
            this.getHolographyParameters().setCalMode(string);
            object2 = string;
        } else if (fieldID.equals(HolographyParameterEditor.FID_ROWSCAL)) {
            Integer n = Integer.valueOf((String)object);
            this.getHolographyParameters().setRowsCal(n);
            object2 = n;
        } else if (fieldID.equals(HolographyParameterEditor.FID_UNISCAN)) {
            Boolean bl = (Boolean)object;
            this.getHolographyParameters().setUniDirectionalScan(bl);
            object2 = bl;
        } else if (fieldID.equals(HolographyParameterEditor.FID_FREQUENCY_VALUE)) {
            object2 = this.frequencyModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_FREQUENCY_UNIT)) {
            object2 = this.frequencyModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_SPEED_VALUE)) {
            object2 = this.speedModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_SPEED_UNIT)) {
            object2 = this.speedModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_CALTIME_VALUE)) {
            object2 = this.calTimeModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_CALTIME_UNIT)) {
            object2 = this.calTimeModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_ROWSIZE_VALUE)) {
            object2 = this.rowSizeModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_ROWSIZE_UNIT)) {
            object2 = this.rowSizeModel.update(editor, fieldID, object);
        } else if (fieldID.equals(HolographyParameterEditor.FID_NROWS)) {
            Integer n = Integer.valueOf((String)object);
            this.getHolographyParameters().setNRows(n);
            object2 = n;
        }
        return object2;
    }

    public String[] getFrequencyOptions() {
        return this.stdFreqsGHz;
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public ValueUnitPairModel getSpeedModel() {
        return this.speedModel;
    }

    public ValueUnitPairModel getCalTimeModel() {
        return this.calTimeModel;
    }

    public ValueUnitPairModel getRowSizeModel() {
        return this.rowSizeModel;
    }

    @Override
    public void setDocument(Object object) {
        HolographyParameters holographyParameters;
        if (object != null && object instanceof HolographyParameters && (holographyParameters = (HolographyParameters)((Object)object)) != null) {
            this.frequencyModel.setDocument((Object)holographyParameters.getFrequency());
            this.speedModel.setDocument((Object)holographyParameters.getSpeed());
            this.calTimeModel.setDocument(holographyParameters.getCalTime());
            this.rowSizeModel.setDocument((Object)holographyParameters.getRowSize());
        }
        super.setDocument(object);
    }
}

