/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.sciencegoals.ProperMotionModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.util.List;

public abstract class AbstractTargetModel
extends ProperMotionModel {
    private static final Integer NAME_DUFF_REVERT_BACK = 0;
    private final ValueUnitPairModel expectedPeakFluxDensity;
    private final ValueUnitPairModel expectedPeakLineFluxDensity;
    private final UserUnitValueUnitPairModel expectedLineWidth;
    private final NameResolver nameResolver;
    private final Log.Logger logger = Log.logger((Object)this);
    private Object previousTP = null;

    public AbstractTargetModel(AbstractTargetParameters abstractTargetParameters) {
        super(abstractTargetParameters);
        this.sourceCoordinatesModel = new SkyCoordsModel(null);
        this.sourceVelocityModel = new VelocityModel(null, AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE, AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT, AbstractTargetEditor.FID_SOURCEVELOCITY_SYSTEM, AbstractTargetEditor.FID_SOURCEVELOCITY_DOPPLER, AbstractTargetEditor.FID_SOURCEVELOCITY_REDSHIFT);
        this.expectedPeakFluxDensity = new ValueUnitPairModel(null, AbstractTargetEditor.FID_PEAKFLUXDENSITY_VALUE, AbstractTargetEditor.FID_PEAKFLUXDENSITY_UNIT);
        this.expectedPeakLineFluxDensity = new ValueUnitPairModel(null, AbstractTargetEditor.FID_PEAKLINEFLUXDENSITY_VALUE, AbstractTargetEditor.FID_PEAKLINEFLUXDENSITY_UNIT);
        this.expectedLineWidth = new UserUnitValueUnitPairModel(null, AbstractTargetEditor.FID_LINEWIDTH_VALUE, AbstractTargetEditor.FID_LINEWIDTH_UNIT);
        this.registerSubModel(this.sourceCoordinatesModel);
        this.registerSubModel(this.sourceVelocityModel);
        this.registerSubModel(this.expectedPeakFluxDensity);
        this.registerSubModel(this.expectedPeakLineFluxDensity);
        this.registerSubModel(this.expectedLineWidth);
        this.nameResolver = new NameResolver();
    }

    public AbstractTargetParameters getAbstractTarget() {
        TargetParameters targetParameters;
        if (this.document == null) {
            return null;
        }
        try {
            targetParameters = (TargetParameters)((SpatialDocument)this.document).getSpatialPartOfSpatialDocument();
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected document : " + this.document.getClass().getSimpleName());
            return null;
        }
        return targetParameters;
    }

    public SkyCoordinates getTargetCenter() {
        return this.getSourceCoordinates();
    }

    public SkyCoordinates getSourceCoordinates() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (abstractTargetParameters == null) {
            return null;
        }
        return abstractTargetParameters.getSourceCoordinates();
    }

    @Override
    public void publish() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (abstractTargetParameters == null) {
            return;
        }
        if (abstractTargetParameters.getSourceName().equals("")) {
            abstractTargetParameters.setPreviousResolvedTargetName(null);
        }
        this.publish(AbstractTargetEditor.FID_SOURCENAME, this.getAbstractTarget().getSourceName());
        this.publish(AbstractTargetEditor.FID_NONSIDEREALMOTION, this.getAbstractTarget().getNonSiderealMotion());
        this.publish(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT, this.getAbstractTarget().getSolarSystemObject());
        this.publish(AbstractTargetEditor.FID_SOURCEEPHEMERIS, this.getAbstractTarget().getSourceEphemeris());
        this.publish(AbstractTargetEditor.FID_CONTINUUM_LINEAR_POLARIZATION, this.getAbstractTarget().getExpectedProperties().getDesiredPolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_LINE_POLARIZATION_PERCENTAGE, this.getAbstractTarget().getExpectedProperties().getDesiredLinePolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_SOLAR_ACTIVITY, this.getAbstractTarget().getExpectedProperties().getSolarActivityLevel());
        this.publish(AbstractTargetEditor.FID_CONTINUUM_CIRCULAR_POLARIZATION, this.getAbstractTarget().getExpectedProperties().getDesiredCircularPolarizationPercentage());
        this.publish(AbstractTargetEditor.FID_SPECTRALLINE_CIRCULAR_POLARIZATION, this.getAbstractTarget().getExpectedProperties().getDesiredLineCircularPolarizationPercentage());
        this.sourceCoordinatesModel.publish();
        this.getPmRAModel().publish();
        this.getPmDecModel().publish();
        this.getParallaxModel().publish();
        this.sourceVelocityModel.publish();
        this.expectedPeakFluxDensity.publish();
        this.expectedPeakLineFluxDensity.publish();
        this.expectedLineWidth.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (fieldID.equals(AbstractTargetEditor.FID_SOURCENAME)) {
            String string = (String)object;
            if (abstractTargetParameters.hasNoPreviousTargetName()) {
                abstractTargetParameters.setPreviousTargetName(abstractTargetParameters.getSourceName());
            }
            abstractTargetParameters.setSourceName(string);
            return string;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_NONSIDEREALMOTION)) {
            Boolean bl = (Boolean)object;
            if (this.previousTP != null && this.previousTP.equals(abstractTargetParameters) && abstractTargetParameters.getNonSiderealMotion() != bl.booleanValue()) {
                if (!bl.booleanValue()) {
                    this.zeroNonSolarSystemFields(false);
                    abstractTargetParameters.setSourceName("");
                } else {
                    abstractTargetParameters.setSourceName(AbstractTargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED);
                    abstractTargetParameters.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
                }
                this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
                this.sourceVelocityModel.publish();
            }
            abstractTargetParameters.setNonSiderealMotion(bl);
            this.previousTP = abstractTargetParameters;
            if (!bl.booleanValue()) {
                abstractTargetParameters.setSolarSystemObject(AbstractTargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED);
                this.publish(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT, abstractTargetParameters.getSolarSystemObject());
                abstractTargetParameters.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
                this.sourceVelocityModel.publish();
            }
            if (bl.booleanValue() && abstractTargetParameters.getSolarSystemObject() != null && abstractTargetParameters.getSolarSystemObject().equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS)) {
                this.setEphemerisAttributesInDocument(abstractTargetParameters, abstractTargetParameters.getSourceEphemeris());
            }
            this.publish(AbstractTargetEditor.FID_NONSIDEREALMOTION, bl);
            return bl;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT)) {
            String string = (String)object;
            abstractTargetParameters.setSolarSystemObject(string);
            if (string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_SUN)) {
                this.setEphemerisAttributesInDocument(abstractTargetParameters, abstractTargetParameters.getSourceEphemeris());
            } else {
                abstractTargetParameters.setSourceName(string);
            }
            this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
            return string;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_SOURCEEPHEMERIS)) {
            String string = (String)object;
            abstractTargetParameters.setSourceEphemeris(string);
            this.setEphemerisAttributesInDocument(abstractTargetParameters, string);
            return string;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_RESOLVENAME)) {
            this.resolveName();
            return null;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_RESOLVECANCEL)) {
            return null;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_CONTINUUM_LINEAR_POLARIZATION)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
            }
            catch (OutOfRangeException | NumberFormatException exception) {
                // empty catch block
            }
            abstractTargetParameters.getExpectedProperties().setDesiredPolarizationPercentage(d);
            return new Double(d);
        }
        if (fieldID.equals(AbstractTargetEditor.FID_SOLAR_ACTIVITY)) {
            String string = (String)object;
            abstractTargetParameters.getExpectedProperties().setSolarActivityLevel(string);
            return string;
        }
        if (fieldID.equals(AbstractTargetEditor.FID_LINE_POLARIZATION_PERCENTAGE)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
            }
            catch (OutOfRangeException | NumberFormatException exception) {
                // empty catch block
            }
            abstractTargetParameters.getExpectedProperties().setDesiredLinePolarizationPercentage(d);
            return new Double(d);
        }
        if (fieldID.equals(AbstractTargetEditor.FID_CONTINUUM_CIRCULAR_POLARIZATION)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
            }
            catch (OutOfRangeException | NumberFormatException exception) {
                // empty catch block
            }
            abstractTargetParameters.getExpectedProperties().setDesiredCircularPolarizationPercentage(d);
            return new Double(d);
        }
        if (fieldID.equals(AbstractTargetEditor.FID_SPECTRALLINE_CIRCULAR_POLARIZATION)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble(object, 0.0, 100.0);
            }
            catch (OutOfRangeException | NumberFormatException exception) {
                // empty catch block
            }
            abstractTargetParameters.getExpectedProperties().setDesiredLineCircularPolarizationPercentage(d);
            return new Double(d);
        }
        return object;
    }

    private void setEphemerisAttributesInDocument(AbstractTargetParameters abstractTargetParameters, String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        OTHorizonParser oTHorizonParser = null;
        try {
            oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(this.logger, this.getClass().getName(), null), string);
            assert (oTHorizonParser != null);
            abstractTargetParameters.setSourceName(MiscUtils.getSanitizedSourceName(oTHorizonParser.getSourceName(string)));
            List list = oTHorizonParser.parseEphemeris();
            if (list.size() > 0) {
                HorizonParser.ParsedEphemerisLine parsedEphemerisLine = (HorizonParser.ParsedEphemerisLine)list.get(0);
                SkyCoordinates skyCoordinates = abstractTargetParameters.getSourceCoordinates();
                skyCoordinates.setLatitude(Latitude.createLatitude((double)parsedEphemerisLine.declination, (String)Latitude.UNIT_RAD));
                skyCoordinates.setLongitude(Longitude.createLongitude((double)parsedEphemerisLine.rightAscension, (String)Longitude.UNIT_RAD));
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
                skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
                this.sourceCoordinatesModel.publish();
            } else {
                Log.logger(AbstractTargetModel.class).warning("No ephemeris data found in the file");
            }
            this.publish(AbstractTargetEditor.FID_SOURCENAME, this.getAbstractTarget().getSourceName());
        }
        catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
            this.logger.info("Logic error: the ephemeris data should be parseable at this point : " + throwable.getMessage());
        }
    }

    @Override
    public SkyCoordsModel getSourceCoordinatesModel() {
        return this.sourceCoordinatesModel;
    }

    @Override
    public VelocityModel getSourceVelocityModel() {
        return this.sourceVelocityModel;
    }

    public ValueUnitPairModel getExpectedPeakFluxDensity() {
        return this.expectedPeakFluxDensity;
    }

    public ValueUnitPairModel getExpectedPeakLineFluxDensity() {
        return this.expectedPeakLineFluxDensity;
    }

    public UserUnitValueUnitPairModel getExpectedLineWidth() {
        return this.expectedLineWidth;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            this.setDocumentToSubModels(object);
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    protected void setDocumentToSubModels(Object object) {
        if (object == null) {
            return;
        }
        this.sourceCoordinatesModel.setonlyDocument(this.getAbstractTarget().getSourceCoordinates());
        this.getPmRAModel().setonlyDocument((Object)this.getAbstractTarget().getPmRA());
        this.getPmDecModel().setonlyDocument((Object)this.getAbstractTarget().getPmDec());
        this.getParallaxModel().setonlyDocument((Object)this.getAbstractTarget().getParallax());
        this.sourceVelocityModel.setonlyDocument((Object)this.getAbstractTarget().getSourceVelocity());
        this.expectedPeakFluxDensity.setonlyDocument((Object)this.getAbstractTarget().getExpectedProperties().getExpectedPeakFluxDensity());
        this.expectedPeakLineFluxDensity.setonlyDocument((Object)this.getAbstractTarget().getExpectedProperties().getExpectedPeakLineFluxDensity());
        this.expectedLineWidth.setonlyDocument(this.getAbstractTarget().getExpectedProperties().getExpectedLineWidth());
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        if (abstractTargetParameters.getNonSiderealMotion() && abstractTargetParameters.getSolarSystemObject().equals(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS)) {
            this.setEphemerisAttributesInDocument(abstractTargetParameters, abstractTargetParameters.getSourceEphemeris());
        }
    }

    public void resolveName() {
        AbstractTargetParameters abstractTargetParameters = this.getAbstractTarget();
        Object object = this.nameResolver.resolve(abstractTargetParameters);
        if (object != null && object instanceof Resolver) {
            ObservingToolGui observingToolGui;
            this.publish();
            this.sourceCoordinatesModel.publish(SkyCoordsModel.FID_RESOLVEDBY, ((Resolver)object).getNameServer() + " (" + ((Resolver)object).getResolverService().getResolutionServiceName() + ")");
            ObservingToolController observingToolController = ObservingToolController.getMyInstance();
            if (observingToolController != null && (observingToolGui = observingToolController.getGui()) != null) {
                observingToolGui.addInformationMessage(this.nameResolver.getFeedback());
            }
            abstractTargetParameters.setPreviousResolvedTargetName(abstractTargetParameters.getSourceName());
        } else {
            boolean bl;
            boolean bl2 = bl = object instanceof Integer && (Integer)object == NAME_DUFF_REVERT_BACK;
            if (bl) {
                boolean bl3;
                String string = abstractTargetParameters.getPreviousResolvedTargetName();
                boolean bl4 = null == string;
                boolean bl5 = bl3 = abstractTargetParameters.getSourceName() == abstractTargetParameters.getPreviousTargetName();
                if (abstractTargetParameters.hasNoPreviousResolvedTargetName()) {
                    string = bl4 || bl3 ? "" : abstractTargetParameters.getPreviousTargetName();
                }
                abstractTargetParameters.setSourceName(string);
                this.publish(AbstractTargetEditor.FID_SOURCENAME, abstractTargetParameters.getSourceName());
            }
        }
    }
}

