/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.misc.FieldSetupSummaryTableLoader;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialPartModel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Flux;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.data.SkyCoordinatesData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldSetupModel
extends Model
implements SpatialPartModel {
    private static DialogId DIALOG_OUT_OF_RANGE = new DialogId("ExportTargets.OutOfRange", "Exporting to file. Coordinates out of range");
    private static DialogId DIALOG_INVALID_COORDS = new DialogId("ExportTargets.InvalidCoords", "Exporting to file. Invalid coordinates");
    private static DialogId DIALOG_FILE_IO_ERROR = new DialogId("ExportTargets.WriteFileProblem", "Exporting to file. Problem while writing file");
    private static DialogId DIALOG_IGNORE_COORDINATES = new DialogId("ExportTargets.UnsupportedCoordinates", "Exporting to file. Ignoring unsupported coordinates");
    private static final String EXPORT_HEADER_SEPARATOR = "--   This signals end of the header\n";
    private static final String EXPORT_TARGETS_HEADER = "Name, RA |Galactic Long (Degs), Dec|Galactic Lat(Degs), PMRA(mas/yr), PMDec(mas/yr), vel(km/s), ref frame, Doppler type, peak cont flux(mJy), peak line flux(mJy), cont pol(%), line pol(%), line width(km/s), cont circular pol (%), line circular pol (%)\n";
    private TargetParametersModel targetParametersModel;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public FieldSetupModel(ScienceGoal scienceGoal) {
        super(scienceGoal);
        this.targetParametersModel = new TargetParametersModel(null);
        this.registerSubModel(this.targetParametersModel);
        this.publish();
    }

    public ScienceGoal getScienceGoal() {
        return (ScienceGoal)this.getDocument();
    }

    public TargetParameters[] getTargetParameters() {
        return this.getScienceGoal().getTargetParameters();
    }

    public TargetParameters getTargetParameters(int n) {
        try {
            return this.getScienceGoal().getTargetParameters()[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void publish() {
        if (this.getScienceGoal() != null) {
            this.publish(FieldSetupEditor.FID_TABBEDPANE, this.getScienceGoal());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FieldSetupEditor.FID_ADD_BUTTON) {
            ScienceGoal scienceGoal = this.getScienceGoal();
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            String string = scienceGoal.getFieldType();
            targetParameters.setType(string);
            this.getScienceGoal().addTargetParameters(targetParameters);
            if (TargetParameters.TYPE_F_SINGLERECTANGLE.equals(string)) {
                targetParameters.clearField();
                Rectangle rectangle = Rectangle.createRectangle();
                rectangle.getCentre().setType(SkyCoordinates.TYPE_RELATIVE);
                targetParameters.addField((Field)((Object)rectangle));
                targetParameters.setIsMosaic(true);
            }
            this.publish();
        } else if (fieldID == FieldSetupEditor.FID_DELETE_BUTTON) {
            TargetParameters targetParameters = this.targetParametersModel.getTargetParameters();
            this.getScienceGoal().removeTargetParameters(targetParameters);
            this.publish();
        } else if (fieldID == FieldSetupEditor.FID_CLONE_BUTTON) {
            this.cloneExistingSource(this.targetParametersModel.getTargetParameters());
        } else if (fieldID == FieldSetupEditor.FID_DEBUGPRINT_BUTTON) {
            System.out.println(">>> SGFieldSetupEditor : Debug Print <<<");
            ScienceGoal scienceGoal = this.getScienceGoal();
            if (scienceGoal == null) {
                System.out.println("sg is null");
            } else {
                System.out.println(scienceGoal.toXml());
            }
        } else if (fieldID == FieldSetupEditor.FID_DELETE_ALL_BUTTON) {
            TargetParameters targetParameters = TargetParameters.createTargetParameters();
            this.getScienceGoal().clearTargetParameters();
            this.getScienceGoal().addTargetParameters(targetParameters);
            this.targetParametersModel.setDocument(targetParameters);
            this.publish();
        }
        return object;
    }

    private void cloneExistingSource(TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetToClone");
        }
        TargetParameters targetParameters2 = targetParameters.deepCopy();
        targetParameters2.setSourceName("Copy of " + targetParameters.getSourceName());
        this.getScienceGoal().addTargetParameters(targetParameters2);
        this.publish();
    }

    private void addToParent(List list, String string) {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: list");
        }
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: fieldPatternType");
        }
        Iterator iterator = list.iterator();
        ScienceGoal scienceGoal = this.getScienceGoal();
        while (iterator.hasNext()) {
            try {
                TargetParameters targetParameters = (TargetParameters)iterator.next();
                targetParameters.setType(string);
                if (string.equals(FieldTypeInfo.F_SingleRectangle.getValue())) {
                    targetParameters.clearField();
                    targetParameters.addField((Field)((Object)Rectangle.createRectangle()));
                    targetParameters.setIsMosaic(true);
                }
                scienceGoal.addTargetParameters(targetParameters);
            }
            catch (ClassCastException classCastException) {}
        }
        this.publish();
    }

    public void loadFromFile(File file, boolean bl) {
        Boolean bl2;
        FieldSetupSummaryTableLoader fieldSetupSummaryTableLoader = new FieldSetupSummaryTableLoader();
        if (fieldSetupSummaryTableLoader == null) {
            return;
        }
        try {
            bl2 = fieldSetupSummaryTableLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        if (!bl2.booleanValue()) {
            return;
        }
        TargetParameters targetParameters = this.getScienceGoal().getTargetParameters(0);
        String string = targetParameters.getType();
        if (string == null) {
            throw new NullPointerException("FieldPattern associated with source " + targetParameters.getSourceName() + " is set to null");
        }
        if (!bl) {
            this.getScienceGoal().clearTargetParameters();
        }
        if (!fieldSetupSummaryTableLoader.getList().isEmpty()) {
            this.addToParent(fieldSetupSummaryTableLoader.getList(), string);
        }
    }

    private boolean isCoordinatesSupportedForExport(TargetParameters targetParameters) {
        String string = targetParameters.getSourceCoordinates().getSystem();
        return !string.equals(SkyCoordinatesData.SYSTEM_ECLIPTIC) && !string.equals(SkyCoordinatesData.SYSTEM_HORIZON) && !string.equals(SkyCoordinatesData.SYSTEM_AZEL);
    }

    /*
     * WARNING - void declaration
     */
    public void exportTargetsToFile(File file) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(EXPORT_TARGETS_HEADER);
            fileWriter.write(EXPORT_HEADER_SEPARATOR);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (!this.isCoordinatesSupportedForExport(targetParameters)) {
                    arrayList.add(targetParameters.getSourceName());
                    continue;
                }
                boolean bl = targetParameters.getSourceCoordinates().isGalactic();
                SkyCoordinates skyCoordinates = bl ? targetParameters.getSourceCoordinates() : targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
                ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
                String string = new String();
                string = string + targetParameters.getSourceName() + ", ";
                try {
                    if (bl) {
                        string = string + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ", ";
                        string = string + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + ", ";
                    } else {
                        string = string + skyCoordinates.getLongitude().toHHMMSS() + ", ";
                        string = string + skyCoordinates.getLatitude().toDDMMSS() + ", ";
                    }
                }
                catch (InvalidCoordException | OutOfRangeException exception) {
                    exception.printStackTrace();
                }
                string = string + Double.toString(targetParameters.getPMRA().getContent()) + ", ";
                string = string + Double.toString(targetParameters.getPMDec().getContent()) + ", ";
                string = string + Double.toString(targetParameters.getSourceVelocity().getCenterVelocity().getContent()) + ", ";
                string = string + targetParameters.getSourceVelocity().getReferenceSystem() + ", ";
                string = string + targetParameters.getSourceVelocity().getDopplerCalcType() + ", ";
                string = string + Double.toString(expectedProperties.getExpectedPeakFluxDensity().getContentInUnits(Flux.UNIT_MJY)) + ", ";
                string = string + Double.toString(expectedProperties.getExpectedPeakLineFluxDensity().getContentInUnits(Flux.UNIT_MJY)) + ", ";
                string = string + Double.toString(expectedProperties.getDesiredPolarizationPercentage()) + ", ";
                string = string + Double.toString(expectedProperties.getDesiredLinePolarizationPercentage()) + ", ";
                string = string + Double.toString(expectedProperties.getExpectedLineWidth().getContentInUnits(UserFrequency.USERUNIT_KM_S)) + ",";
                string = string + Double.toString(expectedProperties.getDesiredCircularPolarizationPercentage()) + ", ";
                string = string + Double.toString(expectedProperties.getDesiredLineCircularPolarizationPercentage()) + "\n";
                fileWriter.write(string);
            }
            fileWriter.close();
            if (arrayList.size() > 0) {
                void string2;
                String iOException2 = "Only ICRS, J2000 and Galactic coordinate systems supported.\nThe following targets were not exported:\n\n";
                for (String string : arrayList) {
                    String string3 = (String)string2 + string + "\n";
                }
                GUIUtilities.warning(DIALOG_IGNORE_COORDINATES, string2);
            }
        }
        catch (IOException iOException) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string4 = "Problem occurred while writing\ntargets to " + string;
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, string4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void exportParametersToFile(File file, boolean bl, FieldSetupEditor.coordsFormat coordsFormat2) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string = new String();
            if (bl) {
                string = string + "Source Name, ";
            }
            if (coordsFormat2 == FieldSetupEditor.coordsFormat.SEXAGESIMAL) {
                string = string + "RA(sexagesimal) , Dec(sexagesimal)\n";
            } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.DEGREES) {
                string = string + "RA(degrees) , Dec(degrees)\n";
            } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.RADIANS) {
                string = string + "RA(radians) , Dec(radians)\n";
            }
            fileWriter.write(string);
            fileWriter.write(EXPORT_HEADER_SEPARATOR);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                String string2;
                if (!this.isCoordinatesSupportedForExport(targetParameters)) {
                    arrayList.add(targetParameters.getSourceName());
                    continue;
                }
                String string3 = new String();
                SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getICRSSkyCoordinates();
                if (bl) {
                    string3 = string3 + targetParameters.getSourceName() + ", ";
                }
                try {
                    if (coordsFormat2 == FieldSetupEditor.coordsFormat.SEXAGESIMAL) {
                        string3 = string3 + skyCoordinates.getLongitude().toHHMMSS() + ", ";
                        string3 = string3 + skyCoordinates.getLatitude().toDDMMSS() + "\n";
                    } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.DEGREES) {
                        string3 = string3 + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ", ";
                        string3 = string3 + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + "\n";
                    } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.RADIANS) {
                        string3 = string3 + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ", ";
                        string3 = string3 + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + "\n";
                    }
                }
                catch (OutOfRangeException outOfRangeException) {
                    string2 = "Parameter coordinates out of range for " + targetParameters.getSourceName() + ".\nPlease check your system coordinates.";
                    GUIUtilities.error(DIALOG_OUT_OF_RANGE, string2);
                }
                catch (InvalidCoordException invalidCoordException) {
                    string2 = "Invalid parameter coordinates for " + targetParameters.getSourceName() + ".\nPlease check your system coordinates.";
                    GUIUtilities.error(DIALOG_INVALID_COORDS, string2);
                }
                fileWriter.write(string3);
            }
            fileWriter.close();
            if (arrayList.size() > 0) {
                void var8_14;
                String string4 = "Only ICRS, J2000 and Galactic coordinate systems supported.\nThe following targets were not exported:\n\n";
                for (String string5 : arrayList) {
                    String string6 = (String)var8_14 + string5 + "\n";
                }
                GUIUtilities.warning(DIALOG_IGNORE_COORDINATES, var8_14);
            }
        }
        catch (IOException iOException) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string5 = "Problem occurred while writing target parameter\ncoordinates to " + string;
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, string5);
        }
    }

    public void exportPointingsToFile(File file, FieldSetupEditor.coordsFormat coordsFormat2) {
        ScienceGoal scienceGoal = this.getScienceGoal();
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string = new String();
            if (coordsFormat2 == FieldSetupEditor.coordsFormat.SEXAGESIMAL) {
                string = string + "RA(sexagesimal) , Dec(sexagesimal)\n";
            } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.DEGREES) {
                string = string + "RA(degrees) , Dec(degrees)\n";
            } else if (coordsFormat2 == FieldSetupEditor.coordsFormat.RADIANS) {
                string = string + "RA(radians) , Dec(radians)\n";
            }
            fileWriter.write(string);
            fileWriter.write(EXPORT_HEADER_SEPARATOR);
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                String string2 = new String();
                string2 = string2 + "# Source Name: " + targetParameters.getSourceName() + "\n";
                fileWriter.write(string2);
                string2 = new String();
                try {
                    for (SkyCoordinates skyCoordinates : targetParameters.getPointingPattern().getPhaseCenterCoordinates()) {
                        if (coordsFormat2 == FieldSetupEditor.coordsFormat.SEXAGESIMAL) {
                            string2 = string2 + skyCoordinates.getLongitude().toHHMMSS() + ", ";
                            string2 = string2 + skyCoordinates.getLatitude().toDDMMSS() + "\n";
                            continue;
                        }
                        if (coordsFormat2 == FieldSetupEditor.coordsFormat.DEGREES) {
                            string2 = string2 + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ", ";
                            string2 = string2 + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + "\n";
                            continue;
                        }
                        if (coordsFormat2 != FieldSetupEditor.coordsFormat.RADIANS) continue;
                        string2 = string2 + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ", ";
                        string2 = string2 + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + "\n";
                    }
                }
                catch (OutOfRangeException outOfRangeException) {
                    String string3 = "Pointing coordinates out of range for " + targetParameters.getSourceName() + ".\nPlease check your system coordinates.";
                    GUIUtilities.error(DIALOG_OUT_OF_RANGE, string3);
                }
                catch (InvalidCoordException invalidCoordException) {
                    String string4 = "Invalid pointing coordinates for " + targetParameters.getSourceName() + ".\nPlease check your system coordinates.";
                    GUIUtilities.error(DIALOG_INVALID_COORDS, string4);
                }
                fileWriter.write(string2);
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string5 = "Problem occurred while writing pointing\ncoordinates to " + string;
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, string5);
        }
    }

    @Override
    public void setDocument(Object object) {
        if (!(object instanceof ScienceGoal)) {
            throw new RuntimeException("Unexpected type of document");
        }
        if (object != null) {
            this.document = object;
            ScienceGoal scienceGoal = (ScienceGoal)object;
            this.targetParametersModel.setDocument(scienceGoal.getSoleTargetParameters());
        }
        this.publish();
    }

    public void setSelectedTargetParametersIndex(int n) {
        TargetParameters targetParameters = this.targetParametersModel.getTargetParameters();
        TargetParameters targetParameters2 = this.getTargetParameters(n);
        if (targetParameters2 != targetParameters) {
            this.targetParametersModel.setDocument(targetParameters2);
        }
        this.targetParametersSelectionChanged(n);
    }

    public TargetParametersModel getTargetParametersModel() {
        return this.targetParametersModel;
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPart() {
        return this.targetParametersModel.getSpatialPart();
    }

    public void addTargetParametersSelectionChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public boolean removeTargetParametersSelectionChangeListener(ChangeListener changeListener) {
        return this.listeners.remove(changeListener);
    }

    private void targetParametersSelectionChanged(int n) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(new ChangeEvent(n));
        }
    }
}

