/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.obsproject.OpticalPointingTargetQueryParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.ISODateVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.ot.editors.sciencegoals.OpticalPointingTargetQueryEditor;
import alma.obsprep.util.Convert;
import alma.valuetypes.Angle;
import java.util.Calendar;
import java.util.TimeZone;

public class OpticalPointingTargetQueryModel
extends Model {
    public OpticalPointingTargetQueryModel(Object object) {
        super(object);
    }

    public OpticalPointingTargetQueryParameters getQueryParameters() {
        return (OpticalPointingTargetQueryParameters)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = this.getQueryParameters();
        if (opticalPointingTargetQueryParameters != null) {
            this.publish(OpticalPointingTargetQueryEditor.CATALOG_LOCATION_FID, opticalPointingTargetQueryParameters.getCatalogLocation());
            this.publish(OpticalPointingTargetQueryEditor.FILENAME_FID, opticalPointingTargetQueryParameters.getLocalFileName());
            this.publish(OpticalPointingTargetQueryEditor.RA_MIN_FID, opticalPointingTargetQueryParameters.getMinRA());
            this.publish(OpticalPointingTargetQueryEditor.RA_MAX_FID, opticalPointingTargetQueryParameters.getMaxRA());
            this.publish(OpticalPointingTargetQueryEditor.DEC_MIN_FID, opticalPointingTargetQueryParameters.getMinDec());
            this.publish(OpticalPointingTargetQueryEditor.DEC_MAX_FID, opticalPointingTargetQueryParameters.getMaxDec());
            this.publish(OpticalPointingTargetQueryEditor.MAG_BRIGHTEST_FID, opticalPointingTargetQueryParameters.getMinMagnitude().getValue());
            this.publish(OpticalPointingTargetQueryEditor.MAG_FAINTEST_FID, opticalPointingTargetQueryParameters.getMaxMagnitude().getValue());
            this.publish(OpticalPointingTargetQueryEditor.AZ_MIN_FID, opticalPointingTargetQueryParameters.getMinAzimuth().getContentInUnits(Angle.UNIT_DEG));
            this.publish(OpticalPointingTargetQueryEditor.AZ_MAX_FID, opticalPointingTargetQueryParameters.getMaxAzimuth().getContentInUnits(Angle.UNIT_DEG));
            this.publish(OpticalPointingTargetQueryEditor.EL_MIN_FID, opticalPointingTargetQueryParameters.getMinElevation().getContentInUnits(Angle.UNIT_DEG));
            this.publish(OpticalPointingTargetQueryEditor.EL_MAX_FID, opticalPointingTargetQueryParameters.getMaxElevation().getContentInUnits(Angle.UNIT_DEG));
            this.publish(OpticalPointingTargetQueryEditor.LST_FID, opticalPointingTargetQueryParameters.getLstCalendar());
            this.publish(OpticalPointingTargetQueryEditor.SELECTION_FACTOR_FID, opticalPointingTargetQueryParameters.getSelectionFactor());
            this.publish(OpticalPointingTargetQueryEditor.LOAD_SEPARATION_FID, opticalPointingTargetQueryParameters.getFieldMinSeparation().getContentInUnits(Angle.UNIT_ARCMIN));
            this.publish(OpticalPointingTargetQueryEditor.SEPARATION_FID, opticalPointingTargetQueryParameters.getListMinSeparation().getContentInUnits(Angle.UNIT_ARCMIN));
            this.publish(OpticalPointingTargetQueryEditor.N_STARS_FID, opticalPointingTargetQueryParameters.getMaxTargets());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (this.getDocument() == null) {
            return null;
        }
        OpticalPointingTargetQueryParameters opticalPointingTargetQueryParameters = this.getQueryParameters();
        if (fieldID.equals(OpticalPointingTargetQueryEditor.CATALOG_LOCATION_FID)) {
            String string = (String)object;
            opticalPointingTargetQueryParameters.setCatalogLocation(string);
            return string;
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.FILENAME_FID)) {
            String string = (String)object;
            opticalPointingTargetQueryParameters.setLocalFileName(string);
            return string;
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.RA_MIN_FID)) {
            double d = 0.0;
            try {
                d = Convert.HHMMSSToDeg((String)object);
            }
            catch (InvalidCoordException invalidCoordException) {
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            opticalPointingTargetQueryParameters.setMinRA(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.RA_MAX_FID)) {
            double d = 0.0;
            try {
                d = Convert.HHMMSSToDeg((String)object);
            }
            catch (InvalidCoordException invalidCoordException) {
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            opticalPointingTargetQueryParameters.setMaxRA(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.DEC_MAX_FID)) {
            double d = 0.0;
            try {
                d = Convert.DDMMSSToDeg((String)object);
            }
            catch (InvalidCoordException invalidCoordException) {
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            opticalPointingTargetQueryParameters.setMaxDec(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.DEC_MIN_FID)) {
            double d = 0.0;
            try {
                d = Convert.DDMMSSToDeg((String)object);
            }
            catch (InvalidCoordException invalidCoordException) {
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            opticalPointingTargetQueryParameters.setMinDec(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.MAG_BRIGHTEST_FID)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble((Object)((String)object), 0.0, Double.MAX_VALUE);
            }
            catch (OutOfRangeException outOfRangeException) {
                // empty catch block
            }
            opticalPointingTargetQueryParameters.setMinMagnitude(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.MAG_FAINTEST_FID)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble((Object)((String)object), 0.0, Double.MAX_VALUE);
            }
            catch (OutOfRangeException outOfRangeException) {
                // empty catch block
            }
            opticalPointingTargetQueryParameters.setMaxMagnitude(d);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.AZ_MAX_FID)) {
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_DEG);
            opticalPointingTargetQueryParameters.setMaxAzimuth(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.AZ_MIN_FID)) {
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_DEG);
            opticalPointingTargetQueryParameters.setMinAzimuth(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.EL_MAX_FID)) {
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_DEG);
            opticalPointingTargetQueryParameters.setMaxElevation(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.EL_MIN_FID)) {
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_DEG);
            opticalPointingTargetQueryParameters.setMinElevation(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.LST_FID)) {
            if (object == null) {
                return null;
            }
            Calendar calendar = null;
            String string = (String)object;
            try {
                calendar = ISODateVerifier.parseIsoDate(string, TimeZone.getTimeZone("UTC"));
            }
            catch (NumberFormatException numberFormatException) {
                if (string.length() == 0) {
                    calendar = null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (calendar != null) {
                opticalPointingTargetQueryParameters.setLst(calendar);
            }
            return calendar;
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.N_STARS_FID)) {
            int n = 0;
            try {
                n = IntegerVerifier.parseInt((String)object, 0, Integer.MAX_VALUE);
            }
            catch (OutOfRangeException outOfRangeException) {
                // empty catch block
            }
            opticalPointingTargetQueryParameters.setMaxTargets(n);
            return new Integer(n);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.SEPARATION_FID)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble((Object)((String)object), 0.0, Double.MAX_VALUE);
            }
            catch (OutOfRangeException outOfRangeException) {
                // empty catch block
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_ARCMIN);
            opticalPointingTargetQueryParameters.setListMinSeparation(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.LOAD_SEPARATION_FID)) {
            double d = 0.0;
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            Angle angle = Angle.createAngle();
            angle.setContent(d);
            angle.setUnit(Angle.UNIT_ARCMIN);
            opticalPointingTargetQueryParameters.setFieldMinSeparation(angle);
            return new Double(d);
        }
        if (fieldID.equals(OpticalPointingTargetQueryEditor.SELECTION_FACTOR_FID)) {
            int n = 1;
            try {
                n = IntegerVerifier.parseInt((String)object, 0, Integer.MAX_VALUE);
            }
            catch (OutOfRangeException outOfRangeException) {
                // empty catch block
            }
            opticalPointingTargetQueryParameters.setSelectionFactor(n);
            return new Integer(n);
        }
        return object;
    }
}

