/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.data.PerformanceParametersData;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.valuetypes.UnitsToDisplayManagerInterface;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairView;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionProviderInterface;
import alma.obsprep.ot.models.sciencegoals.MonitoringConstraintsListModel;
import alma.obsprep.ot.models.sciencegoals.TimingConstraintsListModel;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.obsprep.ot.models.valuetypes.SensitivityFormModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.etc.editor.SensitivityCalculatorEditor;
import alma.obsprep.services.experts.ACAExpert;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;

public class SfiControlParameterModel
extends Model
implements UnitsToDisplayManagerInterface {
    private MyUserUnitValueUnitPairModel angularResolutionModel;
    private MyUserUnitValueUnitPairModel acceptableAngularResolutionModel;
    private MyValueUnitPairModel largestScaleModel;
    private SensitivityFormModel sensitivityModel;
    private ValueUnitPairModel desiredTimeModel;
    private ValueUnitPairModel allowedMargin;
    private UserUnitValueUnitPairModel frequencyWidthModel;
    private UserUnitValueUnitPairModel acaSensitivityModel;
    private UserUnitValueUnitPairModel tpSensitivityModel;
    private TimingConstraintsListModel timingConstraintsModel;
    private VisitConstraintsListModel visitConstraintsModel;
    private MonitoringConstraintsListModel monitoringConstraintsModel;
    private ValueUnitPairModel fieldOneARRangeModel;
    private ValueUnitPairModel fieldTwoARRangeModel;
    public static FieldID FID_STANDALONE_ACA = new FieldID("SfiControlParameterModel.standaloneACA");
    private ObsProposalModel obsProposalModel;
    private ModelChangeSubscriber lasModelChangeSubscriber = (model, fieldID, object) -> {
        this.updatePointSourceStatus();
        this.updateTPStatus();
    };
    private final ModelChangeSubscriber sensitivitySubscriber = (model, fieldID, object) -> {
        this.updateSensitivityValues();
        if (fieldID.equals(this.getSensitivityModel().getUnitFID())) {
            String string = (String)object;
            this.publish(SfiControlParameterEditor.FID_DESIRED_SENSITIVITY_EQUIVALENCE_SEPARATOR_LABEL, UserSensitivity.inFluxUnit(string) ? "and" : "will provide");
        }
    };
    private final PropertyChangeListener boListener = new PropertyChangeListener(){
        private AtomicBoolean timerActive = new AtomicBoolean(false);

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.timerActive.get()) {
                this.timerActive.set(true);
                Timer timer = new Timer(100, actionEvent -> {
                    SfiControlParameterModel.this.publish();
                    this.timerActive.set(false);
                });
                timer.setRepeats(false);
                timer.start();
            }
        }
    };
    private Boolean previousSACAStatusState = null;
    private Angle aca7mConfigBeamsize = null;
    private Angle worstClusterSpecificCompactPSG12mAngularResolution;
    private Angle bestClusterSpecificExtendedPSG12mAngularResolution;
    private Boolean previousSimultaneous12And7PossibleState = null;
    public static FieldID FID_ANGULAR_RESOLUTION_VALUES_EQUAL = new FieldID("SfiControlParameterModel.angularResolutionValuesEqual");

    public MonitoringConstraintsListModel getMonitoringConstraintsModel() {
        return this.monitoringConstraintsModel;
    }

    public void setMonitoringConstraintsModel(MonitoringConstraintsListModel monitoringConstraintsListModel) {
        this.monitoringConstraintsModel = monitoringConstraintsListModel;
    }

    public TimingConstraintsListModel getTimingConstraintsModel() {
        return this.timingConstraintsModel;
    }

    public void setTimingConstraintsModel(TimingConstraintsListModel timingConstraintsListModel) {
        this.timingConstraintsModel = timingConstraintsListModel;
    }

    public VisitConstraintsListModel getVisitConstraintsModel() {
        return this.visitConstraintsModel;
    }

    public void setVisitConstraintsModel(VisitConstraintsListModel visitConstraintsListModel) {
        this.visitConstraintsModel = visitConstraintsListModel;
    }

    public SfiControlParameterModel(PerformanceParameters performanceParameters) {
        super(performanceParameters);
        this.acceptableAngularResolutionModel = new MyUserUnitValueUnitPairModel(null);
        this.angularResolutionModel = new MyUserUnitValueUnitPairModel(null);
        this.fieldOneARRangeModel = new ValueUnitPairModel();
        this.fieldTwoARRangeModel = new ValueUnitPairModel();
        this.angularResolutionModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            PerformanceParameters performanceParameters;
            if (this.acceptableAngularResolutionModel.getDocument() != null && (performanceParameters = this.getPerformanceParameters()) != null) {
                ValueUnitPair valueUnitPair = this.acceptableAngularResolutionModel.getVUP();
                String string = this.angularResolutionModel.getVUP().getUserUnit();
                double d = valueUnitPair.getContent();
                if (EnumSet.of(AngularResolutionMode.Single, AngularResolutionMode.SACA).contains(performanceParameters.getAngularResolutionMode())) {
                    d = performanceParameters.getDesiredAngularResolution().getContentInUnits(string);
                }
                valueUnitPair.setUserContent(d, string);
                this.acceptableAngularResolutionModel.publish();
                this.updateSensitivityFeedbackFieldVisibility();
                this.publishARRangeForSensitivity();
            }
        });
        this.acceptableAngularResolutionModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            this.updateSensitivityFeedbackFieldVisibility();
            this.publishARRangeForSensitivity();
        });
        this.largestScaleModel = new MyValueUnitPairModel(null);
        SensitivityFormModel sensitivityFormModel = new SensitivityFormModel(null);
        sensitivityFormModel.setSensitivityDisplayOption(SensitivityCalculatorEditor.SensitivityDisplayOption.CURRENT);
        sensitivityFormModel.setAngularResolutionProvider(SensitivityFormModel.FeedbackField.FIRST, this::getAngularResolutionForFirstSensitivityEquivalenceField);
        sensitivityFormModel.setAngularResolutionProvider(SensitivityFormModel.FeedbackField.SECOND, this::getAngularResolutionForSecondSensitivityEquivalenceField);
        this.sensitivityModel = sensitivityFormModel;
        this.frequencyWidthModel = new UserUnitValueUnitPairModel(null);
        this.acaSensitivityModel = new SensitivityFormModel(null);
        this.tpSensitivityModel = new SensitivityFormModel(null);
        this.timingConstraintsModel = new TimingConstraintsListModel(null);
        this.visitConstraintsModel = new VisitConstraintsListModel(null);
        this.monitoringConstraintsModel = new MonitoringConstraintsListModel(null);
        this.allowedMargin = new ValueUnitPairModel(null, SfiControlParameterEditor.FID_ALLOWED_MARGIN_VALUE, SfiControlParameterEditor.FID_ALLOWED_MARGIN_UNIT);
        this.desiredTimeModel = new ValueUnitPairModel(null, SfiControlParameterEditor.FID_DESIREDTIME_VALUE, SfiControlParameterEditor.FID_DESIREDTIME_UNIT);
        this.registerSubModel(this.angularResolutionModel);
        this.registerSubModel(this.acceptableAngularResolutionModel);
        this.registerSubModel(this.largestScaleModel);
        this.registerSubModel(this.sensitivityModel);
        this.registerSubModel(this.allowedMargin);
        this.registerSubModel(this.desiredTimeModel);
        this.registerSubModel(this.acaSensitivityModel);
        this.registerSubModel(this.tpSensitivityModel);
        this.registerSubModel(this.timingConstraintsModel);
        this.registerSubModel(this.visitConstraintsModel);
        this.registerSubModel(this.monitoringConstraintsModel);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            this.publishSensitivityModels();
            this.publishARRangeForSensitivity();
        };
        this.angularResolutionModel.subscribe(modelChangeSubscriber);
        this.acceptableAngularResolutionModel.subscribe(modelChangeSubscriber);
        this.largestScaleModel.subscribe(modelChangeSubscriber);
        this.largestScaleModel.subscribe(this.lasModelChangeSubscriber);
        this.sensitivityModel.subscribe(this.sensitivitySubscriber);
        this.sensitivityModel.subscribe((Model model, FieldID fieldID, Object object) -> this.publishARRangeForSensitivity());
    }

    private void updateSensitivityFeedbackFieldVisibility() {
        UserAngle userAngle = (UserAngle)this.angularResolutionModel.getDocument();
        UserAngle userAngle2 = (UserAngle)this.acceptableAngularResolutionModel.getDocument();
        this.publish(FID_ANGULAR_RESOLUTION_VALUES_EQUAL, userAngle.isEqual((AbstractDoubleWithUnit)userAngle2));
    }

    private void updateTPStatus() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        boolean bl = performanceParameters.getUseACA();
        if (bl) {
            performanceParameters.setUseTP(SchedBlockExpert.determineIfTPArrayIsToBeUsed(bl, performanceParameters.getScienceGoal()));
        }
        this.publish(SfiControlParameterEditor.FID_IS_SIMULTANEOUS_12_AND_7_POSSIBLE, this.isSimultaneous12And7Possible());
    }

    public UserUnitValueUnitPairModel getAngularResolutionModel() {
        return this.angularResolutionModel;
    }

    public UserUnitValueUnitPairModel getAcceptableAngularResolutionModel() {
        return this.acceptableAngularResolutionModel;
    }

    protected void updatePointSourceStatus() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        assert (performanceParameters != null);
        if (performanceParameters.getDesiredLargestScale().isZero()) {
            performanceParameters.setIsPointSource(true);
        } else {
            performanceParameters.setIsPointSource(false);
        }
        this.publish(SfiControlParameterEditor.FID_ISPOINTSOURCE, performanceParameters.getIsPointSource());
    }

    public ValueUnitPairModel getLargestScaleModel() {
        return this.largestScaleModel;
    }

    public UserUnitValueUnitPairModel getSensitivityModel() {
        return this.sensitivityModel;
    }

    public ValueUnitPairModel getFeedbackCoarseResolutionModel() {
        return this.sensitivityModel.getFeedbackModel();
    }

    public ValueUnitPairModel getAllowedMargin() {
        return this.allowedMargin;
    }

    public ValueUnitPairModel getDesiredTimeModel() {
        return this.desiredTimeModel;
    }

    public UserUnitValueUnitPairModel getFrequencyWidthModel() {
        return this.frequencyWidthModel;
    }

    public UserUnitValueUnitPairModel getACASensitivityModel() {
        return this.acaSensitivityModel;
    }

    public ValueUnitPairModel getACAFeedbackModel() {
        return ((SensitivityFormModel)this.acaSensitivityModel).getFeedbackModel();
    }

    public UserUnitValueUnitPairModel getTPSensitivityModel() {
        return this.tpSensitivityModel;
    }

    public ValueUnitPairModel getTPFeedbackModel() {
        return ((SensitivityFormModel)this.tpSensitivityModel).getFeedbackModel();
    }

    public PerformanceParameters getPerformanceParameters() {
        return (PerformanceParameters)this.getDocument();
    }

    public void publishBeamSizeDependentParameters() {
        if (this.getPerformanceParameters() != null) {
            Frequency frequency = this.getPerformanceParameters().getRepresentativeFrequency();
            this.publishBeamsizeDependentParameters(frequency);
        }
    }

    @Override
    public void publish() {
        this.updateTPStatus();
        SpectralSetupParameters spectralSetupParameters = null;
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            AngularResolutionMode angularResolutionMode;
            spectralSetupParameters = performanceParameters.getSpectralSetupParameters();
            if (spectralSetupParameters != null) {
                switch (spectralSetupParameters.getSpectralType()) {
                    case SINGLECONTINUUM: {
                        this.publish(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_CONT, performanceParameters.getDesiredSensitivityFrequencyMeasure());
                        break;
                    }
                    case SPECTRALLINE: {
                        this.publish(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_SPECLINE, performanceParameters.getDesiredSensitivityFrequencyMeasure());
                        break;
                    }
                    case SPECTRALSCAN: {
                        this.publish(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_SPECSCAN, performanceParameters.getDesiredSensitivityFrequencyMeasure());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown spectral type found: " + (Object)((Object)spectralSetupParameters.getSpectralType()));
                    }
                }
            }
            if ((angularResolutionMode = performanceParameters.getAngularResolutionMode()) != null) {
                this.publish(SfiControlParameterEditor.FID_ANGULARRESOLUTIONMODE, angularResolutionMode.getBOMapping());
            }
            this.publish(SfiControlParameterEditor.FID_FREQUENCYWIDTH, (Object)performanceParameters.getSensitivityFrequencyWidth());
            Frequency frequency = this.getPerformanceParameters().getRepresentativeFrequency();
            this.publishBeamsizeDependentParameters(frequency);
            this.publish(SfiControlParameterEditor.FID_ISPOINTSOURCE, performanceParameters.getIsPointSource());
            this.publish(SfiControlParameterEditor.FID_DYNAMICRANGE, performanceParameters.getDesiredDynamicRange());
            this.publish(SfiControlParameterEditor.FID_ACAOBSERVATION, performanceParameters.getUseACA());
            this.publish(SfiControlParameterEditor.FID_NEEDSMORETIME, performanceParameters.getNeedsMoreTime());
            this.publish(SfiControlParameterEditor.FID_ISTIMECONST, performanceParameters.getIsTimeConstrained());
            this.publish(SfiControlParameterEditor.FID_TYPE_OF_TIME_CONSTRAINT, (Object)performanceParameters.getTypeOfTimingConstraint());
            this.publish(SfiControlParameterEditor.FID_IS_SIMULTANEOUS_12_AND_7, performanceParameters.getIsSimultaneous12and7() ? "Yes" : "No");
            this.publish(SfiControlParameterEditor.FID_IS_SIMULTANEOUS_12_AND_7_POSSIBLE, this.isSimultaneous12And7Possible());
            this.publish(SfiControlParameterEditor.FID_TEMPORAL_NOTE, performanceParameters.getTimingConstraintNote());
            this.publish(SfiControlParameterEditor.FID_TEMPORAL_NOTE_ENABLED, performanceParameters.isValidToEditTimingConstraintNote());
            if (spectralSetupParameters != null) {
                this.publish(SfiControlParameterEditor.FID_SPECTRALTYPE, (Object)spectralSetupParameters.getSpectralType());
            }
            ScienceGoal scienceGoal = ((PerformanceParameters)this.getDocument()).getScienceGoal();
            try {
                if (scienceGoal.isSolarScienceGoal() && performanceParameters.getDesiredLargestScale().isLessThan((AbstractDoubleWithUnit)Angle.createAngle())) {
                    performanceParameters.getDesiredLargestScale().setContent(0.0);
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(SfiControlParameterModel.class).warning("Unable to determine if Solar mode");
            }
        }
        this.angularResolutionModel.publish();
        this.acceptableAngularResolutionModel.publish();
        this.largestScaleModel.publish();
        this.allowedMargin.publish();
        this.desiredTimeModel.publish();
        this.publishSensitivityModels();
        this.frequencyWidthModel.publish();
        this.timingConstraintsModel.publish();
        this.visitConstraintsModel.publish();
        this.monitoringConstraintsModel.publish();
        this.publish(SfiControlParameterEditor.FID_NO_ANTENNA_12M, AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_12M, spectralSetupParameters));
        this.publish(SfiControlParameterEditor.FID_NO_ANTENNA_7M, AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_7M, spectralSetupParameters));
        this.publish(SfiControlParameterEditor.FID_NO_ANTENNA_TP, AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_TP, spectralSetupParameters));
    }

    public void updateRelevantTimingNote(String string) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (null != performanceParameters) {
            performanceParameters.setTimingConstraintNote(string);
        }
    }

    private void publishBeamsizeDependentParameters(Frequency frequency) {
        ScienceGoal scienceGoal = ((PerformanceParameters)this.getDocument()).getScienceGoal();
        assert (scienceGoal != null);
        this.publish(SfiControlParameterEditor.FID_BEAMSIZE_12M, (Object)Antenna.ANTENNA_12M.getBeamSize(frequency));
        this.publish(SfiControlParameterEditor.FID_BEAMSIZE_7M, (Object)Antenna.ANTENNA_7M.getBeamSize(frequency));
        Configuration configuration = null;
        configuration = Configuration.getMostExtendedCompatibleConfiguration(RequestedArray.TWELVE_M, scienceGoal);
        this.getARRangeConfigurationPerformance(frequency, scienceGoal);
        this.publish(SfiControlParameterEditor.FID_MOSTEXTENDEDBASELINE_BEAMSIZE, (Object)this.bestClusterSpecificExtendedPSG12mAngularResolution);
        this.publish(SfiControlParameterEditor.FID_COMPACTMAXBASELINE_BEAMSIZE, (Object)this.worstClusterSpecificCompactPSG12mAngularResolution);
        assert (this.worstClusterSpecificCompactPSG12mAngularResolution != null && this.bestClusterSpecificExtendedPSG12mAngularResolution != null) : "Unable to calculate angular resolution for clusters";
        assert (configuration != null);
        Configuration configuration2 = Configuration.MOST_COMPACT.get((Object)RequestedArray.TWELVE_M);
        Configuration configuration3 = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
        Length length = configuration.getMaxBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_MAXBASELINE_LENGTH, (Object)length);
        length = configuration3.getMaxBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_ACA7MMAXBASELINE_LENGTH, (Object)length);
        length = configuration2.getMaxBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_COMPACTMAXBASELINE_LENGTH, (Object)length);
        try {
            this.aca7mConfigBeamsize = Angle.createAngle((double)configuration3.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), (String)Angle.UNIT_ARCSEC);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            this.aca7mConfigBeamsize = null;
        }
        this.publish(SfiControlParameterEditor.FID_ACA7MMAXBASELINE_BEAMSIZE, (Object)this.aca7mConfigBeamsize);
        this.calculateAngularResolutions(frequency, scienceGoal);
        this.angularResolutionModel.publish();
        this.acceptableAngularResolutionModel.publish();
        this.publishARRangeForSensitivity();
        length = configuration3.getMinBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_ACA7MMINBASELINE_LENGTH, (Object)length);
        length = configuration.getMinBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_MINBASELINE_LENGTH, (Object)length);
        Angle angle = null;
        try {
            angle = Angle.createAngle((double)configuration.getRecoverableScale(frequency.getContentInGHz(), scienceGoal.getTargetParameters(), RequestedArray.TWELVE_M), (String)Angle.UNIT_ARCSEC);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            angle = null;
        }
        this.publish(SfiControlParameterEditor.FID_MINBASELINE_SCALE, (Object)angle);
        Angle angle2 = null;
        try {
            angle2 = Angle.createAngle((double)configuration3.getRecoverableScale(frequency.getContentInGHz(), scienceGoal.getTargetParameters(), RequestedArray.SEVEN_M), (String)Angle.UNIT_ARCSEC);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            angle = null;
        }
        this.publish(SfiControlParameterEditor.FID_ACA7MMINBASELINE_SCALE, (Object)angle2);
        length = configuration2.getMinBaselineVUP();
        length.convertToUnit(length.getFriendlyUnit());
        this.publish(SfiControlParameterEditor.FID_COMPACTMINBASELINE_LENGTH, (Object)length);
        Angle angle3 = null;
        try {
            angle3 = Angle.createAngle((double)configuration2.getRecoverableScale(frequency.getContentInGHz(), scienceGoal.getTargetParameters(), RequestedArray.TWELVE_M), (String)Angle.UNIT_ARCSEC);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            angle3 = null;
        }
        this.publish(SfiControlParameterEditor.FID_COMPACTMINBASELINE_SCALE, (Object)angle3);
    }

    private void getARRangeConfigurationPerformance(Frequency frequency, ScienceGoal scienceGoal) {
        try {
            this.worstClusterSpecificCompactPSG12mAngularResolution = ConfigurationHelper.getAchievableAngularResolutionForAllClusters(scienceGoal, RequestAngularResolutionEnum.COARSEST, Configuration.ConfigurationExtent.COMPACT, frequency, RequestedArray.TWELVE_M);
            this.bestClusterSpecificExtendedPSG12mAngularResolution = ConfigurationHelper.getAchievableAngularResolutionForAllClusters(scienceGoal, RequestAngularResolutionEnum.FINEST, Configuration.ConfigurationExtent.EXTENDED, frequency, RequestedArray.TWELVE_M);
        }
        catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
            this.worstClusterSpecificCompactPSG12mAngularResolution = Angle.createAngle();
            this.bestClusterSpecificExtendedPSG12mAngularResolution = Angle.createAngle();
        }
    }

    private void calculateAngularResolutions(Frequency frequency, ScienceGoal scienceGoal) {
        this.getARRangeConfigurationPerformance(frequency, scienceGoal);
        AngularResolutionMode angularResolutionMode = ((PerformanceParameters)this.getDocument()).getAngularResolutionMode();
        switch (angularResolutionMode) {
            case Any: {
                ValueUnitPair valueUnitPair = this.angularResolutionModel.getVUP();
                if (valueUnitPair != null) {
                    valueUnitPair.setUserContent(this.worstClusterSpecificCompactPSG12mAngularResolution.getContent(), this.worstClusterSpecificCompactPSG12mAngularResolution.getUnit());
                }
                if ((valueUnitPair = this.acceptableAngularResolutionModel.getVUP()) == null) break;
                valueUnitPair.setUserContent(this.bestClusterSpecificExtendedPSG12mAngularResolution.getContent(), this.bestClusterSpecificExtendedPSG12mAngularResolution.getUnit());
                break;
            }
            case SACA: {
                ValueUnitPair valueUnitPair = this.angularResolutionModel.getVUP();
                if (valueUnitPair != null && this.aca7mConfigBeamsize != null) {
                    valueUnitPair.setUserContent(this.aca7mConfigBeamsize.getContent(), this.aca7mConfigBeamsize.getUnit());
                }
                if ((valueUnitPair = this.acceptableAngularResolutionModel.getVUP()) == null || this.aca7mConfigBeamsize == null) break;
                valueUnitPair.setUserContent(this.aca7mConfigBeamsize.getContent(), this.aca7mConfigBeamsize.getUnit());
                break;
            }
            case Single: {
                ValueUnitPair valueUnitPair = this.angularResolutionModel.getVUP();
                ValueUnitPair valueUnitPair2 = this.acceptableAngularResolutionModel.getVUP();
                if (valueUnitPair == null || valueUnitPair2 == null) break;
                valueUnitPair2.setUserContent(valueUnitPair.getContent(), valueUnitPair.getUnit());
                break;
            }
        }
    }

    private void publishARRangeForSensitivity() {
        ScienceGoal scienceGoal = ((PerformanceParameters)this.getDocument()).getScienceGoal();
        assert (scienceGoal != null);
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters.isAngularResolutionModeRange()) {
            try {
                ValueUnitPair valueUnitPair = this.sensitivityModel.getVUP();
                if (valueUnitPair == null) {
                    return;
                }
                boolean bl = UserSensitivity.inFluxUnit(valueUnitPair.getUserUnit());
                Angle angle = null;
                ReceiverBand receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
                double d = frequency.getContentInGHz();
                if (receiverBand == null) {
                    return;
                }
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getRangeOptimalConfigurations(d, RequestedArray.TWELVE_M, scienceGoal, Optional.of(receiverBand));
                if (scienceGoalConfigurations != null && !scienceGoalConfigurations.isEmpty()) {
                    if (bl) {
                        this.fieldOneARRangeModel.setDocument(SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.COARSEST, performanceParameters));
                        this.fieldTwoARRangeModel.setDocument(SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.FINEST, performanceParameters));
                    } else {
                        Configuration configuration = ((ConfigurationSet)scienceGoalConfigurations.get(scienceGoalConfigurations.size() - 1)).getTM1Configuration().get();
                        angle = configuration.getAchievableAngularResolutionForClusters(scienceGoal, RequestAngularResolutionEnum.FINEST, frequency, RequestedArray.TWELVE_M);
                        this.fieldOneARRangeModel.setDocument((Object)angle);
                        this.fieldTwoARRangeModel.setDocument(SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.COARSEST, performanceParameters));
                    }
                }
            }
            catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                this.fieldOneARRangeModel.setDocument((Object)Angle.createAngle((double)ValueUnitPairView.ILLEGAL_VALUE, (String)Angle.UNIT_ARCSEC));
                this.fieldTwoARRangeModel.setDocument((Object)Angle.createAngle((double)ValueUnitPairView.ILLEGAL_VALUE, (String)Angle.UNIT_ARCSEC));
                return;
            }
            this.fieldOneARRangeModel.publish();
            this.fieldTwoARRangeModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return object;
        }
        if (fieldID.equals(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_SPECLINE) || fieldID.equals(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_CONT) || fieldID.equals(SfiControlParameterEditor.FID_FREQUENCY_MEASURES_SPECSCAN)) {
            String string = (String)object;
            performanceParameters.setDesiredSensitivityFrequencyMeasure(string);
            this.publish(SfiControlParameterEditor.FID_FREQUENCYWIDTH, (Object)performanceParameters.getSensitivityFrequencyWidth());
            return string;
        }
        if (fieldID.equals(SfiControlParameterEditor.FID_DYNAMICRANGE)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble((Object)((String)object), 0.0, Double.MAX_VALUE);
            }
            catch (OutOfRangeException | NumberFormatException exception) {
                // empty catch block
            }
            performanceParameters.setDesiredDynamicRange(d);
            return new Double(d);
        }
        if (fieldID.equals(SfiControlParameterEditor.FID_ISTIMECONST)) {
            String string = (String)object;
            boolean bl = string.equals("Yes");
            PerformanceParameters performanceParameters2 = performanceParameters;
            if (bl) {
                performanceParameters2.setIsTimeConstrained(true);
                String string2 = performanceParameters2.getTimingConstraintsType();
                if (null == string2 || PerformanceParametersData.TIMINGCONSTRAINTSTYPE_NONE == string2) {
                    if (performanceParameters2.getVisitConstraintCount() > 0) {
                        performanceParameters2.setTimingConstraintsType(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS);
                    } else if (performanceParameters2.getTemporalParametersCount() > 0) {
                        performanceParameters2.setTimingConstraintsType(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_SPECIFICDATES);
                    } else {
                        performanceParameters2.setTimingConstraintsType(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_NONE);
                    }
                }
            } else {
                performanceParameters2.setIsTimeConstrained(false);
                performanceParameters2.setTimingConstraintsType(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_NONE);
            }
            return bl;
        }
        if (fieldID.equals(SfiControlParameterEditor.FID_TYPE_OF_TIME_CONSTRAINT)) {
            PerformanceParameters.TimingConstraintType timingConstraintType = PerformanceParameters.TimingConstraintType.getTypeFromButtonLabel((String)object);
            performanceParameters.setTimingConstraintsType(timingConstraintType.name);
        } else {
            if (fieldID.equals(SfiControlParameterEditor.FID_NEEDSMORETIME)) {
                String string = (String)object;
                boolean bl = string.equals("Yes");
                if (performanceParameters != null) {
                    performanceParameters.setNeedsMoreTime(bl);
                }
                return bl;
            }
            if (fieldID.equals(SfiControlParameterEditor.FID_EDITORVIEW)) {
                this.publishBeamSizeDependentParameters();
            } else if (fieldID.equals(SfiControlParameterEditor.FID_ANGULARRESOLUTIONMODE)) {
                AngularResolutionMode angularResolutionMode = AngularResolutionMode.valueOfBOMapping((String)object);
                this.setAngularResolutionMode(angularResolutionMode);
            } else if (fieldID.equals(SfiControlParameterEditor.FID_IS_SIMULTANEOUS_12_AND_7)) {
                String string = (String)object;
                boolean bl = string.equals("Yes");
                performanceParameters.setIsSimultaneous12and7(bl);
            } else if (SfiControlParameterEditor.FID_SOLARINTEGRATION_DURATION.equals(fieldID)) {
                if (!(object instanceof String)) {
                    return object;
                }
                int n = Integer.valueOf((String)object);
                Time time = Time.createTime((double)n, (String)Time.UNIT_MS);
            }
        }
        return object;
    }

    private void setAngularResolutionMode(AngularResolutionMode angularResolutionMode) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        if (performanceParameters != null) {
            switch (performanceParameters.getAngularResolutionMode()) {
                case Range: {
                    performanceParameters.setPreviousDesiredARValue(AngularResolutionMode.Range, performanceParameters.getDesiredAngularResolution());
                    performanceParameters.setPreviousAcceptableARValues(AngularResolutionMode.Range, performanceParameters.getAcceptableAngularResolution());
                    break;
                }
                case Single: {
                    performanceParameters.setPreviousDesiredARValue(AngularResolutionMode.Single, performanceParameters.getDesiredAngularResolution());
                    break;
                }
            }
        }
        if (performanceParameters != null) {
            performanceParameters.setAngularResolutionMode(angularResolutionMode);
        }
        switch (angularResolutionMode) {
            case Any: {
                ValueUnitPair valueUnitPair = this.sensitivityModel.getVUP();
                if (!UserSensitivity.inFluxUnit(valueUnitPair.getUserUnit())) {
                    valueUnitPair.setUserContent(valueUnitPair.getContentInUnits(Sensitivity.UNIT_JY), Sensitivity.UNIT_JY);
                    this.sensitivityModel.setSensitivityDisplayOption(SensitivityCalculatorEditor.SensitivityDisplayOption.CURRENT, Sensitivity.UNIT_JY);
                }
                ValueUnitPair valueUnitPair2 = this.largestScaleModel.getVUP();
                valueUnitPair2.setContent(0.0);
                this.largestScaleModel.publish();
                break;
            }
            case Range: {
                ValueUnitPair valueUnitPair;
                Object object;
                Optional<UserAngle> optional = performanceParameters.getPreviousDesiredARValues(AngularResolutionMode.Range);
                if (optional.isPresent()) {
                    object = optional.get();
                    valueUnitPair = this.getAngularResolutionModel().getVUP();
                    valueUnitPair.setUserContent(object.getContent(), object.getUnit());
                    this.getAngularResolutionModel().publish();
                }
                if (!((Optional)(object = performanceParameters.getPreviousAcceptableARValues(AngularResolutionMode.Range))).isPresent()) break;
                valueUnitPair = (UserAngle)((Optional)object).get();
                ValueUnitPair valueUnitPair3 = this.getAcceptableAngularResolutionModel().getVUP();
                valueUnitPair3.setUserContent(valueUnitPair.getContent(), valueUnitPair.getUnit());
                this.getAcceptableAngularResolutionModel().publish();
                break;
            }
            case Single: {
                Optional<UserAngle> optional = performanceParameters.getPreviousDesiredARValues(AngularResolutionMode.Single);
                if (!optional.isPresent()) break;
                UserAngle userAngle = optional.get();
                ValueUnitPair valueUnitPair = this.getAngularResolutionModel().getVUP();
                valueUnitPair.setUserContent(userAngle.getContent(), userAngle.getUnit());
                this.getAngularResolutionModel().publish();
                break;
            }
        }
        this.publishBeamSizeDependentParameters();
        this.publishSensitivityModels();
    }

    @Override
    public void setDocument(Object object) {
        PerformanceParameters performanceParameters = (PerformanceParameters)object;
        PerformanceParameters performanceParameters2 = this.getPerformanceParameters();
        if (performanceParameters2 != null) {
            performanceParameters2.getRepresentativeFrequency().removePropertyChangeListener(this.boListener);
        }
        this.previousSimultaneous12And7PossibleState = null;
        this.previousSACAStatusState = null;
        super.setonlyDocument(performanceParameters);
        if (performanceParameters != null) {
            this.angularResolutionModel.setonlyDocument(performanceParameters.getDesiredAngularResolution());
            this.acceptableAngularResolutionModel.setDocument(performanceParameters.getAcceptableAngularResolution());
            performanceParameters.getAcceptableAngularResolution().setName("acceptableAngularResolution");
            this.calculateAngularResolutions(performanceParameters.getRepresentativeFrequency(), performanceParameters.getScienceGoal());
            this.largestScaleModel.setDocument((Object)performanceParameters.getDesiredLargestScale());
            this.sensitivityModel.setDocument(performanceParameters.getDesiredSensitivity());
            this.desiredTimeModel.setDocument(performanceParameters.getDesiredTime());
            this.frequencyWidthModel.setDocument(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth());
            this.acaSensitivityModel.setDocument(performanceParameters.getDesiredACASensitivity());
            this.tpSensitivityModel.setDocument(performanceParameters.getDesiredTPSensitivity());
            this.timingConstraintsModel.setDocument(performanceParameters);
            this.visitConstraintsModel.setDocument(performanceParameters);
            this.monitoringConstraintsModel.setDocument(performanceParameters);
            performanceParameters.getRepresentativeFrequency().addPropertyChangeListener(this.boListener);
            this.obsProposalModel.publishProposalType();
        }
        this.previousSACAStatusState = null;
        this.publish();
    }

    public void updateSensitivityValues() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
        ACAExpert aCAExpert = ACAExpert.getInstance(scienceGoal);
        double d = aCAExpert.getACA7SensitivityJy();
        performanceParameters.getDesiredACASensitivity().setContentAndUnit(d, Sensitivity.UNIT_JY);
        this.getACASensitivityModel().publish();
        double d2 = aCAExpert.getTPSensitivityJy();
        performanceParameters.getDesiredTPSensitivity().setContentAndUnit(d2, Sensitivity.UNIT_JY);
        this.getTPSensitivityModel().publish();
    }

    public void setObsProposalModel(ObsProposalModel obsProposalModel) {
        this.obsProposalModel = obsProposalModel;
        obsProposalModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            PerformanceParameters performanceParameters;
            if (fieldID.equals(ObsProposalEditor.PROPOSALTYPE_FID) && StringUtils.equals((CharSequence)((String)object), (CharSequence)"VLBI") && (performanceParameters = (PerformanceParameters)this.getDocument()) != null) {
                performanceParameters.setAngularResolutionMode(AngularResolutionMode.Single);
                performanceParameters.setDesiredAngularResolution(UserAngle.createUserAngle());
                performanceParameters.setAcceptableAngularResolution(UserAngle.createUserAngle());
                this.publish();
            }
        });
    }

    public void setACAScheduling() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
        assert (scienceGoal != null);
        boolean bl = ScienceGoal.determineACAScheduling(scienceGoal);
        Boolean bl2 = scienceGoal.isStandAloneACA();
        if (this.previousSACAStatusState == null || bl2.booleanValue() != this.previousSACAStatusState.booleanValue()) {
            this.previousSACAStatusState = bl2;
            this.publish(FID_STANDALONE_ACA, scienceGoal.isStandAloneACA());
        }
        if (bl) {
            this.publish(SfiControlParameterEditor.FID_ACAOBSERVATION, performanceParameters.getUseACA());
        }
        Boolean bl3 = this.isSimultaneous12And7Possible();
        if (this.previousSimultaneous12And7PossibleState == null || this.previousSimultaneous12And7PossibleState.booleanValue() != bl3.booleanValue()) {
            this.previousSimultaneous12And7PossibleState = bl3;
            this.publish(SfiControlParameterEditor.FID_IS_SIMULTANEOUS_12_AND_7_POSSIBLE, bl3);
        }
    }

    public ValueUnitPairModel getFeedbackFineResolutionModel() {
        return this.sensitivityModel.getFineResolutionFeedbackModel();
    }

    private UserAngle getAngularResolutionForFirstSensitivityEquivalenceField(String string) throws AngularResolutionProviderInterface.UnableToDetermineResolutionsException {
        PerformanceParameters performanceParameters = (PerformanceParameters)this.getDocument();
        if (performanceParameters == null) {
            throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException("No performance parameters document specified");
        }
        return SfiControlParameterModel.getARForFirstSensitivityFeedbackField(string, performanceParameters);
    }

    public static UserAngle getARForFirstSensitivityFeedbackField(String string, PerformanceParameters performanceParameters) throws AngularResolutionProviderInterface.UnableToDetermineResolutionsException {
        UserAngle userAngle = null;
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal().getParentScienceGoal() != null ? performanceParameters.getScienceGoal().getParentScienceGoal() : performanceParameters.getScienceGoal();
        Frequency frequency = performanceParameters.getRepresentativeFrequencyWithSkyOffset();
        MatchedConfiguration matchedConfiguration = null;
        switch (performanceParameters.getAngularResolutionMode()) {
            case Any: {
                if (UserSensitivity.inFluxUnit(string)) {
                    try {
                        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.TWELVE_M);
                        if (scienceGoalConfigurations.isEmpty()) {
                            throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException("No configurations returned for the given AR range");
                        }
                        matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.COARSEST, false);
                    }
                    catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                        Log.logger(SfiControlParameterModel.class).warning("Unable to determine the configurations to be scheduled" + exception.getMessage());
                        throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException(exception.getMessage());
                    }
                    assert (matchedConfiguration != null);
                    userAngle = UserAngle.createUserAngle(matchedConfiguration.getConfigurationAR().getContent(), matchedConfiguration.getConfigurationAR().getUnit(), frequency.deepCopy());
                }
                if (matchedConfiguration != null) {
                    Log.logger(SfiControlParameterModel.class).fine("First sensitivity equivalent field AR " + userAngle + " for configuration " + matchedConfiguration.getConfiguration().get().getName());
                }
                assert (userAngle != null);
                break;
            }
            case Range: {
                if (UserSensitivity.inFluxUnit(string)) {
                    userAngle = SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.COARSEST, performanceParameters);
                } else {
                    try {
                        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.TWELVE_M);
                        if (scienceGoalConfigurations.isEmpty()) {
                            throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException("No configurations returned for the given AR range");
                        }
                        matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
                    }
                    catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                        Log.logger(SfiControlParameterModel.class).warning("Unable to determine the configurations to be scheduled" + exception.getMessage());
                        throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException(exception.getMessage());
                    }
                    assert (matchedConfiguration != null);
                    userAngle = UserAngle.createUserAngle(matchedConfiguration.getConfigurationAR().getContent(), matchedConfiguration.getConfigurationAR().getUnit(), frequency.deepCopy());
                    if (matchedConfiguration != null) {
                        Log.logger(SfiControlParameterModel.class).fine("First sensitivity equivalent field AR " + userAngle + " for configuration " + matchedConfiguration.getConfiguration().get().getName());
                    }
                }
                assert (userAngle != null);
                break;
            }
            case SACA: {
                Angle angle;
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    angle = Angle.createAngle((double)configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), (String)Angle.UNIT_ARCSEC);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(SfiControlParameterModel.class).warning("Unable to determine the configurations to be scheduled" + invalidConfigurationParametersException.getMessage());
                    throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException(invalidConfigurationParametersException.getMessage());
                }
                userAngle = UserAngle.createUserAngle(angle.getContentInUnits(Angle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
                break;
            }
            case Single: {
                userAngle = performanceParameters.getDesiredAngularResolution();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected angular resolution mode " + performanceParameters.getAngularResolutionMode());
            }
        }
        assert (userAngle != null);
        return userAngle;
    }

    public UserAngle getAngularResolutionForSecondSensitivityEquivalenceField(String string) throws AngularResolutionProviderInterface.UnableToDetermineResolutionsException {
        PerformanceParameters performanceParameters = (PerformanceParameters)this.getDocument();
        if (performanceParameters == null) {
            throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException("No performance parameters document specified");
        }
        return SfiControlParameterModel.getARForSecondSensitivityFeedbackField(string, performanceParameters);
    }

    public static UserAngle getARForSecondSensitivityFeedbackField(String string, PerformanceParameters performanceParameters) throws AngularResolutionProviderInterface.UnableToDetermineResolutionsException {
        UserAngle userAngle = null;
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal().getParentScienceGoal() != null ? performanceParameters.getScienceGoal().getParentScienceGoal() : performanceParameters.getScienceGoal();
        Frequency frequency = performanceParameters.getRepresentativeFrequencyWithSkyOffset();
        MatchedConfiguration matchedConfiguration = null;
        switch (performanceParameters.getAngularResolutionMode()) {
            case Any: {
                if (UserSensitivity.inFluxUnit(string)) {
                    try {
                        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.TWELVE_M);
                        if (scienceGoalConfigurations.isEmpty()) {
                            throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException("No configurations returned for the given AR range");
                        }
                        matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
                    }
                    catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                        Log.logger(SfiControlParameterModel.class).warning("Unable to determine the configurations to be scheduled" + exception.getMessage());
                        throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException(exception.getMessage());
                    }
                    assert (matchedConfiguration != null);
                    userAngle = UserAngle.createUserAngle(matchedConfiguration.getConfigurationAR().getContent(), matchedConfiguration.getConfigurationAR().getUnit(), frequency.deepCopy());
                }
                if (matchedConfiguration == null) break;
                Log.logger(SfiControlParameterModel.class).fine("Second sensitivity equivalent field AR " + userAngle + " for configuration " + matchedConfiguration.getConfiguration().get().getName());
                break;
            }
            case Range: {
                userAngle = UserSensitivity.inFluxUnit(string) ? SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.FINEST, performanceParameters) : SfiControlParameterModel.getPISpecifiedAR(RequestAngularResolutionEnum.COARSEST, performanceParameters);
                assert (userAngle != null);
                break;
            }
            case SACA: {
                Angle angle;
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    angle = Angle.createAngle((double)configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), (String)Angle.UNIT_ARCSEC);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(SfiControlParameterModel.class).warning("Unable to determine the configurations to be scheduled" + invalidConfigurationParametersException.getMessage());
                    throw new AngularResolutionProviderInterface.UnableToDetermineResolutionsException(invalidConfigurationParametersException.getMessage());
                }
                userAngle = UserAngle.createUserAngle(angle.getContentInUnits(Angle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
                break;
            }
            case Single: {
                userAngle = performanceParameters.getDesiredAngularResolution();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected angular resolution mode " + performanceParameters.getAngularResolutionMode());
            }
        }
        assert (userAngle != null);
        return userAngle;
    }

    public static UserAngle getPISpecifiedAR(RequestAngularResolutionEnum requestAngularResolutionEnum, PerformanceParameters performanceParameters) {
        UserAngle userAngle;
        UserAngle userAngle2 = null;
        UserAngle userAngle3 = performanceParameters.getAcceptableAngularResolution();
        if (userAngle3.isGreaterThan((AbstractDoubleWithUnit)(userAngle = performanceParameters.getDesiredAngularResolution()))) {
            userAngle2 = requestAngularResolutionEnum.equals((Object)RequestAngularResolutionEnum.COARSEST) ? userAngle3 : userAngle;
        } else {
            UserAngle userAngle4 = userAngle2 = requestAngularResolutionEnum.equals((Object)RequestAngularResolutionEnum.COARSEST) ? userAngle : userAngle3;
        }
        assert (userAngle2 != null);
        return userAngle2;
    }

    private void publishSensitivityModels() {
        this.sensitivityModel.publish();
        this.acaSensitivityModel.publish();
        this.tpSensitivityModel.publish();
    }

    @Override
    public String[] getUnitCategoryForDisplay(FieldID fieldID, ValueUnitPair<?> valueUnitPair) {
        if (fieldID == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: fid");
        }
        if (valueUnitPair == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: vup");
        }
        UserSensitivity userSensitivity = (UserSensitivity)this.sensitivityModel.getDocument();
        if (this.document == null) {
            return UserSensitivity.getKnownUserUnitList();
        }
        PerformanceParameters performanceParameters = (PerformanceParameters)this.document;
        String[] stringArray = null;
        switch (performanceParameters.getAngularResolutionMode()) {
            case Any: 
            case Range: {
                if (fieldID.equals(SfiControlParameterEditor.FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP)) {
                    stringArray = userSensitivity.inFluxUnit() ? UserSensitivity.getFluxUnits() : UserSensitivity.getTemperatureUnits();
                    break;
                }
                if (fieldID.equals(SfiControlParameterEditor.FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP)) {
                    stringArray = userSensitivity.inFluxUnit() ? UserSensitivity.getTemperatureUnits() : UserSensitivity.getFluxUnits();
                    break;
                }
                throw new RuntimeException("Unable to determine units for " + fieldID);
            }
            case SACA: 
            case Single: {
                stringArray = userSensitivity.inFluxUnit() ? UserSensitivity.getTemperatureUnits() : UserSensitivity.getFluxUnits();
                break;
            }
            default: {
                throw new RuntimeException("Unknown angular resolution mode detected");
            }
        }
        assert (stringArray != null);
        return stringArray;
    }

    public ValueUnitPairModel getCoarseARRangeModel() {
        return this.fieldOneARRangeModel;
    }

    public ValueUnitPairModel getFineARRangeModel() {
        return this.fieldTwoARRangeModel;
    }

    public void clearAnyExistingTimeBasedConstraints() {
        TimingConstraintsListModel timingConstraintsListModel;
        MonitoringConstraintsListModel monitoringConstraintsListModel;
        VisitConstraintsListModel visitConstraintsListModel = this.getVisitConstraintsModel();
        if (null != visitConstraintsListModel) {
            visitConstraintsListModel.clearVisitConstraintList();
        }
        if (null != (monitoringConstraintsListModel = this.getMonitoringConstraintsModel())) {
            monitoringConstraintsListModel.clearMonitoringConstraintList();
        }
        if (null != (timingConstraintsListModel = this.getTimingConstraintsModel())) {
            timingConstraintsListModel.clearTemporalParameters();
        }
    }

    private boolean isSimultaneous12And7Possible() {
        ScienceGoal scienceGoal = this.getPerformanceParameters().getScienceGoal();
        if (scienceGoal.isStandAloneACA()) {
            return false;
        }
        boolean bl = false;
        try {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduledForAllClusteredScienceGoals(scienceGoal);
            for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
                if (!configurationSet.getTM1Configuration().isPresent() || configurationSet.getTM1Configuration().get().isLongBaselineConfiguration() || !configurationSet.isACA7mRequired()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    class MyValueUnitPairModel
    extends ValueUnitPairModel {
        public MyValueUnitPairModel(ValueUnitPair<?> valueUnitPair) {
            super(valueUnitPair);
        }

        public MyValueUnitPairModel(ValueUnitPair<?> valueUnitPair, FieldID fieldID, FieldID fieldID2) {
            super(valueUnitPair, fieldID, fieldID2);
        }

        @Override
        public Object update(Editor editor, FieldID fieldID, Object object) {
            return super.update(editor, fieldID, object);
        }
    }

    class MyUserUnitValueUnitPairModel
    extends UserUnitValueUnitPairModel {
        public MyUserUnitValueUnitPairModel(ValueUnitPair<?> valueUnitPair) {
            super(valueUnitPair);
        }

        public MyUserUnitValueUnitPairModel(ValueUnitPair<?> valueUnitPair, FieldID fieldID, FieldID fieldID2) {
            super((ValueUnitPair)valueUnitPair, fieldID, fieldID2);
        }

        @Override
        public Object update(Editor editor, FieldID fieldID, Object object) {
            return super.update(editor, fieldID, object);
        }
    }

    public static enum RequestAngularResolutionEnum {
        FINEST,
        COARSEST;

    }
}

