/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SpectralScanTuningTableModel
extends AbstractTableModel {
    private SpectralScan.SpectralScanTunings spectralScanTunings = null;
    private SpectralScan spectralScan;
    private SfiScanSetupModel scanSetupModel;
    static final String longValueFreq = "xxx.xxxx GHz";

    public SpectralScanTuningTableModel(SfiScanSetupModel sfiScanSetupModel) {
        this.scanSetupModel = sfiScanSetupModel;
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (SpectralScanTuningTableModel.this.spectralScan == null) {
                    return;
                }
                if (fieldID.equals(SfiScanSetupModel.SPECSCAN_BANDWIDTH) || fieldID.equals(SfiScanSetupModel.SPECSCAN_ENDFREQ_VALUE_VUP) || fieldID.equals(SfiScanSetupModel.SPECSCAN_STARTFREQ_VALUE_VUP)) {
                    SpectralScanTuningTableModel.this.recalculateSpectralScanTunings();
                }
            }
        };
        sfiScanSetupModel.subscribe(modelChangeSubscriber);
    }

    private void recalculateSpectralScanTunings() {
        block2: {
            try {
                this.spectralScanTunings = this.spectralScan.getTunings();
                this.scanSetupModel.setAverageTuningOverlap(this.spectralScan.getTuningOverlap());
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                if (this.spectralScanTunings == null) break block2;
                this.spectralScanTunings.clearTunings();
            }
        }
        this.fireTableStructureChanged();
    }

    public SpectralScanTuningTableModel(SpectralScan spectralScan, SfiScanSetupModel sfiScanSetupModel) {
        this.scanSetupModel = sfiScanSetupModel;
        this.setDocument(spectralScan);
    }

    public void setDocument(SpectralScan spectralScan) {
        this.spectralScan = spectralScan;
        if (spectralScan == null) {
            return;
        }
        this.recalculateSpectralScanTunings();
    }

    public SpectralScan getDocument() {
        return this.spectralScan;
    }

    @Override
    public int getColumnCount() {
        if (this.spectralScanTunings != null && this.spectralScanTunings.getNumberOfTunings() > 0) {
            try {
                int n = this.spectralScanTunings.getImageTunings().isEmpty() ? 0 : this.spectralScanTunings.getImageTunings().get(0).size();
                return this.spectralScanTunings.getNumberOfSPWs() + n + 1;
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                return 0;
            }
        }
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this.spectralScanTunings == null) {
            return 0;
        }
        return this.spectralScanTunings.getNumberOfTunings();
    }

    @Override
    public String getColumnName(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnName();
    }

    public Class getColumnClass(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case TUNINGNUMBER: {
                return n + 1;
            }
            case SPWONE: 
            case SPWTWO: {
                try {
                    return this.spectralScanTunings.getTuning(n).get(n2 - 1);
                }
                catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                    return null;
                }
            }
            case SPWTHREE: 
            case SPWFOUR: {
                try {
                    if (this.spectralScanTunings.getNumberOfSPWs() == 4) {
                        return this.spectralScanTunings.getTuning(n).get(n2 - 1);
                    }
                    return null;
                }
                catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                    return null;
                }
            }
            case SPWFIVE: 
            case SPWSIX: 
            case SPWSEVEN: 
            case SPWEIGHT: {
                int n3 = -ColumnDescriptor.SPWFIVE.ordinal();
                try {
                    return this.spectralScanTunings.getImageTuning(n).get(n3 + n2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public Object[] getLongValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
            arrayList.add(columnDescriptor.longValue);
        }
        Object[] objectArray = new Object[arrayList.size()];
        return arrayList.toArray(objectArray);
    }

    public static enum ColumnDescriptor {
        TUNINGNUMBER("<html><center>Tuning (Max. 5)<br></center></html>", Integer.class, 0),
        SPWONE("<html><center>SPW 1 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWTWO("<html><center>SPW 2 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWTHREE("<html><center>SPW 3 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWFOUR("<html><center>SPW 4 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWFIVE("<html><center>SPW 5 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWSIX("<html><center>SPW 6 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWSEVEN("<html><center>SPW 7 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz"),
        SPWEIGHT("<html><center>SPW 8 (GHz)<br></center></html>", Frequency.class, "xxx.xxxx GHz");

        public final String colName;
        public final Class colClass;
        public final Object longValue;

        private ColumnDescriptor(String string2, Class clazz, Object object) {
            this.colName = string2;
            this.colClass = clazz;
            this.longValue = object;
        }

        public static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        public static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        public String getColumnName() {
            return this.colName;
        }

        public Class getColumnClass() {
            return this.colClass;
        }

        public int getColumnIndex() {
            int n = 0;
            for (ColumnDescriptor columnDescriptor : ColumnDescriptor.values()) {
                if (this == columnDescriptor) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

