/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.SingleContinuumObservingFrequency;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.AbstractSpectralLine;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.BasebandSwapListener;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.OverlaidSpectralLine;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralWindowGroupEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.ot.models.sciencegoals.RepFreqValueUnitPairModel;
import alma.obsprep.ot.models.sciencegoals.SelectedSpectralLineValidatorInterface;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.obsprep.ot.models.sciencegoals.SpectralWindowGroupModel;
import alma.obsprep.ot.models.sciencegoals.WalshSwitchControllerInterface;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;

public class SpectralSetupParametersModel
extends Model
implements ChangeListener,
RepresentativeFrequencyListener,
WalshSwitchControllerInterface,
SelectedSpectralLineValidatorInterface {
    public static final FieldID REP_FREQ_VUP_UNIT = new FieldID("SpectralSetupParameters.representativeFrequency.unit");
    public static final FieldID REP_FREQ_VUP_VALUE = new FieldID("SpectralSetupParameters.representativeFrequency.value");
    public static final FieldID REP_FREQ_SELECTED = new FieldID("SpectralSetupParameters.representativeWindow");
    public static final FieldID BASEBANDS_SWAPPED = new FieldID("SpectralSetupParameters basebands swapped");
    public static final int NUM_BASEBANDS = 4;
    private final List<SpectralWindowGroupModel> spectralWindowModels = new ArrayList<SpectralWindowGroupModel>(4);
    private final RepFreqValueUnitPairModel repFreqModel = new RepFreqValueUnitPairModel(null, REP_FREQ_VUP_VALUE, REP_FREQ_VUP_UNIT);
    private final ObservingFrequencyModel singleContinuumModel = new ObservingFrequencyModel(null);
    private final SfiScanSetupModel spectralScanModel = new SfiScanSetupModel(null);
    private final BasebandSwapListener basebandSwapListener = new BasebandSwapListener(){
        private final Random rnd = new Random();

        @Override
        public void BasebandsSwapped(int n, int n2) {
            SpectralSetupParametersModel.this.publish(BASEBANDS_SWAPPED, new int[]{n, n2, this.rnd.nextInt()});
        }
    };
    private boolean initialisingDocument;
    private ObsProposalModel obsProposalModel;
    private CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);

    public SpectralSetupParametersModel(SpectralSetupParameters spectralSetupParameters) {
        super((Object)spectralSetupParameters);
        this.configureSingleContinuumModel();
        this.configureSpectralScanModel();
        for (int i = 0; i < 4; ++i) {
            SpectralWindowGroupModel spectralWindowGroupModel = new SpectralWindowGroupModel(spectralSetupParameters, i);
            spectralWindowGroupModel.setWalshSwitchController(this);
            this.spectralWindowModels.add(spectralWindowGroupModel);
            this.registerSubModel(spectralWindowGroupModel);
            spectralWindowGroupModel.subscribe(new ModelChangeSubscriber(){

                @Override
                public void modelChanged(Model model, FieldID fieldID, Object object) {
                    if (SpectralSetupParametersModel.this.spectralWindowModels.contains(model) && fieldID.equals(SpectralWindowGroupEditor.FID_SELECT_LINES)) {
                        for (SpectralWindowGroupModel spectralWindowGroupModel : SpectralSetupParametersModel.this.spectralWindowModels) {
                            spectralWindowGroupModel.setDocument((Object)SpectralSetupParametersModel.this.getSpectralSetupParameters());
                        }
                    }
                }
            });
        }
        this.registerSubModel(this.repFreqModel);
    }

    private void configureSpectralScanModel() {
        this.registerSubModel(this.spectralScanModel);
        this.spectralScanModel.setWalshSwitchController(this);
        this.spectralScanModel.configureModelListeners();
        this.spectralScanModel.subscribe((Model model, FieldID fieldID, Object object) -> this.publish(ScienceViewSpectralVisualEditor.FID_VISUALPANEL, (Object)this.getSpectralSetupParameters()));
    }

    public PerformanceParameters getPerformanceParameters() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return null;
        }
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (businessObject instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)businessObject;
            return scienceGoal.getPerformanceParameters();
        }
        return null;
    }

    public ObservingFrequencyModel getSingleContinuumModel() {
        return this.singleContinuumModel;
    }

    public void updateSpectralWindowsForContinuum() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        ObservingFrequency observingFrequency = this.singleContinuumModel.getObservingFrequency();
        if (observingFrequency == null) {
            return;
        }
        Frequency frequency = observingFrequency.getInputFrequency();
        if (frequency == null) {
            return;
        }
        spectralSetupParameters.setSingleContinuumFrequency(frequency);
        try {
            spectralSetupParameters.updateSingleContinuumWindows(frequency, observingFrequency.getSourceVelocity(), observingFrequency.getInputType(), spectralSetupParameters.getCorrPolarization());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            spectralSetupParameters.clearAbstractScienceSpectralWindow();
        }
        for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
            spectralWindowGroupModel.getTableModel().fireTableDataChanged();
        }
    }

    private void configureSingleContinuumModel() {
        this.singleContinuumModel.getFrequencyModel().subscribe((Model model, FieldID fieldID, Object object) -> {
            SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
            if (spectralSetupParameters == null) {
                return;
            }
            PerformanceParameters performanceParameters = spectralSetupParameters.getPerformanceParameters();
            if (performanceParameters == null) {
                return;
            }
            performanceParameters.updateRepresentativeFrequency();
        });
        this.registerSubModel(this.singleContinuumModel);
        this.singleContinuumModel.subscribe((Model model, FieldID fieldID, Object object) -> this.publish(ScienceViewSpectralVisualEditor.FID_VISUALPANEL, (Object)this.getSpectralSetupParameters()));
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        return (SpectralSetupParameters)((Object)this.document);
    }

    public SpectralWindowGroupModel getSubModel(int n) throws IndexOutOfBoundsException {
        return this.spectralWindowModels.get(n);
    }

    public ValueUnitPairModel getRepFreqModel() {
        return this.repFreqModel;
    }

    public void publish_light() {
        for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
            spectralWindowGroupModel.publish();
        }
        this.singleContinuumModel.publish();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters != null) {
            if (spectralSetupParameters.isSpectralScan()) {
                this.spectralScanModel.publish();
            }
            this.publish(SfiSpectralSetupEditor.FID_POLARIZATION, spectralSetupParameters.getPolarisation());
            this.publish(ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID, spectralSetupParameters.getOverlayLines());
            this.publish(ScienceViewSpectralVisualEditor.FID_VISUALPANEL, (Object)spectralSetupParameters);
        }
    }

    @Override
    public void publish() {
        for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
            spectralWindowGroupModel.publish();
        }
        Object object = this.getSpectralSetupParameters();
        if (object != null && ((SpectralSetupParameters)((Object)object)).isSpectralScan()) {
            this.spectralScanModel.publish();
        }
        this.repFreqModel.publish();
        this.singleContinuumModel.publish();
        if (object != null) {
            this.publish(SfiSpectralSetupEditor.FID_POLARIZATION, object.getPolarisation());
            this.publish(SfiSpectralSetupEditor.FID_SPECTRALTYPE, (Object)((SpectralSetupParameters)((Object)object)).getSpectralType());
            this.publish(ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID, ((SpectralSetupParameters)((Object)object)).getOverlayLines());
            this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, object.getAdvancedSpectralSetup().getSideBandSeparation());
            this.setWalshSwitchingUserAvailability();
        }
        this.publish(ScienceViewSpectralVisualEditor.FID_VISUALPANEL, object);
    }

    private void refreshSpectralPanel() {
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null) {
            EditorManager editorManager = observingToolController.getGui().getEditors();
            ScienceViewSpectralVisualEditor scienceViewSpectralVisualEditor = (ScienceViewSpectralVisualEditor)editorManager.editorFor(EditorManager.EditorType.VISUAL_SPECTRAL, ScienceGoal.class);
            scienceViewSpectralVisualEditor.refreshWaterVapourTransmission();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (SfiSpectralSetupEditor.FID_SPECTRALTYPE.equals(fieldID)) {
            SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = SpectralSetupParameters.SpectralSetupTypeChoice.getTypeChoice((String)object);
            if (spectralSetupParameters == null) {
                return object;
            }
            boolean bl = spectralSetupParameters.isSpectralLineWSEnabled();
            spectralSetupParameters.setSpectralType(spectralSetupTypeChoice);
            if (spectralSetupParameters.isSpectralLine() && bl) {
                spectralSetupParameters.setSpectralLineWSEnabled(true);
                this.setWalshSwitchingUserAvailability();
            }
            switch (spectralSetupTypeChoice) {
                case SPECTRALLINE: {
                    boolean bl2 = ReceiverBand.isWalshReceiverSelected(spectralSetupParameters) && spectralSetupParameters.isSpectralLineWSEnabled();
                    this.update(null, SfiSpectralSetupEditor.FID_WALSH_SWITCHING, bl2);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, bl2);
                    this.setWalshSwitchingUserAvailability();
                    this.refreshSpectralPanel();
                    break;
                }
                case SINGLECONTINUUM: {
                    this.setWalshSwitchingUserAvailability();
                    this.singleContinuumModel.setDocument(new SingleContinuumObservingFrequency(spectralSetupParameters));
                    this.refreshSpectralPanel();
                    break;
                }
                case SPECTRALSCAN: {
                    this.setWalshSwitchingUserAvailability();
                    this.refreshSpectralPanel();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected TypeChoice " + (Object)((Object)spectralSetupTypeChoice));
                }
            }
            this.updateSensitivityFrequencyMeasure(spectralSetupTypeChoice);
            return spectralSetupTypeChoice;
        }
        if (fieldID.equals(SfiSpectralSetupEditor.FID_POLARIZATION)) {
            CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization((String)object);
            if (corrPolarization == null) {
                throw new IllegalArgumentException("Unexpected Polarisation : " + object);
            }
            String string = corrPolarization.name();
            if (spectralSetupParameters == null) {
                return object;
            }
            spectralSetupParameters.setPolarisation(string);
            this.publish_light();
            return object;
        }
        if (ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID.equals(fieldID) && object instanceof List) {
            List list = (List)object;
            if (spectralSetupParameters != null) {
                spectralSetupParameters.setOverlayLines(list);
            }
        } else if (fieldID.equals(SfiSpectralSetupEditor.FID_FEEDBACK)) {
            this.publish(SfiSpectralSetupEditor.FID_FEEDBACK, object);
        } else if (fieldID.equals(SfiSpectralSetupEditor.FID_WALSH_SWITCHING)) {
            if (spectralSetupParameters == null) {
                return object;
            }
            boolean bl = (Boolean)object;
            if (spectralSetupParameters.isSpectralLine()) {
                spectralSetupParameters.setSpectralLineWSEnabled(bl);
            }
            spectralSetupParameters.setWalshSwitching(bl);
            if (bl) {
                this.setSPWBandwidthToWalshSwitchingCompatibility();
            }
            this.setSPWWalshSwitchingDocumentState();
            this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> this.publish());
            if (!bl) {
                this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX, false));
            }
            this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, bl));
        } else if (fieldID.equals(SfiSpectralSetupEditor.REST_FREQUENCIES_DEFINED_FID)) {
            List list = (List)object;
            assert (list != null);
            this.assignRestFrequencyLinesToSpectralWindows(list);
        }
        return object;
    }

    private void setActiveWalshSwitchingComponents(SpectralSetupParameters spectralSetupParameters) {
        boolean bl = spectralSetupParameters.isSpectralLine() ? ReceiverBand.isWalshReceiverSelected(spectralSetupParameters) : false;
        this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, bl);
        boolean bl2 = spectralSetupParameters.isSpectralLine() ? ReceiverBand.isWalshReceiverSelected(spectralSetupParameters) : spectralSetupParameters.getAdvancedSpectralSetup().getSideBandSeparation();
        this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, bl2));
    }

    @Override
    public void setWalshSwitchingUserAvailability() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null) {
            return;
        }
        if (this.initialisingDocument) {
            return;
        }
        boolean bl = ReceiverBand.isWalshReceiverSelected(spectralSetupParameters);
        switch (spectralSetupParameters.getSpectralType()) {
            case SPECTRALSCAN: {
                boolean bl2 = bl;
                this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, false);
                try {
                    SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
                    if (spectralScan == null) {
                        bl2 = false;
                    } else {
                        SpectralScan.SpectralScanTunings spectralScanTunings = spectralScan.getTunings();
                        bl2 &= spectralScanTunings.isTwoSidebandScanSolution();
                    }
                }
                catch (UnableToFindSolutionException unableToFindSolutionException) {
                    bl2 = false;
                }
                if (!bl2) {
                    spectralSetupParameters.setWalshSwitching(false);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, false);
                } else {
                    spectralSetupParameters.setWalshSwitching(true);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, true);
                    this.setSPWBandwidthToWalshSwitchingCompatibility();
                }
                this.spectralScanModel.update(null, SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, bl2);
                break;
            }
            case SINGLECONTINUUM: {
                this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, false);
                if (!bl) {
                    spectralSetupParameters.setWalshSwitching(false);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, false);
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX, false));
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, false));
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, false));
                } else {
                    spectralSetupParameters.setWalshSwitching(true);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, true);
                    this.setSPWBandwidthToWalshSwitchingCompatibility();
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, true));
                }
                this.setSPWWalshSwitchingDocumentState();
                break;
            }
            case SPECTRALLINE: {
                if (!bl) {
                    spectralSetupParameters.setWalshSwitching(false);
                    spectralSetupParameters.setSpectralLineWSEnabled(false);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, false);
                    this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, false);
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX, false));
                    this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, false));
                    this.setSPWWalshSwitchingDocumentState();
                }
                if (!bl) break;
                if (!spectralSetupParameters.isSpectralLineWSEnabled()) {
                    this.setSPWWalshSwitchingDocumentState();
                }
                this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, true);
                this.spectralWindowModels.stream().forEach(spectralWindowGroupModel -> spectralWindowGroupModel.publish(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE, spectralSetupParameters.isWalshSwitching()));
                break;
            }
            default: {
                throw new RuntimeException("Unknown spectral type specified");
            }
        }
    }

    public void setSPWWalshSwitchingDocumentState() {
        Object object = this.getDocument();
        if (object == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
        boolean bl = spectralSetupParameters.getAdvancedSpectralSetup().getSideBandSeparation();
        switch (spectralSetupParameters.getSpectralType()) {
            case SPECTRALLINE: 
            case SINGLECONTINUUM: {
                for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                    scienceSpectralWindow.getAdvancedWindowSetup().setUseImage(bl);
                }
                break;
            }
            case SPECTRALSCAN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown spectral type detected " + (Object)((Object)spectralSetupParameters.getSpectralType()));
            }
        }
    }

    @Override
    public void setSPWBandwidthToWalshSwitchingCompatibility() {
        Object object = this.getDocument();
        if (object == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
        if (!spectralSetupParameters.getAdvancedSpectralSetup().getSideBandSeparation()) {
            return;
        }
        switch (spectralSetupParameters.getSpectralType()) {
            case SPECTRALLINE: {
                Frequency frequency = Frequency.createFrequencyMHZ(1875.0);
                CorrConfigMode corrConfigMode = this.correlatorExpert.getSpectralLineWalshSwitchMode(spectralSetupParameters.getCorrPolarization());
                for (ScienceSpectralWindow scienceSpectralWindow2 : spectralSetupParameters.getScienceSpectralWindow()) {
                    if (scienceSpectralWindow2.getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)frequency)) continue;
                    scienceSpectralWindow2.setCorrConfigMode(corrConfigMode);
                    AdvancedWindowSetup advancedWindowSetup = scienceSpectralWindow2.getAdvancedWindowSetup();
                    if (advancedWindowSetup.getSmoothingFactor() != 1) continue;
                    advancedWindowSetup.setSmoothingFactor(2);
                }
                break;
            }
            case SPECTRALSCAN: {
                break;
            }
            case SINGLECONTINUUM: {
                CorrConfigMode corrConfigMode = this.correlatorExpert.getContinuumMode(spectralSetupParameters.getCorrPolarization());
                Arrays.stream(spectralSetupParameters.getScienceSpectralWindow()).forEach(scienceSpectralWindow -> scienceSpectralWindow.setCorrConfigMode(corrConfigMode));
                break;
            }
            default: {
                throw new RuntimeException("Unknown spectral type detected " + (Object)((Object)spectralSetupParameters.getSpectralType()));
            }
        }
    }

    public boolean isSpectralLineSetupWalshSwitchingCompatible() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null || !spectralSetupParameters.isSpectralLine()) {
            return false;
        }
        return ReceiverBand.isWalshReceiverSelected(spectralSetupParameters);
    }

    @Override
    public void setDocument(Object object) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        this.setInitialisingDocument(true);
        SpectralSetupParameters spectralSetupParameters2 = (SpectralSetupParameters)((Object)object);
        if (spectralSetupParameters2.isSpectralLine() && spectralSetupParameters2.isWalshSwitching()) {
            spectralSetupParameters2.setSpectralLineWSEnabled(true);
        }
        if (spectralSetupParameters2.isSpectralScan()) {
            this.spectralScanModel.setInhibitCalculationOfRepFreq(true);
        }
        if (spectralSetupParameters == object) {
            this.publish();
            this.setInitialisingDocument(false);
            if (spectralSetupParameters2.isSpectralScan()) {
                this.spectralScanModel.setInhibitCalculationOfRepFreq(false);
            }
            return;
        }
        if (spectralSetupParameters != null) {
            spectralSetupParameters.removeRepresentativeFrequencyListener(this.repFreqModel);
            spectralSetupParameters.removeBasebandSwapListener(this.basebandSwapListener);
            spectralSetupParameters.removeRepresentativeFrequencyListener(this);
        }
        this.document = object;
        for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
            spectralWindowGroupModel.setDocument((Object)spectralSetupParameters2);
        }
        this.repFreqModel.setDocument((Object)spectralSetupParameters2.getRepresentativeFrequency());
        spectralSetupParameters2.addRepresentativeFrequencyListener(this.repFreqModel);
        spectralSetupParameters2.addRepresentativeFrequencyListener(this);
        spectralSetupParameters2.addBasebandSwapListener(this.basebandSwapListener);
        this.singleContinuumModel.setDocument(new SingleContinuumObservingFrequency(spectralSetupParameters2));
        if (spectralSetupParameters2.isSpectralScan()) {
            this.spectralScanModel.setDocument((Object)spectralSetupParameters2.getSpectralScan());
        }
        this.publish();
        if (spectralSetupParameters2.isSpectralScan()) {
            this.spectralScanModel.setInhibitCalculationOfRepFreq(false);
        }
        this.restoreOverlayLinesFromDocument();
        this.setInitialisingDocument(false);
        this.setActiveWalshSwitchingComponents(spectralSetupParameters2);
        if (this.obsProposalModel != null) {
            this.obsProposalModel.publishProposalType();
        }
    }

    private void restoreOverlayLinesFromDocument() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        List<SpectralLine> list = spectralSetupParameters.getOverlayLines();
        if (!list.isEmpty() || spectralSetupParameters.getOverlaidSpectralLineCount() == 0) {
            return;
        }
        for (OverlaidSpectralLine overlaidSpectralLine : spectralSetupParameters.getOverlaidSpectralLine()) {
            SpectralLine spectralLine = new SpectralLine();
            spectralLine.setTransition(overlaidSpectralLine.getTransition());
            spectralLine.setFrequency(overlaidSpectralLine.getRestFrequency());
            spectralLine.setDescription(overlaidSpectralLine.getDescription());
            if (StringUtils.isNotEmpty((CharSequence)overlaidSpectralLine.getSpatalogId())) {
                spectralLine.setLineId(Integer.valueOf(overlaidSpectralLine.getSpatalogId()));
            }
            list.add(spectralLine);
        }
    }

    public boolean isConfiguring() {
        return this.initialisingDocument;
    }

    public void setInitialisingDocument(boolean bl) {
        this.initialisingDocument = bl;
    }

    public ScienceSpectralWindow getRepresentativeWindow() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return null;
        }
        return spectralSetupParameters.getRepresentativeSpectralWindow();
    }

    private void updateSensitivityFrequencyMeasure(SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        String string;
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        switch (spectralSetupTypeChoice) {
            case SINGLECONTINUUM: {
                string = PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH;
                break;
            }
            case SPECTRALSCAN: {
                string = PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_FINESTRESOLUTION;
                break;
            }
            default: {
                string = PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_REPRESENTATIVEWINDOWRESOLUTION;
            }
        }
        performanceParameters.setDesiredSensitivityFrequencyMeasure(string);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
                spectralWindowGroupModel.getTableModel().setTargetIndex(n);
            }
        }
    }

    public SfiScanSetupModel getSpectralScanModel() {
        return this.spectralScanModel;
    }

    public Model getScanSetupModel() {
        return this.spectralScanModel;
    }

    public void publishRepSpectralWindow() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters != null && spectralSetupParameters.isSpectralLine() && spectralSetupParameters.getRepresentativeSpectralWindow() != null) {
            int n = spectralSetupParameters.getRepresentativeSpectralWindow().getIndex();
            AbstractTableModel abstractTableModel = null;
            ScienceSpectralWindow scienceSpectralWindow = null;
            block0: for (SpectralWindowGroupModel spectralWindowGroupModel : this.spectralWindowModels) {
                for (ScienceSpectralWindow scienceSpectralWindow2 : spectralWindowGroupModel.getScienceSpectralWindows()) {
                    if (!scienceSpectralWindow2.getRepresentativeWindow()) continue;
                    scienceSpectralWindow = scienceSpectralWindow2;
                    abstractTableModel = spectralWindowGroupModel.getTableModel();
                    continue block0;
                }
            }
            if (scienceSpectralWindow != null) {
                scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)scienceSpectralWindow.getCenterFrequency());
            } else {
                Log.logger(SpectralSetupParametersModel.class).warning("Unable to locate representative spectral window: cannot update RF");
            }
            if (abstractTableModel != null) {
                abstractTableModel.fireTableRowsUpdated(n, n);
            } else {
                Log.logger(SpectralSetupParametersModel.class).warning("Unable to locate MultiResolutionElementTableModel for representative spectral window: cannot update visualiser");
            }
        }
    }

    public void setObsProposalModel(ObsProposalModel obsProposalModel) {
        this.obsProposalModel = obsProposalModel;
    }

    @Override
    public void representativeFrequencyUpdated(RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent) {
        this.setWalshSwitchingUserAvailability();
    }

    public void assignRestFrequencyLinesToSpectralWindows(List<SpectralLine> list) {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: selectedRestFrequencyLines");
        }
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        assert (spectralSetupParameters != null);
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            scienceSpectralWindow.clearExpectedSpectralLine();
        }
        if (list.isEmpty()) {
            return;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
            Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
            FrequencyRange frequencyRange2 = FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequencyRest(), frequency);
            HashSet<String> hashSet = new HashSet<String>();
            for (SpectralLine spectralLine : list) {
                Integer n = spectralLine.getLineId();
                if (n == null || hashSet.contains(n.toString())) continue;
                if (frequencyRange2.contains(spectralLine.getFrequency())) {
                    scienceSpectralWindow.addExpectedSpectralLine(ExpectedSpectralLine.createNewExpectedLine(spectralLine));
                    hashSet.add(n.toString());
                    continue;
                }
                optional.ifPresent(frequencyRange -> {
                    if (frequencyRange.contains(spectralLine.getFrequency())) {
                        scienceSpectralWindow.addExpectedSpectralLine(ExpectedSpectralLine.createNewExpectedLine(spectralLine));
                        hashSet.add(n.toString());
                    }
                });
            }
        }
    }

    @Override
    public boolean verifySelectedLinesAreValid(SortedList<SpectralLine> sortedList) {
        if (sortedList == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: selectedRestFrequencyLines");
        }
        if (sortedList.isEmpty()) {
            return true;
        }
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        assert (spectralSetupParameters != null);
        for (SpectralLine spectralLine : sortedList) {
            boolean bl = false;
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
                FrequencyRange frequencyRange = FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequencyRest(), frequency);
                if (frequencyRange.contains(spectralLine.getFrequency())) {
                    bl = true;
                    break;
                }
                Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
                if (!optional.isPresent() || !optional.get().contains(spectralLine.getFrequency())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean isExpectedLinesToBeDefinedByPI() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is null when not expected");
        }
        return Stream.of(spectralSetupParameters.getScienceSpectralWindow()).filter(scienceSpectralWindow -> scienceSpectralWindow.getExpectedSpectralLineCount() == 0).findFirst().isPresent();
    }

    public boolean isOverlayLinesDefined() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null) {
            return false;
        }
        return spectralSetupParameters.getOverlaidSpectralLineCount() > 0;
    }

    public void addExistingOverlayLinesToRestFrequencies() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null) {
            return;
        }
        if (spectralSetupParameters.isSpectralScan() || spectralSetupParameters.getOverlaidSpectralLineCount() == 0) {
            return;
        }
        List<OverlaidSpectralLine> list = Arrays.asList(spectralSetupParameters.getOverlaidSpectralLine());
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            Object object;
            int n = scienceSpectralWindow.getExpectedSpectralLineCount();
            if (n > 1) continue;
            if (n == 1) {
                if (!scienceSpectralWindow.hasSplatalogId()) continue;
                int n2 = scienceSpectralWindow.getSplatalogId();
                object = scienceSpectralWindow.getExpectedSpectralLine(0).getSpatalogId();
                if (object == null || Integer.valueOf(object) != n2) continue;
            }
            assert (n == 0 || n == 1);
            Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
            object = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
            FrequencyRange frequencyRange = FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequencyRest(), (Frequency)((Object)object));
            list.stream().filter(overlaidSpectralLine -> {
                String string = overlaidSpectralLine.getSpatalogId();
                for (ExpectedSpectralLine expectedSpectralLine : scienceSpectralWindow.getExpectedSpectralLine()) {
                    String string2 = expectedSpectralLine.getSpatalogId();
                    if (string2 != null && string != null && !string2.equals(string)) continue;
                    return false;
                }
                if (frequencyRange.contains(overlaidSpectralLine.getRestFrequency())) {
                    return true;
                }
                return optional.isPresent() && ((FrequencyRange)optional.get()).contains(overlaidSpectralLine.getRestFrequency());
            }).forEach(overlaidSpectralLine -> scienceSpectralWindow.addExpectedSpectralLine(ExpectedSpectralLine.createNewExpectedLine((AbstractSpectralLine)((Object)((Object)overlaidSpectralLine)))));
        }
    }

    public boolean isSpectralScan() {
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
        if (spectralSetupParameters == null) {
            return false;
        }
        return spectralSetupParameters.isSpectralScan();
    }
}

