/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.text.DecimalFormat;

public class TechnicalJustificationFormatters {
    static String formattedFriendlyTempUnits(UserSensitivity userSensitivity) {
        String[] stringArray = new String[]{UserSensitivity.USERUNIT_K, UserSensitivity.USERUNIT_MK};
        String string = userSensitivity.getUnit();
        if (userSensitivity.isZero(1.0E-6)) {
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(0.0, string);
        }
        double d = userSensitivity.getContentInUnits(string);
        for (String string2 : stringArray) {
            d = userSensitivity.getContentInUnits(string2);
            string = string2;
            if (!(d >= 1.0)) continue;
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string2);
        }
        return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string);
    }

    public static String formattedRangeValueWithUnit(AbstractDoubleWithUnit<?> abstractDoubleWithUnit, AbstractDoubleWithUnit<?> abstractDoubleWithUnit2) {
        return TechnicalJustificationFormatters.formattedValueWithUnit(abstractDoubleWithUnit, "%.2f %s") + " - " + TechnicalJustificationFormatters.formattedValueWithUnit(abstractDoubleWithUnit2, "%.2f %s");
    }

    static String formattedFriendlyFluxUnits(UserSensitivity userSensitivity) {
        String[] stringArray;
        String string = userSensitivity.getUnit();
        if (userSensitivity.isZero(1.0E-6)) {
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(0.0, string);
        }
        double d = userSensitivity.getContentInUnits(string);
        for (String string2 : stringArray = new String[]{UserSensitivity.USERUNIT_JY, UserSensitivity.USERUNIT_MJY, UserSensitivity.USERUNIT_UJY}) {
            d = userSensitivity.getContentInUnits(string2);
            string = string2;
            if (!(d >= 1.0)) continue;
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string2);
        }
        return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string);
    }

    static String formattedFriendlySpeedUnits(double d, String string) {
        double d2 = d * 1000.0;
        if (d2 >= 0.0 && d2 < 1.0E-9) {
            return String.format(string, d2 * 1.0E9, "nm/s");
        }
        if (d2 >= 1.0E-9 && d2 < 1.0E-6) {
            return String.format(string, d2 * 1000000.0, "um/s");
        }
        if (d2 >= 1.0E-6 && d2 < 0.001) {
            return String.format(string, d2 * 1000.0, "mm/s");
        }
        if (d2 >= 0.001 && d2 < 0.01) {
            return String.format(string, d2 * 100.0, "cm/s");
        }
        if (d2 >= 0.01 && d2 < 1000.0) {
            return String.format(string, d2, "m/s");
        }
        if (d2 >= 1000.0 && d2 < 1000000.0) {
            return String.format(string, d2 / 1000.0, "km/s");
        }
        return String.format(string, d, "km/s");
    }

    static String formattedFriendlySpeedUnits(double d) {
        return TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d, "%.2f %s");
    }

    static String formatDisplaySignificantDigitWhenSmall(double d) {
        if (d > 0.1) {
            return String.format("%.2f", d);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        decimalFormat.setMaximumFractionDigits(320);
        return decimalFormat.format(TechnicalJustificationFormatters.roundToSignificantFigures(d, 1));
    }

    private static double roundToSignificantFigures(double d, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Math.ceil(Math.log10(d < 0.0 ? -d : d));
        int n2 = n - (int)d2;
        double d3 = Math.pow(10.0, n2);
        long l = Math.round(d * d3);
        return (double)l / d3;
    }

    public static String formattedValueWithUnit(AbstractDoubleWithUnit<?> abstractDoubleWithUnit, String string) {
        String string2 = abstractDoubleWithUnit.getUnit();
        if (abstractDoubleWithUnit.isZero(1.0E-6)) {
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(0.0, string2);
        }
        double d = abstractDoubleWithUnit.getContentInUnits(string2);
        Object[] objectArray = abstractDoubleWithUnit.unitMap().getUnitsSorted();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            string2 = (String)objectArray[i];
            d = abstractDoubleWithUnit.getContentInUnits(string2);
            if (!(d >= 1.0)) continue;
            return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string2, string);
        }
        return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string2, string);
    }

    public static String tjFormattedValueUnitString(double d, String string) {
        return TechnicalJustificationFormatters.tjFormattedValueUnitString(d, string, "%.2f %s");
    }

    public static String tjFormattedValueUnitString(double d, String string, String string2) {
        return String.format(string2, d, string);
    }

    public static String getKSensitivityEquivalents(UserSensitivity userSensitivity, ScienceGoal scienceGoal) {
        String string = "";
        UserSensitivity userSensitivity2 = userSensitivity.deepCopy();
        UserSensitivity userSensitivity3 = userSensitivity.deepCopy();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters.isAngularResolutionModeAny()) {
            UserAngle[] userAngleArray = ConfigurationHelper.determineARRangeForARModeAny(scienceGoal);
            assert (userAngleArray != null && userAngleArray.length == 2) : "No AR range returned for Any configurations";
            userSensitivity2.setBeamsize((Angle)((Object)userAngleArray[0]));
            userSensitivity3.setBeamsize((Angle)((Object)userAngleArray[1]));
            userSensitivity2.convertToUnit(UserSensitivity.USERUNIT_MK);
            userSensitivity3.convertToUnit(UserSensitivity.USERUNIT_MK);
            string = String.format(", %s-%s", TechnicalJustificationFormatters.formattedFriendlyTempUnits(userSensitivity2), TechnicalJustificationFormatters.formattedFriendlyTempUnits(userSensitivity3));
        } else if (performanceParameters.isAngularResolutionModeRange()) {
            UserAngle userAngle = performanceParameters.getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST);
            UserAngle userAngle2 = performanceParameters.getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.FINEST);
            userSensitivity2.setBeamsize((Angle)((Object)userAngle));
            userSensitivity3.setBeamsize((Angle)((Object)userAngle2));
            userSensitivity2.convertToUnit(UserSensitivity.USERUNIT_MK);
            userSensitivity3.convertToUnit(UserSensitivity.USERUNIT_MK);
            string = userAngle2.isEqual((AbstractDoubleWithUnit)userAngle) ? String.format(", %s", TechnicalJustificationFormatters.formattedFriendlyTempUnits(userSensitivity2)) : String.format(", %s-%s", TechnicalJustificationFormatters.formattedFriendlyTempUnits(userSensitivity2), TechnicalJustificationFormatters.formattedFriendlyTempUnits(userSensitivity3));
        }
        return string;
    }
}

