/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationFormatters;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationListHelper;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;

public class TechnicalJustificationModel
extends Model {
    private UserSensitivity continuumRms;
    private Frequency representativeFrequency;
    TechnicalJustificationListHelper tjeList;
    protected UserAngle desiredResolution;
    protected UserAngle desiredResolutionLimit;
    protected Angle desiredLargestStructure;
    protected UserSensitivity desiredSensitivity;
    protected Frequency sensitivityFrequencyWidth;
    private static final String SENSITIVITY_CALC_UNIT = Sensitivity.UNIT_MJY;
    private static final String FLUX_CALC_UNIT = Flux.UNIT_MJY;
    private static final String FREQUENCY_CALC_UNIT = UserFrequency.USERUNIT_KM_S;
    private static final String SPEED_CALC_UNIT = Speed.UNIT_KM_S;
    private double reqContSensitivity;

    public TechnicalJustificationModel(ScienceGoal scienceGoal) {
        super(scienceGoal);
        ScienceGoal scienceGoal2 = scienceGoal;
        this.tjeList = null != scienceGoal2 ? new TechnicalJustificationListHelper(scienceGoal2) : null;
        this.setParametersWhenDocumentChanges();
    }

    @Override
    public void setDocument(Object object) {
        Log.logger((Object)this).info("Set Document Called on TJ Node");
        super.setDocument(object);
        if (this.document != null) {
            this.tjeList = new TechnicalJustificationListHelper(this.getScienceGoal());
        }
    }

    @Override
    public void setonlyDocument(Object object) {
        super.setonlyDocument(object);
    }

    private void setParametersWhenDocumentChanges() {
        this.representativeFrequency = Frequency.createFrequency();
        this.reqContSensitivity = 0.0;
        this.continuumRms = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq();
    }

    public ScienceGoal getScienceGoal() {
        if (null == this.document) {
            return null;
        }
        return (ScienceGoal)this.document;
    }

    private void recalculateFlagging(ScienceGoal scienceGoal) {
        Log.logger((Object)this).finest("Recalculating TJ Flags");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (null != scienceGoal) {
            boolean bl6;
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            for (bl6 = false; bl6 < targetParametersArray.length; bl6 += 1) {
                TargetParameters targetParameters = targetParametersArray[bl6];
                if (!bl) {
                    bl = targetParameters.isMaxElevationNeedingJustification();
                }
                if (!targetParameters.isRectanglePattern()) continue;
                double d = this.getNyquistSpacing();
                double d2 = targetParameters.getSingleRectangle().getSpacing().getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
                double d3 = Math.abs(d2 - d);
                if (!(d3 > 5.0E-6)) continue;
                bl2 = true;
            }
            bl3 = spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_X.toString()) || spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_Y.toString());
            bl4 = scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration();
            bl6 = performanceParameters.getIsTimeConstrained();
            boolean bl7 = spectralSetupParameters.isNonStandardContinuumFrequency();
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_LOW_MAX_ELEVATION, bl);
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_NYQUIST, bl2);
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SINGLE_POLARISATION, bl3);
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_USER_DEFINED_CALIB, bl4);
            bl5 = performanceParameters.getNeedsMoreTime();
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_ADDITIONAL_TIME, bl5);
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_STD_CONT_FREQ, bl7);
            this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_TIME_CONSTRAINT, bl6);
            if (bl4 || bl5 || bl7 || bl3 || bl6 || bl) {
                Log.logger((Object)this).finest("At least one non standard editor ...");
                this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
            } else {
                this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, false);
                Log.logger((Object)this).finest("Hide the non standard editor section ...");
            }
        }
    }

    private void enableEditor(ScienceGoal scienceGoal, TechnicalJustificationEditor.TechJustEditor techJustEditor, boolean bl) {
        FieldID fieldID = techJustEditor.id;
        String string = techJustEditor.name();
        if (bl) {
            TechnicalJustification technicalJustification = this.tjeList.getTechnicalJustification(scienceGoal, string);
            String string2 = technicalJustification.getJustificationText();
            this.publish(fieldID, string2);
        } else {
            this.publish(fieldID, null);
            this.tjeList.removeTechnicalJustification(scienceGoal, string);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        this.updateRelevantTechnicalJustificationText(fieldID, object);
        return object;
    }

    public void updateRelevantTechnicalJustificationText(FieldID fieldID, Object object) {
        TechnicalJustificationEditor.TechJustEditor techJustEditor = TechnicalJustificationEditor.TechJustEditor.getEditor(fieldID);
        if (null != techJustEditor) {
            String string = (String)object;
            ScienceGoal scienceGoal = this.getScienceGoal();
            if (null != scienceGoal) {
                this.tjeList.updateTechnicalJustification(scienceGoal, techJustEditor.name(), string);
            }
        }
    }

    @Override
    public void publish() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (null != scienceGoal) {
            this.tjeList = new TechnicalJustificationListHelper(scienceGoal);
            for (TechnicalJustificationEditor.TechJustEditor techJustEditor : TechnicalJustificationEditor.TechJustEditor.values()) {
                TechnicalJustification technicalJustification = this.tjeList.getTechnicalJustification(scienceGoal, techJustEditor.name());
                String string = technicalJustification.getJustificationText();
                this.publish(techJustEditor.id, string);
            }
            try {
                ObsProposal obsProposal = scienceGoal.getObsProposal();
                if (null != obsProposal && obsProposal.isVLBI()) {
                    this.publishForVLBI(scienceGoal);
                } else if (scienceGoal.isSolarScienceGoal()) {
                    this.publishForSolar(scienceGoal);
                } else {
                    this.publishForNonVLBI(scienceGoal);
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
    }

    private void publishForVLBI(ScienceGoal scienceGoal) {
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, false);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, "");
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, "");
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, "");
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, "");
        this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, 0);
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, "");
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_MIN_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, "");
        this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, "");
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY_COMMENTS, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_ANGULAR_RESOLUTION, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_NYQUIST, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_CORR_COMMENTS, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_CORRELATOR, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_USER_DEFINED_CALIB, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_ADDITIONAL_TIME, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_STD_CONT_FREQ, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SINGLE_POLARISATION, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_TIME_CONSTRAINT, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_LOW_MAX_ELEVATION, false);
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_VLBI, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SOLAR, false);
    }

    private void publishForSolar(ScienceGoal scienceGoal) {
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, false);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, "");
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, "");
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, "");
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, "");
        this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, 0);
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, "");
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, "");
        this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, "");
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY_COMMENTS, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SENSITIVITY, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_ANGULAR_RESOLUTION, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_NYQUIST, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_CORR_COMMENTS, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_CORRELATOR, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_USER_DEFINED_CALIB, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_ADDITIONAL_TIME, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_NON_STD_CONT_FREQ, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SINGLE_POLARISATION, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_TIME_CONSTRAINT, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_LOW_MAX_ELEVATION, false);
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SOLAR, true);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_VLBI, false);
    }

    private void publishForNonVLBI(ScienceGoal scienceGoal) {
        String string;
        double d;
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_VLBI, false);
        this.enableEditor(scienceGoal, TechnicalJustificationEditor.TechJustEditor.ED_SOLAR, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, false);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        ScienceGoal.ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.collapseExpectedProperties();
        UserFrequency userFrequency = performanceParameters.getSensitivityFrequencyWidthAsUF();
        this.desiredSensitivity = performanceParameters.getDesiredSensitivity().deepCopy();
        this.desiredSensitivity.setBeamsize(performanceParameters.getDesiredSensitivity().getBeamsize());
        this.desiredSensitivity.setObservingFrequency(performanceParameters.getDesiredSensitivity().getObservingFrequency().deepCopy());
        this.reqContSensitivity = this.desiredSensitivity.getContentInUnits(SENSITIVITY_CALC_UNIT);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(this.desiredSensitivity));
        double d2 = expectedPropertiesElements.expectedLineWidth.asSpeed().getContentInUnits(SPEED_CALC_UNIT);
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d2));
        double d3 = userFrequency.getContentInUnits(FREQUENCY_CALC_UNIT);
        if (d3 < d2 * 2.0) {
            this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d3, "%.3f %s"));
        } else {
            this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, TechnicalJustificationFormatters.formattedValueWithUnit(userFrequency, "%.3f %s"));
        }
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d3));
        double d4 = d2 / d3;
        String string2 = TechnicalJustificationFormatters.formatDisplaySignificantDigitWhenSmall(d4);
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, string2);
        this.representativeFrequency = spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset();
        UserSensitivity userSensitivity = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq();
        userSensitivity.setContentAndUnit((ValueUnitPair)expectedPropertiesElements.expectedPeakLineFluxDensity);
        UserSensitivity userSensitivity2 = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq();
        userSensitivity2.setContentAndUnit((ValueUnitPair)expectedPropertiesElements.expectedPeakFluxDensity);
        Frequency frequency = expectedPropertiesElements.aggregateBandwith;
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, TechnicalJustificationFormatters.formattedValueWithUnit(frequency, "%.3f %s"));
        this.publishRMSSensitivity(scienceGoal, expectedPropertiesElements);
        UserSensitivity userSensitivity3 = expectedPropertiesElements.lineRms;
        boolean bl = userSensitivity != null && userSensitivity.getContent() > 0.0;
        boolean bl2 = userSensitivity2 != null && userSensitivity2.getContent() > 0.0;
        boolean bl3 = false;
        UserSensitivity userSensitivity4 = this.desiredSensitivity;
        if (bl2) {
            if (bl) {
                if (d3 > 2.0 * d2) {
                    bl3 = true;
                    userSensitivity4 = userSensitivity3;
                }
            } else {
                bl3 = true;
            }
        }
        boolean bl4 = !bl3;
        boolean bl5 = bl2 && bl4 || performanceParameters.getNeedsMoreTime() || spectralSetupParameters.getPolarizationFactor() != 1;
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, bl5);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, bl);
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, bl2 || bl);
        double d5 = 0.0;
        if (bl3) {
            this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity2));
            d5 = userSensitivity2.getContentInUnits(FLUX_CALC_UNIT) / this.reqContSensitivity;
        } else {
            this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity));
            d5 = userSensitivity.getContentInUnits(FLUX_CALC_UNIT) / this.reqContSensitivity;
        }
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, this.snrFormattedValue(d5));
        double d6 = userSensitivity.getContentInUnits(FLUX_CALC_UNIT) / userSensitivity3.getContentInUnits(SENSITIVITY_CALC_UNIT);
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, this.snrFormattedValue(d6));
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity));
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d2 / 3.0));
        if (d2 > 0.0) {
            Object object;
            this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, true);
            Frequency frequency2 = spectralSetupParameters.getRepresentativeBandwidth();
            Frequency frequency3 = spectralSetupParameters.getRepresentativeFrequency();
            if (spectralSetupParameters.isSpectralScan()) {
                frequency2 = spectralSetupParameters.getSpectralScan().getEffectiveBandwidth();
                frequency3 = spectralSetupParameters.getSpectralScan().getCenterFrequency();
            } else {
                object = spectralSetupParameters.getRepresentativeSpectralWindow();
                if (null != object) {
                    Log.logger((Object)this).fine("Reperesentative window identifiedWidth is " + frequency2.toString());
                    frequency2 = object.getEffectiveBandwidth();
                    frequency3 = object.getCenterFrequencySky();
                }
            }
            Log.logger((Object)this).fine("Width is " + frequency2.toString());
            object = Speed.getSpeedResolution(frequency2, frequency3);
            Log.logger((Object)this).fine("representativeWidthAsSpeed is " + object.toString());
            this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(object.getContentInUnits(Speed.UNIT_KM_S)));
            if (d2 > object.getContentInUnits(Speed.UNIT_KM_S)) {
                this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, true);
            } else {
                this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
            }
        } else {
            this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
            this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        }
        double d7 = userSensitivity2.getContentInUnits(FLUX_CALC_UNIT);
        double d8 = this.continuumRms.getContentInUnits(SENSITIVITY_CALC_UNIT);
        double d9 = d7 / d8;
        this.publishContinuumFlux(userSensitivity2, scienceGoal);
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, this.snrFormattedValue(d9));
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, d5 < 3.0 || bl2 && d9 < 3.0 || bl && d6 < 3.0);
        this.publishAngularResolution(scienceGoal);
        this.desiredLargestStructure = performanceParameters.getDesiredLargestScale();
        if (this.desiredLargestStructure.getContentInDefaultUnits() < 0.0) {
            this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, "Undefined");
        } else {
            this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredLargestStructure));
        }
        boolean bl6 = bl && d2 > 0.0 && d2 / d3 < 3.0;
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, bl6);
        if (bl && bl2 && userSensitivity4.getContent() > 0.0) {
            d = expectedPropertiesElements.dynamicRange;
            Log.logger((Object)this).finest("-- Peak Cont Flux            :" + userSensitivity2);
            Log.logger((Object)this).finest("Dynamic Range : " + d);
            string = String.format("%.2f", d);
            this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, string);
            this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, true);
            int[] nArray = new int[]{-1, -1, 1000, 1000, 500, 1000, 400, 250, 170, 150};
            int n = -1;
            if (scienceGoal != null && !scienceGoal.getRepresentativeFrequency().isZero()) {
                try {
                    int n2;
                    ReceiverBand receiverBand = scienceGoal.getReceiverBand();
                    if (receiverBand != null && 0 <= (n2 = receiverBand.getNumber() - 1) && n2 < nArray.length) {
                        n = nArray[receiverBand.getNumber() - 1];
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.logger((Object)this).info("Illegal argument exception was thrown - this could be trapped up front");
                }
            }
            if (n > 0 && (double)n < d) {
                this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, true);
            } else {
                this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
            }
        } else {
            this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
            this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        }
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(expectedPropertiesElements.resolvedVelocity));
        d = expectedPropertiesElements.resPerLineWidth;
        string = TechnicalJustificationFormatters.formatDisplaySignificantDigitWhenSmall(d);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, string);
        boolean bl7 = d2 > 0.0 && bl && expectedPropertiesElements.resolvedVelocity > d2 / 3.0;
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, bl7);
        this.recalculateFlagging(scienceGoal);
    }

    private void publishContinuumFlux(UserSensitivity userSensitivity, ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: piScienceGoal");
        }
        if (userSensitivity == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: peakContFlux");
        }
        String string = TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity);
        String string2 = TechnicalJustificationFormatters.getKSensitivityEquivalents(userSensitivity, scienceGoal);
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, string + string2);
    }

    private void publishAngularResolution(ScienceGoal scienceGoal) {
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        AngularResolutionMode angularResolutionMode = performanceParameters.getAngularResolutionMode();
        this.desiredResolution = performanceParameters.getDesiredAngularResolution();
        this.desiredResolutionLimit = performanceParameters.getAcceptableAngularResolution();
        switch (angularResolutionMode) {
            case Any: {
                this.setAnyAngularResolutionTJField(scienceGoal);
                break;
            }
            case Range: {
                UserAngle userAngle = scienceGoal.getPerformanceParameters().getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST);
                UserAngle userAngle2 = scienceGoal.getPerformanceParameters().getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.FINEST);
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, TechnicalJustificationFormatters.formattedRangeValueWithUnit(userAngle, userAngle2));
                break;
            }
            case SACA: {
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    this.desiredResolution = UserAngle.createUserAngle(configuration.getAchievableResolution(this.representativeFrequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), Angle.UNIT_ARCSEC);
                    this.desiredResolution.setObservingFrequency(this.representativeFrequency);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(TechnicalJustificationModel.class).info("Unable to determine configuration for ACA 7-m : " + invalidConfigurationParametersException.getMessage());
                    return;
                }
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredResolution));
                break;
            }
            case Single: {
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredResolution));
                break;
            }
            default: {
                throw new RuntimeException("Unknown AR mode " + angularResolutionMode);
            }
        }
    }

    private void publishRMSSensitivity(ScienceGoal scienceGoal, ScienceGoal.ExpectedPropertiesElements expectedPropertiesElements) {
        UserSensitivity userSensitivity = expectedPropertiesElements.sensitivityForBW;
        this.continuumRms.setContentAndUnit(userSensitivity);
        this.continuumRms.convertToUnit(this.continuumRms.getFriendlyUnit());
        String string = TechnicalJustificationFormatters.formattedFriendlyFluxUnits(this.continuumRms);
        String string2 = TechnicalJustificationFormatters.getKSensitivityEquivalents(userSensitivity, scienceGoal);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, string + string2);
    }

    private void setAnyAngularResolutionTJField(ScienceGoal scienceGoal) {
        UserAngle[] userAngleArray = ConfigurationHelper.determineARRangeForARModeAny(scienceGoal);
        assert (userAngleArray.length == 2);
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, TechnicalJustificationFormatters.formattedRangeValueWithUnit(userAngleArray[0], userAngleArray[1]));
    }

    private UserSensitivity createUserSensitivityWithDefinedBeamsizeAndObsFreq() {
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity();
        userSensitivity.setBeamsize((Angle)((Object)this.desiredResolution));
        userSensitivity.setObservingFrequency(this.representativeFrequency);
        return userSensitivity;
    }

    private String snrFormattedValue(double d) {
        return String.format("%.1f", d);
    }

    protected UserFrequency getFrequencyResolution(ScienceGoal scienceGoal) {
        UserFrequency userFrequency = scienceGoal.getSpectralSetupParameters().getCriticalResolutionPerPolnSmoothed();
        if (userFrequency == null) {
            return null;
        }
        userFrequency.getObservingFrequency().setContentAndUnit((ValueUnitPair)scienceGoal.getRepresentativeFrequency());
        return userFrequency;
    }

    public String formattedValueWithUnit(AbstractDoubleWithUnit<?> abstractDoubleWithUnit) {
        return TechnicalJustificationFormatters.formattedValueWithUnit(abstractDoubleWithUnit, "%.2f %s");
    }

    public double getNyquistSpacing() {
        return 1.0 / Math.sqrt(3.0) / Antenna.BEAMSIZE_FACTOR;
    }
}

