/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.TimingConstraintsTableLoader;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintTableModel;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintsListEditor;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Time;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;

public class TimingConstraintsListModel
extends Model {
    private TimingConstraintTableModel tcTableModel = null;
    private TemporalParameters currentTimingConstraint = null;
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int MIN_ADVISED_TIME_MARGIN = (int)almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D);
    ValueUnitPairModel allowedMarginModel = new ValueUnitPairModel();

    public TimingConstraintsListModel(Object object) {
        super(object);
        this.registerSubModel(this.allowedMarginModel);
        this.tcTableModel = new TimingConstraintTableModel(this);
    }

    public PerformanceParameters getPerformanceParameters() {
        return (PerformanceParameters)this.getDocument();
    }

    public TimingConstraintTableModel getTimingConstraintsTableModel() {
        return this.tcTableModel;
    }

    @Override
    public void publish() {
        this.allowedMarginModel.publish();
        this.fireTableDataChanged();
        this.publish(TimingConstraintsListEditor.tpCountLabelFID, this.getTemporalParametersCount());
        if (this.getTemporalParametersCount() > 0) {
            this.publish(TimingConstraintsListEditor.TEMPORAL_PARAM_TABLE_FID, this.getPerformanceParameters().getTemporalParameters());
        }
    }

    private void fireTableDataChanged() {
        this.getTimingConstraintsTableModel().fireTableDataChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.tcTableModel.fireTableStructureChanged();
        this.publish();
    }

    public void addTemporalParameters(int n) {
        TemporalParameters temporalParameters = TemporalParameters.createTemporalParameters();
        ZonedDateTime zonedDateTime = TemporalParameters.nowInUTC();
        ZonedDateTime zonedDateTime2 = zonedDateTime.plusDays(1L);
        ZonedDateTime zonedDateTime3 = zonedDateTime2.plusDays(MIN_ADVISED_TIME_MARGIN);
        temporalParameters.setStartTimeInDate(zonedDateTime2);
        temporalParameters.setEndTimeInDate(zonedDateTime3);
        int n2 = MIN_ADVISED_TIME_MARGIN / 2;
        temporalParameters.setAllowedMargin(Time.createTime((double)n2, (String)Time.UNIT_D));
        if (n == -1) {
            n = this.getTemporalParametersCount();
        }
        if (this.getPerformanceParameters().getTemporalParametersCount() > 0) {
            TemporalParameters temporalParameters2 = this.getPerformanceParameters().getTemporalParameters(0);
            temporalParameters.setNote(temporalParameters2.getNote());
        }
        this.getPerformanceParameters().addTemporalParameters(n, temporalParameters);
        this.getTimingConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public TemporalParameters getTemporalParameters(int n) {
        return this.getPerformanceParameters().getTemporalParameters(n);
    }

    public void addTemporalParameters(TemporalParameters temporalParameters) {
        int n = this.getTemporalParametersCount();
        this.getPerformanceParameters().addTemporalParameters(n, temporalParameters);
        this.getTimingConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public void deleteTemporalParameters(int n) {
        if (n != -1) {
            PerformanceParameters performanceParameters = this.getPerformanceParameters();
            if (performanceParameters == null) {
                return;
            }
            TemporalParameters temporalParameters = performanceParameters.getTemporalParameters(n);
            performanceParameters.removeTemporalParameters(temporalParameters);
            this.getTimingConstraintsTableModel().fireTableRowsDeleted(n, n);
        }
    }

    private void swapParams(int n, int n2) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            TemporalParameters temporalParameters = performanceParameters.getTemporalParameters(n2);
            performanceParameters.removeTemporalParameters(temporalParameters);
            performanceParameters.addTemporalParameters(n, temporalParameters);
            this.getTimingConstraintsTableModel().fireTableRowsUpdated(n, n2);
        }
    }

    public void clearTemporalParameters() {
        this.setCurrentTimingConstraint(null);
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters == null) {
            return;
        }
        performanceParameters.clearTemporalParameters();
        this.fireTableDataChanged();
        this.publish();
    }

    public void downTemporalParameters(int n) {
        if (n != -1 && n < this.getTemporalParametersCount() - 1) {
            this.swapParams(n, n + 1);
        }
    }

    public int getTemporalParametersCount() {
        return this.document == null ? 0 : this.getPerformanceParameters().getTemporalParametersCount();
    }

    public int getTimingConstraintsTableRowCount() {
        TimingConstraintTableModel timingConstraintTableModel = this.getTimingConstraintsTableModel();
        return timingConstraintTableModel == null ? 0 : timingConstraintTableModel.getRowCount();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    public TemporalParameters getCurrentTimingConstraint() {
        return this.currentTimingConstraint;
    }

    public void setCurrentTimingConstraint(Object object) {
        this.currentTimingConstraint = (TemporalParameters)object;
        if (null != this.currentTimingConstraint) {
            this.allowedMarginModel.setDocument(this.currentTimingConstraint.getAllowedMargin());
        }
    }

    public AbstractValueUnitPairModel getAllowedMarginModel() {
        return this.allowedMarginModel;
    }

    public void updateAssociatedeNote(String string) {
        TemporalParameters temporalParameters = this.getCurrentTimingConstraint();
        if (null != temporalParameters) {
            temporalParameters.setNote(string);
        }
    }

    public void importTimingConstraintsFromFile(File file, boolean bl) {
        Boolean bl2;
        if (file == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: file");
        }
        TimingConstraintsTableLoader timingConstraintsTableLoader = new TimingConstraintsTableLoader();
        try {
            bl2 = timingConstraintsTableLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        if (!bl2.booleanValue()) {
            return;
        }
        if (!bl) {
            this.clearTemporalParameters();
        }
        if (!timingConstraintsTableLoader.getList().isEmpty()) {
            this.addToParent(timingConstraintsTableLoader.getList());
        }
    }

    private void addToParent(List<TemporalParameters> list) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: list");
        }
        Iterator<TemporalParameters> iterator = list.iterator();
        while (iterator.hasNext()) {
            TemporalParameters temporalParameters = TemporalParameters.createTemporalParameters();
            try {
                temporalParameters = iterator.next();
                performanceParameters.addTemporalParameters(temporalParameters);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The list should contain only type TemporalParameters");
            }
        }
        this.getTimingConstraintsTableModel().fireTableRowsInserted(0, list.size() - 1);
        this.publish();
    }
}

