/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintListEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintTableModel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeMap;

public class VisitConstraintsListModel
extends Model
implements ModelChangeSubscriber {
    private static final int VISIT_ID_NONE = 0;
    private VisitConstraint currentVisitConstraint = null;
    private VisitConstraintTableModel vcTableModel = null;
    private static final DialogId DIALOG_ORDER_IMPOSSIBLE = new DialogId("VisitConstraints.ImpossibleOrder");
    private ValueUnitPairModel requiredDelayModel = new ValueUnitPairModel();
    ValueUnitPairModel allowedMarginModel = new ValueUnitPairModel();
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int MIN_ADVISED_MARGIN = (int)almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D);

    public ValueUnitPairModel getRequiredDelayModel() {
        return this.requiredDelayModel;
    }

    public ValueUnitPairModel getAllowedMarginModel() {
        return this.allowedMarginModel;
    }

    public VisitConstraintsListModel(Object object) {
        super(object);
        this.vcTableModel = new VisitConstraintTableModel(this);
        this.registerSubModel(this.allowedMarginModel);
        this.registerSubModel(this.requiredDelayModel);
    }

    public VisitConstraint getCurrentVisitConstraint() {
        return this.currentVisitConstraint;
    }

    public PerformanceParameters getPerformanceParameters() {
        return (PerformanceParameters)this.getDocument();
    }

    public VisitConstraintTableModel getVisitConstraintsTableModel() {
        return this.vcTableModel;
    }

    @Override
    public void publish() {
        this.allowedMarginModel.publish();
        this.requiredDelayModel.publish();
        this.fireTableDataChanged();
        this.publish(VisitConstraintListEditor.tpCountLabelFID, this.getVisitConstraintCount());
        if (this.getVisitConstraintCount() > 0) {
            this.publish(VisitConstraintListEditor.VISIT_CONSTRAINT_TABLE_FID, this.getPerformanceParameters().getVisitConstraint());
        }
    }

    private void fireTableDataChanged() {
        this.getVisitConstraintsTableModel().fireTableDataChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.setCurrentVisitConstraint((Object)VisitConstraint.createVisitConstraint());
        this.vcTableModel.fireTableStructureChanged();
    }

    public void addVisitConstraint(int n) {
        this.setCurrentVisitConstraint((Object)VisitConstraint.createVisitConstraint());
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        int n2 = this.getNextFreeVisitId();
        visitConstraint.setVisitId(n2);
        visitConstraint.setIsFixedStart(false);
        int n3 = MIN_ADVISED_MARGIN / 2;
        visitConstraint.setAllowedMargin(Time.createTime((double)n3, (String)Time.UNIT_D));
        if (n2 > 1) {
            visitConstraint.setRequiredDelay(Time.createTime((double)MIN_ADVISED_MARGIN, (String)Time.UNIT_D));
            visitConstraint.setPreviousVisitId(n2 - 1);
        } else {
            visitConstraint.setRequiredDelay(Time.createTime((double)0.0, (String)Time.UNIT_D));
            visitConstraint.setPreviousVisitId(0);
        }
        this.getPerformanceParameters().addVisitConstraint(n, visitConstraint);
        this.getVisitConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public VisitConstraint getVisitConstraint(int n) {
        return this.getPerformanceParameters().getVisitConstraint(n);
    }

    public void addVisit(VisitConstraint visitConstraint) {
        int n = this.getVisitConstraintCount();
        this.getPerformanceParameters().addVisitConstraint(n, visitConstraint);
        this.getVisitConstraintsTableModel().fireTableRowsInserted(n, n);
    }

    public void deleteVisitConstraint(int n) {
        if (n != -1) {
            VisitConstraint visitConstraint = this.getPerformanceParameters().getVisitConstraint(n);
            int n2 = visitConstraint.getVisitId();
            this.removeConstraintDepenciesOnDeletedRow(n2);
            this.getPerformanceParameters().removeVisitConstraint(visitConstraint);
            this.orderVisitConstraints();
            this.getVisitConstraintsTableModel().fireTableRowsDeleted(n, n);
        }
    }

    public void clearVisitConstraintList() {
        this.setCurrentVisitConstraint(null);
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            performanceParameters.clearVisitConstraint();
        }
        this.fireTableDataChanged();
        this.publish();
    }

    private void removeConstraintDepenciesOnDeletedRow(int n) {
        for (VisitConstraint visitConstraint : this.getPerformanceParameters().getVisitConstraint()) {
            if (visitConstraint.getPreviousVisitId() != n) continue;
            visitConstraint.setPreviousVisitId(0);
        }
    }

    private void swapParams(int n, int n2) {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        if (performanceParameters != null) {
            VisitConstraint visitConstraint = performanceParameters.getVisitConstraint(n2);
            performanceParameters.removeVisitConstraint(visitConstraint);
            performanceParameters.addVisitConstraint(n, visitConstraint);
            this.getVisitConstraintsTableModel().fireTableRowsUpdated(n, n2);
        }
    }

    public void orderVisitConstraints() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        int n = performanceParameters.getVisitConstraintCount();
        Hashtable<Integer, VisitConstraint> hashtable = new Hashtable<Integer, VisitConstraint>();
        for (VisitConstraint visitConstraint : performanceParameters.getVisitConstraint()) {
            hashtable.put(visitConstraint.getVisitId(), visitConstraint);
        }
        Hashtable hashtable2 = new Hashtable();
        TreeMap<ZonedDateTime, VisitConstraint> treeMap = new TreeMap<ZonedDateTime, VisitConstraint>();
        int n2 = n;
        int n3 = n + 1;
        hashtable2.put(0, VisitConstraint.nowInUTC());
        while (n2 < n3) {
            n3 = n2;
            n2 = 0;
            for (VisitConstraint[] visitConstraintArray : hashtable.keySet()) {
                if (hashtable2.containsKey(visitConstraintArray)) continue;
                VisitConstraint visitConstraint = (VisitConstraint)((Object)hashtable.get(visitConstraintArray));
                ZonedDateTime zonedDateTime = VisitConstraint.nowInUTC();
                if (visitConstraint.getIsFixedStart()) {
                    zonedDateTime = visitConstraint.getStartTimeInDate();
                    zonedDateTime = zonedDateTime.plus(visitConstraint.getVisitId(), ChronoUnit.MILLIS);
                    ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(zonedDateTime.toInstant(), ZoneOffset.UTC);
                    treeMap.put(zonedDateTime2, visitConstraint);
                    hashtable2.put(visitConstraint.getVisitId(), zonedDateTime2);
                    continue;
                }
                if (hashtable2.containsKey(visitConstraint.getPreviousVisitId())) {
                    zonedDateTime = (ZonedDateTime)hashtable2.get(visitConstraint.getPreviousVisitId());
                    int n4 = (int)Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_S));
                    zonedDateTime = zonedDateTime.plus(n4, ChronoUnit.SECONDS);
                    zonedDateTime = zonedDateTime.plus(visitConstraint.getVisitId(), ChronoUnit.MILLIS);
                    ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(zonedDateTime.toInstant(), ZoneOffset.UTC);
                    treeMap.put(zonedDateTime3, visitConstraint);
                    hashtable2.put(visitConstraint.getVisitId(), zonedDateTime3);
                    continue;
                }
                ++n2;
            }
        }
        if (n > 1) {
            if (treeMap.size() + 1 >= hashtable.size()) {
                VisitConstraint[] visitConstraintArray;
                Collection collection = treeMap.values();
                visitConstraintArray = collection.toArray(new VisitConstraint[collection.size()]);
                int n5 = collection.size();
                int n6 = n5 + 10;
                for (int i = 1; i < n5 + 1; ++i) {
                    int n7 = visitConstraintArray[i - 1].getVisitId();
                    int n8 = i + n6;
                    for (VisitConstraint visitConstraint : visitConstraintArray) {
                        if (visitConstraint.getVisitId() == n7) {
                            visitConstraint.setVisitId(n8);
                            continue;
                        }
                        if (visitConstraint.getPreviousVisitId() != n7) continue;
                        visitConstraint.setPreviousVisitId(n8);
                    }
                }
                for (VisitConstraint visitConstraint : visitConstraintArray) {
                    visitConstraint.setVisitId(visitConstraint.getVisitId() - n6);
                    if (visitConstraint.getPreviousVisitId() <= 0) continue;
                    visitConstraint.setPreviousVisitId(visitConstraint.getPreviousVisitId() - n6);
                }
                performanceParameters.setVisitConstraint(collection.toArray(visitConstraintArray));
                this.getVisitConstraintsTableModel().fireTableDataChanged();
            } else {
                GUIUtilities.warning(DIALOG_ORDER_IMPOSSIBLE, "The order of these visits is not possible");
            }
        }
    }

    public void upVisitConstraints(int n) {
        if (n > 0) {
            this.swapParams(n - 1, n);
        }
    }

    public void downVisitConstraints(int n) {
        if (n != -1 && n < this.getVisitConstraintCount() - 1) {
            this.swapParams(n, n + 1);
        }
    }

    public int getVisitConstraintCount() {
        return this.document == null ? 0 : this.getPerformanceParameters().getVisitConstraintCount();
    }

    public int getVisitConstraintsTableRowCount() {
        VisitConstraintTableModel visitConstraintTableModel = this.getVisitConstraintsTableModel();
        return visitConstraintTableModel == null ? 0 : visitConstraintTableModel.getRowCount();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (fieldID.equals(VisitConstraintEditor.FIXED_START_FID)) {
            boolean bl = object.toString().equals("Specific Date");
            visitConstraint.setIsFixedStart(bl);
            if (bl && (visitConstraint.getStartTime() == null || visitConstraint.getStartTime() == "")) {
                visitConstraint.setStartTimeInDate(VisitConstraint.nowInUTC());
            }
            String string = visitConstraint.getStartTime();
            this.publish(VisitConstraintEditor.START_TIME_FID, string);
        } else if (fieldID.equals(VisitConstraintEditor.START_TIME_FID)) {
            visitConstraint.setStartTime((String)object);
        } else if (fieldID.equals(VisitConstraintEditor.PREVIOUS_VISIT_FID)) {
            String string = object.toString();
            int n = "None".equals(string) || string == null ? 0 : Integer.parseInt(string);
            visitConstraint.setPreviousVisitId(n);
            return string;
        }
        return object;
    }

    public boolean isFixedStart() {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        return null == visitConstraint ? false : visitConstraint.getIsFixedStart();
    }

    public int getNextFreeVisitId() {
        int n = 0;
        for (String string : this.getPreviousVistIds()) {
            int n2 = Integer.valueOf(string);
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    public String[] getPreviousVistIds() {
        Object[] objectArray;
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (visitConstraint == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Integer n = visitConstraint.getVisitId();
        if (null != this.document) {
            for (VisitConstraint visitConstraint2 : objectArray = this.getPerformanceParameters().getVisitConstraint()) {
                Integer n2 = visitConstraint2.getVisitId();
                if (null == n2 || n2.equals(n)) continue;
                arrayList.add(Integer.toString(n2));
            }
        }
        objectArray = new String[arrayList.size()];
        objectArray = (String[])arrayList.toArray(objectArray);
        return objectArray;
    }

    public void setCurrentVisitConstraint(Object object) {
        this.currentVisitConstraint = (VisitConstraint)((Object)object);
        if (this.currentVisitConstraint != null) {
            this.requiredDelayModel.setDocument(this.currentVisitConstraint.getRequiredDelay());
            this.allowedMarginModel.setDocument(this.currentVisitConstraint.getAllowedMargin());
            this.requiredDelayModel.publish();
            this.allowedMarginModel.publish();
        }
    }

    public void updateAssociatedeNote(String string) {
        VisitConstraint visitConstraint = this.getCurrentVisitConstraint();
        if (null != visitConstraint) {
            visitConstraint.setNote(string);
        }
    }
}

