/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.SingleContinuumObservingFrequency;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.valuetypes.ObservingFrequencyEditor;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Frequency;
import javax.swing.SwingUtilities;

public class ObservingFrequencyModel
extends Model {
    public static final FieldID FREQUENCY_TYPE_FID = new FieldID("FrequencyModel.FrequencyType");
    public static final FieldID EDITOR_LABEL_FID = new FieldID("FrequencyModel.EditorLabel");
    public static final FieldID FEEDBACK_LABEL_FID = new FieldID("FrequencyModel.FeedbackLabel");
    public static final FieldID FEEDBACK_AREA_FID = new FieldID("FrequencyModel.FeedbackArea");
    public static final FieldID BAND_SELECTED_FID = new FieldID("FrequencyModel.bandSelected");
    public static final FieldID RESET_TO_STANDARD_FREQ_FID = new FieldID("FrequencyModel.resetToStandardFrequency");
    private final ValueUnitPairModel frequencyModel = new ValueUnitPairModel();
    private boolean updateCentralFrequencyWhenBandChanges = true;
    private final ModelChangeSubscriber freqSubscriber = new ModelChangeSubscriber(){

        @Override
        public void modelChanged(Model model, FieldID fieldID, Object object) {
            ObservingFrequencyModel.this.publish();
        }
    };
    private Integer receiverBandNumber;

    public ObservingFrequencyModel(Object object) {
        super(object);
        this.frequencyModel.subscribe(this.freqSubscriber);
        this.registerSubModel(this.frequencyModel);
    }

    public ObservingFrequency getObservingFrequency() {
        return (ObservingFrequency)this.getDocument();
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            ObservingFrequency observingFrequency = this.getObservingFrequency();
            this.publish(FREQUENCY_TYPE_FID, observingFrequency.getInputType().toString());
            this.publishFeedbackFrequency();
            try {
                this.receiverBandNumber = ReceiverBand.getReceiverBand(observingFrequency.getSkyFrequency()).getNumber();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.setUpdateCentralFrequencyWhenBandChanges(false);
            this.publish(BAND_SELECTED_FID, this.receiverBandNumber);
            this.setUpdateCentralFrequencyWhenBandChanges(true);
        }
    }

    public void publishLight() {
        if (this.document != null) {
            ObservingFrequency observingFrequency = this.getObservingFrequency();
            this.publish(FREQUENCY_TYPE_FID, observingFrequency.getInputType().toString());
            this.publishFeedbackFrequency();
        }
    }

    private Frequency getFeedbackFrequency() {
        ObservingFrequency observingFrequency = this.getObservingFrequency();
        if (observingFrequency.getInputType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return observingFrequency.getRestFrequency();
        }
        return observingFrequency.getSkyFrequency();
    }

    private void publishFeedbackFrequency() {
        Frequency frequency = this.getFeedbackFrequency();
        this.publish(FEEDBACK_AREA_FID, (Object)frequency);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FREQUENCY_TYPE_FID) {
            String string = (String)object;
            this.getObservingFrequency().setInputType(ObservingFrequency.FrequencyType.getFrequencyType(string));
            this.publishFeedbackFrequency();
            return string;
        }
        if (fieldID == BAND_SELECTED_FID && this.getUpdateCentralFrequencyWhenBandChanges().booleanValue()) {
            try {
                this.receiverBandNumber = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            this.setStandardFrequency(ReceiverBand.getReceiverBand(this.receiverBandNumber));
        }
        if (fieldID == RESET_TO_STANDARD_FREQ_FID) {
            if (this.receiverBandNumber == null) {
                return null;
            }
            this.setStandardFrequency(ReceiverBand.getReceiverBand(this.receiverBandNumber));
        }
        if (fieldID == ObservingFrequencyEditor.INPUT_FREQUENCY_VUP) {
            this.publish();
        }
        return object;
    }

    private void setStandardFrequency(ReceiverBand receiverBand) {
        Iterable<SummaryTableRow> iterable;
        if (!(this.getDocument() instanceof SingleContinuumObservingFrequency)) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = ((SingleContinuumObservingFrequency)this.getDocument()).getSpectralSetupParameters();
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(spectralSetupParameters.getPolarisation());
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (spectralSetupParameters.getObservatoryGoal() == null) {
                iterable = spectralSetupParameters.getScienceGoal();
                if (iterable == null) {
                    return;
                }
                bl = ((ScienceGoal)iterable).getObsProposal().isVLBI();
                bl2 = ((ScienceGoal)iterable).isSolarScienceGoal();
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(ObservingFrequencyModel.class).warning("Unable to determine if the project is a VLBI or Solar project");
            return;
        }
        assert (!(bl && bl2));
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        iterable = bl ? almaCapabilities.getVLBIFrequencies() : (bl2 ? almaCapabilities.getSolarFrequencies() : (corrPolarization.equals((Object)CorrPolarization.FULL) ? almaCapabilities.getPolarizationFrequencies() : almaCapabilities.getContinuumFrequencies()));
        Frequency frequency = null;
        for (Frequency frequency2 : iterable) {
            if (!ReceiverBand.getReceiverBand(frequency2).equals(receiverBand)) continue;
            frequency = frequency2;
            break;
        }
        if (frequency == null) {
            return;
        }
        this.frequencyModel.update(null, this.frequencyModel.getValueFID(), frequency.getContentInUnits(this.frequencyModel.getVUP().getUnit()));
        this.frequencyModel.publish();
    }

    @Override
    public void setDocument(Object object) {
        SingleContinuumObservingFrequency singleContinuumObservingFrequency;
        SpectralSetupParameters spectralSetupParameters;
        this.document = (ObservingFrequency)object;
        Boolean bl = this.getObservingFrequency().getInputFrequency().isZero();
        if (object instanceof SingleContinuumObservingFrequency && (spectralSetupParameters = (singleContinuumObservingFrequency = (SingleContinuumObservingFrequency)object).getSpectralSetupParameters()).isSingleContinuum() && this.getObservingFrequency().getInputType().equals((Object)ObservingFrequency.FrequencyType.REST_FREQUENCY)) {
            Frequency frequency = this.getObservingFrequency().getSkyFrequency();
            this.getObservingFrequency().setInputFrequency(frequency);
            this.getObservingFrequency().setInputType(ObservingFrequency.FrequencyType.SKY_FREQUENCY);
        }
        this.frequencyModel.setDocument((Object)this.getObservingFrequency().getInputFrequency());
        if (bl.booleanValue()) {
            this.publish(BAND_SELECTED_FID, 3);
            SwingUtilities.invokeLater(() -> this.setStandardFrequency(ReceiverBand.getReceiverBand(3)));
        }
        this.publish();
    }

    private Boolean getUpdateCentralFrequencyWhenBandChanges() {
        return this.updateCentralFrequencyWhenBandChanges;
    }

    private void setUpdateCentralFrequencyWhenBandChanges(Boolean bl) {
        this.updateCentralFrequencyWhenBandChanges = bl;
    }
}

