/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.valuetypes.OffsetEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.SkyCoordinates;

public class OffsetModel
extends Model {
    private ValueUnitPairModel offsetRAModel = new ValueUnitPairModel();
    private ValueUnitPairModel offsetDecModel = new ValueUnitPairModel();

    public OffsetModel(SkyCoordinates skyCoordinates) {
        super(skyCoordinates);
        this.registerSubModel(this.offsetRAModel);
        this.registerSubModel(this.offsetDecModel);
        this.setDocument(skyCoordinates);
    }

    public ValueUnitPairModel getOffsetRAModel() {
        return this.offsetRAModel;
    }

    public ValueUnitPairModel getOffsetDecModel() {
        return this.offsetDecModel;
    }

    public SkyCoordinates getOffset() {
        return (SkyCoordinates)this.getDocument();
    }

    @Override
    public void publish() {
        SkyCoordinates skyCoordinates = this.getOffset();
        if (skyCoordinates == null) {
            return;
        }
        this.publish(OffsetEditor.FID_SYSTEM, skyCoordinates.getSystem());
        this.offsetRAModel.publish();
        this.offsetDecModel.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        if (fieldID == OffsetEditor.FID_SYSTEM) {
            SkyCoordinates skyCoordinates = this.getOffset();
            skyCoordinates.setSystem(string);
        }
        return string;
    }

    @Override
    public void setonlyDocument(Object object) {
        Class<?> clazz;
        super.setDocument(object);
        if (object != null && (clazz = object.getClass()) != SkyCoordinates.class) {
            throw new RuntimeException("Unexpected document type : " + clazz.getSimpleName());
        }
        if (object != null) {
            this.offsetRAModel.setonlyDocument((Object)this.getOffset().getLongitude());
            this.offsetDecModel.setonlyDocument((Object)this.getOffset().getLatitude());
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }
}

