/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionProviderInterface;
import alma.obsprep.ot.models.sciencegoals.SensitivityProviderInterface;
import alma.obsprep.ot.models.valuetypes.SensitivityFeedbackCalculatorInterface;
import alma.obsprep.ot.models.valuetypes.SensitivityFormModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.etc.editor.SensitivityCalculatorEditor;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;

public class SensitivityFeedbackModel
extends ValueUnitPairModel {
    private String name;
    private SensitivityFormModel sensitivityFormModel;
    protected String unitRequested = null;
    private UserUnitValueUnitPairModel sensitivityModel;
    private AngularResolutionProviderInterface angularResolutionProvider = null;
    private SensitivityProviderInterface sensitivityProvider = null;
    private SensitivityFeedbackCalculatorInterface sensitivityFeedbackCalculator = null;

    public SensitivityFeedbackModel(SensitivityFormModel sensitivityFormModel, UserUnitValueUnitPairModel userUnitValueUnitPairModel, FieldID fieldID) {
        super(null, fieldID);
        this.sensitivityFormModel = sensitivityFormModel;
        this.sensitivityModel = userUnitValueUnitPairModel;
        this.name = fieldID.toString();
    }

    @Override
    public ValueUnitPair getVUP() {
        String string;
        boolean bl;
        String string2;
        boolean bl2;
        if (this.sensitivityModel == null) {
            return null;
        }
        UserSensitivity userSensitivity = (UserSensitivity)this.sensitivityModel.getVUP();
        if (userSensitivity == null) {
            return null;
        }
        UserAngle userAngle = null;
        if (this.angularResolutionProvider != null) {
            try {
                userAngle = this.angularResolutionProvider.getAngularResolution(this.sensitivityModel.getVUP().getUserUnit());
            }
            catch (AngularResolutionProviderInterface.UnableToDetermineResolutionsException unableToDetermineResolutionsException) {
                Log.logger(SensitivityFeedbackModel.class).info("Unable to determine resolutions" + unableToDetermineResolutionsException.getMessage());
                return null;
            }
            if (userAngle != null) {
                assert (userAngle != null);
                userSensitivity = userSensitivity.deepCopy();
                userSensitivity.setBeamsize((Angle)userAngle.inDefaultUnits());
            }
        }
        ValueUnitPair valueUnitPair = (ValueUnitPair)this.document;
        if (this.sensitivityFeedbackCalculator == null) {
            throw new RuntimeException("No sensitivityFeedbackCalculator has been specified");
        }
        this.document = this.sensitivityFeedbackCalculator.getSensitivityFeedback(userSensitivity);
        if (valueUnitPair != null && this.document != null && (bl2 = UserSensitivity.isModelSupportUnit(string2 = valueUnitPair.getUnit())) != (bl = UserSensitivity.isModelSupportUnit(string = ((ValueUnitPair)this.document).getUnit()))) {
            this.unitRequested = null;
        }
        return (ValueUnitPair)this.document;
    }

    public void setBeamsize(Angle angle) {
        UserSensitivity userSensitivity = (UserSensitivity)this.sensitivityModel.getVUP();
        if (null != userSensitivity) {
            userSensitivity.setBeamsize(angle);
        }
    }

    @Override
    public void publish() {
        String string;
        ValueUnitPair valueUnitPair = this.getVUP();
        if (valueUnitPair == null) {
            return;
        }
        if (this.unitRequested == null) {
            this.unitRequested = this.sensitivityFormModel.sensitivityDisplayOption == SensitivityCalculatorEditor.SensitivityDisplayOption.CURRENT ? valueUnitPair.getUnit() : valueUnitPair.defaultUnit();
        }
        switch (this.sensitivityFormModel.sensitivityDisplayOption) {
            case AUTOMATIC: {
                string = valueUnitPair.getUnit();
                this.sensitivityFormModel.convertToFriendlyUnits(valueUnitPair);
                break;
            }
            case CURRENT: {
                string = this.unitRequested;
                break;
            }
            default: {
                string = valueUnitPair.defaultUnit();
            }
        }
        if (!valueUnitPair.getUnit().equals(string)) {
            valueUnitPair.convertToUnit(string);
        }
        this.unitRequested = string;
        String string2 = TextUtils.format(valueUnitPair.getContent(), 0, 5);
        String string3 = valueUnitPair.getUnit();
        this.publish(this.getValueFID(), string2);
        this.publish(this.getUnitFID(), string3);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(this.getUnitFID())) {
            this.unitRequested = (String)object;
        }
        return super.update(editor, fieldID, object);
    }

    @Override
    public void setDocument(Object object) {
    }

    public void setAngularResolutionProvider(AngularResolutionProviderInterface angularResolutionProviderInterface) {
        this.angularResolutionProvider = angularResolutionProviderInterface;
    }

    public SensitivityFeedbackCalculatorInterface getSensitivityFeedbackCalculator() {
        return this.sensitivityFeedbackCalculator;
    }

    public void setSensitivityFeedbackCalculator(SensitivityFeedbackCalculatorInterface sensitivityFeedbackCalculatorInterface) {
        this.sensitivityFeedbackCalculator = sensitivityFeedbackCalculatorInterface;
    }

    public ValueUnitPair<?> getFieldOneFeedback(UserSensitivity userSensitivity) {
        Object object;
        if (userSensitivity.inFluxUnit()) {
            object = userSensitivity.asTemperature();
            if (userSensitivity.getBeamsize().getContent() <= 0.0) {
                object.setContent(Double.POSITIVE_INFINITY);
            }
        } else {
            String string = userSensitivity.defaultUnit();
            double d = userSensitivity.getContentInUnits(string);
            if (userSensitivity.getBeamsize().getContent() <= 0.0) {
                d = 0.0;
            }
            UserSensitivity userSensitivity2 = UserSensitivity.createUserSensitivity();
            userSensitivity2.setObservingFrequency(userSensitivity.getObservingFrequency());
            userSensitivity2.setContentAndUnit(d, string);
            userSensitivity2.setBeamsize(userSensitivity.getBeamsize());
            object = userSensitivity2;
        }
        return object;
    }

    public ValueUnitPair<?> getFieldTwoFeedback(UserSensitivity userSensitivity) {
        Object object = null;
        if (userSensitivity.inFluxUnit()) {
            object = userSensitivity.asTemperature();
            if (userSensitivity.getBeamsize().getContent() <= 0.0) {
                object.setContent(Double.POSITIVE_INFINITY);
            }
        } else {
            if (this.sensitivityProvider == null) {
                throw new RuntimeException("sensitivityProviderInterface has not been defined");
            }
            ValueUnitPair<?> valueUnitPair = this.sensitivityProvider.getSensitivityMeasurement();
            if (valueUnitPair != null && this.angularResolutionProvider != null) {
                UserAngle userAngle = null;
                try {
                    userAngle = this.angularResolutionProvider.getAngularResolution(Angle.UNIT_ARCSEC);
                }
                catch (AngularResolutionProviderInterface.UnableToDetermineResolutionsException unableToDetermineResolutionsException) {
                    Log.logger(SensitivityFeedbackModel.class).warning("Unable to get angular resolution " + unableToDetermineResolutionsException.getMessage());
                    return UserSensitivity.createUserSensitivity();
                }
                assert (userAngle != null);
                UserSensitivity userSensitivity2 = UserSensitivity.createUserSensitivity();
                userSensitivity2.setUserContentAndUserUnit(valueUnitPair);
                userSensitivity2.setObservingFrequency(userSensitivity.getObservingFrequency());
                userSensitivity2.setBeamsize((Angle)((Object)userAngle));
                object = userSensitivity2;
            }
        }
        return object;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSensitivityProviderInterface(SensitivityProviderInterface sensitivityProviderInterface) {
        this.sensitivityProvider = sensitivityProviderInterface;
    }

    public ValueUnitPair<?> getFeedbackValue() {
        return this.getVUP();
    }
}

