/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class SkyCoordsModel
extends Model {
    public static final FieldID FID_LON = new FieldID("SkyCoordsEditor.Lon");
    public static final FieldID FID_ULON = new FieldID("SkyCoordsEditor.LonUnit");
    public static final FieldID FID_LAT = new FieldID("SkyCoordsEditor.Lat");
    public static final FieldID FID_ULAT = new FieldID("SkyCoordsEditor.LatUnit");
    public static final FieldID FID_SYS = new FieldID("SkyCoordsEditor.Sys");
    public static final FieldID FID_RESOLVEDBY = new FieldID("SkyCoordsEditor.ResolvedBy");

    public SkyCoordsModel(SkyCoordinates skyCoordinates) {
        super(skyCoordinates);
    }

    protected SkyCoordinates getSkyCoordinates() {
        return (SkyCoordinates)this.getDocument();
    }

    @Override
    public void publish() {
        SkyCoordinates skyCoordinates = this.getSkyCoordinates();
        if (skyCoordinates == null) {
            return;
        }
        Longitude longitude = skyCoordinates.getLongitude();
        Latitude latitude = skyCoordinates.getLatitude();
        double d = longitude.getContentInUnits(Angle.UNIT_DEG);
        double d2 = latitude.getContentInUnits(Angle.UNIT_DEG);
        this.publish(FID_LON, new Double(d));
        this.publish(FID_ULON, longitude.getUnit());
        this.publish(FID_LAT, new Double(d2));
        this.publish(FID_ULAT, latitude.getUnit());
        this.publish(FID_SYS, skyCoordinates.getSystem());
        this.publish(FID_RESOLVEDBY, null);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        SkyCoordinates skyCoordinates = this.getSkyCoordinates();
        Latitude latitude = skyCoordinates.getLatitude();
        Longitude longitude = skyCoordinates.getLongitude();
        String string = object.toString();
        if (fieldID.equals(FID_SYS)) {
            skyCoordinates.setSystem(string);
        } else if (fieldID.equals(FID_ULON)) {
            longitude.setUnit(string);
        } else if (fieldID.equals(FID_ULAT)) {
            latitude.setUnit(string);
        } else {
            try {
                double d = Double.parseDouble(string);
                if (fieldID.equals(FID_LON)) {
                    longitude.setContent(d);
                } else if (fieldID.equals(FID_LAT)) {
                    latitude.setContent(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean systemConvert(String string) {
        SkyCoordinates skyCoordinates = this.getSkyCoordinates();
        if (skyCoordinates == null) {
            return false;
        }
        if (skyCoordinates.isSystemConvertSupportedForAbsolute(string)) {
            skyCoordinates.convertToSystem(string);
            this.publish(FID_LON, skyCoordinates.getLongitude().getContentInDeg());
            this.publish(FID_LAT, skyCoordinates.getLatitude().getContentInDeg());
            return true;
        }
        return false;
    }
}

