/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class VelocityModel
extends Model {
    private final FieldID centerVelocityUnitFID;
    private final FieldID centerVelocityValueFID;
    private final FieldID referenceSystemFID;
    private final FieldID dopplerCalcTypeFID;
    private final FieldID redshiftFID;
    private NumberFormat formatter = new DecimalFormat("0.000");

    public VelocityModel(Velocity velocity, FieldID fieldID, FieldID fieldID2, FieldID fieldID3, FieldID fieldID4, FieldID fieldID5) {
        super((Object)velocity);
        this.referenceSystemFID = fieldID3;
        this.centerVelocityValueFID = fieldID;
        this.centerVelocityUnitFID = fieldID2;
        this.dopplerCalcTypeFID = fieldID4;
        this.redshiftFID = fieldID5;
    }

    public VelocityModel() {
        this(null, new FieldID("Velocity.referenceSystem"), new FieldID("Velocity.centerVelocity.value"), new FieldID("Velocity.centerVelocity.unit"), new FieldID("Velocity.dopplerCalctype"), new FieldID("Velocity.redshift"));
    }

    public FieldID getCenterVelocityValueFID() {
        return this.centerVelocityValueFID;
    }

    public FieldID getCenterVelocityUnitFID() {
        return this.centerVelocityUnitFID;
    }

    public FieldID getReferenceSystemFID() {
        return this.referenceSystemFID;
    }

    public FieldID getDopplerCalcTypeFID() {
        return this.dopplerCalcTypeFID;
    }

    public FieldID getRedshiftFID() {
        return this.redshiftFID;
    }

    public String[] getKnownReferenceSystemList() {
        return Velocity.getKnownReferenceSystemList();
    }

    public String[] getKnownDopplerCalcTypeList() {
        return Velocity.getKnownDopplerCalcTypeList();
    }

    @Override
    public void publish() {
        Velocity velocity = this.getVelocity();
        if (velocity == null) {
            return;
        }
        String string = this.formatter.format(velocity.getCenterVelocity().getContent());
        String string2 = velocity.getCenterVelocity().getUnit();
        String string3 = velocity.getReferenceSystem();
        String string4 = velocity.getDopplerCalcType();
        String string5 = Double.toString(velocity.asRedshift());
        this.publish(this.getCenterVelocityValueFID(), string);
        this.publish(this.getCenterVelocityUnitFID(), string2);
        this.publish(this.getReferenceSystemFID(), string3);
        this.publish(this.getDopplerCalcTypeFID(), string4);
        this.publish(this.getRedshiftFID(), string5);
    }

    public UnitMap unitMap() {
        Velocity velocity = this.getVelocity();
        if (velocity == null) {
            return null;
        }
        return velocity.getCenterVelocity().unitMap();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Velocity velocity = this.getVelocity();
        if (this.referenceSystemFID.equals(fieldID)) {
            String string = (String)object;
            velocity.setReferenceSystem(string);
        } else if (this.centerVelocityValueFID.equals(fieldID)) {
            String string = (String)object;
            double d = Double.NaN;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (Double.isFinite(d)) {
                velocity.getCenterVelocity().setContent(d);
            }
        } else if (this.centerVelocityUnitFID.equals(fieldID)) {
            String string = (String)object;
            velocity.getCenterVelocity().setUnit(string);
        } else if (this.dopplerCalcTypeFID.equals(fieldID)) {
            String string = (String)object;
            double d = velocity.asRedshift();
            velocity.setDopplerCalcType(string);
            Velocity velocity2 = velocity.fromRedshift(d);
            Speed speed = velocity2.getCenterVelocity();
            speed.convertToUnit(velocity.getCenterVelocity().getUnit());
            velocity.getCenterVelocity().setContent(speed.getContent());
            velocity.getCenterVelocity().setUnit(speed.getUnit());
            this.publish(this.centerVelocityValueFID, this.formatter.format(velocity.getCenterVelocity().getContent()));
            this.publish(this.centerVelocityUnitFID, velocity.getCenterVelocity().getUnit());
            this.publish(this.dopplerCalcTypeFID, velocity.getDopplerCalcType());
        } else if (this.redshiftFID.equals(fieldID)) {
            if (object instanceof String) {
                String string = (String)object;
                try {
                    double d = Double.parseDouble(string);
                    Velocity velocity3 = velocity.fromRedshift(d);
                    Speed speed = velocity3.getCenterVelocity();
                    speed.convertToUnit(velocity.getCenterVelocity().getUnit());
                    velocity.getCenterVelocity().setContentAndUnit((ValueUnitPair)speed);
                    velocity.setDopplerCalcType(velocity3.getDopplerCalcType());
                    this.publish(this.centerVelocityValueFID, this.formatter.format(velocity.getCenterVelocity().getContent()));
                    this.publish(this.centerVelocityUnitFID, velocity.getCenterVelocity().getUnit());
                    this.publish(this.dopplerCalcTypeFID, velocity.getDopplerCalcType());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                throw new IllegalArgumentException("Non-string published as redshift");
            }
        }
        this.updateRedshift();
        return object;
    }

    private void updateRedshift() {
        Velocity velocity = this.getVelocity();
        this.publish(this.redshiftFID, velocity.asRedshift());
    }

    private Velocity getVelocity() {
        return (Velocity)((Object)this.getDocument());
    }
}

