/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.entity.xmlbinding.obsattachment.ObsAttachment;
import alma.entity.xmlbinding.obsproposal.ObsProposal;
import alma.entity.xmlbinding.obsreview.ObsReview;
import alma.entity.xmlbinding.schedblock.SchedBlock;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.util.DatamodelInstanceChecker;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.ZipSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.exolab.castor.xml.XMLException;
import uk.ac.roe.ukatc.xsltchain.ConvertZip;

public class ImpexFactory {
    private static Queue<ProjectResetListener> projectImportListeners = new ConcurrentLinkedQueue<ProjectResetListener>();
    public static DialogId confirmConversionOnImport = new DialogId("Import.ConfirmConversion");
    private static Log.Logger logger = Log.logger(ImpexFactory.class);
    private static Optional<URL> urlOfLastProjectFileImported = Optional.empty();
    static ImpPrj impPrj = new ImpPrj();

    public static void addProjectImportListener(ProjectResetListener projectResetListener) {
        if (!MiscUtils.isOTRunningInProjectRepository()) {
            if (projectImportListeners.contains(projectResetListener)) {
                return;
            }
            projectImportListeners.add(projectResetListener);
        }
    }

    public static void removeImportListener(ProjectResetListener projectResetListener) {
        if (!MiscUtils.isOTRunningInProjectRepository() && projectImportListeners.contains(projectResetListener)) {
            projectImportListeners.remove(projectResetListener);
        }
    }

    public static void exportProject(ObsProject obsProject, OutputStream outputStream) throws XmlConversionException, IOException, UnknownEntityException {
        ImpexFactory.exportProject(obsProject, outputStream, true);
    }

    public static void exportProject(ObsProject obsProject, OutputStream outputStream, boolean bl) throws XmlConversionException, IOException, UnknownEntityException {
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decomposeIncludingFiles(obsProject);
        Apdm_to_BO.SoBundle soBundle = Apdm_to_BO.down(boBundle);
        ImpexFactory.exportRaw(soBundle, boBundle.documents, outputStream, bl);
    }

    public static void exportRaw(Apdm_to_BO.SoBundle soBundle, List<File> list, OutputStream outputStream) throws IOException {
        ImpexFactory.exportRaw(soBundle, list, outputStream, true);
    }

    public static void exportRaw(Apdm_to_BO.SoBundle soBundle, List<File> list, OutputStream outputStream, boolean bl) throws IOException {
        Apdm_to_BO.XmlBundle xmlBundle = Apdm_to_BO.down(soBundle);
        impPrj.writeAot(xmlBundle, list, outputStream, bl);
    }

    public static ObsProject importObsProject(URL uRL, boolean bl) throws XMLException, IOException, PersistenceException {
        WorkingPersistenceData workingPersistenceData;
        MiscUtils.resetJCSCache();
        URL uRL2 = impPrj.checkAndConvert(uRL, bl);
        InputStream inputStream = uRL2.openStream();
        Apdm_to_BO.SoBundle soBundle = impPrj.readAot(inputStream);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(soBundle);
        if (boBundle.boProject == null) {
            throw new ZipException("no project found in input");
        }
        if (!MiscUtils.isOTRunningInProjectRepository()) {
            projectImportListeners.stream().forEach(projectResetListener -> projectResetListener.projectDocumentReset(boBundle.boProject, ImpexFactory.impPrj.workingPersistenceData));
        }
        if ((workingPersistenceData = ImpexFactory.impPrj.workingPersistenceData) == null || workingPersistenceData.schedBlockFreshnessMap.isEmpty()) {
            StaleSBDetector.getInstance().resetSBFreshnessMap(boBundle.boProject);
        }
        try {
            if (boBundle.boProject.getStatus().equals(ObsProject.STATUS_NEWPHASE1) || boBundle.boProject.getStatus().equals(ObsProject.STATUS_PHASE1SUBMITTED)) {
                MendMyStruct.setIndividualPointingPatternsToCustomMosaic(boBundle.boProject.getObsProposal());
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).info("Unable to change pointing patterns to mosaic : " + unknownEntityException.getMessage());
        }
        urlOfLastProjectFileImported = Optional.of(uRL);
        boBundle.boProject.resetAfterImport();
        return boBundle.boProject;
    }

    public static ObsProject importObsProject(URL uRL) throws XMLException, IOException, PersistenceException {
        return ImpexFactory.importObsProject(uRL, true);
    }

    public static ObsProject importProject(InputStream inputStream) throws XMLException, IOException {
        urlOfLastProjectFileImported = Optional.empty();
        Apdm_to_BO.SoBundle soBundle = impPrj.readAot(inputStream);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(soBundle);
        if (boBundle.boProject == null) {
            throw new ZipException("no project found in input");
        }
        return boBundle.boProject;
    }

    public static Optional<URL> getUrlOfLastProjectFileImported() {
        return urlOfLastProjectFileImported;
    }

    static class ImpPrj {
        static final String PROJECT = "ObsProject";
        static final String PROPOSAL = "ObsProposal";
        static final String SCHEDBLOCK = "SchedBlock";
        static final String STATUS = "ProjectStatus";
        static final String REVIEW = "ObsReview";
        static final String ATTACHMENT = "ObsAttachment";
        static final String DOCUMENT = "Document_";
        static final String EXT = ".xml";
        static final String P2USERCHANGEPERSISTENCEFILE = "UserChangePersistence";
        static final String SBSTALENESSPERSISTENCEFILE = "SBStalenessPersistence";
        final WorkingPersistenceData workingPersistenceData = new WorkingPersistenceData();

        ImpPrj() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL checkAndConvert(URL uRL, boolean bl) throws IOException {
            Object object;
            Object object2;
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder("Checking data model versions...");
            String string3 = "This message should never be seen! Please report this";
            try {
                Object object3;
                string2 = System.getProperty("OTDataModelVersion");
                string = System.getProperty("SupportedDataModelVersions");
                if (string == null) {
                    string = string2;
                }
                stringBuilder.append(" This OT produces version ").append(string2);
                stringBuilder.append(". It can read version(s) ").append(string).append(". ");
                if (string == null) {
                    logger.severe("Failed to find OT version info");
                    stringBuilder.append("Failed to find OT version. Update or remove your ObservingTool.properties").append("Failed to find OT data model version!");
                    GUIUtilities.error(null, "Failed to find OT version. Update or remove your ObservingTool.properties");
                    throw new IOException("Failed to find OT version. Update or remove your ObservingTool.properties");
                }
                stringBuilder.append("Processed data contains:");
                object2 = uRL.openStream();
                object = new ZipSupport.ZipReader((InputStream)object2);
                boolean bl2 = false;
                boolean bl3 = false;
                while ((object3 = ((ZipSupport.ZipReader)object).getZipEntry()) != null) {
                    String string4;
                    String string5 = ((ZipEntry)object3).getName();
                    byte[] byArray = ((ZipSupport.ZipNtry)object3).getData();
                    String string6 = new String(byArray);
                    StringReader stringReader = new StringReader(string6);
                    DatamodelInstanceChecker datamodelInstanceChecker = new DatamodelInstanceChecker();
                    if (string5.startsWith(PROJECT)) {
                        string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        stringBuilder.append(" Project=").append(string4);
                        bl2 |= !string.contains(string4);
                        bl3 |= !string2.contains(string4);
                        continue;
                    }
                    if (string5.startsWith(PROPOSAL)) {
                        string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        stringBuilder.append(" Proposal=").append(string4);
                        bl2 |= !string.contains(string4);
                        bl3 |= !string2.contains(string4);
                        continue;
                    }
                    if (string5.startsWith(ATTACHMENT)) {
                        string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        stringBuilder.append(" Documents=").append(string4);
                        bl2 |= !string.contains(string4);
                        bl3 |= !string2.contains(string4);
                        continue;
                    }
                    if (string5.startsWith(REVIEW)) {
                        string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        stringBuilder.append(" Review=").append(string4);
                        bl2 |= !string.contains(string4);
                        bl3 |= !string2.contains(string4);
                        continue;
                    }
                    if (string5.startsWith(STATUS)) {
                        string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        stringBuilder.append(" ProjectStatus=").append(string4);
                        bl2 |= !string.contains(string4);
                        bl3 |= !string2.contains(string4);
                        continue;
                    }
                    if (!string5.startsWith(SCHEDBLOCK)) continue;
                    string4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                    stringBuilder.append(" SB=").append(string4);
                    bl2 |= !string.contains(string4);
                    bl3 |= !string2.contains(string4);
                }
                ((ZipSupport.ZipReader)object).close();
                ((InputStream)object2).close();
                if (!bl2 && !bl3) {
                    object3 = uRL;
                    return object3;
                }
                if (bl2) {
                    stringBuilder.append(" Project requires upgrade.\n");
                    string3 = "This is a project for which upgrading is required.\nYes to upgrade and import, no to ignore and attempt input (may fail)";
                } else if (bl3) {
                    stringBuilder.append(" Upgrade is recommended.\n");
                    string3 = "This is a project for which upgrading is strongly recommended, but not required.\nYes to upgrade and import, no to ignore and attempt input";
                }
            }
            finally {
                logger.info(stringBuilder.toString());
            }
            if (bl && !GUIUtilities.confirm(confirmConversionOnImport, string3)) {
                return uRL;
            }
            string = uRL.getPath();
            object2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf(".aot"));
            object2 = (String)object2 + "000";
            ConvertZip.load_defaults();
            ConvertZip.setBaseURL((String)System.getProperty("ConverterBaseUrl"));
            try {
                object = File.createTempFile((String)object2, ".aot");
                String string7 = ((File)object).getPath();
                ConvertZip.Converter((String)string, (String)"versionmap.txt", (String)"versiontable.txt", (String)string2, (String)string7);
                GUIUtilities.info(confirmConversionOnImport, "Project converted OK");
                return ((File)object).toURI().toURL();
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Could not convert project", (Throwable)exception);
                GUIUtilities.error(null, "Could not convert Project - will try original, but expect problems", exception);
                return uRL;
            }
        }

        Apdm_to_BO.SoBundle readAot(InputStream inputStream) throws XMLException, IOException {
            ZipSupport.ZipNtry zipNtry;
            Apdm_to_BO.SoBundle soBundle = new Apdm_to_BO.SoBundle();
            ImpexFactory.impPrj.workingPersistenceData.clear();
            ZipSupport.ZipReader zipReader = new ZipSupport.ZipReader(inputStream);
            while ((zipNtry = zipReader.getZipEntry()) != null) {
                Object object;
                String string = zipNtry.getName();
                byte[] byArray = zipNtry.getData();
                if (string.startsWith(PROJECT)) {
                    object = new StringReader(new String(byArray, "UTF-8"));
                    soBundle.soProject = alma.entity.xmlbinding.obsproject.ObsProject.unmarshalObsProject((Reader)object);
                    continue;
                }
                if (string.startsWith(PROPOSAL)) {
                    object = new StringReader(new String(byArray, "UTF-8"));
                    soBundle.soProposal = ObsProposal.unmarshalObsProposal((Reader)object);
                    continue;
                }
                if (string.startsWith(ATTACHMENT)) {
                    object = new StringReader(new String(byArray, "UTF-8"));
                    soBundle.soDocuments = ObsAttachment.unmarshalObsAttachment((Reader)object);
                    continue;
                }
                if (string.startsWith(REVIEW)) {
                    object = new StringReader(new String(byArray, "UTF-8"));
                    soBundle.soReview = ObsReview.unmarshalObsReview((Reader)object);
                    continue;
                }
                if (string.startsWith(STATUS)) continue;
                if (string.startsWith(SCHEDBLOCK)) {
                    object = new StringReader(new String(byArray, "UTF-8"));
                    soBundle.soSchedblocks.add(SchedBlock.unmarshalSchedBlock((Reader)object));
                    continue;
                }
                if (string.startsWith(DOCUMENT)) {
                    object = string.substring(DOCUMENT.length());
                    File file = FileUtilities.getTmpDir();
                    File file2 = new File(file, (String)object);
                    file2.deleteOnExit();
                    FileUtilities.bytesToFile(byArray, file2);
                    continue;
                }
                if (string.startsWith(P2USERCHANGEPERSISTENCEFILE)) {
                    this.workingPersistenceData.setMajorChangePersistenceData((ArrayList)SerializationUtils.deserialize((byte[])byArray));
                    continue;
                }
                if (string.startsWith(SBSTALENESSPERSISTENCEFILE)) {
                    try {
                        this.workingPersistenceData.setSchedBlockFreshnessMap((ConcurrentHashMap)SerializationUtils.deserialize((byte[])byArray));
                    }
                    catch (SerializationException serializationException) {
                        Log.logger(ImpPrj.class).info("Unable to deserialize SB stale information : " + serializationException.getMessage());
                    }
                    continue;
                }
                throw new ZipException("Unknown entry in Zip file: " + string);
            }
            zipReader.close();
            inputStream.close();
            return soBundle;
        }

        void writeAot(Apdm_to_BO.XmlBundle xmlBundle, List<File> list, OutputStream outputStream, boolean bl) throws IOException {
            ConcurrentHashMap<String, Integer> concurrentHashMap;
            ZipSupport.ZipWriter zipWriter = new ZipSupport.ZipWriter(outputStream);
            if (xmlBundle.xmlProj != null) {
                zipWriter.putZipEntry("ObsProject.xml", xmlBundle.xmlProj.getBytes("UTF-8"));
            }
            if (xmlBundle.xmlProp != null) {
                zipWriter.putZipEntry("ObsProposal.xml", xmlBundle.xmlProp.getBytes("UTF-8"));
            }
            if (xmlBundle.xmlDocs != null) {
                zipWriter.putZipEntry("ObsAttachment.xml", xmlBundle.xmlDocs.getBytes("UTF-8"));
            }
            if (xmlBundle.xmlReview != null) {
                zipWriter.putZipEntry("ObsReview.xml", xmlBundle.xmlReview.getBytes("UTF-8"));
            }
            for (int i = 0; i < xmlBundle.xmlSBs.size(); ++i) {
                zipWriter.putZipEntry(SCHEDBLOCK + i + EXT, xmlBundle.xmlSBs.get(i).getBytes("UTF-8"));
            }
            for (File serializable2 : list) {
                byte[] byArray = FileUtilities.fileToBytes(serializable2);
                zipWriter.putZipEntry(DOCUMENT + serializable2.getName(), byArray);
            }
            ArrayList<UserEditRestrictionController.MajorChangePersistence> arrayList = UserEditRestrictionController.getInstance().getMajorChangePersistenceData();
            if (!arrayList.isEmpty() && bl) {
                zipWriter.putZipEntry(P2USERCHANGEPERSISTENCEFILE, SerializationUtils.serialize((Serializable)arrayList));
            }
            if (!(concurrentHashMap = StaleSBDetector.getInstance().getSchedBlockFreshnessMap()).isEmpty() && bl) {
                zipWriter.putZipEntry(SBSTALENESSPERSISTENCEFILE, SerializationUtils.serialize(concurrentHashMap));
            }
            zipWriter.close();
        }
    }

    public static class WorkingPersistenceData {
        private ArrayList<UserEditRestrictionController.MajorChangePersistence> majorChangePersistenceData = new ArrayList();
        private ConcurrentHashMap<String, Integer> schedBlockFreshnessMap = new ConcurrentHashMap(50);

        public ArrayList<UserEditRestrictionController.MajorChangePersistence> getMajorChangePersistenceData() {
            return this.majorChangePersistenceData;
        }

        public void setMajorChangePersistenceData(ArrayList<UserEditRestrictionController.MajorChangePersistence> arrayList) {
            this.majorChangePersistenceData = arrayList;
        }

        public ConcurrentHashMap<String, Integer> getSchedBlockFreshnessMap() {
            return this.schedBlockFreshnessMap;
        }

        public void setSchedBlockFreshnessMap(ConcurrentHashMap<String, Integer> concurrentHashMap) {
            this.schedBlockFreshnessMap = concurrentHashMap;
        }

        public void clear() {
            this.schedBlockFreshnessMap.clear();
            this.majorChangePersistenceData.clear();
        }
    }
}

