/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntityRefFinder;
import alma.entities.commonentity.EntityRefT;
import alma.entities.commonentity.EntityT;
import alma.entity.xmlbinding.obsproject.UnitDependenciesT;
import alma.entity.xmlbinding.schedblock.SchedBlock;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.EntityIdFactoryImpl;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.EntityIdUpdatedListenerInterface;
import alma.valuetypes.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MendMyStruct {
    static final ConcurrentLinkedQueue<EntityIdUpdatedListenerInterface> listeners = new ConcurrentLinkedQueue();

    public static void addEntityChangeListener(EntityIdUpdatedListenerInterface entityIdUpdatedListenerInterface) {
        if (entityIdUpdatedListenerInterface == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: listener");
        }
        listeners.add(entityIdUpdatedListenerInterface);
    }

    public static void removeEntityChangeListener(EntityIdUpdatedListenerInterface entityIdUpdatedListenerInterface) {
        if (entityIdUpdatedListenerInterface == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: listener");
        }
        listeners.remove(entityIdUpdatedListenerInterface);
    }

    public static void renewIds(ObsProject obsProject, boolean bl) throws UnknownEntityException, EntityException {
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
        List<Entity> list = boBundle.entities();
        List<EntityRefT> list2 = MendMyStruct.allEntityRefs(boBundle);
        Set<UnitDependenciesT> set = MendMyStruct.getAllSbUnitDependencies(boBundle);
        for (Entity entity : list) {
            if (!bl && !EntityIdFactoryImpl.isOnTheFlyId(entity.getEntityID())) continue;
            String string = entity.getEntityID();
            String string2 = EntityIDFactory.getFactory().assignUniqueEntityId(entity);
            for (EntityRefT entityRefT : list2) {
                if (!string.equals(entityRefT.getEntityId())) continue;
                entityRefT.setEntityId(string2);
            }
            listeners.stream().forEach(entityIdUpdatedListenerInterface -> entityIdUpdatedListenerInterface.entityIdUpdated(string, string2));
            set.forEach(unitDependenciesT -> {
                if (unitDependenciesT.removeDependencyList(string)) {
                    unitDependenciesT.addDependencyList(string2);
                }
            });
        }
    }

    private static Set<UnitDependenciesT> getAllSbUnitDependencies(Apdm_to_BO.BoBundle boBundle) throws EntityException {
        HashSet<UnitDependenciesT> hashSet = new HashSet<UnitDependenciesT>();
        Apdm_to_BO.SoBundle soBundle = Apdm_to_BO.down(boBundle);
        for (SchedBlock schedBlock : soBundle.soSchedblocks) {
            if (schedBlock.getUnitDependencies() == null || schedBlock.getUnitDependencies().getDependencyListCount() <= 0) continue;
            hashSet.add(schedBlock.getUnitDependencies());
        }
        return hashSet;
    }

    public static void sanitizeEntityRefs(ObsProject obsProject) throws UnknownEntityPartException, UnknownEntityException, EntityException {
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
        List<EntityRefT> list = MendMyStruct.allEntityRefs(boBundle);
        for (EntityRefT object2 : list) {
            if (object2.getEntityId() != null) continue;
        }
        List<Entity> list2 = boBundle.entities();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            EntityT entityT = entity.getmCastorEntity();
            if (entityT.getDocumentVersion() == null) {
                entityT.setDocumentVersion("1");
            }
            String string = entityT.getEntityId();
            for (EntityRefT entityRefT : list) {
                if (!string.equals(entityRefT.getEntityId())) continue;
                entityRefT.setDocumentVersion(entityT.getDocumentVersion());
            }
        }
    }

    private static List<EntityRefT> allEntityRefs(Apdm_to_BO.BoBundle boBundle) throws EntityException {
        ArrayList<EntityRefT> arrayList = new ArrayList<EntityRefT>();
        Apdm_to_BO.SoBundle soBundle = Apdm_to_BO.down(boBundle);
        EntityRefFinder entityRefFinder = new EntityRefFinder();
        arrayList.addAll(Arrays.asList(entityRefFinder.findEntityReferences((Object)soBundle.soProject)));
        arrayList.addAll(Arrays.asList(entityRefFinder.findEntityReferences((Object)soBundle.soProposal)));
        arrayList.addAll(Arrays.asList(entityRefFinder.findEntityReferences((Object)soBundle.soDocuments)));
        arrayList.addAll(Arrays.asList(entityRefFinder.findEntityReferences((Object)soBundle.soReview)));
        for (SchedBlock schedBlock : soBundle.soSchedblocks) {
            arrayList.addAll(Arrays.asList(entityRefFinder.findEntityReferences((Object)schedBlock)));
        }
        return arrayList;
    }

    public static void recycleProjectAsNewProject(ObsProject obsProject, boolean bl) throws UnknownEntityException, EntityException {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        MendMyStruct.resetProject(obsProject);
        MendMyStruct.resetProposal(obsProject);
        MendMyStruct.resetObsProgram(obsProject, bl);
        MendMyStruct.resetObsReview(obsProject);
        MendMyStruct.resetDocumentAttachments(obsProject);
        ObsProposal obsProposal = obsProject.getObsProposal();
        if (obsProposal == null) {
            Log.logger(MendMyStruct.class).warning("Unable to determine the proposal when recycling project");
        } else {
            MendMyStruct.resetAnyDescopedScienceGoals(obsProposal);
            MendMyStruct.resetResubmissionFlags(obsProposal);
            MendMyStruct.setIndividualPointingPatternsToCustomMosaic(obsProposal);
        }
        MendMyStruct.renewIds(obsProject, true);
    }

    private static void resetResubmissionFlags(ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: proposal");
        }
        obsProposal.setIsResubmission(false);
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).hasIsResubmission() || !scienceGoal.getIsResubmission()) continue;
            scienceGoal.setIsResubmission(false);
        }
    }

    private static void resetDocumentAttachments(ObsProject obsProject) {
        ObsAttachment obsAttachment;
        ObsProposal obsProposal;
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        if (obsProposal == null) {
            Log.logger(MendMyStruct.class).warning("Unable to locate the obsProposal: unable to reset document attachments when recycling project.");
            return;
        }
        try {
            obsAttachment = obsProposal.gettrueDocuments();
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        if (obsAttachment != null) {
            obsAttachment.detachDocument(DocumentLinkData.DOCUMENTCLASS_TA_COVERPAGE);
            obsAttachment.detachDocument(DocumentLinkData.DOCUMENTCLASS_TA_SCIENCEGOALS);
            obsAttachment.setAssociatedBulkStoreUid(null);
        }
    }

    private static void resetObsReview(ObsProject obsProject) throws UnknownEntityException {
        ObsReview obsReview = null;
        try {
            obsReview = obsProject.getObsReview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obsReview != null) {
            MendMyStruct.clearObservingPlanOfPhase((ObsPhase)((Object)obsReview));
        }
        obsProject.setObsReview(null);
    }

    private static void resetObsProgram(ObsProject obsProject, boolean bl) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram != null) {
            MendMyStruct.clearObservingPlanOfPhase((ObsPhase)((Object)obsProgram));
            if (bl) {
                MendMyStruct.copyP2SGsToP1(obsProject);
            }
            obsProgram.clearAbstractScienceGoal();
            obsProgram.getObsPlan().setStatus(ObsUnit.STATUS_NEWPHASE1);
            obsProgram.getObsPlan().setOUSStatus(null);
        }
    }

    private static void resetProposal(ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        obsProposal.setCycle(obsProject.getIsDDT() ? almaPolicies.getDDTCycleNumber() : almaPolicies.getCycleNumber());
        obsProposal.setDateReceived(null);
        obsProposal.setPreviousProposals("");
        obsProposal.setProposalFeedback(null);
        obsProposal.getObsPlan().setStatus(ObsUnit.STATUS_NEWPHASE1);
        if (obsProposal.hasIsResubmission() && obsProposal.getIsResubmission()) {
            obsProposal.setIsResubmission(false);
        }
        obsProposal.setResubmittedProjectCode("");
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            abstractScienceGoal.setObsUnitSet(null);
        }
    }

    private static void resetProject(ObsProject obsProject) {
        obsProject.setCode("");
        obsProject.setTimeOfCreation("");
        obsProject.clearSubmissionRecord();
        obsProject.setConsensusReport("");
        obsProject.setTaMainComments("");
        obsProject.setTaPhase2Comments("");
        obsProject.setScientificRank(0);
        obsProject.setScientificScore(0.0);
        obsProject.setLetterGrade("D");
        obsProject.setStaffProjectNote("");
        obsProject.setStatus(ObsProject.STATUS_NEWPHASE1);
        obsProject.setProjectStatus(null);
        obsProject.setVersion("0");
        obsProject.setIsCalibration(false);
        obsProject.setIsCommissioning(false);
        obsProject.setManualMode(false);
        obsProject.setSimulationMode(false);
    }

    private static void copyP2SGsToP1(ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: project");
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        assert (obsProposal != null);
        obsProposal.clearAbstractScienceGoal();
        ObsProgram obsProgram = obsProject.getObsProgram();
        assert (obsProgram != null);
        for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
            abstractScienceGoal.getCastorObject().setObsUnitSetRef(null);
            AbstractScienceGoal abstractScienceGoal2 = abstractScienceGoal.deepCopy();
            obsProposal.addAbstractScienceGoal(abstractScienceGoal2);
        }
        obsProgram.clearAbstractScienceGoal();
    }

    public static void setIndividualPointingPatternsToCustomMosaic(ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (!targetParameters.isPointingPattern() || targetParameters.getFieldSinglePointCount() <= 1) continue;
                targetParameters.setIsMosaic(true);
            }
        }
    }

    private static void clearObservingPlanOfPhase(ObsPhase obsPhase) throws UnknownEntityException {
        ObsUnitSet obsUnitSet = obsPhase.gettrueObsPlan();
        if (obsUnitSet != null) {
            for (alma.obsprep.bo.schedblock.SchedBlock object2 : obsUnitSet.findSchedBlocks()) {
                obsUnitSet.removeSchedBlock(object2);
            }
            List<ObsUnitSet> list = obsUnitSet.findObsUnitSets();
            list.remove(obsUnitSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObsUnitSet obsUnitSet2 = (ObsUnitSet)iterator.next();
                obsUnitSet2.removeFromParent();
            }
        }
    }

    public static void resetStatusFromPhase1SubmittedToNewPhase1(ObsProject obsProject) throws IllegalArgumentException, UnknownEntityException {
        if (!ObsProject.STATUS_PHASE1SUBMITTED.equals(obsProject.getStatus())) {
            throw new IllegalArgumentException("Project in state " + obsProject.getStatus());
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        ObsUnitSet obsUnitSet = obsProposal.gettrueObsPlan();
        if (obsUnitSet != null) {
            obsUnitSet.setOUSStatus(null);
            obsUnitSet.setStatus(ObsUnit.STATUS_NEWPHASE1);
            MendMyStruct.clearObservingPlanOfPhase((ObsPhase)((Object)obsProposal));
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            abstractScienceGoal.setObsUnitSet(null);
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        ObsUnitSet obsUnitSet2 = obsProgram.gettrueObsPlan();
        if (obsUnitSet2 != null) {
            obsUnitSet2.setOUSStatus(null);
            obsUnitSet2.setStatus(ObsUnit.STATUS_NEWPHASE1);
        }
        obsProject.setObsReview(null);
        obsProject.setStatus(ObsProject.STATUS_NEWPHASE1);
        obsProject.setProjectStatus(null);
    }

    public static void resetStatusToNewPhase2(ObsProject obsProject) throws IllegalArgumentException, UnknownEntityException {
        ObsUnitSet obsUnitSet = obsProject.getObsProgram().getObsPlan();
        for (ObsUnitSet obsUnitSetComponent : obsUnitSet.findObsUnitSets()) {
            obsUnitSetComponent.setStatus(ObsUnit.STATUS_NEWPHASE2);
            obsUnitSetComponent.setOUSStatus(null);
        }
        for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            schedBlock.setStatus(ObsUnit.STATUS_NEWPHASE2);
            schedBlock.setSBStatus(null);
        }
        obsProject.setStatus(ObsProject.STATUS_NEWPHASE2);
        obsProject.setProjectStatus(null);
    }

    public static void pushStatusFromBrokenToRepaired(ObsProject obsProject) throws UnknownEntityException {
        if (!obsProject.getStatus().equals(Status.STATE_BROKEN)) {
            throw new IllegalArgumentException("Project in state " + obsProject.getStatus());
        }
        obsProject.setStatus(Status.STATE_REPAIRED);
        ObsUnitSet obsUnitSet = obsProject.getObsProgram().getObsPlan();
        for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            if (!schedBlock.getStatus().equals(Status.STATE_BROKEN)) continue;
            schedBlock.setStatus(Status.STATE_PHASE2SUBMITTED);
        }
    }

    public static void moveToCurrentCycle(ObsProject obsProject, String string) throws UnknownEntityException {
        ObsProposal obsProposal = obsProject.getObsProposal();
        obsProposal.setCycle(string);
        String string2 = obsProject.getCode().trim();
        if (!string2.equals("None Assigned") && !string2.isEmpty()) {
            String string3 = obsProposal.getPreviousProposals();
            if (!string3.isEmpty()) {
                string3 = string3 + ", ";
            }
            string3 = string3 + string2;
            obsProposal.setPreviousProposals(string3);
        }
        obsProject.setCode("");
        obsProject.setTimeOfCreation("");
        obsProposal.setDateReceived(null);
    }

    public static void resetAnyDescopedScienceGoals(ObsProposal obsProposal) {
        for (ScienceGoal scienceGoal : obsProposal.getAbstractScienceGoalScienceGoal()) {
            if (!scienceGoal.hasIsDescoped() || !scienceGoal.getIsDescoped()) continue;
            scienceGoal.setIsDescoped(false);
            String string = scienceGoal.getName().replaceFirst("^DESCOPED[ -]*", "");
            scienceGoal.setName(string);
            Log.logger(MendMyStruct.class).info("Science Goal rescoped as part of resetting to clean Phase 1 Project : " + string);
        }
    }
}

