/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.BOWithOwnRenderer;
import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.ProjectTreeTransferHandler;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OverlayedIcon;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProjectTreeNodeRenderer
extends DefaultTreeCellRenderer {
    private final Color HIGHLIGHT_COLOR = Color.yellow;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        int n2;
        BOWithOwnRenderer bOWithOwnRenderer;
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)object;
        Object object2 = projectTreeNode.getUserObject();
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        ColorPalette colorPalette = ((OTTree)jTree).getColorPalette();
        if (ProjectTreeTransferHandler.isClipboarded(projectTreeNode)) {
            this.setForeground(colorPalette.getClipboardColor());
        } else {
            this.setForeground(colorPalette.getForegroundColor());
        }
        if (projectTreeNode.getHighlight()) {
            this.setBackgroundNonSelectionColor(this.HIGHLIGHT_COLOR);
        } else {
            this.setBackgroundNonSelectionColor(null);
        }
        Class<?> clazz = object2.getClass();
        if (object2 instanceof BOWithOwnRenderer) {
            bOWithOwnRenderer = (BOWithOwnRenderer)object2;
            bOWithOwnRenderer.getTreeCellRendererComponent(this, jTree, object, bl, bl2, bl3, n, bl4);
        } else if (clazz.equals(ObsProject.class)) {
            this.renderObsProject(bl2);
        } else if (clazz.equals(ObsProposal.class)) {
            this.renderObsProposal(bl2);
        } else if (clazz.equals(ObsProgram.class)) {
            this.renderObsProgram(bl2);
        } else if (clazz.equals(Circle.class)) {
            this.renderCircle(bl2);
        } else if (clazz.equals(Rectangle.class)) {
            this.renderRectangle(bl2);
        } else if (clazz.equals(Ellipse.class)) {
            this.renderEllipse(bl2);
        } else if (clazz.equals(Polygon.class)) {
            this.renderPolygon(bl2);
        } else if (clazz.equals(SchedBlock.class)) {
            this.renderSchedBlock((SchedBlock)object2, bl2);
        } else if (clazz.equals(ObservingGroup.class)) {
            this.renderObservingGroup(bl2);
        } else if (clazz.equals(Target.class)) {
            this.renderTarget(bl2);
        } else if (clazz.equals(ObsUnitSet.class)) {
            this.renderObsUnitSet((ObsUnitSet)object2, bl2);
        } else if (clazz.equals(OpticalPointingScienceGoal.class)) {
            this.renderOpticalPointingScienceGoal(bl2);
        } else if (clazz.equals(ScienceGoal.class)) {
            this.renderScienceGoal((ScienceGoal)object2, bl2);
        } else if (clazz.equals(ObservatoryGoal.class)) {
            this.renderObservatoryGoal(bl2);
        } else if (object2 instanceof TargetCollection) {
            this.renderTargetFolder(bl2);
        } else if (object2 instanceof FieldSourceCollection) {
            this.renderFieldSourceFolder(bl2);
        } else if (object2 instanceof InstrumentSpecCollection) {
            this.renderInstrumentSpecFolder(bl2);
        } else if (object2 instanceof ObservingParametersCollection) {
            this.renderIntentsFolder(bl2);
        } else {
            this.setNodeToolTip(null);
        }
        if (object2 instanceof BusinessObject) {
            bOWithOwnRenderer = (BusinessObject)object2;
            String string = "previous_text_" + jTree.hashCode();
            String string2 = (String)bOWithOwnRenderer.getNameValue(string);
            String string3 = this.getText();
            if (!string3.equals(string2)) {
                if (string2 != null) {
                    ((OTTree)jTree).sizesRecalculationNeeded();
                }
                bOWithOwnRenderer.setNameValue(string, string3);
            }
        }
        if (((n2 = projectTreeNode.getErrorStatus()) & 8) != 0) {
            this.setIcon(new OverlayedIcon(this.getIcon(), Icons.error_overlay));
        } else if ((n2 & 4) != 0) {
            this.setIcon(new OverlayedIcon(this.getIcon(), Icons.warning_overlay));
        }
        if ((n2 & 2) != 0) {
            this.setFont(MiscUtils.italicize(this.getFont()));
        } else {
            this.setFont(jTree.getFont());
        }
        return this;
    }

    private void setNodeToolTip(String string) {
        String string2 = string != null ? (string.length() > 250 ? "<html><body width=350>" + string.subSequence(0, 250) + "...</body></html>" : (string.length() > 80 ? "<html><body width=350>" + string + "</body></html>" : string)) : string;
        this.setToolTipText(string2);
    }

    private void renderObsProject(boolean bl) {
        this.setIcon(Icons.project);
        this.setNodeToolTip(null);
    }

    private void renderObsProposal(boolean bl) {
        this.setIcon(Icons.proposal);
        this.setNodeToolTip(null);
    }

    private void renderObsProgram(boolean bl) {
        this.setIcon(Icons.program);
        this.setNodeToolTip(null);
    }

    private void renderObservingGroup(boolean bl) {
        this.setIcon(Icons.observingGroup);
        this.setNodeToolTip(null);
    }

    private void renderTarget(boolean bl) {
        this.setIcon(Icons.target);
        this.setNodeToolTip(null);
    }

    private void renderTargetFolder(boolean bl) {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderFieldSourceFolder(boolean bl) {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderInstrumentSpecFolder(boolean bl) {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderIntentsFolder(boolean bl) {
        this.setIcon(Icons.calibratorFolder);
        this.setNodeToolTip(null);
    }

    private void renderCalibrator(boolean bl) {
        this.setIcon(Icons.calibrator);
        this.setNodeToolTip(null);
    }

    private void renderCalibratorFolder(boolean bl) {
        this.setIcon(Icons.calibratorFolder);
        this.setNodeToolTip(null);
    }

    private void renderCircle(boolean bl) {
        this.setIcon(Icons.circle);
        this.setNodeToolTip(null);
    }

    private void renderRectangle(boolean bl) {
        this.setIcon(Icons.rectangle);
        this.setNodeToolTip(null);
    }

    private void renderEllipse(boolean bl) {
        this.setIcon(Icons.ellipse);
        this.setNodeToolTip(null);
    }

    private void renderPolygon(boolean bl) {
        this.setIcon(Icons.polygon);
        this.setNodeToolTip(null);
    }

    private void renderSchedBlock(SchedBlock schedBlock, boolean bl) {
        this.setIcon(Icons.schedBlock);
        if (schedBlock.getNote().length() > 0) {
            this.setNodeToolTip(schedBlock.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderSchedBlockRef(boolean bl) {
        this.setIcon(Icons.schedBlock);
        this.setNodeToolTip(null);
    }

    private void renderObsUnitSet(ObsUnitSet obsUnitSet, boolean bl) {
        this.setIcon(Icons.obsUnitSet);
        if (obsUnitSet.getNote().length() > 0) {
            this.setNodeToolTip(obsUnitSet.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderOpticalPointingScienceGoal(boolean bl) {
        this.setIcon(Icons.optical);
        this.setNodeToolTip(null);
    }

    private void renderScienceGoal(ScienceGoal scienceGoal, boolean bl) {
        this.setIcon(Icons.scienceGoal);
        if (scienceGoal.getNote().length() > 0) {
            this.setNodeToolTip(scienceGoal.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderObservatoryGoal(boolean bl) {
        this.setIcon(Icons.optical);
        this.setNodeToolTip(null);
    }
}

