/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project.transfer;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.ProjectTreeTransferHandler;
import alma.obsprep.ot.project.transfer.TransferExportBo;
import alma.obsprep.ot.project.transfer.TransferImport;
import alma.obsprep.ot.project.transfer.botransferrers.Import;
import alma.obsprep.ot.project.transfer.botransferrers.Import_AbstractScienceGoal_to_ObsPhase;
import alma.obsprep.ot.project.transfer.botransferrers.Import_AttachableToTarget_to_ResourceCollection;
import alma.obsprep.ot.project.transfer.botransferrers.Import_AttachableToTarget_to_SubSBCollection;
import alma.obsprep.ot.project.transfer.botransferrers.Import_CompositionChild;
import alma.obsprep.ot.project.transfer.botransferrers.Import_ObsProgram_to_ObsProject;
import alma.obsprep.ot.project.transfer.botransferrers.Import_ObsUnitSet_to_ObsProgram;
import alma.obsprep.ot.project.transfer.botransferrers.Import_ObsUnitSet_to_ObsProgramFolder;
import alma.obsprep.ot.project.transfer.botransferrers.Import_ObsUnitSet_to_ObsUnitSet;
import alma.obsprep.ot.project.transfer.botransferrers.Import_SchedBlock_to_ObsUnitSet;
import alma.obsprep.ot.project.transfer.botransferrers.Import_ScienceGoal_to_PhaseISciencePlanCollection;
import alma.obsprep.ot.project.transfer.botransferrers.Import_Target_to_SchedBlock;
import alma.obsprep.ot.project.transfer.botransferrers.Import_Target_to_TargetCollection;
import alma.obsprep.ot.project.transfer.botransferrers.Import_WorkbookPage_to_ScienceGoal;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.logging.Level;

public class TransferImportBo
implements TransferImport {
    protected Log.Logger logger;
    private Import[] imps = new Import[]{new Import_AttachableToTarget_to_ResourceCollection(), new Import_AttachableToTarget_to_SubSBCollection(), new Import_Target_to_TargetCollection(), new Import_Target_to_SchedBlock(), new Import_AbstractScienceGoal_to_ObsPhase(), new Import_ScienceGoal_to_PhaseISciencePlanCollection(), new Import_SchedBlock_to_ObsUnitSet(), new Import_ObsUnitSet_to_ObsUnitSet(), new Import_ObsUnitSet_to_ObsProgram(), new Import_ObsUnitSet_to_ObsProgramFolder(), new Import_ObsProgram_to_ObsProject(), new Import_WorkbookPage_to_ScienceGoal(), new Import_CompositionChild()};

    public TransferImportBo() {
        this.logger = Log.logger((Object)this);
    }

    private Import findResponsibleImporter(Import.ImportOperation importOperation) {
        for (int i = 0; i < this.imps.length; ++i) {
            if (!this.imps[i].responsibleFor(importOperation)) continue;
            if (this.logger.trace()) {
                this.logger.log(Log.TRACE, "found appropriate importer for " + importOperation + ": " + this.imps[i].getClass().getSimpleName());
            }
            return this.imps[i];
        }
        if (this.logger.trace()) {
            this.logger.log(Log.TRACE, "couldn't find appropriate importer for " + importOperation);
        }
        return null;
    }

    @Override
    public boolean responsibleFor(DataFlavor[] dataFlavorArray) {
        return Arrays.asList(dataFlavorArray).contains(TransferExportBo.PTN_FLAVOR);
    }

    @Override
    public boolean canImportAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        if (!this.responsibleFor(transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
            TransferExportBo.ProjectNodeTransport projectNodeTransport = (TransferExportBo.ProjectNodeTransport)transferable.getTransferData(TransferExportBo.PTN_FLAVOR);
            ProjectTreeNode projectTreeNode2 = projectNodeTransport.node;
            BusinessObject businessObject2 = (BusinessObject)projectTreeNode2.getUserObject();
            Import.ImportOperation importOperation = new Import.ImportOperation(businessObject2, businessObject, n);
            Import import_ = this.findResponsibleImporter(importOperation);
            if (import_ == null) {
                if (this.logger.finer()) {
                    this.logger.finer("transfer generally not supported: " + importOperation.dragBo + " -> " + importOperation.destBo);
                }
                return false;
            }
            String string = import_.objectionAgainst(importOperation);
            if (this.logger.finer()) {
                this.logger.finer((string == null ? "transfer possible" : "transfer rejected because " + string) + ": " + ProjectTreeTransferHandler.decode(n) + " " + importOperation.dragBo + " -> " + importOperation.destBo);
            }
            return string == null;
        }
        catch (Exception exception) {
            this.logger.fine("failed to analyse transfer: " + exception);
            return false;
        }
    }

    @Override
    public boolean importAt(Transferable transferable, ProjectTreeNode projectTreeNode, int n) {
        if (this.logger.debug()) {
            this.logger.log(Log.DEBUG, "requested to import " + transferable.getClass().getSimpleName() + "@" + transferable.hashCode() + " to " + projectTreeNode);
        }
        try {
            BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
            TransferExportBo.ProjectNodeTransport projectNodeTransport = (TransferExportBo.ProjectNodeTransport)transferable.getTransferData(TransferExportBo.PTN_FLAVOR);
            ProjectTreeNode projectTreeNode2 = projectNodeTransport.node;
            BusinessObject businessObject2 = (BusinessObject)projectTreeNode2.getUserObject();
            Import.ImportOperation importOperation = new Import.ImportOperation(businessObject2, businessObject, n);
            Import import_ = this.findResponsibleImporter(importOperation);
            if (import_ == null) {
                throw new AssertionError((Object)"How could canImportAt return 'yes'? Or was it not called before calling importAt?");
            }
            import_.performImport(importOperation);
            return true;
        }
        catch (Exception exception) {
            this.logger.log(Level.INFO, "failed to import data: " + exception, (Throwable)exception);
            return false;
        }
    }
}

