/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project.transfer.botransferrers;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.project.transfer.botransferrers.Import;
import alma.obsprep.ot.project.transfer.botransferrers.Import_CompositionChild;

public class Import_ObsUnitSet_to_ObsUnitSet
implements Import {
    private Import_CompositionChild worker = new Import_CompositionChild();

    @Override
    public boolean responsibleFor(Import.ImportOperation importOperation) {
        return importOperation.dragBo instanceof ObsUnitSet && importOperation.destBo instanceof ObsUnitSet;
    }

    @Override
    public String objectionAgainst(Import.ImportOperation importOperation) {
        ObsUnitSet obsUnitSet = (ObsUnitSet)importOperation.dragBo;
        ObsUnitSet obsUnitSet2 = (ObsUnitSet)importOperation.destBo;
        if (obsUnitSet2.getSchedBlockCount() > 0) {
            return "Cannot add an ObsUnitSet to an ObsUnitSet which already contains SchedBlocks";
        }
        if (obsUnitSet == obsUnitSet2 || obsUnitSet.findObsUnitSets().contains(obsUnitSet2)) {
            return "Cannot add an ObsUnitSet to itself or one of its own children";
        }
        return this.worker.objectionAgainst(importOperation);
    }

    @Override
    public void performImport(Import.ImportOperation importOperation) throws Exception {
        this.worker.performImport(importOperation);
        this.updateSBOUSReferences((ObsUnitSet)importOperation.destBo);
    }

    private void updateSBOUSReferences(ObsUnitSet obsUnitSet) {
        ObsUnitSet obsUnitSet2;
        if (obsUnitSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: destinationOUS");
        }
        for (obsUnitSet2 = obsUnitSet; obsUnitSet2 != null && obsUnitSet2.getParent() instanceof ObsUnitSet && !obsUnitSet2.getParent().getName().equals("Observing Program"); obsUnitSet2 = (ObsUnitSet)obsUnitSet2.getParent()) {
        }
        if (obsUnitSet2 == null || obsUnitSet2 == obsUnitSet) {
            return;
        }
        try {
            for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
                schedBlock.setObsUnitSet(obsUnitSet2);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(Import_ObsUnitSet_to_ObsUnitSet.class).warning("Unable to find SBs " + unknownEntityException.getMessage());
        }
    }
}

