/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project.transfer.botransferrers;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.ot.boEditors.MultiPageEditor;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.SgNoteModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.ot.project.transfer.botransferrers.Import;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class Import_WorkbookPage_to_ScienceGoal
implements Import {
    private Log.Logger logger = Log.logger((Object)this);
    private final List<Class<? extends Model>> supportedPages = Arrays.asList(FieldSetupModel.class, SgNoteModel.class, TechnicalJustificationModel.class, SpectralSetupParametersModel.class, SfiControlParameterModel.class, CalibrationSetupParametersModel.class);

    @Override
    public boolean responsibleFor(Import.ImportOperation importOperation) {
        return importOperation.dragBo instanceof WorkbookPage && importOperation.destBo instanceof ScienceGoal;
    }

    @Override
    public String objectionAgainst(Import.ImportOperation importOperation) {
        WorkbookPage workbookPage = (WorkbookPage)importOperation.dragBo;
        ScienceGoal scienceGoal = (ScienceGoal)importOperation.destBo;
        MultiPageEditor multiPageEditor = workbookPage.getCollector();
        Model model = multiPageEditor.getModel();
        if (!(model instanceof SingleFieldScienceGoalModel)) {
            return "don't know how to transfer this kind of workbook page";
        }
        ScienceGoal scienceGoal2 = (ScienceGoal)workbookPage.getParent();
        if (scienceGoal2 == scienceGoal) {
            return "workbook pages cannot be copied to their own science goal";
        }
        if (scienceGoal2.getClass() != scienceGoal.getClass()) {
            return "this kind of workbook page doesn't fit under this kind of science goal";
        }
        int n = workbookPage.getIndex();
        View view = multiPageEditor.getPageContent(n);
        Model model2 = view.getModel();
        if (!this.supportedPages.contains(model2.getClass())) {
            return "don't know how to transfer a workbook page of kind " + model2.getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public void performImport(Import.ImportOperation importOperation) throws Exception {
        WorkbookPage workbookPage = (WorkbookPage)importOperation.dragBo;
        ScienceGoal scienceGoal = (ScienceGoal)importOperation.destBo;
        MultiPageEditor multiPageEditor = workbookPage.getCollector();
        int n = workbookPage.getIndex();
        View view = multiPageEditor.getPageContent(n);
        Model model = view.getModel();
        ScienceGoal scienceGoal2 = (ScienceGoal)workbookPage.getParent();
        if (model instanceof FieldSetupModel) {
            if (this.logger.finest()) {
                this.logger.log(Level.FINEST, "the transferred " + workbookPage + " represents a ScienceGoal's list of TargetParameters, trying to copy the latter, and assign the copy to " + scienceGoal);
            }
            scienceGoal.clearTargetParameters();
            for (TargetParameters targetParameters : scienceGoal2.getTargetParameters()) {
                TargetParameters targetParameters2 = targetParameters.deepCopy();
                targetParameters2.addToParent((IBusinessObject)scienceGoal);
            }
            return;
        }
        if (model instanceof SgNoteModel) {
            scienceGoal.setNote(scienceGoal2.getNote());
            return;
        }
        if (model instanceof TechnicalJustificationModel) {
            TechnicalJustification[] technicalJustificationArray = scienceGoal2.getTechnicalJustification();
            TechnicalJustification[] technicalJustificationArray2 = new TechnicalJustification[technicalJustificationArray.length];
            for (int i = 0; i < technicalJustificationArray.length; ++i) {
                technicalJustificationArray2[i] = technicalJustificationArray[i].deepCopy();
            }
            scienceGoal.setTechnicalJustification(technicalJustificationArray2);
            return;
        }
        if (model instanceof SpectralSetupParametersModel) {
            SpectralSetupParameters spectralSetupParameters = scienceGoal2.getSpectralSetupParameters();
            SpectralSetupParameters spectralSetupParameters2 = spectralSetupParameters.deepCopy();
            scienceGoal.setSpectralSetupParameters(spectralSetupParameters2);
            return;
        }
        if (model instanceof SfiControlParameterModel) {
            PerformanceParameters performanceParameters = scienceGoal2.getPerformanceParameters();
            PerformanceParameters performanceParameters2 = performanceParameters.deepCopy();
            scienceGoal.setPerformanceParameters(performanceParameters2);
            return;
        }
        if (model instanceof CalibrationSetupParametersModel) {
            CalibrationSetupParameters calibrationSetupParameters = scienceGoal2.getCalibrationSetupParameters();
            CalibrationSetupParameters calibrationSetupParameters2 = calibrationSetupParameters.deepCopy();
            scienceGoal.setCalibrationSetupParameters(calibrationSetupParameters2);
            return;
        }
    }
}

