/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.valdef.ProblemListModel;
import java.util.logging.Level;

public abstract class AbstractValidator {
    private boolean isValidatorThreadSafe = false;
    private static final double TOLERANCE = 1.0E-5;

    protected abstract void localValidate(BusinessObject var1, ProblemListModel var2);

    public final void validate(BusinessObject businessObject, ProblemListModel problemListModel) {
        try {
            this.localValidate(businessObject, problemListModel);
        }
        catch (Exception exception) {
            Log.logger((Object)this).log(Level.INFO, "Error running the " + this.getClass().getSimpleName() + " on " + businessObject.getClass().getName() + ". Its validation results will be ignored.", (Throwable)exception);
        }
    }

    protected boolean isMultiple(double d, double d2, double d3) {
        double d4 = d / d2;
        double d5 = d4 - Math.floor(d4);
        return d5 <= d3;
    }

    protected boolean isMultiple(double d, double d2) {
        return this.isMultiple(d, d2, 1.0E-5);
    }

    protected boolean isZero(double d, double d2) {
        return Math.abs(d) <= d2;
    }

    protected boolean isZero(double d) {
        return this.isZero(d, 1.0E-5);
    }

    protected boolean equals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    protected boolean equals(double d, double d2) {
        return this.equals(d, d2, 1.0E-5);
    }

    public boolean isValidatorThreadSafe() {
        return this.isValidatorThreadSafe;
    }

    public void setValidatorThreadSafe(boolean bl) {
        this.isValidatorThreadSafe = bl;
    }
}

