/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultProblemListModel
implements ProblemListModel {
    private List<Problem> uncommittedProblems;
    private List<Problem> problems;
    private List<Problem> unpublishedProblems;
    private ArrayList<ProblemListListener> listeners = new ArrayList();

    public DefaultProblemListModel() {
        this.problems = new ArrayList<Problem>();
        this.uncommittedProblems = new ArrayList<Problem>();
        this.unpublishedProblems = new ArrayList<Problem>();
    }

    @Override
    public void addProblemToBuffer(Problem problem) {
        this.uncommittedProblems.add(problem);
    }

    @Override
    public void removeDuplicateProblemsFromBuffer() {
        ArrayList<Problem> arrayList = new ArrayList<Problem>();
        for (int i = 0; i < this.uncommittedProblems.size(); ++i) {
            for (int j = i + 1; j < this.uncommittedProblems.size(); ++j) {
                if (!this.uncommittedProblems.get(i).isEqual(this.uncommittedProblems.get(j))) continue;
                arrayList.add(this.uncommittedProblems.get(j));
            }
        }
        this.uncommittedProblems.removeAll(arrayList);
    }

    @Override
    public void commitProblemsToModel() {
        for (Problem problem : this.uncommittedProblems) {
            this.add(problem);
        }
        this.uncommittedProblems.clear();
    }

    @Override
    public Problem getProblemAt(int n) {
        return this.problems.get(n);
    }

    @Override
    public int getSize() {
        return this.problems.size();
    }

    @Override
    public boolean hasErrorOrWorse() {
        for (Problem problem : this.problems) {
            if (!problem.isErrorOrWorse()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Problem problem) {
        boolean bl;
        List<Problem> list = this.problems;
        synchronized (list) {
            bl = this.problems.add(problem);
        }
        if (bl) {
            int n = this.getSize() - 1;
            this.fireIntervalAdded(this, n, n);
        }
        return bl;
    }

    @Override
    public void clear() {
        int n = this.getSize();
        this.unpublishedProblems.clear();
        this.uncommittedProblems.clear();
        if (n > 0) {
            this.problems.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    @Override
    public void start() {
        this.fireStart(this);
        this.clear();
    }

    @Override
    public void finish() {
        this.fireFinish(this);
    }

    @Override
    public boolean remove(Problem problem) {
        boolean bl;
        int n = this.problems.indexOf(problem);
        boolean bl2 = bl = n >= 0;
        if (bl) {
            this.fireIntervalRemoved(this, n, n);
        }
        return bl;
    }

    @Override
    public void addProblemListListener(ProblemListListener problemListListener) {
        this.listeners.add(problemListListener);
    }

    @Override
    public void removeProblemListListener(ProblemListListener problemListListener) {
        this.listeners.remove(problemListListener);
    }

    protected void fireStart(Object object) {
        this.publish(new ProblemListEvent(object, 1061, -1, -1));
    }

    protected void fireFinish(Object object) {
        this.publish(new ProblemListEvent(object, 1062, -1, -1));
    }

    protected void fireContentsChanged(Object object, int n, int n2) {
        this.publish(new ProblemListEvent(object, 1063, n, n2));
    }

    protected void fireIntervalAdded(Object object, int n, int n2) {
        this.publish(new ProblemListEvent(object, 1064, n, n2));
    }

    protected void fireIntervalRemoved(Object object, int n, int n2) {
        this.publish(new ProblemListEvent(object, 1065, n, n2));
    }

    private void publish(ProblemListEvent problemListEvent) {
        for (ProblemListListener problemListListener : this.listeners) {
            problemListListener.problemListChanged(problemListEvent);
        }
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.problems.iterator();
    }

    @Override
    public void addUnpublishedProblem(Problem problem) {
        this.unpublishedProblems.add(problem);
    }

    @Override
    public Collection<Problem> getUnpublishedProblems() {
        return ImmutableList.copyOf(this.unpublishedProblems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeProblems(ProblemListModel problemListModel) {
        for (int i = 0; i < problemListModel.getSize(); ++i) {
            List<Problem> list = this.problems;
            synchronized (list) {
                this.add(problemListModel.getProblemAt(i));
                continue;
            }
        }
    }
}

