/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.P2GAlerter;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.util.MiscUtils;
import alma.scheduling.projectstatus.StatusBase;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class ValidatorSet {
    private ConcurrentLinkedQueue<Future<?>> validatorThreadCompletionList = new ConcurrentLinkedQueue();
    private ExecutorService fixedThreadPool;
    private HashMap<String, Set<AbstractValidator>> map = new HashMap();
    private Set<AbstractValidator> validatorsForAny = new HashSet<AbstractValidator>();
    private int maxNumberOfProblemsLimit = 600;

    public void setMaxNumberOfProblemsLimit(int n) {
        this.maxNumberOfProblemsLimit = n;
    }

    public void registerValidator(AbstractValidator abstractValidator, Class<?> clazz) {
        Set<AbstractValidator> set = this.mapGet(clazz.getName());
        set.add(abstractValidator);
    }

    public void registerValidator(AbstractValidator abstractValidator) {
        this.validatorsForAny.add(abstractValidator);
    }

    private Set<AbstractValidator> mapGet(String string) {
        Set<AbstractValidator> set = this.map.get(string);
        if (set == null) {
            set = new HashSet<AbstractValidator>();
            this.map.put(string, set);
        }
        return set;
    }

    private Set<AbstractValidator> validatorsFor(BusinessObject businessObject) {
        HashSet<AbstractValidator> hashSet = new HashSet<AbstractValidator>();
        hashSet.addAll(this.mapGet(businessObject.getClass().getName()));
        hashSet.addAll(this.validatorsForAny);
        return hashSet;
    }

    public void validate(BusinessObject businessObject, ProblemListModel problemListModel) {
        HashSet<IBusinessObject> hashSet = new HashSet<IBusinessObject>();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.fixedThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        problemListModel.start();
        this.recursivelyValidate(businessObject, problemListModel, hashSet, true);
        boolean bl = true;
        block2: do {
            bl = true;
            for (Future<?> future : this.validatorThreadCompletionList) {
                if (future.isDone() || future.isCancelled()) continue;
                bl = false;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue block2;
            }
        } while (!bl);
        this.fixedThreadPool.shutdown();
        if (problemListModel.getSize() == 0) {
            problemListModel.add(DefaultProblem.createSuccess("No problems found", "", null));
        }
        if (businessObject instanceof ObsProject) {
            P2GAlerter p2GAlerter = new P2GAlerter((ObsProject)businessObject);
            p2GAlerter.determineIfP2GAttentionNeeded(problemListModel);
        }
        problemListModel.finish();
        stopwatch.stop();
        Log.logger(ValidatorSet.class).info("Time for validation process : " + stopwatch.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void recursivelyValidate(final BusinessObject businessObject, final ProblemListModel problemListModel, Set<IBusinessObject> set, boolean bl) {
        Object object2;
        if (businessObject == null) {
            return;
        }
        if (set.contains(businessObject)) {
            return;
        }
        if (businessObject instanceof SchedBlock) {
            void var6_8;
            object2 = (SchedBlock)businessObject;
            Object object3 = null;
            try {
                ObsProject obsProject = object2.getObsProject();
            }
            catch (UnknownEntityException unknownEntityException) {
                System.out.println("Could not find project!! Report this.");
                unknownEntityException.printStackTrace();
            }
            if (var6_8 == null) {
                return;
            }
            if (object2.getStatus() == SchedBlock.STATUS_NEWPHASE1 && var6_8.getStatus() != ObsProject.STATUS_NEWPHASE1 && var6_8.getStatus() != ObsProject.STATUS_PHASE1SUBMITTED) {
                return;
            }
        }
        if (businessObject instanceof ObsProposal) {
            void var6_11;
            object2 = (ObsProposal)businessObject;
            Object var6_9 = null;
            try {
                ObsProject obsProject = object2.getObsProject();
            }
            catch (UnknownEntityException unknownEntityException) {
                System.out.println("Could not find project!! Report this.");
                unknownEntityException.printStackTrace();
            }
            if (var6_11 == null) {
                return;
            }
            if (var6_11.getStatus() != ObsProject.STATUS_NEWPHASE1 && var6_11.getStatus() != ObsProject.STATUS_PHASE1SUBMITTED) {
                Log.logger((Object)this).log(Level.INFO, "Warning - not validating proposal items");
                return;
            }
        }
        if (businessObject instanceof ObsProject && !bl) {
            return;
        }
        if (businessObject instanceof StatusBase) {
            return;
        }
        if (problemListModel.getSize() > this.maxNumberOfProblemsLimit) {
            return;
        }
        set.add((IBusinessObject)businessObject);
        for (final AbstractValidator abstractValidator : this.validatorsFor(businessObject)) {
            if (abstractValidator.isValidatorThreadSafe() && MiscUtils.isParallelismToBeUsed()) {
                this.validatorThreadCompletionList.add(this.fixedThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        Log.logger(ValidatorSet.class).fine("Executing concurrent validator " + abstractValidator.getClass().getSimpleName());
                        DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
                        abstractValidator.validate(businessObject, defaultProblemListModel);
                        defaultProblemListModel.removeDuplicateProblemsFromBuffer();
                        defaultProblemListModel.commitProblemsToModel();
                        problemListModel.mergeProblems(defaultProblemListModel);
                    }
                }));
                continue;
            }
            Log.logger(ValidatorSet.class).fine("Executing thread unsafe validator " + abstractValidator.getClass().getSimpleName());
            if (MiscUtils.isParallelismToBeUsed()) {
                boolean bl2 = false;
                block7: do {
                    bl2 = true;
                    for (Future<?> future : this.validatorThreadCompletionList) {
                        if (future.isDone() || future.isCancelled()) continue;
                        bl2 = false;
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block7;
                    }
                } while (!bl2);
            }
            DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
            abstractValidator.validate(businessObject, defaultProblemListModel);
            defaultProblemListModel.removeDuplicateProblemsFromBuffer();
            defaultProblemListModel.commitProblemsToModel();
            problemListModel.mergeProblems(defaultProblemListModel);
        }
        for (BusinessObject businessObject2 : businessObject.associatedObjects()) {
            this.recursivelyValidate(businessObject2, problemListModel, set, false);
        }
    }
}

