/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CalibrationSetupParametersValidator
extends AbstractValidator {
    private static final Map<String, Integer> MANDATORY_CALIBRATORS = new HashMap<String, Integer>();

    public CalibrationSetupParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)businessObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (calibrationSetupParameters.isUserDefinedCalibration()) {
            Problem problem;
            for (CalibrationTargetParameters calibrationTargetParameters : calibrationSetupParameters.getCalibrationTargetParameters()) {
                arrayList.add(calibrationTargetParameters.getIntendedUse());
                if (!calibrationTargetParameters.isMaxElevationNeverVisible()) continue;
                problem = DefaultProblem.createError("Static calibrator for " + calibrationTargetParameters.getIntendedUse() + " has a target declination that is never visible", "Select the Calibration Setup node in the Science Goal and choose another target", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            for (QuerySource querySource : calibrationSetupParameters.getQuerySource()) {
                arrayList.add(querySource.getIntendedUse());
                if (!querySource.isMaxElevationNeverVisible()) continue;
                problem = DefaultProblem.createError("Dynamic calibrator  for " + querySource.getIntendedUse() + " has a target declination that is never visible", "Select the Calibration Setup node in the Science Goal and choose another target", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
            int n = 0;
            if (scienceGoal != null) {
                n = scienceGoal.getSpectralSetupParameters().isFullPolarisation().booleanValue() ? 1 : 0;
            }
            for (Map.Entry<String, Integer> entry : MANDATORY_CALIBRATORS.entrySet()) {
                String string = entry.getKey();
                if (string.equals(CalibrationTargetParameters.INTENDEDUSE_POLARIZATION) && n == 0) continue;
                int n2 = Collections.frequency(arrayList, string);
                if (entry.getValue() <= n2) continue;
                String string2 = "No " + string + " calibrator will be observed";
                problem = DefaultProblem.createWarning(string2, "Removal of system-defined calibrators must be justified.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    static {
        MANDATORY_CALIBRATORS.put(CalibrationTargetParameters.INTENDEDUSE_BANDPASS, 1);
        MANDATORY_CALIBRATORS.put(CalibrationTargetParameters.INTENDEDUSE_PHASE, 1);
        MANDATORY_CALIBRATORS.put(CalibrationTargetParameters.INTENDEDUSE_AMPLITUDE, 1);
        MANDATORY_CALIBRATORS.put(CalibrationTargetParameters.INTENDEDUSE_POLARIZATION, 1);
    }
}

