/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Velocity;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import jsky.coords.WorldCoords;

public class ScienceGoalValidator
extends AbstractValidator {
    static AlmaPolicies apol = AlmaPolicies.getInstance();
    static int MAX_TEXTAREA_CHARACTERS = apol.getMaxTextAreaCharacters();
    static int MAX_TUNINGS_PER_GOAL = apol.getMaxRetuningsPerGoal();
    static final boolean TJ_REQUIRED = apol.getIsTechnicalJustificationRequired();
    private static String DEFAULT_SUGGESTION = "Revise the spectral setup or move some of the targets to a different Science Goal";
    private Log.Logger logger = Log.logger((Object)this);

    public ScienceGoalValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Collection<ScienceGoal> collection;
        Object object;
        ScienceGoal scienceGoal = (ScienceGoal)businessObject;
        scienceGoal.clearLo1Tunings();
        Log.logger(ScienceGoalValidator.class).info("science goal validator executed");
        if (scienceGoal.isPhase2ScienceGoal()) {
            object = UserEditRestrictionController.getInstance();
            ((UserEditRestrictionController)object).performUserRestrictedValidationChecks(scienceGoal, problemListModel);
        }
        this.validateAllSourcesHaveUniqueNames(businessObject, problemListModel, scienceGoal);
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ScienceGoalValidator.class).info("Unable to run source cluster algorithm : " + invalidObsProgramParametersException.getMessage());
            return;
        }
        boolean bl = false;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getNonSiderealMotion()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.validateNonSiderealTargetSeparation(businessObject, problemListModel, scienceGoal);
        }
        for (ScienceGoal scienceGoal2 : collection) {
            try {
                MinTuningsCalculator.getLO1Tunings(scienceGoal2);
            }
            catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                object = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer((Problem)object);
                return;
            }
            this.validateDataRates(businessObject, problemListModel, scienceGoal2);
            this.validateLegalNumberOfSourcesDefined(businessObject, problemListModel, scienceGoal2);
            this.validateAllTargetsWillProduceValidSpectralSetups(businessObject, problemListModel, scienceGoal2);
            this.validateFullPolarisationIsDisabledWithACA(businessObject, problemListModel, scienceGoal2);
            this.validateStandAloneACA(businessObject, problemListModel, scienceGoal2);
            int n = 0;
            int n2 = AlmaPolicies.getInstance().getMaxNumberPointings();
            boolean bl2 = false;
            try {
                bl2 = scienceGoal2.getScienceGoalMode().equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA);
            }
            catch (UnknownEntityException unknownEntityException) {
                object = DefaultProblem.createError("Cannot determine if the science goal is standalone ACA", "Review your science goal configuration", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer((Problem)object);
            }
            if (!SpectralSetupParameters.TYPE_SCAN.equals(scienceGoal.getSpectralSetupParameters().getType())) {
                Collection<MinTuningsCalculator.TuningResult> collection2 = null;
                try {
                    collection2 = MinTuningsCalculator.getLO1Tunings(scienceGoal2);
                }
                catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                    object = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                    return;
                }
                assert (collection2 != null);
                n = collection2.size();
                if (n > MAX_TUNINGS_PER_GOAL) {
                    problemListModel.addProblemToBuffer(DefaultProblem.createError("Goal requires more than " + MAX_TUNINGS_PER_GOAL + " tunings", "Package targets with different velocities into separate science goals", (IBusinessObject)scienceGoal));
                }
                int n3 = 0;
                for (MinTuningsCalculator.TuningResult tuningResult : collection2) {
                    for (TargetParameters targetParameters : tuningResult.getTargets()) {
                        n3 += targetParameters.getNumberOfPointings(bl2 ? Array.ARRAY_7M : Array.ARRAY_12M);
                    }
                }
                this.logger.log(Log.DEBUG, "Max Number of Targets Check - MAX is          : " + n2);
                this.logger.log(Log.DEBUG, "Number of Pointing across Tunings is          : " + n3);
                this.logger.log(Log.DEBUG, "Number of Tunings is                          : " + n);
                if (n * n3 > n2) {
                    object = DefaultProblem.createError("There are too many pointing-tuning combinations specified", "Select the Field Setup in the Science Goal and ensure there are no more than " + n2 + " pointings", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                }
            } else {
                try {
                    n = scienceGoal2.getSpectralSetupParameters().getSpectralScan().getTunings().getNumberOfTunings();
                }
                catch (UnableToFindSolutionException unableToFindSolutionException) {
                    Log.logger(ScienceGoalValidator.class).fine("Unable to determine solution for spectral scan in " + scienceGoal.getName());
                }
                if (n * scienceGoal2.getTargetParameters().length > n2) {
                    object = DefaultProblem.createError("There are too many pointing-tuning combinations specified", "Select the Field Setup in the Science Goal and ensure there are no more than " + n2 + " pointings", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer((Problem)object);
                }
            }
            this.validateSingleTuningDoesNotExceedMaxNoOfSBExecs(problemListModel, scienceGoal, n, businessObject);
            this.validateTPFieldSetup(businessObject, problemListModel, scienceGoal);
        }
        this.validateVLBIProjects(problemListModel, scienceGoal);
        this.validateNoFullPolarisationAndSolar(businessObject, problemListModel, scienceGoal);
        this.validateSpectralAveragingNotEnabledInSpectralScans(businessObject, problemListModel, scienceGoal);
        this.validateTJParameters(businessObject, problemListModel, scienceGoal);
        this.validateNonStandardObservingModes(businessObject, problemListModel, scienceGoal);
        this.validateNoToOAndSolarSelection(businessObject, problemListModel, scienceGoal);
        this.validateAllSourcesAreSolar(businessObject, problemListModel, scienceGoal);
    }

    private void validateNoFullPolarisationAndSolar(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine if science goal is Solar:" + unknownEntityException.getMessage());
            return;
        }
        if (bl && scienceGoal.getSpectralSetupParameters().isFullPolarisation().booleanValue()) {
            Problem problem = DefaultProblem.createError("Full polarization cannnot be used with Solar", "Select a different polarization product", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
            return;
        }
    }

    private void validateNoToOAndSolarSelection(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        boolean bl = false;
        try {
            bl = scienceGoal.getObsProposal().isToO();
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        if (!bl) {
            return;
        }
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getNonSiderealMotion() || !targetParameters.getSolarSystemObject().equals(AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN)) continue;
            Problem problem = DefaultProblem.createError("The OT cannot be configured for Solar when the proposal type is Target of Opportunity", "Select a different proposal type or choose a different solar system object in the target parameters.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
            return;
        }
    }

    private void validateAllSourcesAreSolar(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (scienceGoal.getObsProposal().isVLBI()) {
                return;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (targetParameters.getNonSiderealMotion() && targetParameters.getSolarSystemObject().equals(AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN)) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            Problem problem = DefaultProblem.createError("The Sun and a non-solar target have been selected.", "Place the non-solar target into a different Science Goal.", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateVLBIProjects(ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument scienceGoal cannot be null");
        }
        ObsProposal obsProposal = null;
        try {
            obsProposal = scienceGoal.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).fine("Unable to determine obsProposal for science goal");
            return;
        }
        if (obsProposal == null) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to find obsProposal associated with science goal");
            return;
        }
        if (obsProposal.isVLBI() && scienceGoal.getTargetParametersCount() > 1) {
            Problem problem = DefaultProblem.createError("Only a single target per science goal can be specified with a VLBI proposal", "Move targets into other science goals", (IBusinessObject)scienceGoal);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateNonStandardObservingModes(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = null;
        try {
            enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal);
        }
        catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
            this.logger.warning("Unable to determine non-standard observing modes: " + unableToDetermineObservingModesException.getMessage());
            return;
        }
        assert (enumSet != null);
        for (SingleFieldScienceGoalModel.NonStandardMode nonStandardMode : enumSet) {
            Problem problem = DefaultProblem.createWarning("Non-standard observing mode identified", nonStandardMode.getExplanation(), (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateStandAloneACA(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        ScienceGoal.ScienceGoalMode scienceGoalMode;
        try {
            scienceGoalMode = scienceGoal.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalValidator.class).warning("Unable to determine science goal mode " + unknownEntityException.getMessage());
            return;
        }
        assert (scienceGoalMode != null);
        if (scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.STANDALONEACA)) {
            EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = null;
            try {
                enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal);
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                this.logger.warning("Unable to determine non-standard observing modes: " + unableToDetermineObservingModesException.getMessage());
                return;
            }
            if (!enumSet.isEmpty()) {
                Problem problem = DefaultProblem.createError("Non-standard modes are not allowed with stand-alone ACA", "Edit setup such that the non-standard mode is no longer triggered", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private void validateLegalNumberOfSourcesDefined(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (apol.getMaxSourcesPerGoal() > 0 && scienceGoal.getTargetParametersCount() > apol.getMaxSourcesPerGoal()) {
            Problem problem = DefaultProblem.createError("Too many sources in the Science Goal (maximum is " + apol.getMaxSourcesPerGoal() + ")", "Put some of these sources into a separate science goal", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateFullPolarisationIsDisabledWithACA(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (scienceGoal.getPerformanceParameters().getUseACA() && scienceGoal.getSpectralSetupParameters().getPolarisation().equals("FULL") && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            Problem problem = DefaultProblem.createError("ACA observations are not permitted when full polarization is selected ", "De-select the request for ACA observations", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateDataRates(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        String string;
        Problem problem;
        if (scienceGoal.isStandAloneACA()) {
            return;
        }
        List<DataRate> list = null;
        try {
            list = scienceGoal.getInstantaneousDataRates(RequestedArray.TWELVE_M);
        }
        catch (ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            problem = DefaultProblem.createError("Unable to determine instantaneous data rates", "Is the setup of the science goal valid?", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        DataRate dataRate = DataRate.createDataRate((double)AlmaPolicies.getInstance().getInstantaneous12mDataRateMBPS(), (String)DataRate.UNIT_MB_S);
        for (DataRate dataRate2 : list) {
            if (!dataRate2.isGreaterThan((AbstractDoubleWithUnit)dataRate)) continue;
            string = String.format("12-m array peak data rate (%.2f MB/s) exceeds the max allowed (%.2f MB/s)", dataRate2.getContentInUnits(DataRate.UNIT_MB_S), dataRate.getContentInUnits(DataRate.UNIT_MB_S));
            problem = DefaultProblem.createError(string, "The data rate can be lowered by using/increasing spectral averaging", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        double d = scienceGoal.getAverageDataRate(Array.ARRAY_12M).getContentInUnits(DataRate.UNIT_MB_S);
        if (d > apol.getMax12MDataRateMBPS()) {
            string = String.format("12-m array average data rate (%.2f MB/s) exceeds the max allowed (%.2f MB/s)", d, apol.getMax12MDataRateMBPS());
            problem = DefaultProblem.createError(string, "The data rate can be lowered by using/increasing spectral averaging", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
        if (d > apol.getWarningDataRateMBPS()) {
            string = String.format("12-m array average data rate (%.2f MB/s) exceeds %.2f MB/s", d, apol.getWarningDataRateMBPS());
            problem = DefaultProblem.createWarning(string, "The PI may be contacted during Phase 2 to see if there is a possibility to reduce the data rate", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateSpectralAveragingNotEnabledInSpectralScans(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        SpectralScan spectralScan;
        if (scienceGoal.getSpectralSetupParameters().isSpectralScan() && (spectralScan = scienceGoal.getSpectralSetupParameters().getSpectralScan()) != null && spectralScan.getSpectralAverageFactor() != 1 && spectralScan.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM)) {
            Problem problem = DefaultProblem.createError("Spectral scan averaging factor must be set to 1 in TDM mode", "Set averaging factor to 1", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateAllTargetsWillProduceValidSpectralSetups(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        Problem problem;
        HashSet<ReceiverBand> hashSet = new HashSet<ReceiverBand>();
        if (scienceGoal.getTargetParametersCount() > 0) {
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            int n = scienceGoal.getKeyTargetParametersPosition();
            for (int i = 0; i < targetParametersArray.length; ++i) {
                if (!targetParametersArray[i].getNonSiderealMotion()) {
                    scienceGoal.setKeyTargetParameters(i);
                    try {
                        this.checkTuningsAreDeployable(businessObject, problemListModel, spectralSetupParameters, scienceGoal);
                    }
                    catch (BaseBandNotDeployableException baseBandNotDeployableException) {
                        problem = DefaultProblem.createError(String.format("Spectral setup is not valid for the target %s", scienceGoal.getKeyTargetParameters().getSourceName()), DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    Velocity velocity = targetParametersArray[i].getSourceVelocity();
                    ReceiverBand receiverBand = this.determineReceiverBand(spectralSetupParameters, velocity);
                    if (receiverBand != null) {
                        hashSet.add(receiverBand);
                    }
                }
                if (spectralSetupParameters.isSpectralScan()) break;
            }
            scienceGoal.setKeyTargetParameters(n);
        }
        if (hashSet.size() > 1) {
            problem = DefaultProblem.createError("Science goal requires too many receiver bands (" + hashSet.size() + ")", DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateSingleTuningDoesNotExceedMaxNoOfSBExecs(ProblemListModel problemListModel, ScienceGoal scienceGoal, int n, BusinessObject businessObject) {
        try {
            if (n > 1 && this.scienceGoalPrincipalArraySBHasMultipleExecs(scienceGoal)) {
                problemListModel.addProblemToBuffer(DefaultProblem.createWarning("Multiple-tuning projects which require multiple SB executions are currently inefficient time-wise", "Try splitting the different tunings into different Science Goals", (IBusinessObject)businessObject));
            }
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            // empty catch block
        }
    }

    private void validateTPFieldSetup(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (scienceGoal.getPerformanceParameters().getUseTP()) {
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (targetParameters.getIsMosaic() || targetParameters.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M) <= 1) continue;
                Problem problem = DefaultProblem.createError("When TP is scheduled, non-mosaic targets must only have a single pointing", "Adjust the pointing setup for " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private void validateAllSourcesHaveUniqueNames(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (!targetParameters.getSourceName().trim().equals("") && hashSet.contains(targetParameters.getSourceName().trim())) {
                Problem problem = DefaultProblem.createError("All source names in a science goal must be unique", targetParameters.getSourceName() + " is a duplicate source name, please change its name", (IBusinessObject)targetParameters);
                problemListModel.addProblemToBuffer(problem);
            }
            hashSet.add(targetParameters.getSourceName().trim());
        }
    }

    private List<ScienceGoal.SourcePoint> validateNonSiderealTargetSeparation(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        List<ScienceGoal.SourcePoint> list = scienceGoal.getAllSiderealSourceFieldCentres();
        double d = AlmaPolicies.getInstance().getMaxConeDiameter().getContentInUnits(Angle.UNIT_DEG);
        double d2 = d * 60.0;
        this.logger.log(Log.DEBUG, " Science Goal Spacing Check - Number of Target Parameters is " + list.size());
        this.logger.log(Log.DEBUG, "  (Max Size of Cone is " + d + " Deg or " + d2 + " arcmin)");
        block0: for (int i = 0; i < list.size(); ++i) {
            SkyPoint skyPoint = list.get(i).getSkyPoint();
            for (int j = i + 1; j < list.size(); ++j) {
                SkyPoint skyPoint2 = list.get(j).getSkyPoint();
                double d3 = WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY());
                if (!(d3 > d2)) continue;
                Problem problem = DefaultProblem.createError(String.format("Sources separated by > %g degrees cannot include solar-system objects", d2), "Place the solar-system objects in separate Science Goals", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break block0;
            }
        }
        return list;
    }

    private void validateTJParameters(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        if (TJ_REQUIRED && scienceGoal.isPhase1ScienceGoal()) {
            String string;
            int n;
            Problem problem;
            TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(scienceGoal);
            technicalJustificationModel.publish();
            if (scienceGoal.gettrueTechnicalJustification() == null) {
                problem = DefaultProblem.createError("No Technical Justification has been supplied", "Select the Science Goal's Technical Justification node in the Proposal tab and edit the Justication Text", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
            if ((n = (string = scienceGoal.getNote()).length()) > MAX_TEXTAREA_CHARACTERS) {
                problem = DefaultProblem.createError("Description contains too many characters (" + n + ")", "Select the Science Goal's General node in the Proposal tab and edit your description (max " + MAX_TEXTAREA_CHARACTERS + " characters)", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private ReceiverBand determineReceiverBand(SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        return spectralSetupParameters.getReceiverBand();
    }

    private void checkTuningsAreDeployable(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, ScienceGoal scienceGoal) throws BaseBandNotDeployableException {
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        if (spectralSetupParameters.isSpectralScan()) {
            try {
                spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return;
            }
            if (spectralScanTunings != null) {
                for (int i = 0; i < spectralScanTunings.getNumberOfTunings(); ++i) {
                    BaseBandDeployer baseBandDeployer = new BaseBandDeployer(spectralSetupParameters, i);
                    if (baseBandDeployer.isDeployable(true)) continue;
                    Problem problem = DefaultProblem.createError("SPWs associated with tuning " + i + " in the spectral scan cannot be deployed", DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
            }
        } else {
            BaseBandDeployer baseBandDeployer = new BaseBandDeployer(spectralSetupParameters);
            if (!baseBandDeployer.isDeployable(true)) {
                TargetParameters targetParameters = scienceGoal.getKeyTargetParameters();
                String string = String.format("Your spectral setup is not compatible with one or more of your targets (%s) in this ScienceGoal", targetParameters.getSourceName());
                Problem problem = DefaultProblem.createError(string, DEFAULT_SUGGESTION, (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private boolean scienceGoalPrincipalArraySBHasMultipleExecs(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
        Array array = scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        return observingTimeCalculator.getSBExecutionCount(array) > 1;
    }
}

