/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SpectralSetupParametersValidator
extends AbstractValidator {
    private static final Set<ReceiverBand> validReceiverBandsForFullPolarisation = ReceiverBand.getFullPolarizationReceiverBands();
    private static final Frequency NOISY_REGION = (Frequency)((Frequency)Frequency.createFrequencyGHZ(2.0).divide(128.0)).multiply(6.0);

    public SpectralSetupParametersValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        Object object;
        Object object2;
        String[] stringArray;
        Problem problem;
        Collection<ScienceGoal> collection;
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)businessObject;
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = spectralSetupParameters.getSpectralType();
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        SpectralScan spectralScan = null;
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        if (spectralSetupParameters.isSpectralScan()) {
            spectralScan = spectralSetupParameters.getSpectralScan();
        }
        if (!spectralSetupParameters.isSpectralScan() && spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
            problem = DefaultProblem.createError("No spectral windows are defined!", "Select the Spectral Setup in the Science Goal and enter some", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!Arrays.asList(stringArray = SpectralSetupParameters.getKnownPolarisationList()).contains(spectralSetupParameters.getPolarisation())) {
            problem = DefaultProblem.createError("Polarization " + spectralSetupParameters.getPolarisation() + " not valid", "Select the spectral setup in the Science Goal and choose a valid polarization", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.getType().equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            if (!spectralSetupParameters.getSoleFrequency().hasContent()) {
                problem = DefaultProblem.createError("Continuum is chosen and frequency is not set", "Select the Spectral Setup in the Science Goal and enter the frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (((ScienceSpectralWindow)(object2 = spectralSetupParameters.getScienceSpectralWindow(0))).getCorrConfigMode() == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                Log.logger((Object)this).warning("inconsistent bandwidth/resolution/polarization found in the ScienceSpectralWindow. trying to correct.");
                ((ScienceSpectralWindow)object2).updateContinuumCorrMode();
            }
        } else if (spectralSetupParameters.isSpectralScan()) {
            spectralScanTunings = this.validateSpectralScanSetup(businessObject, problemListModel, spectralSetupParameters, scienceGoal, spectralScan, spectralScanTunings);
        } else if (spectralSetupParameters.getType().equals(SpectralSetupParameters.TYPE_FULL)) {
            this.validateSpectralLineSetup(businessObject, problemListModel, spectralSetupParameters);
        }
        object2 = AlmaCapabilities.getInstance();
        List<String> list = ((AlmaCapabilities)object2).getAvailableReceiverBands();
        boolean bl2 = false;
        scienceGoal.clearRequiredReceiverBands();
        if (spectralSetupParameters.isSpectralScan()) {
            if (spectralScanTunings != null) {
                try {
                    Iterator<ScienceGoal> iterator = spectralSetupParameters.getReceiverBand().getName();
                    bl2 = true;
                    scienceGoal.addRequiredReceiverBands((String)((Object)iterator));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            for (String object3 : list) {
                try {
                    if (!object3.equals(spectralSetupParameters.getReceiverBand().getName())) continue;
                    bl2 = true;
                    scienceGoal.addRequiredReceiverBands(object3);
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2) {
            problem = DefaultProblem.createError("Required receiver band is not available!", "Select the Spectral Setup in the Science Goal and revise your selections", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!spectralSetupParameters.getRepresentativeFrequency().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the representative frequency", "Select the Spectral Setup Parameters in the Science Goal and choose a representative window", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (spectralSetupParameters.getRepresentativeFrequency().getContentInUnits(Frequency.UNIT_GHZ) <= 0.0) {
            problem = DefaultProblem.createError("Representative frequency is not valid", "Select the Spectral Setup Parameters in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.validateWalshSwitching(businessObject, problemListModel, spectralSetupParameters);
        this.validateRestFrequenciesAreInSPWs(businessObject, problemListModel, spectralSetupParameters);
        this.validateBasebandResources(businessObject, problemListModel, spectralSetupParameters, spectralSetupTypeChoice, (AlmaCapabilities)object2);
        this.validateRepresentativeAttributes(businessObject, problemListModel, spectralSetupParameters, spectralSetupTypeChoice);
        if (spectralSetupParameters.getPolarisation().equals(SpectralSetupParameters.POLARISATION_FULL)) {
            for (ScienceGoal scienceGoal2 : collection) {
                object = null;
                try {
                    object = MinTuningsCalculator.getLO1Tunings(scienceGoal2);
                }
                catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                    problem = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                    return;
                }
                if (object == null) {
                    Log.logger(SpectralSetupParametersValidator.class).warning("Unable to determine the number of tunings");
                    continue;
                }
                if (Telescope.isOTConfiguredAs(Telescope.CSVALMA) || object.size() <= 1) continue;
                problem = DefaultProblem.createError("Only a single tuning is supported with full polarization: " + object.size() + " tunings are required", "Ensure that all of the sources defined can be observed using a single tuning.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        for (ScienceGoal scienceGoal3 : collection) {
            object = scienceGoal3.getSpectralSetupParameters();
            if (!ReceiverBand.getReceiverBand(10).equals(((SpectralSetupParameters)((Object)object)).getReceiverBand())) continue;
            for (TargetParameters targetParameters : ((SpectralSetupParameters)((Object)object)).getScienceGoal().getTargetParameters()) {
                if (!targetParameters.isRectanglePattern() && (!targetParameters.isMosaic() || targetParameters.getNumberOfPointings(scienceGoal3.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M) <= 1)) continue;
                problem = DefaultProblem.createError("Mosaics are not permitted with band 10", "Custom mosaics with more than a single pointing and rectangle pointing patterns are not permitted in band 10 (see " + targetParameters.getSourceName() + ")", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        boolean bl22 = false;
        boolean bl3 = false;
        try {
            bl22 = scienceGoal.getObsProposal().isVLBI();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SpectralSetupParametersValidator.class).info("Unable to determine if project is VLBI: " + unknownEntityException.getMessage());
        }
        if (bl22) {
            this.validateVLBISpectralSetup(spectralSetupParameters, problemListModel);
        }
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SpectralSetupParametersValidator.class).info("Unable to determine if science goal is solar: " + unknownEntityException.getMessage());
        }
        if (bl) {
            this.validateSolarSpectralSetup(spectralSetupParameters, problemListModel);
        }
    }

    private void validateSPWRestFrequencyIsWithinSPW(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            if (!scienceSpectralWindow.hasSplatalogId()) continue;
            int n = scienceSpectralWindow.getSplatalogId();
            VupRange<Frequency> vupRange = scienceSpectralWindow.getSkyFrequencyEffectiveRange();
            Frequency frequency = vupRange.min().inverseDopplerShifted(scienceSpectralWindow.getSourceVelocity());
            Frequency frequency2 = vupRange.max().inverseDopplerShifted(scienceSpectralWindow.getSourceVelocity());
            for (SpectralLine spectralLine : SpectralLineCatalogue.getInstance(false).getRootCatalogue()) {
                Integer n2 = spectralLine.getLineId();
                if (n2 == null || n2 != n || !spectralLine.getFrequency().isGreaterThan((AbstractDoubleWithUnit)frequency2) && !spectralLine.getFrequency().isLessThan((AbstractDoubleWithUnit)frequency)) continue;
                Problem problem = DefaultProblem.createError(String.format("Spectral window %s@%s GHz was created using a spectral line that now lies outside the spw.", scienceSpectralWindow.getTransitionName(), scienceSpectralWindow.getCenterFrequencyRest().getContentInGHz()), "Delete the spw and re-enter if necessary.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void validateRestFrequenciesAreInSPWs(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        int n = 0;
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
            FrequencyRange frequencyRange = FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequencyRest(), frequency);
            Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
            for (ExpectedSpectralLine expectedSpectralLine : scienceSpectralWindow.getExpectedSpectralLine()) {
                if (hashSet.contains(expectedSpectralLine.getSpatalogId())) continue;
                ++n2;
                if (frequencyRange.contains(expectedSpectralLine.getRestFrequency()) || optional.isPresent() && optional.get().contains(expectedSpectralLine.getRestFrequency())) continue;
                Log.logger(SpectralSetupParametersValidator.class).info("Is outside of the passband of the SPWs : " + expectedSpectralLine.getTransition());
                ++n;
                hashSet.add(expectedSpectralLine.getSpatalogId());
            }
        }
        if (n > 0) {
            Problem problem = DefaultProblem.createError(String.format("%d out of %d rest frequencies do not lie within a spectral window", n, n2), "Remove the non-observable rest frequencies", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateSpectralLineSetup(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        Object object;
        Object object2;
        Object object3;
        Problem problem;
        ScienceSpectralWindow[] scienceSpectralWindowArray;
        String string = "Can not observe these spectral windows in one science goal";
        String string2 = "Revise spectral windows so that all of them fit in sidebands";
        try {
            scienceSpectralWindowArray = new BaseBandDeployer(spectralSetupParameters);
            if (!scienceSpectralWindowArray.isDeployable(true)) {
                problem = DefaultProblem.createError(string, string2, (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            object3 = scienceSpectralWindowArray.getBasebands();
            scienceSpectralWindowArray.getAdjustedBaseBandCenterFrequenciesRest();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (BaseBandDeployer.BaseBand)iterator.next();
                object = (Frequency)((Object)((VupRange)object2).min());
                Frequency frequency = (Frequency)((Object)((VupRange)object2).max());
                FrequencyRange frequencyRange = spectralSetupParameters.getReceiverBand().getRFRange();
                Frequency frequency2 = (Frequency)frequencyRange.clip(object).minus((AbstractDoubleWithUnit)object);
                Frequency frequency3 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequencyRange.clip(frequency));
                Frequency frequency4 = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency2);
                object = (Frequency)object.minus((AbstractDoubleWithUnit)frequency4);
                Frequency object4 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequency4);
                FrequencyRange frequencyRange2 = new FrequencyRange((Frequency)((Object)object), (Frequency)object.plus((AbstractDoubleWithUnit)NOISY_REGION));
                FrequencyRange frequencyRange3 = new FrequencyRange((Frequency)object4.minus((AbstractDoubleWithUnit)NOISY_REGION), object4);
                for (BaseBandDeployer.SpectralWindow spectralWindow : ((BaseBandDeployer.BaseBand)object2).getSpectralWindowArray()) {
                    if (!frequencyRange2.contains(spectralWindow) && !frequencyRange3.contains(spectralWindow)) continue;
                    ObservingToolController observingToolController = ObservingToolController.getMyInstance();
                    RoleDirectoryService roleDirectoryService = observingToolController.getRoleDirectory();
                    problem = DefaultProblem.createWarning("Spectral window falls entirely within noisy region at baseband edge", "If possible, edit your spectral window selection so that windows are not at the edge of the baseband", (IBusinessObject)spectralSetupParameters);
                    try {
                        if (roleDirectoryService.canExecute(OTOperation.ENABLE_ADVANCED_OPTIONS)) {
                            problemListModel.add(problem);
                        }
                    }
                    catch (IOException iOException) {
                        Log.logger(SpectralSetupParametersValidator.class).info("Unable to determine if user is advanced : " + iOException.getMessage());
                    }
                    problemListModel.addUnpublishedProblem(problem);
                }
            }
            scienceSpectralWindowArray.getAdjustedBaseBandCenterFrequenciesRest();
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            object3 = baseBandNotDeployableException.getMessage();
            problem = DefaultProblem.createError((String)(object3 == null ? "Spectral setup is invalid" : object3), string2, (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        int n = scienceSpectralWindowArray.length;
        for (int i = 0; i < n; ++i) {
            object2 = scienceSpectralWindowArray[i];
            ((ScienceSpectralWindow)object2).resetCorrConfigMode();
            if (((ScienceSpectralWindow)object2).getCorrConfigMode() == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                problem = DefaultProblem.createError("Spectral Window setup is invalid", "Please correct your spectral window setup", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
            if (StringUtils.stripToEmpty((String)object2.getTransitionName().replaceAll("\\s+", "")).equals("...Enter Name Here...".replaceAll("\\s+", ""))) {
                problem = DefaultProblem.createError("Spectral window name is invalid", "Change the name to something more meaningful", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
            if (StringUtils.stripToNull((String)object2.getTransitionName()) != null) continue;
            problem = DefaultProblem.createError("Spectral window name is empty", "Change the name to something more meaningful", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isAdvancedSetup()) {
            boolean bl = false;
            for (n = 0; n < 4; ++n) {
                ScienceSpectralWindow[] scienceSpectralWindowArray2 = spectralSetupParameters.getScienceSpectralWindowGroup(n);
                if (scienceSpectralWindowArray2.length > 0) {
                    int n2 = n + 1;
                    object = scienceSpectralWindowArray2[0];
                    for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray2) {
                        if (!((ScienceSpectralWindow)object).getSpectralResolution().equals(scienceSpectralWindow.getSpectralResolution())) {
                            string = "Baseband-" + n2 + " : Spectral window resolution mismatch in spectral set-up. All windows must be allocated the same resolution.";
                            string2 = "Revise spectral windows so that they all have the same resolution.";
                            bl = true;
                            break;
                        }
                        if (scienceSpectralWindow.getCorrConfigMode().isValid()) continue;
                        string = "Spectral window baseband " + n2 + " has an invalid correlator configuration.";
                        string2 = "Select a valid correlator configuration for this baseband.";
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
            }
            if (bl) {
                problem = DefaultProblem.createError(string, string2, (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
        }
    }

    private SpectralScan.SpectralScanTunings validateSpectralScanSetup(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, ScienceGoal scienceGoal, SpectralScan spectralScan, SpectralScan.SpectralScanTunings spectralScanTunings) {
        if (spectralScan == null) {
            Problem problem = DefaultProblem.createError("Spectral scan has not been defined", "Select the spectral scan setup in the Science Goal and set up the spectral scan", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else {
            Problem problem;
            if (!spectralScan.getStartFrequency().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the scan start frequency is not set", "Select the Spectral Scan Setup in the Science Goal and enter the start frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getEndFrequency().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the scan end frequency is not set", "Select the Spectral Scan Setup in the Science Goal and enter the end frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getBandWidth().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the bandwidth has not been specified", "Select the Spectral Scan Setup in the Science Goal and select the bandwidth", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getSpectralResolution().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the spectral resolution is not defined", "Select the Spectral Scan Setup in the Science Goal and setup the spectral resolution", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (spectralSetupParameters.getRepresentativeFrequency().hasContent()) {
                TargetParameters[] targetParametersArray = spectralScan.getRealisableScanRange();
                if (targetParametersArray != null && !targetParametersArray.contains(spectralSetupParameters.getRepresentativeFrequency())) {
                    problem = DefaultProblem.createError("The representative frequency is outside of the achievable scan range", "Modify the representative frequency so that it lies between the achievable start and end frequencies of the spectral scan", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            } else {
                problem = DefaultProblem.createError("A spectral scan has been selected but no representative frequency is not defined", "Select the Spectral Scan Setup in the Science Goal and define the representative frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            try {
                spectralScanTunings = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                problem = DefaultProblem.createError("Unable to determine a valid set of spectral scan tunings", "Revise the spectral scan setup", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (scienceGoal.getPerformanceParameters().getUseACA()) {
                problem = DefaultProblem.createError("The ACA cannot be utilised if the spectral setup is a spectral scan", "Revise the performance parameters configuration", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            block2: for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                Integer n = 0;
                for (Field field : targetParameters.getField()) {
                    if (field.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
                        Integer n2 = n;
                        Integer n3 = n = Integer.valueOf(n + 1);
                        if (n <= 1) continue;
                        problem = DefaultProblem.createError("Only single pointing field setups permitted for spectral scans", "Revise the field setup for source " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                        problemListModel.add(problem);
                        continue block2;
                    }
                    problem = DefaultProblem.createError("Spectral scans can only be used with single point setups not mosaics", "Revise the field setup for source " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
        return spectralScanTunings;
    }

    private void validateBasebandResources(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice, AlmaCapabilities almaCapabilities) {
        if (spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE) || spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM)) {
            Integer n;
            int n2;
            Problem problem;
            if (spectralSetupParameters.getPolarisation().equals(SpectralSetupParameters.POLARISATION_FULL) && !validReceiverBandsForFullPolarisation.contains(spectralSetupParameters.getReceiverBand())) {
                problem = DefaultProblem.createError("Unsupported receiver band for full polarisation", "Only receiver bands 3,4,5,6 and 7 are supported when full polarization is selected.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup(n2);
                if (this.verifyTotalFraction(scienceSpectralWindowArray)) continue;
                n = n2 + 1;
                problem = DefaultProblem.createError("Baseband-" + n + ": The sum of fractions for all spectral windows must be equal to or less than 1", "Delete or modify the windows in the baseband", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (almaCapabilities.getMaxNumberSw() == 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    int n3 = spectralSetupParameters.getScienceSpectralWindowCount(n2);
                    n = n2 + 1;
                    if (n3 <= 1) continue;
                    problem = DefaultProblem.createError("Baseband-" + n + ": A maximum of one spectral window is allowed per baseband", "Delete excess spectral windows from baseband " + n, (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
    }

    private void validateRepresentativeAttributes(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        if (SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE == spectralSetupTypeChoice || SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM == spectralSetupTypeChoice) {
            ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.getRepresentativeSpectralWindow();
            if (scienceSpectralWindow == null) {
                Problem problem = DefaultProblem.createError("There is no Representative Window set", "Please select a representative spectral window.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            } else {
                FrequencyRange frequencyRange;
                Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
                if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan()) {
                    Frequency frequency2 = scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth();
                    frequencyRange = FrequencyRange.centredOn(frequency, frequency2);
                } else {
                    frequencyRange = new FrequencyRange(scienceSpectralWindow.minInRest(), scienceSpectralWindow.maxInRest());
                }
                if (!frequencyRange.contains(frequency)) {
                    Problem problem = DefaultProblem.createError("Representative frequency is outside the range of the representative spectral window.", "Enter a new representative frequency that is inside the range of the representative spectral window.", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
    }

    private void validateVLBISpectralSetup(SpectralSetupParameters spectralSetupParameters, ProblemListModel problemListModel) {
        ReceiverBand receiverBand;
        if (!spectralSetupParameters.getSpectralType().equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM)) {
            Problem problem = DefaultProblem.createError("VLBI spectral setup should be single continuum", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            return;
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        try {
            receiverBand = ReceiverBand.getReceiverBand(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Problem problem = DefaultProblem.createError("Invalid spectral setup for VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            return;
        }
        assert (receiverBand != null);
        List<Frequency> list = null;
        switch (receiverBand.getNumber()) {
            case 3: {
                list = almaCapabilities.getVLBISPWCentralFrequencies(3);
                break;
            }
            case 6: {
                list = almaCapabilities.getVLBISPWCentralFrequencies(6);
                break;
            }
            default: {
                Problem problem = DefaultProblem.createError("Incompatible receiver band selected for VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
                return;
            }
        }
        if (spectralSetupParameters.getAbstractScienceSpectralWindowCount() != list.size()) {
            Problem problem = DefaultProblem.createError("4 SPWs expected for a VLBI spectral setup", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
        }
        for (int i = 0; i < spectralSetupParameters.getAbstractScienceSpectralWindow().length; ++i) {
            AbstractScienceSpectralWindow abstractScienceSpectralWindow = spectralSetupParameters.getAbstractScienceSpectralWindow()[i];
            Frequency frequency = abstractScienceSpectralWindow.getCenterFrequency();
            boolean bl = false;
            for (int j = 0; j < list.size(); ++j) {
                if (!frequency.isEqual((AbstractDoubleWithUnit)list.get(j), 1.0E-6)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Problem problem = DefaultProblem.createError("Invalid SPW central frequencies for VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            break;
        }
    }

    private void validateSolarSpectralSetup(SpectralSetupParameters spectralSetupParameters, ProblemListModel problemListModel) {
        Object object;
        if (!spectralSetupParameters.getSpectralType().equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM)) {
            object = DefaultProblem.createError("Solar spectral setup should be continuum", "Select a valid solar spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add((Problem)object);
        }
        object = ReceiverBand.getReceiverBand(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset());
        ImmutableSet immutableSet = null;
        switch (((ReceiverBand)object).getNumber()) {
            case 3: {
                immutableSet = ImmutableSet.of((Object)((Object)Frequency.createFrequencyGHZ(107.0)), (Object)((Object)Frequency.createFrequencyGHZ(105.0)), (Object)((Object)Frequency.createFrequencyGHZ(95.0)), (Object)((Object)Frequency.createFrequencyGHZ(93.0)));
                break;
            }
            case 6: {
                immutableSet = ImmutableSet.of((Object)((Object)Frequency.createFrequencyGHZ(230.0)), (Object)((Object)Frequency.createFrequencyGHZ(232.0)), (Object)((Object)Frequency.createFrequencyGHZ(246.0)), (Object)((Object)Frequency.createFrequencyGHZ(248.0)));
                break;
            }
            default: {
                throw new RuntimeException("Unable to process solar frequencies in band " + ((ReceiverBand)object).getNumber());
            }
        }
        assert (immutableSet != null);
        boolean bl = false;
        for (AbstractScienceSpectralWindow abstractScienceSpectralWindow : spectralSetupParameters.getAbstractScienceSpectralWindow()) {
            bl = false;
            for (Frequency frequency : immutableSet) {
                if (!abstractScienceSpectralWindow.getCenterFrequency().isEqual((AbstractDoubleWithUnit)frequency, 1.0E-9)) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        if (!bl) {
            Problem problem = DefaultProblem.createError("Invalid SPW central frequencies for Solar", "Select a valid solar spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
        }
    }

    private boolean verifyTotalFraction(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            try {
                n += scienceSpectralWindow.getFraction().getUnits();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return n <= 32;
    }

    private void validateWalshSwitching(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        ScienceSpectralWindow[] scienceSpectralWindowArray;
        Object object;
        if (!spectralSetupParameters.isWalshSwitching()) {
            return;
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            Problem problem = DefaultProblem.createError("Unable to determine receiver band", "Please revise your setup.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
            return;
        }
        if (!ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10)) {
            object = DefaultProblem.createError("Walsh switching is enabled but is incompatible with receiver band", "90-deg Walsh switching is only comptible with B9 and B10", (IBusinessObject)businessObject);
            problemListModel.add((Problem)object);
        }
        object = Frequency.createFrequencyMHZ(1875.0);
        if (spectralSetupParameters.isSpectralScan() && !(scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralScan(0)).getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)object)) {
            Problem problem = DefaultProblem.createError("The bandwidth is incompatible with 90-degree Walsh switching.", "Set the spectral scan bandwidth to 1875 MHz.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isSpectralLine()) {
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                if (scienceSpectralWindow.getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)object)) continue;
                Problem problem = DefaultProblem.createError("The bandwidth is incompatible with 90-degree Walsh switching.", "Set the bandwidth to 1875 MHz for window " + scienceSpectralWindow.getTransitionName(), (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }
}

