/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.EphemerisValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.data.UserFrequencyData;
import jsky.coords.WorldCoords;

public class TargetParametersValidator
extends AbstractValidator {
    private Log.Logger logger = Log.logger((Object)this);
    private static AlmaPolicies apol = AlmaPolicies.getInstance();
    private static boolean sourceParametersRequired = apol.getIsSourceParametersRequired();
    private final double MIN_THRESHOLD_CIRCULAR_POLARIZATION_PERCENT = 1.8;

    public static boolean isSourceParametersRequired() {
        return sourceParametersRequired;
    }

    public void setSourceParametersRequired(boolean bl) {
        sourceParametersRequired = bl;
    }

    public TargetParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Object object;
        boolean bl;
        Problem problem;
        TargetParameters targetParameters = (TargetParameters)businessObject;
        targetParameters.setSourceName(MiscUtils.getSanitizedSourceName(targetParameters.getSourceName()));
        if (targetParameters.getSourceName() == null || targetParameters.getSourceName().length() == 0) {
            problem = DefaultProblem.createError("No source name provided", "Check the Target Parameters in the Science Goal and ensure all have a non-blank source name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        if (targetParameters.isMaxElevationTooLow()) {
            String string = String.format("The source %s cannot be observed with ALMA as its elevation never exceeds %g degrees", targetParameters.getSourceName(), almaCapabilities.getElLoWarn().getContentInUnits(Angle.UNIT_DEG));
            problem = DefaultProblem.createError(string, "Choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((bl = targetParameters.getScienceGoal().isPhase1ScienceGoal()) && targetParameters.isMaxElevationNeedingJustification()) {
            object = String.format("The source %s has a maximum elevation between %g and %g degrees", targetParameters.getSourceName(), almaCapabilities.getElLoWarn().getContentInUnits(Angle.UNIT_DEG), almaCapabilities.getElLoWarnThreshold().getContentInUnits(Angle.UNIT_DEG));
            problem = DefaultProblem.createWarning((String)object, "Please justify (minimum 50 characters) in the TJ node.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!targetParameters.getNonSiderealMotion() && skyCoordinates.getLatitude().getContent() == 0.0 && skyCoordinates.getLongitude().getContent() == 0.0) {
            problem = DefaultProblem.createWarning("Your field source coordinates are 0.0, 0.0", "Please be sure you mean this - OK for ToO goals", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!targetParameters.getNonSiderealMotion() && targetParameters.getSourceCoordinates().getSystem().equals(SkyCoordinates.SYSTEM_J2000)) {
            problem = DefaultProblem.createWarning("Coordinate system is FK5, but ICRS will be observed.", "Switch to ICRS. The systems differ by tens of mas so the coordinates probably do not need to be updated.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (targetParameters.getNonSiderealMotion() && targetParameters.getSolarSystemObject() == TargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED) {
            problem = DefaultProblem.createError("You have selected a solar system target without specifying one", "Choose a solar system object from the list", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (targetParameters.getNonSiderealMotion() && (targetParameters.getSolarSystemObject() == TargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS || targetParameters.getSolarSystemObject() == TargetParameters.SOLARSYSTEMOBJECT_SUN)) {
            object = new EphemerisValidator(this.logger);
            ((EphemerisValidator)object).validateEphemeris(targetParameters.getSourceEphemeris(), (BusinessObject)targetParameters, problemListModel, bl);
        }
        if (targetParameters.isPointingPattern()) {
            this.validatePointingPattern(businessObject, problemListModel, targetParameters);
        }
        boolean bl2 = false;
        try {
            bl2 = targetParameters.getScienceGoal().isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).info("Unable to determine science goal is configured for Solar");
        }
        if (sourceParametersRequired && !bl2) {
            this.validateExpectedProperties(businessObject, problemListModel, targetParameters);
        }
        this.validatePointingsNotTooFarFromSourceCoordinate(businessObject, problemListModel, targetParameters);
        if (!Telescope.isOTConfiguredAs(Telescope.CSVALMA) && SpectralSetupParameters.POLARISATION_FULL.equals(targetParameters.getScienceGoal().getSpectralSetupParameters().getPolarisation()) && (targetParameters.getFieldSinglePointCount() > 1 || targetParameters.isMosaic())) {
            problem = DefaultProblem.createError("Full polarization can only be used with sources with a single pointing", this.getTargetParametersName(targetParameters) + " has multiple pointings associated with it", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.validateVLBIPointingSetup(businessObject, problemListModel, targetParameters);
    }

    private void validateVLBIPointingSetup(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        try {
            if (targetParameters.getScienceGoal().getObsProposal().isVLBI()) {
                if (!targetParameters.getFieldPattern().getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
                    Problem problem = DefaultProblem.createError("A rectangle target type is not permitted with VLBI", "Change field type of source " + this.getTargetParametersName(targetParameters), (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                } else if (targetParameters.getFieldSinglePointCount() > 1 || targetParameters.isMosaic()) {
                    Problem problem = DefaultProblem.createError("A source may have only a single pointing when configured for VLBI", this.getTargetParametersName(targetParameters) + " has multiple pointings associated with it", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).info("Unable to determine proposal type: " + unknownEntityException.getMessage());
            Problem problem = DefaultProblem.createError("Unable to determine proposal type", "Please contact your support contact.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validatePointingPattern(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        boolean bl;
        Problem problem;
        if (targetParameters.getFieldSinglePointCount() < 1) {
            problem = DefaultProblem.createError("No pointings specified in the Field Setup!", "Select the Field Setup in the Science Goal and ensure there is at least one pointing", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        boolean bl2 = bl = targetParameters.getFieldSinglePointCount() > 1 && targetParameters.isMosaic();
        if (bl) {
            boolean bl3 = false;
            try {
                bl3 = SchedBlockWorker.isMosaicPointingsOverlapping(targetParameters);
            }
            catch (SchedBlockWorker.InfiniteBandwithException infiniteBandwithException) {
                problem = DefaultProblem.createError("The bandwidth cannot be calculated - unable to do mosaic spacing checks for target " + targetParameters.getSourceName(), "Please check the parameters for the science goal " + targetParameters.getScienceGoal().getNameOrDefault(), (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            catch (SchedBlockWorker.NotAMosaicException notAMosaicException) {
                throw new RuntimeException("Logic error in determining if target parameters " + targetParameters.getSourceName() + " is a mosaic");
            }
            if (!bl3) {
                String string = targetParameters.gettrueSourceName();
                if (string == null || string.trim().equals("")) {
                    string = "Single Point";
                }
                problem = DefaultProblem.createError("All pointings of a source must overlap.", "Please reduce the distance between pointings for " + string + ", or place non-overlapping pointings into separate targets.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void validateExpectedProperties(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        boolean bl;
        Problem problem;
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        String string = expectedProperties.getExpectedLineWidth().getUserUnit();
        if (!UserFrequencyData.USERUNIT_M_S.equals(string) && !UserFrequencyData.USERUNIT_KM_S.equals(string)) {
            problem = DefaultProblem.createError("Line width should be defined in units of velocity", this.getTargetParametersName(targetParameters) + " has it's line width specified in frequency, change it to units of velocity", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getExpectedPeakFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) < 0.0) {
            problem = DefaultProblem.createError("Expected peak flux density is too small", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getExpectedPeakLineFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) < 0.0) {
            problem = DefaultProblem.createError("Expected peak line flux density is too small", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!expectedProperties.gettrueExpectedLineWidth().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the expected line width", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (expectedProperties.getExpectedLineWidth().getContentInGHz() < 0.0) {
            problem = DefaultProblem.createError("Expected line width is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getDesiredPolarizationPercentage() < 0.0 || expectedProperties.getDesiredPolarizationPercentage() > 100.0) {
            problem = DefaultProblem.createError("Expected polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getDesiredLinePolarizationPercentage() < 0.0 || expectedProperties.getDesiredLinePolarizationPercentage() > 100.0) {
            problem = DefaultProblem.createError("Expected line polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getDesiredCircularPolarizationPercentage() < 0.0 || expectedProperties.getDesiredCircularPolarizationPercentage() > 100.0) {
            problem = DefaultProblem.createError("Expected continuum circular polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (expectedProperties.getDesiredLineCircularPolarizationPercentage() < 0.0 || expectedProperties.getDesiredLineCircularPolarizationPercentage() > 100.0) {
            problem = DefaultProblem.createError("Expected spectral line circular polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = scienceGoal.getSpectralSetupParameters().getSpectralType();
        String string2 = scienceGoal.getSpectralSetupParameters().getPolarisation();
        if (SpectralSetupParameters.POLARISATION_FULL.equals(string2)) {
            this.validatePolarizationConfiguration(businessObject, problemListModel, targetParameters, expectedProperties, scienceGoal);
        }
        if (SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.equals((Object)spectralSetupTypeChoice)) {
            if (expectedProperties.getExpectedPeakFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
                problem = DefaultProblem.createError("Expected peak continuum flux is required for a single continuum setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        } else if (SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.equals((Object)spectralSetupTypeChoice) || SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.equals((Object)spectralSetupTypeChoice)) {
            if (expectedProperties.getExpectedPeakLineFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
                problem = DefaultProblem.createError("Expected peak line flux is required for a spectral line or spectral scan setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (expectedProperties.getExpectedLineWidth().getContentInGHz() <= 0.0) {
                problem = DefaultProblem.createError("Expected line width is required for a spectral line or spectral scan setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        if (expectedProperties.getExpectedPeakLineFluxDensity().getContent() > 0.0 && expectedProperties.getExpectedLineWidth().getContent() <= 0.0 || expectedProperties.getExpectedLineWidth().getContent() > 0.0 && expectedProperties.getExpectedPeakLineFluxDensity().getContent() <= 0.0) {
            problem = DefaultProblem.createWarning("Both or neither of line width and line flux must be specified", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and ensure both line flux and line width values are provided, or neither", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        boolean bl2 = false;
        try {
            bl2 = scienceGoal.getObsProposal().isVLBI();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).info("Unable to determine if this is a VLBI proposal : " + unknownEntityException.getMessage());
        }
        boolean bl3 = bl = !bl2 && SpectralSetupParameters.POLARISATION_FULL.equals(string2);
        if (bl && expectedProperties.getDesiredPolarizationPercentage() <= 0.0 && expectedProperties.getDesiredLinePolarizationPercentage() <= 0.0 && expectedProperties.getDesiredCircularPolarizationPercentage() <= 0.0 && expectedProperties.getDesiredLineCircularPolarizationPercentage() <= 0.0) {
            problem = DefaultProblem.createError("A polarization percentage is required for a full-polarization setup.", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validatePolarizationConfiguration(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters, ExpectedProperties expectedProperties, ScienceGoal scienceGoal) {
        double d;
        double d2;
        double d3;
        Problem problem;
        double d4;
        double d5;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isFullPolarisation().booleanValue()) {
            return;
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        if (scienceSpectralWindowArray.length == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            if (scienceSpectralWindow.isModeFilterTDM()) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        assert (bl2 || bl);
        boolean bl3 = scienceGoal.getPerformanceParameters().getIsEquivalentToPointSource();
        if (bl2 && bl) {
            d5 = bl3 ? 0.1 : 0.3;
            d4 = bl3 ? 1.0 : 3.0;
        } else if (bl) {
            d4 = d5 = bl3 ? 0.1 : 0.3;
        } else if (bl2) {
            d5 = d4 = bl3 ? 1.0 : 3.0;
        } else {
            throw new RuntimeException("Logic error: unable to determine the mode types of the spectral windows");
        }
        double d6 = expectedProperties.getDesiredPolarizationPercentage();
        if (d6 < d5 && d6 > 0.0) {
            problem = DefaultProblem.createError("The expected linear polarization continuum for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d3 = expectedProperties.getDesiredLinePolarizationPercentage()) < d4 && d3 > 0.0) {
            problem = DefaultProblem.createError("The expected linear polarization line for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d2 = expectedProperties.getDesiredLineCircularPolarizationPercentage()) < 1.8 && d2 > 0.0) {
            problem = DefaultProblem.createError("The expected circular polarization line for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d = expectedProperties.getDesiredCircularPolarizationPercentage()) < 1.8 && d > 0.0) {
            problem = DefaultProblem.createError("The expected circular polarization continuum for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private String getTargetParametersName(TargetParameters targetParameters) {
        String string = targetParameters.getSourceName();
        if (string == null || string.length() == 0) {
            string = "no source name";
        }
        return "(" + string + ")";
    }

    private void validatePointingsNotTooFarFromSourceCoordinate(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        double d = almaPolicies.getMaxSeparationFromSourceCoordinate().getContentInUnits(Angle.UNIT_DEG);
        SkyPoint skyPoint = targetParameters.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
        if (targetParameters.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
            SkyCoordinates[] skyCoordinatesArray = targetParameters.getPointingPattern().getPhaseCenterCoordinates();
            for (int i = 0; i < skyCoordinatesArray.length; ++i) {
                SkyCoordinates skyCoordinates = skyCoordinatesArray[i];
                if (skyCoordinates.isOffsetCoordinates()) {
                    skyCoordinates = skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates());
                }
                SkyPoint skyPoint2 = skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
                double d2 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
                if (!(d2 >= d)) continue;
                Problem problem = DefaultProblem.createError(String.format("A pointing is more than %.0f degrees of separation from the source coordinate", d), "Please revise your field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break;
            }
        } else if (targetParameters.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
            SkyCoordinates skyCoordinates;
            Rectangle rectangle = targetParameters.getFieldRectangle()[0];
            SkyCoordinates skyCoordinates2 = skyCoordinates = rectangle.getCentre();
            if (skyCoordinates.isOffsetCoordinates()) {
                skyCoordinates2 = skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates());
            }
            SkyPoint skyPoint3 = skyCoordinates2.getAbsoluteSkyPointInJ2000Deg();
            double d3 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint3.getX(), (double)skyPoint3.getY()) / 60.0;
            if (d3 >= d) {
                Problem problem = DefaultProblem.createError(String.format("Rectangle field pattern is offset by more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        } else {
            throw new RuntimeException("Unknown field type specified" + (Object)((Object)targetParameters.getFieldPatternType()));
        }
    }
}

