/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class TechnicalJustificationValidator
extends AbstractValidator {
    static AlmaPolicies apol = AlmaPolicies.getInstance();
    static final boolean TJ_REQUIRED = apol.getIsTechnicalJustificationRequired();
    static final int MAX_TECH_JUSTIFICATION_CHARACTERS = apol.getMaxTechnicalJustificationTextCharacters();
    static final int MIN_TECH_JUSTIFICATION_CHARACTERS = apol.getMinTechnicalJustificationTextCharacters();

    public TechnicalJustificationValidator() {
        this.setValidatorThreadSafe(true);
    }

    private boolean isNonCommissioningProject(TechnicalJustification technicalJustification) {
        boolean bl = true;
        ObsProject obsProject = technicalJustification.findProject();
        if (obsProject != null) {
            bl = !obsProject.hasIsCommissioning() || !obsProject.getIsCommissioning();
        }
        return bl;
    }

    private boolean isPhase1ScienceGoal(TechnicalJustification technicalJustification) {
        boolean bl = false;
        ScienceGoal scienceGoal = (ScienceGoal)technicalJustification.getParent();
        if (scienceGoal != null) {
            bl = scienceGoal.isPhase1ScienceGoal();
        }
        return bl;
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        block12: {
            TechnicalJustification technicalJustification = (TechnicalJustification)businessObject;
            if (TJ_REQUIRED && this.isNonCommissioningProject(technicalJustification) && this.isPhase1ScienceGoal(technicalJustification)) {
                try {
                    Method method = TechnicalJustification.class.getMethod("getJustificationKey", new Class[0]);
                    String string = (String)method.invoke((Object)technicalJustification, new Object[0]);
                    if (string.length() <= 0) break block12;
                    TechnicalJustificationEditor.TechJustEditor techJustEditor = null;
                    try {
                        techJustEditor = TechnicalJustificationEditor.TechJustEditor.valueOf(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.logger(TechnicalJustificationValidator.class).warning("Unknown TJ found, this will not be validated : " + string);
                        return;
                    }
                    String string2 = techJustEditor.getDescription();
                    String string3 = StringUtils.trimToEmpty((String)technicalJustification.gettrueJustificationText());
                    if (string2 != null) {
                        if (string3 == null || string3.length() < MIN_TECH_JUSTIFICATION_CHARACTERS) {
                            Problem problem = DefaultProblem.createError("The " + string2 + " must be at least " + MIN_TECH_JUSTIFICATION_CHARACTERS + " characters long", "Select the Science Goal's Technical Justification node in the Proposal tab and edit the text", (IBusinessObject)businessObject);
                            problemListModel.add(problem);
                        } else {
                            int n;
                            Problem problem;
                            int n2 = string3.length();
                            if (technicalJustification.gettrueJustificationText() != null && n2 > MAX_TECH_JUSTIFICATION_CHARACTERS) {
                                problem = DefaultProblem.createError("The " + string2 + " contains too many characters (" + n2 + ")", "Select the Science Goal's Technical Justification node in the Proposal tab and edit the text (max " + MAX_TECH_JUSTIFICATION_CHARACTERS + " characters)", (IBusinessObject)businessObject);
                                problemListModel.add(problem);
                            }
                            if ((n = this.numberOfPDFLines(string3)) > 75) {
                                int n3 = n - 75;
                                problem = DefaultProblem.createWarning("The " + string2 + " contains more than " + 75 + " lines, and so may be truncated on the PDF( approx " + n3 + " lines too many) ", "Select the Science Goal's Technical Justification node in the Proposal tab and edit the text", (IBusinessObject)businessObject);
                                problemListModel.add(problem);
                            }
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Log.logger((Object)this).warning("Old APDM - TJ Descriptions will not work correctly in the TJ Node - so are not validated");
                    noSuchMethodException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
    }

    private int numberOfPDFLines(String string) {
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        for (char c : cArray) {
            if (c == '\n') {
                ++n;
                n2 = 0;
            }
            if (n2 <= 123) continue;
            ++n;
            n2 = 0;
        }
        return n;
    }
}

