/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproposal;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Status;
import alma.valuetypes.Time;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class ObsProposalValidator
extends AbstractValidator {
    private static Time MAX_ALLOWED_PROPOSAL_TIME;
    private static int MAX_ABSTRACT_CHARACTERS;
    private static int MAX_DUPLICATION_TEXTAREA_CHARACTERS;
    private static int MAX_SCIENCECASE_PAGES;
    private static int MAX_SCIENCE_GOALS;
    private static int MAX_TOTAL_SOURCES;
    private static int MAX_NUMBER_POINTINGS;
    private static int NUM_ANTENNA_7M;
    private static int NUM_ANTENNA_TP;
    private static Time MIN_LARGE_PROGRAM_TIME_TWELVEM;
    private static int MAX_LARGEPROGRAM_SCIENCECASE_PAGES;
    private static Time MIN_LARGE_PROGRAM_TIME_SACA;
    private static final int MIN_KEYWORDS = 1;
    private static final int MAX_KEYWORDS = 2;
    private static final int MAX_TITLE_LENGTH = 120;

    public static void refreshLimits() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        MAX_ALLOWED_PROPOSAL_TIME = almaPolicies.getMaxStandardProposalTime();
        MAX_ABSTRACT_CHARACTERS = almaPolicies.getMaxAbstractCharacters();
        MAX_DUPLICATION_TEXTAREA_CHARACTERS = almaPolicies.getMaxTextAreaCharacters();
        MAX_SCIENCECASE_PAGES = almaPolicies.getMaxScienceCasePages();
        MAX_LARGEPROGRAM_SCIENCECASE_PAGES = almaPolicies.getMaxLargeProgramScienceCasePages();
        MAX_SCIENCE_GOALS = almaPolicies.getMaxScienceGoals();
        MAX_TOTAL_SOURCES = almaPolicies.getMaxSourcesPerGoal() * MAX_SCIENCE_GOALS;
        MAX_NUMBER_POINTINGS = almaPolicies.getMaxNumberPointings();
        MIN_LARGE_PROGRAM_TIME_TWELVEM = almaPolicies.getMinLargeProgramTimeNoACA();
        MIN_LARGE_PROGRAM_TIME_SACA = almaPolicies.getMinLargeProgramTimeWithSACA();
    }

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        ObsProposal obsProposal = (ObsProposal)businessObject;
        ObsProject obsProject = null;
        try {
            obsProject = obsProposal.getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            problemListModel.add(DefaultProblem.createError("Cannot find the containing project!", "Report this to your support centre", (IBusinessObject)businessObject));
            return;
        }
        if (obsProject.getStatus() == Status.STATE_NEWPHASE1 || obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED) {
            this.checkAbstractAndMiscellaneous(obsProposal, problemListModel);
            this.checkDocuments(obsProposal, problemListModel);
            this.checkTime(obsProposal, problemListModel);
            this.checkKeywords(obsProposal, problemListModel);
            this.checkInvestigatorConstraints(obsProposal, problemListModel);
            this.checkProposalTitleLength(obsProposal, problemListModel);
        }
    }

    private void checkInvestigatorConstraints(ObsProposal obsProposal, ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        if (problemListModel == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: plm");
        }
        if (!obsProposal.isLargeProgram() && !obsProposal.isVLBI() && obsProposal.getCoPrincipalInvestigatorCount() > 0) {
            problemListModel.add(DefaultProblem.createError("CoPIs are not allowed unless a large program or VLBI proposal type is specified", "Remove the CoPIs from the proposal", (IBusinessObject)obsProposal));
        }
    }

    void checkAbstractAndMiscellaneous(ObsProposal obsProposal, ProblemListModel problemListModel) {
        String string;
        int n;
        String string2 = obsProposal.getDuplicateObservationsJustification();
        boolean bl = obsProposal.hasIsResubmission() && obsProposal.getIsResubmission();
        int n2 = string2.length();
        if (n2 > MAX_DUPLICATION_TEXTAREA_CHARACTERS) {
            problemListModel.add(DefaultProblem.createError("The justification for a duplicate observation contains too many characters (" + n2 + ")", "Select the proposal node in the Proposal tab and edit the justification for a duplicate observation (max " + MAX_DUPLICATION_TEXTAREA_CHARACTERS + " characters)", (IBusinessObject)obsProposal));
        }
        if ((n = (string = obsProposal.getAbstract()).length()) > MAX_ABSTRACT_CHARACTERS) {
            problemListModel.add(DefaultProblem.createError("Abstract contains too many characters (" + n + ")", "Select the proposal node in the Proposal tab and edit your abstract (max " + MAX_ABSTRACT_CHARACTERS + " characters)", (IBusinessObject)obsProposal));
        }
        if (string.isEmpty() || string.length() == 0) {
            problemListModel.add(DefaultProblem.createError("Abstract appears to be empty", "Select the proposal node in the Proposal tab and edit your abstract", (IBusinessObject)obsProposal));
        }
        if (obsProposal.getScientificCategoryCode() == null || obsProposal.getScientificCategoryCode().equals("0") || obsProposal.getScientificCategoryString().equals("")) {
            problemListModel.add(DefaultProblem.createError("No scientific category defined", "Select Proposal node and set a scientific category", (IBusinessObject)obsProposal));
        }
        if (obsProposal.getProposalTypeCode() == null || obsProposal.getProposalTypeCode().equals("-") || obsProposal.getProposalTypeString().equals("")) {
            problemListModel.add(DefaultProblem.createError("No proposal type defined", "Select Proposal node and set a proposal type", (IBusinessObject)obsProposal));
        }
        if (obsProposal.getAbstractScienceGoalCount() == 0) {
            problemListModel.add(DefaultProblem.createError("This proposal contains no Science Goals", "Select the Planned Observing node in the Proposal tab and add science goals", (IBusinessObject)obsProposal));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            try {
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                String object = scienceGoal.getName().trim();
                if (hashSet.contains(object)) {
                    problemListModel.add(DefaultProblem.createError("This proposal already contains a science goal labelled " + object, "Please change the name of the science goal.", (IBusinessObject)obsProposal));
                    continue;
                }
                hashSet.add(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (MAX_SCIENCE_GOALS > 0) {
            if (obsProposal.getAbstractScienceGoalCount() > MAX_SCIENCE_GOALS) {
                problemListModel.add(DefaultProblem.createError("This proposal contains too many Science Goals (maximum number is " + MAX_SCIENCE_GOALS + ")", "Select the Planned Observing node in the Proposal tab and remove some science goals", (IBusinessObject)obsProposal));
            }
            int n3 = 0;
            int n4 = 0;
            for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
                try {
                    ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                    n3 += scienceGoal.getTargetParametersCount();
                    for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                        if (targetParameters.isRectanglePattern()) {
                            for (Rectangle rectangle : targetParameters.getFieldRectangle()) {
                                n4 += rectangle.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M);
                            }
                            continue;
                        }
                        if (!targetParameters.isPointingPattern()) continue;
                        n4 += targetParameters.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n3 > MAX_TOTAL_SOURCES) {
                problemListModel.add(DefaultProblem.createError("This proposal contains too many Sources (maximum number is " + MAX_TOTAL_SOURCES + ")", "Remove some sources from your science goals", (IBusinessObject)obsProposal));
            }
            if (n4 > MAX_NUMBER_POINTINGS) {
                problemListModel.add(DefaultProblem.createError("Your science goals contain too many pointings in total (limit is " + MAX_NUMBER_POINTINGS + ")", "Try reducing the map sizes or increasing spacing in your science goals", (IBusinessObject)obsProposal));
            }
        }
    }

    void checkDocuments(ObsProposal obsProposal, ProblemListModel problemListModel) {
        block14: {
            try {
                ObsAttachment obsAttachment = obsProposal.getDocuments();
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (obsAttachment != null) {
                    String string;
                    for (DocumentLink n2 : obsAttachment.getDocumentLink()) {
                        string = n2.getFileType();
                        boolean bl3 = true;
                        for (String string2 : DocumentLink.getKnownFileTypeList()) {
                            if (!string.equals(string2)) continue;
                            bl3 = false;
                        }
                        if (bl3) {
                            problemListModel.add(DefaultProblem.createError("Bad document type (" + n2.getFileName() + "): Only files of type +" + Arrays.asList(DocumentLink.getKnownFileTypeList()) + " are accepted", "Select the proposal node in the Proposal tab and attach a file of the correct type", (IBusinessObject)obsProposal));
                        }
                        for (String string3 : arrayList) {
                            if (!n2.getFileName().equals(string3)) continue;
                            bl2 = true;
                        }
                        arrayList.add(n2.getFileName());
                        if (!n2.getDocumentClass().equals(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        problemListModel.add(DefaultProblem.createError("No science case: a Science and Technical Case is a mandatory document", "Select the proposal node in the Proposal tab and add a science case", (IBusinessObject)obsProposal));
                    } else {
                        try {
                            File iOException = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE).getTemporaryFileToView();
                            PdfReader pdfReader = new PdfReader((InputStream)new FileInputStream(iOException));
                            int n = pdfReader.getNumberOfPages();
                            int n2 = MAX_SCIENCECASE_PAGES;
                            if (StringUtils.contains((CharSequence)obsProposal.getProposalTypeCode(), (CharSequence)"L")) {
                                n2 = MAX_LARGEPROGRAM_SCIENCECASE_PAGES;
                            }
                            if (n > n2) {
                                string = String.format("Maximum number of pages allowed for the science case is %d, while your attached case has %d pages.", n2, n);
                                problemListModel.add(DefaultProblem.createError(string, "Select the proposal node in the Proposal tab and replace or modify your science case", (IBusinessObject)obsProposal));
                            }
                        }
                        catch (IOException iOException) {
                            problemListModel.add(DefaultProblem.createError("There was a problem reading your science case", "Select the proposal node in the Proposal tab and check or replace the attached science case", (IBusinessObject)obsProposal));
                        }
                    }
                    if (bl2) {
                        problemListModel.add(DefaultProblem.createError("Duplicate filenames found", "Select the proposal node in the Proposal tab and check the names of your attached files", (IBusinessObject)obsProposal));
                    }
                    break block14;
                }
                problemListModel.add(DefaultProblem.createError("No document found - you must add a Science Case to your proposal", "Select the proposal node in the Proposal tab and add your document", (IBusinessObject)obsProposal));
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
    }

    void checkTime(ObsProposal obsProposal, ProblemListModel problemListModel) {
        if (obsProposal.isVLBI()) {
            this.checkVLBIRequestedTime(obsProposal, problemListModel);
            return;
        }
        AbstractScienceGoal[] abstractScienceGoalArray = obsProposal.getAbstractScienceGoal();
        Time time = Time.createTimeSec(0.0);
        Time time2 = Time.createTimeSec(0.0);
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            Object object;
            try {
                Collection<ScienceGoal> collection;
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                scienceGoal.setEstimatedTotalTime(Time.createTime());
                scienceGoal.setEstimated12mTime(Time.createTime());
                scienceGoal.setEstimated7mTime(Time.createTime());
                scienceGoal.setEstimatedTPTime(Time.createTime());
                scienceGoal.setEstimatedACATime(Time.createTime());
                object = new SourceClusterDetector(scienceGoal);
                try {
                    collection = ((SourceClusterDetector)object).splitScienceGoalIntoSourceClusters();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new WizardSBGenerationException(invalidObsProgramParametersException);
                }
                for (ScienceGoal scienceGoal2 : collection) {
                    Object object2;
                    PerformanceParameters performanceParameters = scienceGoal2.gettruePerformanceParameters();
                    ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal2);
                    Time time3 = Time.createTimeSec(0.0);
                    if (!scienceGoal2.isStandAloneACA()) {
                        time3 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_12M, true);
                    }
                    Time time4 = Time.createTimeSec(0.0);
                    Time time5 = Time.createTimeSec(0.0);
                    if (performanceParameters != null) {
                        object2 = AlmaCapabilities.getInstance();
                        NUM_ANTENNA_7M = ((AlmaCapabilities)object2).getNumAntennas(Array.ARRAY_7M, scienceGoal2.getSpectralSetupParameters());
                        if (performanceParameters.gettrueUseACA() && NUM_ANTENNA_7M > 0) {
                            time4 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_7M, true);
                        }
                        NUM_ANTENNA_TP = ((AlmaCapabilities)object2).getNumAntennas(Array.ARRAY_TP, scienceGoal2.getSpectralSetupParameters());
                        if (performanceParameters.gettrueUseTP() && NUM_ANTENNA_TP > 0) {
                            time5 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_TP, true);
                        }
                    }
                    Object object3 = object2 = time4.isGreaterThan((AbstractDoubleWithUnit)time5) ? time4 : time5;
                    if (scienceGoal2.isStandAloneACA()) {
                        time2.aggregate((Time)object2);
                    } else {
                        time.aggregate(time3);
                    }
                    Time time6 = (Time)time3.plus((AbstractDoubleWithUnit)object2);
                    scienceGoal.getEstimatedTotalTime().aggregate(time6);
                    scienceGoal.getEstimated12mTime().aggregate(time3);
                    scienceGoal.getEstimated7mTime().aggregate(time4);
                    scienceGoal.getEstimatedTPTime().aggregate(time5);
                    scienceGoal.getEstimatedACATime().aggregate((Time)object2);
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                object = TextUtils.stripClasspaths(invalidObsProgramParametersException.getMessage());
                problemListModel.add(DefaultProblem.createError("Unable to calculate estimated array times", "Please revise your setup: " + (String)object, (IBusinessObject)obsProposal));
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obsProposal.isLargeProgram()) {
            this.performLargeProgramsValidation(obsProposal, problemListModel, time2, time);
        } else {
            this.performNonLargeProgramsValidation(obsProposal, problemListModel, time2, time);
        }
    }

    private void performNonLargeProgramsValidation(ObsProposal obsProposal, ProblemListModel problemListModel, Time time, Time time2) {
        if (problemListModel == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: plm");
        }
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        if (time2.isGreaterThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_TWELVEM)) {
            problemListModel.add(DefaultProblem.createError("12-m time is greater than " + MIN_LARGE_PROGRAM_TIME_TWELVEM.getContentInUnits(Time.UNIT_H) + " hours", "Either change Proposal Type to Large Program, or reduce requested time.", (IBusinessObject)obsProposal));
        }
        if (time.isGreaterThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_SACA)) {
            problemListModel.add(DefaultProblem.createError("Stand-alone ACA time is greater than " + MIN_LARGE_PROGRAM_TIME_SACA.getContentInUnits(Time.UNIT_H) + " hours", "Either change Proposal Type to Large Program, or reduce requested time.", (IBusinessObject)obsProposal));
        }
    }

    private void checkVLBIRequestedTime(ObsProposal obsProposal, ProblemListModel problemListModel) {
        Time time = Time.createTimeSec(0.0);
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            PerformanceParameters performanceParameters = scienceGoal.gettruePerformanceParameters();
            if (performanceParameters == null) continue;
            time.aggregate(performanceParameters.getDesiredTime());
        }
        if (time.isGreaterThan((AbstractDoubleWithUnit)MAX_ALLOWED_PROPOSAL_TIME)) {
            problemListModel.add(DefaultProblem.createError("Total time requested, including calibration, is greater than " + MAX_ALLOWED_PROPOSAL_TIME.getContentInUnits(Time.UNIT_H) + " hours", "Try to reduce time required for VLBI", (IBusinessObject)obsProposal));
        }
    }

    private void checkProposalTitleLength(ObsProposal obsProposal, ProblemListModel problemListModel) {
        if (obsProposal.getTitle().length() > 120) {
            problemListModel.add(DefaultProblem.createError("Proposal title cannot exceed 120 characters.", "Please shorten the proposal title to fit within this limit", (IBusinessObject)obsProposal));
        }
    }

    private void checkKeywords(ObsProposal obsProposal, ProblemListModel problemListModel) {
        if (obsProposal.getKeywordCount() < 1) {
            problemListModel.add(DefaultProblem.createError("Must select a minimum of 1 science keywords", "Select the Proposal node and then add some science keywords (minimum 1 keywords)", (IBusinessObject)obsProposal));
        }
        if (obsProposal.getKeywordCount() > 2) {
            problemListModel.add(DefaultProblem.createError("Not permitted to select more than 2 science keywords", "Select the Proposal node and then reduce the number of science keywords (maximum 2 keywords)", (IBusinessObject)obsProposal));
        }
    }

    private void performLargeProgramsValidation(ObsProposal obsProposal, ProblemListModel problemListModel, Time time, Time time2) {
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        if (!obsProposal.isLargeProgram()) {
            throw new IllegalArgumentException("obsproposal should be a large program");
        }
        if (time == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sacaProjectTime");
        }
        if (time2 == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: twelveMProjectTime");
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            Collection<ScienceGoal> collection;
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = null;
                try {
                    enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal2);
                }
                catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                    Log.logger(ObsProposalValidator.class).warning("Unable to determine non-standard observing modes: " + unableToDetermineObservingModesException.getMessage());
                    return;
                }
                assert (enumSet != null);
                for (SingleFieldScienceGoalModel.NonStandardMode nonStandardMode : enumSet) {
                    Problem problem = DefaultProblem.createError("Non-standard observing modes not allowed with large program proposals", nonStandardMode.getExplanation(), (IBusinessObject)scienceGoal);
                    problemListModel.add(problem);
                }
            }
        }
        if (time2.isLessThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_TWELVEM) && time.isLessThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_SACA)) {
            problemListModel.add(DefaultProblem.createError("Minimum time for a Large Program has not been reached", "Ensure that the SACA or 12-m time exceeds the minimum or deselect Large Program.", (IBusinessObject)obsProposal));
        }
    }

    static {
        ObsProposalValidator.refreshLimits();
    }

    public static enum LargeProgramType {
        TWELVEM,
        SACA;

    }
}

