/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Frequency;

public class BaseBandConfigValidator
extends AbstractValidator {
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        Problem problem;
        AbstractBaseBandConfig abstractBaseBandConfig = (AbstractBaseBandConfig)businessObject;
        if (abstractBaseBandConfig.getSingleSpectralWindowCount() == 0) {
            problem = DefaultProblem.createError("No sub bands have been specified for BaseBandConfig " + abstractBaseBandConfig.getBaseBandIndex(), "Navigate to the BaseBandConfig and add one or more sub bands", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        Frequency frequency = abstractBaseBandConfig.getCenterFrequency();
        try {
            String string = ReceiverBand.getReceiverBandName(frequency.getContentInGHz());
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        if (!bl) {
            problem = DefaultProblem.createError("BaseBandConfig " + abstractBaseBandConfig.getBaseBandIndex() + " centre frequency (" + (Object)((Object)frequency) + ") is not supported", "Choose another frequency", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private boolean isValidAutoModeDuration(double d) {
        double[] dArray = this.validAutoModeDurations();
        for (int i = 0; i < dArray.length; ++i) {
            if (!this.equals(d, dArray[i])) continue;
            return true;
        }
        return false;
    }

    private String validAutoModeDurationsString() {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = this.validAutoModeDurations();
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(dArray[i]);
            string = i == dArray.length - 2 ? " or " : ", ";
        }
        return stringBuffer.toString();
    }

    private double[] validAutoModeDurations() {
        double[] dArray = new double[]{1.0, 2.0, 4.0, 8.0};
        return dArray;
    }
}

