/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.ObservingParametersValidator;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Time;

public class CalibratorParametersValidator
extends ObservingParametersValidator {
    public CalibratorParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        Problem problem;
        super.localValidate(businessObject, problemListModel);
        CalibratorParameters calibratorParameters = (CalibratorParameters)businessObject;
        double d2 = calibratorParameters.getCycleTime().getContentInUnits(Time.UNIT_S);
        if (d2 <= 0.0) {
            problem = DefaultProblem.createError("Calibrator cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)calibratorParameters);
            problemListModel.add(problem);
        }
        if ((d = calibratorParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
            problem = DefaultProblem.createError("Calibrator default integration time is invalid", "Set the time to a sensible value", (IBusinessObject)calibratorParameters);
            problemListModel.add(problem);
        }
        if (calibratorParameters.getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Calibrator subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)calibratorParameters);
            problemListModel.add(problem);
        }
        for (Target target : calibratorParameters.getTargetList()) {
            if (target.getAbstractInstrumentSpec() == null || target.getAbstractInstrumentSpec() instanceof OpticalCameraSpec) continue;
            Time time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration();
            Time time2 = calibratorParameters.getSubScanDuration();
            if (!ValidatorUtils.isIntegralMultipleTime(time2, time)) {
                problem = DefaultProblem.createError("Subscan duration in calibrator parameters is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
            problem = DefaultProblem.createError("Subscan duration in calibrator parameters is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

