/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.interfaces.PropertyChangeNotifier;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.defaulters.CircularDependencyException;
import alma.obsprep.defaulters.Defaulter;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeEvent;

public class DefFrequencySetup
extends Defaulter {
    private Model model;

    public DefFrequencySetup(SpectralSpec spectralSpec, Model model) throws CircularDependencyException {
        super((PropertyChangeNotifier)spectralSpec.getRestFrequency(), (Object)spectralSpec);
        this.model = model;
    }

    @Override
    public void fire(PropertyChangeEvent propertyChangeEvent) {
        SpectralSpec spectralSpec = (SpectralSpec)this.getDependent();
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getSource();
        if (string.endsWith("content")) {
            Double d = (Double)object;
            double d2 = d;
            if (d2 == 0.0) {
                return;
            }
            try {
                Velocity velocity = spectralSpec.getSourceVelocity();
                Frequency frequency = Frequency.createFrequencyGHZ(d2);
                Frequency frequency2 = velocity.dopplerShift(frequency);
                String string2 = FrequencySetup.DOPPLERREFERENCE_TOPO.equals(spectralSpec.getFrequencySetup().getDopplerReference()) ? ReceiverBand.getReceiverBandName(frequency.getContentInGHz()) : ReceiverBand.getReceiverBandName(frequency2.getContentInGHz());
                spectralSpec.setReceiverBandName(string2);
                if (this.model != null) {
                    this.model.publish();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GUIUtilities.error(null, "Could not find a matching receiver band", illegalArgumentException);
            }
        }
    }
}

