/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.EphemerisValidator;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import jsky.coords.WorldCoords;

public class FieldSourceValidator
extends AbstractValidator {
    private static final int MAX_NUMBER_POINTINGS = 10000;
    private Log.Logger logger = Log.logger((Object)this);

    public FieldSourceValidator() {
        this.setValidatorThreadSafe(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        double d2;
        double d3;
        Object object;
        FieldPattern fieldPattern;
        Problem problem;
        FieldSource fieldSource = (FieldSource)businessObject;
        fieldSource.setSourceName(MiscUtils.getSanitizedSourceName(fieldSource.getSourceName()));
        if (fieldSource.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Field source " + fieldSource.getName() + " is not used by any target", " ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SchedBlock schedBlock = (SchedBlock)fieldSource.getParent();
        this.logger.fine("Obs Mode = " + schedBlock.getModeName());
        if (fieldSource.getFieldPattern() == null) {
            problem = DefaultProblem.createError("No Field Pattern has been specified for the FieldSource", "Navigate to the FieldSource, select a field pattern type, and fill in the details of that field pattern", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getFieldPatternType().equals(FieldPattern.TYPE_POINT) && ((PointingPattern)((Object)fieldSource.getFieldPattern())).getPhaseCenterCoordinatesCount() == 0) {
            problem = DefaultProblem.createError("Number of pointings in the Pointing Field Pattern is 0", "Navigate to the FieldSource and add at least one pointing position to the field pattern", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((fieldPattern = fieldSource.getFieldPattern()).isRectanglePattern()) {
            void var21_25;
            object = (RectanglePattern)((Object)fieldPattern);
            double d4 = object.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC);
            d3 = object.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC);
            double d5 = 0.0;
            d2 = 0.0;
            try {
                d5 = RectanglePatternModel.calculateSamplesPerBeam((RectanglePattern)object, d4, d3, RectanglePatternModel.Axis.LATITUDE);
            }
            catch (RectanglePatternModel.UnableToCalculateSamplesPerBeamException unableToCalculateSamplesPerBeamException) {
                problem = DefaultProblem.createWarning("Unable to establish latitudinal samples per beam", "Contact ARC representative", (IBusinessObject)businessObject);
                problemListModel.add(problem);
                return;
            }
            try {
                d2 = RectanglePatternModel.calculateSamplesPerBeam((RectanglePattern)object, d4, d3, RectanglePatternModel.Axis.LONGITUDE);
            }
            catch (RectanglePatternModel.UnableToCalculateSamplesPerBeamException unableToCalculateSamplesPerBeamException) {
                problem = DefaultProblem.createWarning("Unable to establish longitudinal samples per beam", "Contact ARC representative", (IBusinessObject)businessObject);
                return;
            }
            d = 0.0;
            double d6 = 0.0;
            String string = null;
            Object object2 = null;
            if (RectanglePattern.SCANDIRECTION_LATITUDE.equals(object.getScanDirection())) {
                d = 4.95;
                d6 = 2.95;
                string = "Revise the orthogonal step";
                String string2 = "Revise the latitudinal length";
            } else {
                d = 2.95;
                d6 = 4.95;
                string = "Revise the longitudinal length";
                String string3 = "Revise the orthogonal step";
            }
            assert (d > 0.0);
            assert (d6 > 0.0);
            assert (string != null);
            assert (var21_25 != null);
            if (d2 < d6) {
                problem = DefaultProblem.createWarning("Longitudinal samples per beam is less than " + d6, string, (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (d5 < d) {
                problem = DefaultProblem.createWarning("Latitudinal samples per beam is less than " + d, (String)var21_25, (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        if (fieldSource.getIsQuery()) {
            return;
        }
        if (fieldSource.getName() == "") {
            problem = DefaultProblem.createWarning("Fieldsource name is blank", "Navigate to the FieldSource and enter a name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getSourceName() == "") {
            problem = DefaultProblem.createError("FieldSource source name is blank", "Navigate to the FieldSource and enter a name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        object = SiteCharacteristics.getInstance();
        Latitude latitude = ((SiteCharacteristics)object).getObsLatitude();
        SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
        d3 = Math.abs(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG) - latitude.getContentInUnits(Latitude.UNIT_DEG));
        if (d3 > 90.0) {
            problem = DefaultProblem.createError("Target declination is never visible from " + ((SiteCharacteristics)object).getObsName(), "Choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!fieldSource.getNonSiderealMotion() && !fieldSource.getIsQuery() && skyCoordinates.getLatitude().getContent() == 0.0 && skyCoordinates.getLongitude().getContent() == 0.0) {
            problem = DefaultProblem.createWarning("Your field source coordinates are 0.0, 0.0", "Please be sure you mean this", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!fieldSource.getNonSiderealMotion() && !fieldSource.getIsQuery() && fieldSource.getSourceCoordinates().getSystem().equals(SkyCoordinates.SYSTEM_J2000)) {
            problem = DefaultProblem.createError("FK5 is no longer supported.", "Change coordinate system to ICRS.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getNonSiderealMotion() && fieldSource.getSolarSystemObject() == FieldSource.SOLARSYSTEMOBJECT_UNSPECIFIED) {
            problem = DefaultProblem.createError("You have selected a solar system target without specifying one", "Choose a solar system object from the list", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (fieldSource.getNonSiderealMotion() && (fieldSource.getSolarSystemObject() == FieldSource.SOLARSYSTEMOBJECT_EPHEMERIS || fieldSource.getSolarSystemObject() == FieldSource.SOLARSYSTEMOBJECT_SUN)) {
            EphemerisValidator ephemerisValidator = new EphemerisValidator(this.logger);
            ephemerisValidator.validateEphemeris(fieldSource.getSourceEphemeris(), (BusinessObject)fieldSource, problemListModel, false);
        }
        if (fieldSource.getSourceVelocity().getReferenceSystem() == Velocity.REFERENCESYSTEM_HEL) {
            problem = DefaultProblem.createWarning("Helio-centric velocity reference frames are not possible in Control", "The frame has been changed to barycentric - or you may choose something else", (IBusinessObject)businessObject);
            problemListModel.add(problem);
            fieldSource.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_BAR);
        }
        Reference[] referenceArray = fieldSource.getReference();
        for (int i = 0; i < referenceArray.length; ++i) {
            d2 = referenceArray[i].getIntegrationTime().getContentInUnits(Time.UNIT_S);
            if (d2 <= 0.0) {
                problem = DefaultProblem.createError("Reference position integration time is invalid", "Set the time to a sensible value", (IBusinessObject)referenceArray[i]);
                problemListModel.add(problem);
            }
            if ((d = referenceArray[i].getCycleTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
                problem = DefaultProblem.createError("Reference position cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)referenceArray[i]);
                problemListModel.add(problem);
            }
            if (referenceArray[i].getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
                problem = DefaultProblem.createError("Reference position subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)referenceArray[i]);
                problemListModel.add(problem);
            }
            for (Target target : fieldSource.getTargetList()) {
                Time time;
                if (target.getAbstractInstrumentSpec() == null || target.getAbstractInstrumentSpec() instanceof OpticalCameraSpec) continue;
                Time time2 = referenceArray[i].getSubScanDuration();
                if (!ValidatorUtils.isIntegralMultipleTime(time2, time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration())) {
                    problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)referenceArray[i]);
                    problemListModel.add(problem);
                }
                if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
                problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)referenceArray[i]);
                problemListModel.add(problem);
            }
        }
        if (fieldPattern.isPointingPattern() && ((PointingPattern)((Object)fieldPattern)).getPhaseCenterCoordinatesCount() > 10000) {
            problem = DefaultProblem.createError("Too many pointings is the field pattern (limit is 10000)", "Select the Field Source reduce the number of pointings", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.validatePointingsNotTooFarFromFieldSourceCentralCoordinate(businessObject, problemListModel, fieldSource);
    }

    private void validatePointingsNotTooFarFromFieldSourceCentralCoordinate(BusinessObject businessObject, ProblemListModel problemListModel, FieldSource fieldSource) {
        double d = AlmaPolicies.getInstance().getMaxSeparationFromSourceCoordinate().getContentInUnits(Angle.UNIT_DEG);
        SkyPoint skyPoint = fieldSource.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
        if (fieldSource.getFieldPattern().isPointingPattern()) {
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldSource.getFieldPattern());
            SkyCoordinates[] skyCoordinatesArray = pointingPattern.getPhaseCenterCoordinates();
            for (int i = 0; i < skyCoordinatesArray.length; ++i) {
                SkyCoordinates skyCoordinates = skyCoordinatesArray[i];
                if (skyCoordinates.isOffsetCoordinates()) {
                    skyCoordinates = skyCoordinates.getAbsoluteCoordinates(fieldSource.getTargetCenter());
                }
                SkyPoint skyPoint2 = skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
                double d2 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
                if (!(d2 >= d)) continue;
                Problem problem = DefaultProblem.createError(String.format("A pointing is more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break;
            }
        } else if (fieldSource.getFieldPattern().isRectanglePattern()) {
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
            SkyCoordinates skyCoordinates = rectanglePattern.getPatternCenterCoordinates();
            if (rectanglePattern.getPatternCenterCoordinates().isOffsetCoordinates()) {
                skyCoordinates = skyCoordinates.getAbsoluteCoordinates(fieldSource.getTargetCenter());
            }
            SkyPoint skyPoint3 = skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
            double d3 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint3.getX(), (double)skyPoint3.getY()) / 60.0;
            if (d3 >= d) {
                Problem problem = DefaultProblem.createError(String.format("Rectangle field pattern is offset by more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        } else {
            throw new RuntimeException("Unknown field type specified" + fieldSource.getFieldPatternType());
        }
    }
}

