/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class ObservingGroupValidator
extends AbstractValidator {
    public ObservingGroupValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        ObservingGroup observingGroup = (ObservingGroup)businessObject;
        if (observingGroup.getOrderedTargetCount() <= 0) {
            problem = DefaultProblem.createWarning("An observing group is empty: the first observing group should include calibrators unless this is a multi-tuning setup", "Add calibrators to the first observing group if necessary", observingGroup);
            problemListModel.add(problem);
        }
        boolean bl = false;
        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
            Target target = orderedTarget.getTarget();
            if (!target.hasScienceParameters()) continue;
            bl = true;
            break;
        }
        if (bl && observingGroup.getMainTarget() == null) {
            problem = DefaultProblem.createWarning("An observing group has science targets but no designated doppler target", "Assign doppler target to observing group", observingGroup);
            problemListModel.add(problem);
        }
    }
}

