/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Angle;

public class PreconditionsValidator
extends AbstractValidator {
    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        Preconditions preconditions = (Preconditions)businessObject;
        if (preconditions.getMaxAllowedHA().getContentInUnits(Angle.UNIT_DEG) < 0.0 || preconditions.getMaxAllowedHA().getContentInUnits(Angle.UNIT_DEG) > 360.0) {
            problem = DefaultProblem.createError("Maximum HA is invalid", "Set the maximum HA allowed to a sensible value", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
        if (preconditions.getMinAllowedHA().getContentInUnits(Angle.UNIT_DEG) < 0.0 || preconditions.getMaxAllowedHA().getContentInUnits(Angle.UNIT_DEG) > 360.0) {
            problem = DefaultProblem.createError("Minimum HA is invalid", "Set the maximum HA allowed to a sensible value", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
        if (preconditions.getMinAllowedHA().getContentInUnits(Angle.UNIT_DEG) > preconditions.getMaxAllowedHA().getContentInUnits(Angle.UNIT_DEG)) {
            problem = DefaultProblem.createError("Minimum HA is greater than maximum HA", "Set the HA limits to consistent values", (IBusinessObject)preconditions);
            problemListModel.add(problem);
        }
    }
}

