/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.data.ObsUnitData;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Magnitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.data.AngleData;
import alma.valuetypes.data.LatitudeData;
import alma.valuetypes.data.TimeData;
import java.util.HashSet;
import jsky.coords.WorldCoords;

public class SchedBlockValidator
extends AbstractValidator {
    static AlmaPolicies apol = AlmaPolicies.getInstance();
    static int MAX_TEXTAREA_CHARACTERS = apol.getMaxTextAreaCharacters();

    public SchedBlockValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        SchedBlockControl schedBlockControl;
        Problem problem;
        SchedBlock schedBlock = (SchedBlock)businessObject;
        schedBlock.setName(MiscUtils.getSanitizedSourceName(schedBlock.getName()));
        String string = schedBlock.getNote();
        int n = string.length();
        if (n > MAX_TEXTAREA_CHARACTERS) {
            problem = DefaultProblem.createError("Description contains too many characters (" + n + ")", "Select the SchedBlock node in the Program tab and edit your description (max " + MAX_TEXTAREA_CHARACTERS + " characters)", schedBlock);
            problemListModel.add(problem);
        }
        if ((schedBlockControl = schedBlock.getSchedBlockControl()).getSBMaximumTime().getContentInUnits(TimeData.UNIT_S) <= 0.0) {
            problem = DefaultProblem.createError("SB Maximum time is not valid", "Set the maximum time allowed for the schedblock to a sensible value", schedBlock);
            problemListModel.add(problem);
        }
        ObsUnitControl obsUnitControl = schedBlock.getObsUnitControl();
        Log.logger((Object)this).fine("**** Before EET checks ****");
        Log.logger((Object)this).fine("**** Estimated Execution Time :" + obsUnitControl.getEstimatedExecutionTime());
        Log.logger((Object)this).fine("**** Aggregated Execution Count :" + obsUnitControl.getAggregatedExecutionCount());
        if (obsUnitControl.getEstimatedExecutionTime().isZero()) {
            obsUnitControl.setEstimatedExecutionTime(schedBlockControl.calcEstimatedTime());
        }
        if (obsUnitControl.getMaximumTime().isZero()) {
            obsUnitControl.setMaximumTime(schedBlockControl.calcMaxTime());
        }
        if (obsUnitControl.getAggregatedExecutionCount() == 0) {
            obsUnitControl.setAggregatedExecutionCount(schedBlockControl.getExecutionCount());
        }
        Log.logger((Object)this).fine("**** After checks ****");
        Log.logger((Object)this).fine("**** Estimated Execution Time :" + obsUnitControl.getEstimatedExecutionTime());
        Log.logger((Object)this).fine("**** Aggregated Execution Count :" + obsUnitControl.getAggregatedExecutionCount());
        if (!schedBlockControl.getIndefiniteRepeat() && schedBlockControl.getExecutionCount() < 1) {
            problem = DefaultProblem.createError("Execution count is < 0 and indefinite repeat is not set", "Either choose indefinite repeat or set a positive repeat count", schedBlock);
            problemListModel.add(problem);
        }
        ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
        String string2 = schedBlock.getModeName();
        if (!schedBlock.getModeType().equals(observingModeExpert.getModeTypeForMode(string2))) {
            problem = DefaultProblem.createWarning("Mode type is not consistent with mode name", "Please check your mode setup", schedBlock);
            problemListModel.add(problem);
        }
        if (schedBlock.getStandardMode() != observingModeExpert.isStandardMode(string2)) {
            problem = DefaultProblem.createWarning("Standard mode flag is not consistent with mode name", "Please check your mode setup", schedBlock);
            problemListModel.add(problem);
        }
        String string3 = schedBlock.getObsProcedure().getObsProcScript();
        if ((string3 = string3.trim()).isEmpty() || string3.length() == 0) {
            problem = DefaultProblem.createWarning("Observing procedure appears to be empty or blank", "Please ensure you have entered a valid observing script or script name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (schedBlock.getModeName().equals("StandardInterferomety") && schedBlock.getObservingGroupCount() < 2) {
            problem = DefaultProblem.createError("Standard Interferometry mode requires at least two observing groups", "Please add groups to match the observing mode description", schedBlock);
            problemListModel.add(problem);
        }
        schedBlock.getSchedulingConstraints().clearRequiredReceiverBands();
        HashSet<String> hashSet = new HashSet<String>();
        for (Target target : schedBlock.getTarget()) {
            AbstractInstrumentSpec abstractInstrumentSpec = target.getAbstractInstrumentSpec();
            if (abstractInstrumentSpec == null || !(abstractInstrumentSpec instanceof SpectralSpec)) continue;
            hashSet.add(((SpectralSpec)((Object)abstractInstrumentSpec)).getReceiverBandName());
        }
        for (String string4 : hashSet) {
            schedBlock.getSchedulingConstraints().addRequiredReceiverBands(string4);
        }
        this.validateScienceTargetsHaveValidAngularSeparation(businessObject, problemListModel, schedBlock);
        this.validateOpticalPointingTargets(problemListModel, schedBlock);
        this.validateRadiometricPointingTargets(problemListModel, schedBlock);
        if (schedBlock.getStatus().equals(ObsUnitData.STATUS_BROKEN)) {
            problem = DefaultProblem.createError("SchedBlock is marked Broken", "Either terminate the SB or fix the SB and mark it as repaired", schedBlock);
            problemListModel.add(problem);
        }
        if (schedBlock.getStatus().equals(ObsUnitData.STATUS_CSVSUSPENDED)) {
            problem = DefaultProblem.createWarning("Observations of this SchedBlock are suspended", "Use the 'Resume' option if you wish to resume observations of this SchedBlock", schedBlock);
            problemListModel.add(problem);
        }
    }

    private void validateScienceTargetsHaveValidAngularSeparation(BusinessObject businessObject, ProblemListModel problemListModel, SchedBlock schedBlock) {
        Target[] targetArray;
        block0: for (Target target : targetArray = schedBlock.getTarget()) {
            FieldSource fieldSource = target.getFieldSource();
            if (fieldSource == null || !target.hasScienceParameters() || fieldSource.getNonSiderealMotion()) continue;
            SkyPoint skyPoint = fieldSource.getSourceCoordinates().getAbsoluteSkyPointInICRSDeg();
            for (Target target2 : targetArray) {
                FieldSource fieldSource2 = target2.getFieldSource();
                if (fieldSource2 == null || !target2.hasScienceParameters() || fieldSource2.getNonSiderealMotion()) continue;
                SkyPoint skyPoint2 = fieldSource2.getSourceCoordinates().getAbsoluteSkyPointInICRSDeg();
                double d = apol.getMaxConeDiameter().getContentInUnits(AngleData.UNIT_DEG);
                if (!(WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY()) > d * 60.0)) continue;
                Problem problem = DefaultProblem.createWarning("Spread of science target positions is large (> " + d + " deg.)", "Consider putting some of the targets into separate science goals", (IBusinessObject)businessObject);
                problemListModel.add(problem);
                break block0;
            }
        }
    }

    private void validateRadiometricPointingTargets(ProblemListModel problemListModel, SchedBlock schedBlock) {
        for (int i = 0; i < schedBlock.getTargetCount(); ++i) {
            double d;
            RadiometricPointingParameters radiometricPointingParameters;
            double d2;
            Problem problem;
            Target target = schedBlock.getTarget(i);
            if (!target.hasRadiometricPointingParameters()) continue;
            FieldSource fieldSource = target.getFieldSource();
            if (fieldSource == null) {
                problem = DefaultProblem.createWarning("Field source unset", "Set a FieldSource to the Target", target);
                problemListModel.add(problem);
                continue;
            }
            if (fieldSource.getSourceName() == "") {
                problem = DefaultProblem.createWarning("Field source name unset", "Navigate to the FieldSource and enter a name", fieldSource);
                problemListModel.add(problem);
            }
            if ((d2 = (radiometricPointingParameters = target.getRadiometricPointingParametersList()[0]).getMinFlux().getContent()) >= (d = radiometricPointingParameters.getMaxFlux().getContent())) {
                problem = DefaultProblem.createError("Minimum flux is brighter than maximum flux", "Swap the flux limits", (IBusinessObject)radiometricPointingParameters);
                problemListModel.add(problem);
            }
            SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
            Latitude latitude = siteCharacteristics.getObsLatitude();
            Angle angle = radiometricPointingParameters.getElevationLimit();
            SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
            double d3 = 90.0 - (skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
            if (d3 < angle.getContent()) {
                problem = DefaultProblem.createError("Target declination is never above the specified elevation limit", "Remove this target or ease the elevation limit", fieldSource);
                problemListModel.add(problem);
            }
            if (fieldSource.getNonSiderealMotion()) {
                problem = DefaultProblem.createError("Radiometric camera targets should be sidereal", "Navigate to the Field Source and check your target settings", fieldSource);
                problemListModel.add(problem);
            }
            if (fieldSource.getSourceCoordinates().getSystem() == "J2000") continue;
            problem = DefaultProblem.createError("Radiometric camera target systems should always be J2000", "Navigate to the Field Source and check your target settings", fieldSource);
        }
    }

    private void validateOpticalPointingTargets(ProblemListModel problemListModel, SchedBlock schedBlock) {
        for (int i = 0; i < schedBlock.getTargetCount(); ++i) {
            Magnitude magnitude;
            double d;
            OpticalPointingParameters opticalPointingParameters;
            double d2;
            Problem problem;
            Target target = schedBlock.getTarget(i);
            if (!target.hasOpticalPointingParameters()) continue;
            FieldSource fieldSource = target.getFieldSource();
            if (fieldSource == null) {
                problem = DefaultProblem.createWarning("Field source unset", "Set a FieldSource to the Target", target);
                problemListModel.add(problem);
                continue;
            }
            if (fieldSource.getSourceName() == "") {
                problem = DefaultProblem.createWarning("Field source name unset", "Navigate to the FieldSource and enter a name", fieldSource);
                problemListModel.add(problem);
            }
            if ((d2 = (opticalPointingParameters = target.getOpticalPointingParametersList()[0]).getMinMagnitude().getValue()) <= (d = opticalPointingParameters.getMaxMagnitude().getValue())) {
                problem = DefaultProblem.createError("Faintest magnitude is brighter than brightest magnitude", "Swap the magnitude limits", (IBusinessObject)opticalPointingParameters);
                problemListModel.add(problem);
            }
            SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
            Latitude latitude = siteCharacteristics.getObsLatitude();
            Angle angle = opticalPointingParameters.getElevationLimit();
            SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
            double d3 = 90.0 - (skyCoordinates.getLatitude().getContentInUnits(LatitudeData.UNIT_DEG) - latitude.getContentInUnits(LatitudeData.UNIT_DEG));
            if (d3 < angle.getContent()) {
                problem = DefaultProblem.createError("Target declination is never above the specified elevation limit", "Remove this target or ease the elevation limit", fieldSource);
                problemListModel.add(problem);
            }
            if (fieldSource.getNonSiderealMotion()) {
                problem = DefaultProblem.createError("Optical Camera targets should be sidereal", "Navigate to the Field Source and check your target settings", fieldSource);
                problemListModel.add(problem);
            }
            if (fieldSource.getSourceCoordinates().getSystem() != "J2000") {
                problem = DefaultProblem.createError("Optical camera target systems should always be J2000", "Navigate to the Field Source and check your target settings", fieldSource);
            }
            if ((magnitude = fieldSource.getVisibleMagnitudeOrNull()) == null) continue;
            if (magnitude.getValue() > d2) {
                problem = DefaultProblem.createError("Target too faint for the specified magnitude limit", "Remove this target or ease the magnitude limit", fieldSource);
                problemListModel.add(problem);
            }
            if (!(magnitude.getValue() < d)) continue;
            problem = DefaultProblem.createError("Target too bright for the specified magnitude limit", "Remove this target or ease the magnitude limit", fieldSource);
            problemListModel.add(problem);
        }
    }
}

