/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingState;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.FrequencySwitchingCycle;
import alma.obsprep.bo.schedblock.FrequencySwitchingState;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.List;

public class SpectralSpecValidator
extends AbstractValidator {
    public static final String MOVE_BASEBANDS_FURTHER_AWAY_FROM_THE_EDGE_OF_THE_FREQUENCY_BAND = "Move spws/basebands further away from the edge of the frequency band.";
    public static final String YOU_MAY_WISH_TO_CHECK_SETUPS_NEAR_BAND_EDGES = "You may wish to check setups near band edges.";
    public static final String SPEC_WINDOW_HAS_CENTRE_SET_NEAR_OR_OUTSIDE_ANTI_ALIASING_FILTER = "Spec. window has centre set near or outside anti-aliasing filter";
    private static final Frequency NOISY_REGION = (Frequency)((Frequency)Frequency.createFrequencyGHZ(2.0).divide(128.0)).multiply(3.0);
    private static final Frequency LO_NOISY_REGION = (Frequency)Frequency.createFrequencyGHZ(2.0).plus((AbstractDoubleWithUnit)NOISY_REGION);
    private static final Frequency HI_NOISY_REGION = (Frequency)Frequency.createFrequencyGHZ(4.0).minus((AbstractDoubleWithUnit)NOISY_REGION);
    private static final Speed EARTH_DOPPLER_SPEED = Speed.createSpeed((double)32.0, (String)Speed.UNIT_KM_S);

    public SpectralSpecValidator() {
        this.setValidatorThreadSafe(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        Object object;
        Problem problem;
        SpectralSpec spectralSpec = (SpectralSpec)businessObject;
        assert (spectralSpec != null);
        if (spectralSpec.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Spectral spec. " + spectralSpec.getName() + " is not used by any target", " ", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        AbstractSwitchingCycle abstractSwitchingCycle = spectralSpec.getAbstractSwitchingCycle();
        String string = null;
        if (abstractSwitchingCycle != null) {
            if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
                string = SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING;
            } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
                string = SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING;
            }
        } else {
            string = SpectralSpec.SWITCHINGTYPE_NO_SWITCHING;
        }
        if (!spectralSpec.getSwitchingType().equals(string)) {
            problem = DefaultProblem.createError("Expected switching type '" + string + "' doesn't match the inner switching cycle type", "The OT should automatically set this for you", (IBusinessObject)spectralSpec);
            problemListModel.add(problem);
        }
        if (abstractSwitchingCycle != null) {
            if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
                object = (FrequencySwitchingCycle)((Object)abstractSwitchingCycle);
                if (object.getFrequencySwitchingState().length == 0) {
                    problem = DefaultProblem.createWarning("No frequency switching states specified", "Add the necessary frequency switching states", (IBusinessObject)abstractSwitchingCycle);
                    problemListModel.add(problem);
                } else {
                    for (FrequencySwitchingState frequencySwitchingState : object.getFrequencySwitchingState()) {
                        if (frequencySwitchingState.getBin() > 0) continue;
                        problem = DefaultProblem.createError("Switching state bins should be natural numbers", "Bin values should start from 1", (IBusinessObject)frequencySwitchingState);
                        problemListModel.add(problem);
                    }
                }
            } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
                object = (BeamSwitchingCycle)((Object)abstractSwitchingCycle);
                if (object.getBeamSwitchingState().length == 0) {
                    problem = DefaultProblem.createWarning("No beam switching states specified", "Add the necessary beam switching states", (IBusinessObject)abstractSwitchingCycle);
                    problemListModel.add(problem);
                } else {
                    for (BeamSwitchingState beamSwitchingState : object.getBeamSwitchingState()) {
                        double d;
                        if (beamSwitchingState.getBin() <= 0) {
                            problem = DefaultProblem.createError("Switching state bins should be natural numbers", "Bin values should start from 1", (IBusinessObject)beamSwitchingState);
                            problemListModel.add(problem);
                        }
                        if (this.isMultiple(d = beamSwitchingState.getDwellTime().getContentInUnits(Time.UNIT_MS), 48.0, 0.0)) continue;
                        problem = DefaultProblem.createError("Dwell time is not multiple of 48 [ms]", "Dwell times should be multiples of 48 [ms]", (IBusinessObject)beamSwitchingState);
                        problemListModel.add(problem);
                    }
                }
            }
        }
        if (spectralSpec.hasSquareLawSetup()) {
            object = spectralSpec.getSquareLawSetup();
            double bl2 = object.getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
            if (object.getIntegrationDuration().isZero() || bl2 % 0.5 != 0.0) {
                problem = DefaultProblem.createError("Square law setup in instrument setup " + businessObject.getName() + " has an illegal integration duration ", "The integration duration must be a positive multiple of 0.5 ms", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            if (abstractBaseBandConfig == null) continue;
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                if (!spectralWindowI.getCenterFrequency().isLessThanOrEqualTo((AbstractDoubleWithUnit)LO_NOISY_REGION) && !spectralWindowI.getCenterFrequency().isGreaterThanOrEqualTo((AbstractDoubleWithUnit)HI_NOISY_REGION)) continue;
                problem = DefaultProblem.createWarning(SPEC_WINDOW_HAS_CENTRE_SET_NEAR_OR_OUTSIDE_ANTI_ALIASING_FILTER, "Signal to noise will be lower than expected. See Technical Handbook for more details.", (IBusinessObject)businessObject);
                if (RoleDirectoryServiceHelper.isUserP2G()) {
                    problemListModel.add(problem);
                }
                problemListModel.addUnpublishedProblem(problem);
            }
        }
        object = new SpectralSpecTuningValidationResult();
        ((SpectralSpecTuningValidationResult)object).setPoorLO2Warning(false);
        ((SpectralSpecTuningValidationResult)object).setPossEarthDopplerProblemMinusWarning(false);
        ((SpectralSpecTuningValidationResult)object).setPossEarthDopplerProblemPlusWarning(false);
        ((SpectralSpecTuningValidationResult)object).setValidationOkay(true);
        ((SpectralSpecTuningValidationResult)object).setCalibrationSetupOkay(true);
        boolean bl3 = true;
        int n = 0;
        List<Target> list = null;
        Object var11_23 = null;
        try {
            list = spectralSpec.getObservingGroupDopplerTargetForSpectralSpec();
            assert (list != null);
            if (list.size() == 0) {
                TargetParameters targetParameters = spectralSpec.searchForKeyTargetParametersForThisTuningGroup();
            }
        }
        catch (SpectralSpec.SpectralSpecAncestorIsAnObservatoryGoalException spectralSpecAncestorIsAnObservatoryGoalException) {
            list = null;
            n = 1;
        }
        catch (SpectralSpec.NoAbstractScienceGoalFoundAsParentException noAbstractScienceGoalFoundAsParentException) {
            list = null;
            bl = false;
        }
        catch (SpectralSpec.UnableToDetermineDopplerTargetException unableToDetermineDopplerTargetException) {
            Object var11_26 = null;
        }
        if (!bl) {
            return;
        }
        assert (bl);
        for (Target target : spectralSpec.getTargetList()) {
            Object object2;
            void var11_27;
            Velocity velocity;
            if (target.hasScienceParameters()) {
                velocity = Velocity.createVelocity();
                if (spectralSpec.getFrequencySetup().getDopplerReference() == FrequencySetup.DOPPLERREFERENCE_REST) {
                    if (list.size() > 0) {
                        for (Target target2 : list) {
                            FieldSource fieldSource = target2.getFieldSource();
                            assert (fieldSource != null);
                            velocity = fieldSource.getSourceVelocityInBary().deepCopy();
                            Log.logger(SpectralSpecValidator.class).fine(String.format("Validating spectral spec %s against velocity %s from doppler target %s", spectralSpec.getName(), velocity.getCenterVelocity().toString(), fieldSource.getSourceName()));
                            this.validateSpectralSpecTunings(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                            this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                        }
                        continue;
                    }
                    if (var11_27 != null) {
                        object2 = target.getFieldSource();
                        if (object2 != null && !object2.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)var11_27.getSourceVelocity().getCenterVelocity())) continue;
                        velocity = var11_27.getSourceVelocityInBary().deepCopy();
                        this.validateSpectralSpecTunings(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                        this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                        continue;
                    }
                    if (n != 0) {
                        void var18_43;
                        object2 = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeTarget();
                        Object var18_41 = null;
                        if (object2 != null) {
                            FieldSource fieldSource = object2.getFieldSource();
                        }
                        velocity = var18_43 == null ? Velocity.createVelocity() : var18_43.getSourceVelocityInBary();
                        this.validateSpectralSpecTunings(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                        this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                        continue;
                    }
                    Log.logger(SpectralSpecValidator.class).warning(String.format("Unable to determine representative target/doppler target associated with spectral spec %s", spectralSpec.getName()));
                    continue;
                }
                this.validateSpectralSpecTunings(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                this.validateBasebandRxBandEdgeInfringementDueToEarthDoppler(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                continue;
            }
            velocity = Velocity.createVelocity();
            if (spectralSpec.getFrequencySetup().getDopplerReference() == FrequencySetup.DOPPLERREFERENCE_REST) {
                void var18_47;
                if (list.size() > 0) {
                    for (Target target3 : list) {
                        velocity = target3.getFieldSource().getSourceVelocityInBary().deepCopy();
                        this.validateSpectralSpecForCalibrator(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                    }
                    continue;
                }
                if (var11_27 != null) {
                    velocity = var11_27.getSourceVelocityInBary().deepCopy();
                    this.validateSpectralSpecForCalibrator(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                    continue;
                }
                if (n == 0) continue;
                object2 = spectralSpec.getSchedBlock().getSchedulingConstraints().getRepresentativeTarget();
                Object var18_45 = null;
                if (object2 != null) {
                    FieldSource fieldSource = object2.getFieldSource();
                }
                velocity = var18_47 == null ? Velocity.createVelocity() : var18_47.getSourceVelocityInBary();
                this.validateSpectralSpecForCalibrator(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
                continue;
            }
            this.validateSpectralSpecForCalibrator(spectralSpec, velocity, (SpectralSpecTuningValidationResult)object);
        }
        if (!((SpectralSpecTuningValidationResult)object).isValidationOkay()) {
            problem = DefaultProblem.createError("Spectral spec. " + spectralSpec.getName() + " does not have a valid LO solution for all its science targets", "Test its LO setup against each target that uses it", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (((SpectralSpecTuningValidationResult)object).isBasebandNotInReceiverBand()) {
            problem = DefaultProblem.createWarning("Spectral spec. " + spectralSpec.getName() + " may fail during execution due to the Earth's motion", MOVE_BASEBANDS_FURTHER_AWAY_FROM_THE_EDGE_OF_THE_FREQUENCY_BAND, (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!((SpectralSpecTuningValidationResult)object).isCalibrationSetupOkay()) {
            problem = DefaultProblem.createWarning("Cal target Spectral spec. " + spectralSpec.getName() + " does not have a valid LO solution", "Check its LO setup", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateBasebandRxBandEdgeInfringementDueToEarthDoppler(SpectralSpec spectralSpec, Velocity velocity, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        Log.logger(SpectralSpecValidator.class).fine("validateBasebandRxBandEdgeInfringementDueToEarthDoppler processing : " + spectralSpec.getName());
        if (spectralSpec.getFrequencySetup().getDopplerReference() != FrequencySetup.DOPPLERREFERENCE_TOPO) {
            Velocity velocity2 = Velocity.createVelocity();
            Velocity velocity3 = Velocity.createVelocity();
            velocity2.setCenterVelocity(EARTH_DOPPLER_SPEED);
            velocity2.setReferenceSystem(velocity.getReferenceSystem());
            velocity2.setDopplerCalcType(velocity.getDopplerCalcType());
            velocity3.setCenterVelocity((Speed)EARTH_DOPPLER_SPEED.multiply(-1.0));
            velocity3.setReferenceSystem(velocity.getReferenceSystem());
            velocity3.setDopplerCalcType(velocity.getDopplerCalcType());
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            double d = ((Frequency)((Object)receiverBand.getRFRange().min())).getContentInGHz();
            double d2 = ((Frequency)((Object)receiverBand.getRFRange().max())).getContentInGHz();
            spectralSpec.calculateCorrelatorSetup(velocity, false);
            for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                Frequency frequency = abstractBaseBandConfig.getCenterFrequencySky();
                Frequency frequency2 = (Frequency)abstractBaseBandConfig.getBandwidth().half();
                double d3 = ((Frequency)frequency.dopplerShifted(velocity2).minus((AbstractDoubleWithUnit)frequency2)).getContentInGHz();
                if (Math.abs(d3) < d) {
                    spectralSpecTuningValidationResult.setBasebandNotInReceiverBand(true);
                }
                d3 = ((Frequency)frequency.dopplerShifted(velocity3).plus((AbstractDoubleWithUnit)frequency2)).getContentInGHz();
                Log.logger(SpectralSpecValidator.class).fine(spectralSpec.getName() + "-ve earth doppler delta_nu " + d3 + " maxReceiverFreqRangeGHz " + d2);
                if (!(Math.abs(d3) > d2)) continue;
                spectralSpecTuningValidationResult.setBasebandNotInReceiverBand(true);
            }
        }
    }

    private void validateSpectralSpecForCalibrator(SpectralSpec spectralSpec, Velocity velocity, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        if (!(spectralSpec.getBaseBandConfigCount() <= 0 || spectralSpec.calculateCorrelatorSetup(velocity) && spectralSpec.getFeedbackInfo() == null)) {
            spectralSpecTuningValidationResult.setCalibrationSetupOkay(false);
        }
    }

    private void validateSpectralSpecTunings(SpectralSpec spectralSpec, Velocity velocity, SpectralSpecTuningValidationResult spectralSpecTuningValidationResult) {
        if (!(spectralSpec.getBaseBandConfigCount() <= 0 || spectralSpec.calculateCorrelatorSetup(velocity) && spectralSpec.getFeedbackInfo() == null)) {
            spectralSpecTuningValidationResult.setValidationOkay(false);
        }
    }

    public class SpectralSpecTuningValidationResult {
        private boolean poorLO2Warning = false;
        private boolean possEarthDopplerProblemPlusWarning = false;
        private boolean possEarthDopplerProblemMinusWarning = false;
        private boolean validationOkay = true;
        private boolean calibrationSetupOkay = true;
        private boolean basebandNotInReceiverBand = false;

        public final boolean isPoorLO2Warning() {
            return this.poorLO2Warning;
        }

        public final boolean isPossEarthDopplerProblemPlusWarning() {
            return this.possEarthDopplerProblemPlusWarning;
        }

        public final boolean isPossEarthDopplerProblemMinusWarning() {
            return this.possEarthDopplerProblemMinusWarning;
        }

        public final boolean isValidationOkay() {
            return this.validationOkay;
        }

        public final void setPoorLO2Warning(boolean bl) {
            this.poorLO2Warning = bl;
        }

        public final void setPossEarthDopplerProblemPlusWarning(boolean bl) {
            this.possEarthDopplerProblemPlusWarning = bl;
        }

        public final void setPossEarthDopplerProblemMinusWarning(boolean bl) {
            this.possEarthDopplerProblemMinusWarning = bl;
        }

        public final void setValidationOkay(boolean bl) {
            this.validationOkay = bl;
        }

        public final boolean isCalibrationSetupOkay() {
            return this.calibrationSetupOkay;
        }

        public final void setCalibrationSetupOkay(boolean bl) {
            this.calibrationSetupOkay = bl;
        }

        public boolean isBasebandNotInReceiverBand() {
            return this.basebandNotInReceiverBand;
        }

        public void setBasebandNotInReceiverBand(boolean bl) {
            this.basebandNotInReceiverBand = bl;
        }
    }
}

