/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class TargetValidator
extends AbstractValidator {
    public TargetValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        Target target = (Target)businessObject;
        if (target.getFieldSource() == null) {
            problem = DefaultProblem.createError("Target is not complete, it is missing its field source", "Navigate to the target and attach a field source", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (target.getAbstractInstrumentSpec() == null) {
            problem = DefaultProblem.createError("Target is not complete, it is missing its instrument spec.", "Navigate to the target and attach an instrument spec.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (target.getObservingParametersCount() == 0) {
            problem = DefaultProblem.createError("Target is not complete, it is missing observing parameters", "Navigate to the target and attach at least one observing parameter", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (target.getUsedCount() == 0) {
            problem = DefaultProblem.createWarning("Target is not in an Observing Group - it will not be observed", "If you want it to be observed put the target into an Observing Group", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

