/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.calibration.BandpassCalObs;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.calibration.CalTimeData;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Temperature;
import java.util.Optional;

public class CalTimeDataAdapter
implements CalTimeData {
    private static final CalObsProperties CALPROPERTIES = CalObsProperties.getInstance();
    private static final Latitude OBSLATITUDE = SiteCharacteristics.getInstance().getObsLatitude();
    private final SpectralSpec spectralSpec;
    private final RequestedArray requestedArray;
    private final Frequency fSky;
    private final TargetWithIntent target;

    public CalTimeDataAdapter(SpectralSpec spectralSpec, RequestedArray requestedArray, TargetWithIntent targetWithIntent) {
        this.spectralSpec = spectralSpec;
        this.requestedArray = requestedArray;
        this.target = targetWithIntent;
        Frequency frequency = this.spectralSpec.getRestFrequency();
        this.fSky = FrequencySetup.DOPPLERREFERENCE_TOPO.equals(this.spectralSpec.getFrequencySetup().getDopplerReference()) ? frequency : frequency.dopplerShifted(this.spectralSpec.getSourceVelocity());
    }

    private int getWvIndex() {
        return WaterVaporColumns.wvindexSelector(this.fSky, this.target.getSourceCoordinates().getJ2000SkyCoordinates().getLatitude(), Optional.of(this.spectralSpec.getReceiverBand()));
    }

    @Override
    public Frequency getChannelWidth() {
        switch (this.target.getObsType()) {
            case BANDPASS: {
                SpectralWindowI spectralWindowI = this.getMostStringentWindow();
                CorrFilter corrFilter = spectralWindowI.getCorrConfigMode().getFilter();
                int n = BandpassCalObs.getBinSize(corrFilter);
                return (Frequency)spectralWindowI.getResolution().multiply(n);
            }
        }
        return this.getMostStringentBandwidth();
    }

    private Frequency getMostStringentBandwidth() {
        SpectralWindowI spectralWindowI = this.getMostStringentWindow();
        if (spectralWindowI == null) {
            return null;
        }
        return spectralWindowI.getNominalBandwidth().deepCopy();
    }

    private SpectralWindowI getMostStringentWindow() {
        Frequency frequency = null;
        SpectralWindowI spectralWindowI = null;
        for (BaseBandSpecification baseBandSpecification : this.spectralSpec.getBaseBandSpecification()) {
            for (SpectralWindowI spectralWindowI2 : baseBandSpecification.getSpectralWindow()) {
                Frequency frequency2 = (Frequency)spectralWindowI2.getNominalBandwidth().divide(spectralWindowI2.getNominalNumberOfChannels());
                if (frequency != null && !frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
                frequency = frequency2;
                spectralWindowI = spectralWindowI2;
            }
        }
        return spectralWindowI;
    }

    @Override
    public Temperature getTsys() throws InvalidFrequencyException, SourceNeverVisibleException {
        return ExposureTimeCalculator.getTsys(this.target.getSourceCoordinates(), OBSLATITUDE, this.fSky, this.getWvIndex(), Double.NaN, Optional.of(this.spectralSpec.getReceiverBand()));
    }

    @Override
    public double getEffectiveApertureArea() {
        double d = this.requestedArray.getAntenna().getApertureArea();
        double d2 = this.getApertureEfficiency();
        return d * d2;
    }

    double getApertureEfficiency() {
        return ExposureTimeCalculator.apertureEfficiency(this.fSky.getContentInGHz());
    }

    @Override
    public double getCorrelatorEfficiency() {
        return 0.88;
    }

    @Override
    public double getSNR() {
        switch (this.target.getObsType()) {
            case AMPLITUDE: {
                if ("ALMA_RB_09".equals(this.spectralSpec.getReceiverBand().getName()) || "ALMA_RB_10".equals(this.spectralSpec.getReceiverBand().getName())) {
                    return 100.0;
                }
                return 50.0;
            }
        }
        return 20.0;
    }

    @Override
    public int getnAntennas() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        return almaCapabilities.getNumAntennas(this.requestedArray.getArray(), this.spectralSpec);
    }

    @Override
    public Flux getCalibratorFlux() {
        switch (this.target.getObsType()) {
            case AMPLITUDE: {
                return CALPROPERTIES.getAmplitudeFlux();
            }
            case DELAY: {
                return CALPROPERTIES.getDelayFlux(this.getReceiverBand());
            }
            case PHASE: {
                return CALPROPERTIES.getPhaseFlux(this.getReceiverBand());
            }
            case BANDPASS: {
                return CALPROPERTIES.getBandpassFlux(this.getReceiverBand());
            }
            case POINTING: {
                return CALPROPERTIES.getPointingFlux();
            }
        }
        return CALPROPERTIES.getBandpassFlux(this.getReceiverBand());
    }

    private String getReceiverBand() {
        return this.spectralSpec.getReceiverBand().getName();
    }
}

