/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;

public enum CalType {
    Bandpass(CalibrationTargetParameters.INTENDEDUSE_BANDPASS),
    Phase(CalibrationTargetParameters.INTENDEDUSE_PHASE),
    Amplitude(CalibrationTargetParameters.INTENDEDUSE_AMPLITUDE),
    Pointing(CalibrationTargetParameters.INTENDEDUSE_POINTING),
    Focus(CalibrationTargetParameters.INTENDEDUSE_FOCUS),
    Polarization(CalibrationTargetParameters.INTENDEDUSE_POLARIZATION),
    Atmospheric(CalibrationTargetParameters.INTENDEDUSE_ATMOSPHERIC),
    Delay(CalibrationTargetParameters.INTENDEDUSE_DELAY),
    SidebandRatio(CalibrationTargetParameters.INTENDEDUSE_SIDEBANDRATIO),
    CheckSource(CalibrationTargetParameters.INTENDEDUSE_CHECKSOURCE);

    static String[] knownCalType;
    private String label;

    private CalType(String string2) {
        this.label = string2;
    }

    public static synchronized String[] getKnownCalType() {
        if (knownCalType == null) {
            knownCalType = new String[CalType.values().length];
            int n = 0;
            for (CalType calType : CalType.values()) {
                CalType.knownCalType[n++] = calType.toString();
            }
        }
        return knownCalType;
    }

    public static CalType getCalType(String string) {
        for (CalType calType : CalType.values()) {
            if (!calType.label.equals(string) && !calType.toString().equals(string)) continue;
            return calType;
        }
        return null;
    }
}

