/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.NameResolvable;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.services.calibration.PointingCalObs;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class CalibrationTimeModel
extends Model {
    public static final FieldID documentFid = new FieldID("CalibrationTime.document");
    public static final FieldID srcNameFid = new FieldID("CalibrationTime.srcName");
    public static final FieldID resolveSrcFid = new FieldID("CalibrationTime.resolveSrc");
    public static final FieldID calNameFid = new FieldID("CalibrationTime.calName");
    public static final FieldID resolveCalFid = new FieldID("CalibrationTime.resolveCal");
    public static final FieldID offAngleFid = new FieldID("CalibrationTime.offAngle");
    public static final FieldID mvTimeFid = new FieldID("CalibrationTime.mvTime");
    public static final FieldID antennaFid = new FieldID("CalibrationTime.antenna");
    public static final FieldID apEffFid = new FieldID("CalibrationTime.apEff");
    public static final FieldID nAntennaFid = new FieldID("CalibrationTime.nAntenna");
    public static final FieldID snrFid = new FieldID("CalibrationTime.snr");
    public static final FieldID wvindexFid = new FieldID("CalibrationTime.wvindex");
    public static final FieldID tsysFid = new FieldID("CalibrationTime.tsys");
    public static final FieldID sciResFid = new FieldID("CalibrationTime.sciRes");
    public static final FieldID corrEffFid = new FieldID("CalibrationTime.corrEff");
    public static final FieldID calCalcBtnFid = new FieldID("CalibrationTime.calCalcBtn");
    public static final FieldID calTimeFid = new FieldID("CalibrationTime.calTime");
    public static final FieldID totalTimeFid = new FieldID("CalibrationTime.totalTime");
    public static final FieldID wavelengthFid = new FieldID("CalibrationTime.wavelength");
    public static final FieldID zenithFid = new FieldID("CalibrationTime.zenith");
    public static final FieldID fluctStrFid = new FieldID("CalibrationTime.fluctStr");
    public static final FieldID phFluctFid = new FieldID("CalibrationTime.phFluct");
    public static final FieldID cycCalcBtnFid = new FieldID("CalibrationTime.cycCalcBtn");
    public static final FieldID cycleTimeFid = new FieldID("CalibrationTime.cycleTime");
    private SkyCoordsModel srcCoordsModel = new SkyCoordsModel(null);
    private SkyCoordsModel calCoordsModel = new SkyCoordsModel(null);
    private ValueUnitPairModel frequencyModel = new ValueUnitPairModel();
    private ValueUnitPairModel resolutionModel = new ValueUnitPairModel();
    private ValueUnitPairModel fluxModel = new ValueUnitPairModel();
    private ValueUnitPairModel windModel = new ValueUnitPairModel();
    private NameResolver resolver = new NameResolver();

    public CalibrationTimeModel(CalObs calObs) {
        super(calObs);
        this.registerSubModel(this.srcCoordsModel);
        this.registerSubModel(this.calCoordsModel);
        this.registerSubModel(this.frequencyModel);
        this.registerSubModel(this.resolutionModel);
        this.registerSubModel(this.fluxModel);
        this.registerSubModel(this.windModel);
        this.configureOffAngleUpdater();
        this.configureTsysUpdater();
        this.configureWavelengthUpdater();
        this.configureZenithUpdater();
    }

    private void configureOffAngleUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                CalibrationTimeModel.this.publishOffsetAngle();
            }
        };
        this.srcCoordsModel.rsubscribe(modelChangeSubscriber);
        this.calCoordsModel.rsubscribe(modelChangeSubscriber);
    }

    private void configureTsysUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == CalibrationTimeModel.this && fieldID != wvindexFid) {
                    return;
                }
                CalibrationTimeModel.this.publishTsys();
            }
        };
        this.frequencyModel.rsubscribe(modelChangeSubscriber);
        this.calCoordsModel.rsubscribe(modelChangeSubscriber);
        this.subscribe(modelChangeSubscriber);
    }

    private void configureWavelengthUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                CalibrationTimeModel.this.publishWavelength();
            }
        };
        this.frequencyModel.subscribe(modelChangeSubscriber);
    }

    private void configureZenithUpdater() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                CalibrationTimeModel.this.publishZenith();
            }
        };
        this.calCoordsModel.rsubscribe(modelChangeSubscriber);
    }

    public CalObs getCalObs() {
        return (CalObs)this.document;
    }

    public PhaseCalObs getPhaseCalObs() {
        try {
            return (PhaseCalObs)this.document;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public PointingCalObs getPointingCalObs() {
        try {
            return (PointingCalObs)this.document;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public SkyCoordsModel getSrcCoordsModel() {
        return this.srcCoordsModel;
    }

    public SkyCoordsModel getCalCoordsModel() {
        return this.calCoordsModel;
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public ValueUnitPairModel getResolutionModel() {
        return this.resolutionModel;
    }

    public ValueUnitPairModel getFluxModel() {
        return this.fluxModel;
    }

    public ValueUnitPairModel getWindModel() {
        return this.windModel;
    }

    @Override
    public void publish() {
        this.publish(documentFid, this.document);
        if (this.document == null) {
            return;
        }
        for (Model object2 : this.getSubModels()) {
            object2.publish();
        }
        this.publish(offAngleFid, null);
        this.publish(mvTimeFid, null);
        this.publish(apEffFid, null);
        this.publish(tsysFid, null);
        this.publish(resolveSrcFid, null);
        this.publish(calTimeFid, null);
        this.publish(totalTimeFid, null);
        this.publish(wavelengthFid, null);
        this.publish(zenithFid, null);
        this.publish(cycleTimeFid, null);
        CalObs calObs = this.getCalObs();
        this.publish(srcNameFid, calObs.getSourceName());
        this.publish(calNameFid, calObs.getCalibratorSourceName());
        this.publish(snrFid, calObs.getSNR());
        this.publish(nAntennaFid, calObs.getnAntennas());
        this.publish(apEffFid, calObs.getApertureEfficiency());
        this.publish(wvindexFid, WaterVaporColumns.getWVIndexLabel(calObs.getWvChoice()));
        this.publish(sciResFid, (Object)calObs.getSpectralResolution());
        PhaseCalObs phaseCalObs = this.getPhaseCalObs();
        if (phaseCalObs != null) {
            this.publish(phFluctFid, (Object)phaseCalObs.getPhaseFluctuations());
            this.publish(fluctStrFid, phaseCalObs.getPhaseFluctuationsFunction());
        }
    }

    private void publishOffsetAngle() {
        CalObs calObs = this.getCalObs();
        if (calObs != null) {
            this.publish(offAngleFid, (Object)calObs.getOffsetAngle());
            this.publish(mvTimeFid, calObs.onewayMotionTime());
        }
    }

    private void publishTsys() {
        CalObs calObs = this.getCalObs();
        if (calObs != null) {
            try {
                this.publish(tsysFid, (Object)calObs.getTsys());
            }
            catch (InvalidFrequencyException invalidFrequencyException) {
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                GUIUtilities.warning(null, sourceNeverVisibleException.getMessage());
            }
        }
    }

    private void publishWavelength() {
        CalObs calObs = this.getCalObs();
        if (calObs != null) {
            Frequency frequency = calObs.getCalFrequency();
            this.publish(wavelengthFid, (Object)frequency.getWavelength());
        }
    }

    private void publishZenith() {
        PhaseCalObs phaseCalObs = this.getPhaseCalObs();
        if (phaseCalObs != null) {
            this.publish(zenithFid, (Object)phaseCalObs.getZenithAngle());
        }
    }

    private String formatCalTime(Time time, Time time2) {
        String string;
        if (time.isEqual((AbstractDoubleWithUnit)time2)) {
            time.convertToFriendlyUnit();
            string = TextUtils.format(time, 0, 2);
        } else {
            time.convertToFriendlyUnit();
            time2.convertToUnit(time.getUnit());
            string = TextUtils.format(time, 0, 2) + " ( " + TextUtils.format(time2, 0, 2) + " ) ";
        }
        return string;
    }

    private void publishCalTime() {
        Time time;
        Time time2;
        Time time3 = Time.createTime();
        try {
            time2 = this.getCalObs().rawCalTime();
            time = this.getCalObs().calTime(time2);
            time3.aggregate(time);
            time3.aggregate((Time)this.getCalObs().onewayMotionTime().multiply(2.0));
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            time = time2 = Time.createTime();
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            time = time2 = Time.createTime();
            GUIUtilities.warning(null, sourceNeverVisibleException.getMessage());
        }
        this.publish(calTimeFid, this.formatCalTime(time, time2));
        this.publish(totalTimeFid, time3);
    }

    private void publishCycleTime() {
        Time time = this.getCalObs().rawCycleTime();
        Time time2 = this.getCalObs().cycleTime(time);
        this.publish(cycleTimeFid, this.formatCalTime(time2, time));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == srcNameFid) {
            String string = (String)object;
            this.getCalObs().setSourceName(string);
            return string;
        }
        if (fieldID == calNameFid) {
            String string = (String)object;
            this.getCalObs().setCalibratorSourceName(string);
            return string;
        }
        if (fieldID == resolveSrcFid) {
            this.resolveName(this.getCalObs().getSource());
            this.srcCoordsModel.publish();
            return object;
        }
        if (fieldID == resolveCalFid) {
            this.resolveName(this.getCalObs().getCalibrator());
            this.calCoordsModel.publish();
            return object;
        }
        if (fieldID == wvindexFid) {
            String string = (String)object;
            int n = WaterVaporColumns.wvindexSelector(string);
            this.getCalObs().setWvChoice(n);
            return string;
        }
        if (fieldID == nAntennaFid) {
            int n = Integer.parseInt((String)object);
            this.getCalObs().setnAntennas(n);
            return n;
        }
        if (fieldID == snrFid) {
            double d = Double.parseDouble((String)object);
            this.getCalObs().setSNR(d);
            return d;
        }
        if (fieldID == corrEffFid) {
            double d = Double.parseDouble((String)object);
            this.getCalObs().setCorrelatorEfficiency(d);
            return d;
        }
        if (fieldID == calCalcBtnFid) {
            this.publishCalTime();
            return object;
        }
        if (fieldID == fluctStrFid) {
            double d = Double.parseDouble((String)object);
            PhaseCalObs phaseCalObs = this.getPhaseCalObs();
            if (phaseCalObs != null) {
                phaseCalObs.setAlpha(d);
            }
            return d;
        }
        if (fieldID == phFluctFid) {
            String string = (String)object;
            PhaseCalObs.PhaseFluctuations phaseFluctuations = PhaseCalObs.PhaseFluctuations.getPhaseFluctuations(string);
            PhaseCalObs phaseCalObs = this.getPhaseCalObs();
            if (phaseCalObs != null) {
                phaseCalObs.setPhaseFluctuations(phaseFluctuations);
            }
            return string;
        }
        if (fieldID == cycCalcBtnFid) {
            this.publishCycleTime();
            return object;
        }
        return object;
    }

    private void resolveName(NameResolvable nameResolvable) {
        CalObs calObs = this.getCalObs();
        if (calObs == null) {
            return;
        }
        this.resolver.resolve(nameResolvable);
    }

    @Override
    public void setonlyDocument(Object object) {
        super.setonlyDocument(object);
        if (object != null) {
            CalObs calObs = this.getCalObs();
            this.srcCoordsModel.setonlyDocument(calObs.getSourceCoordinates());
            this.calCoordsModel.setonlyDocument(calObs.getCalibratorCoordinates());
            this.frequencyModel.setonlyDocument((Object)calObs.getCalFrequency());
            this.resolutionModel.setonlyDocument((Object)calObs.getChannelWidth());
            this.fluxModel.setonlyDocument((Object)calObs.getCalibratorFlux());
            try {
                PhaseCalObs phaseCalObs = (PhaseCalObs)calObs;
                this.windModel.setonlyDocument((Object)phaseCalObs.getWindSpeed());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }
}

