/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SBTimeEstimateHelper {
    private Map<CalType, ArrayList<CalibrationStatistics>> calibrationTimeStats = new HashMap<CalType, ArrayList<CalibrationStatistics>>();
    private SchedBlock schedBlock = null;
    private Map<String, ArrayList<CalObs>> groups = new HashMap<String, ArrayList<CalObs>>();

    public SBTimeEstimateHelper(SchedBlock schedBlock) {
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            this.groups.put(observingGroup.getName(), new ArrayList());
        }
        this.schedBlock = schedBlock;
    }

    public void addCalibrationExecutionStats(CalType calType, Time time, Time time2, Long l) {
        if (this.calibrationTimeStats.get((Object)calType) == null) {
            this.calibrationTimeStats.put(calType, new ArrayList());
        }
        List list = this.calibrationTimeStats.get((Object)calType);
        list.add(new CalibrationStatistics(time, time2, l));
    }

    public void addCalibrationToGroup(String string, CalObs calObs) {
        if (!this.groups.containsKey(string)) {
            this.groups.put(string, new ArrayList());
        }
        this.groups.get(string).add(calObs);
    }

    public static GroupType getGroupType(String string) throws UnknownObservingGroupTypeException {
        for (String string2 : GroupType.CALIBRATORS.getObservingGroupLabelPrefixes()) {
            if (!string.startsWith(string2)) continue;
            return GroupType.CALIBRATORS;
        }
        for (String string2 : GroupType.SCIENCE.getObservingGroupLabelPrefixes()) {
            if (!string.startsWith(string2)) continue;
            return GroupType.SCIENCE;
        }
        throw new UnknownObservingGroupTypeException("Unable to deduce the observing group type for " + string);
    }

    public ArrayList<CalObs[]> getCalibrationsForGroup(GroupType groupType) {
        String[] stringArray;
        ArrayList<CalObs[]> arrayList = new ArrayList<CalObs[]>();
        switch (groupType) {
            case CALIBRATORS: {
                stringArray = GroupType.CALIBRATORS.getObservingGroupLabelPrefixes();
                break;
            }
            case SCIENCE: {
                stringArray = GroupType.SCIENCE.getObservingGroupLabelPrefixes();
                break;
            }
            default: {
                throw new RuntimeException("Unknown observing group detected");
            }
        }
        for (String string : this.groups.keySet()) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                arrayList.add(this.groups.get(string).toArray(new CalObs[this.groups.get(string).size()]));
            }
        }
        return arrayList;
    }

    public CalObs[] getCalibrationsForGroup(String string) throws UnknownObservingGroupTypeException {
        if (!this.groups.containsKey(string)) {
            throw new UnknownObservingGroupTypeException("Unknown observing group specified " + string);
        }
        return this.groups.get(string).toArray(new CalObs[this.groups.get(string).size()]);
    }

    public Integer getNumberOfExecutions() {
        return this.schedBlock.getSchedBlockControl().getExecutionCount();
    }

    public Time getTotalRetuningLatency(Time time) {
        return (Time)time.multiply(this.schedBlock.getSpectralSpecCount());
    }

    public String toString() {
        ArrayList<CalObs> arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        for (String object : this.groups.keySet()) {
            stringBuffer.append(object + "\n");
            arrayList = this.groups.get(object);
            for (CalObs calObs : arrayList) {
                try {
                    stringBuffer.append(calObs.getClass().getName() + " " + " Cycle time " + calObs.cycleTime() + " Int. time " + calObs.calTime() + "\n");
                }
                catch (InvalidFrequencyException invalidFrequencyException) {
                    invalidFrequencyException.printStackTrace();
                }
                catch (SourceNeverVisibleException sourceNeverVisibleException) {
                    sourceNeverVisibleException.printStackTrace();
                }
            }
        }
        for (CalType calType : this.calibrationTimeStats.keySet()) {
            arrayList = (ArrayList<CalObs>)this.calibrationTimeStats.get((Object)calType);
            if (arrayList == null) continue;
            for (CalibrationStatistics calibrationStatistics : arrayList) {
                stringBuffer.append("Execution stats for cal " + (Object)((Object)calType) + " Cycle Time : " + calibrationStatistics.getCycleTime() + " Execution count " + calibrationStatistics.getExecutionCount() + " Execution Time " + calibrationStatistics.getExecutionTime() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public CalibrationTimeSummaryRecord getCalibrationStats(CalType calType) {
        Time time = Time.createTime();
        Long l = 0L;
        Time time2 = Time.createTime();
        if (!this.calibrationTimeStats.containsKey((Object)calType)) {
            return null;
        }
        for (CalibrationStatistics calibrationStatistics : this.calibrationTimeStats.get((Object)calType)) {
            time.aggregate(calibrationStatistics.getExecutionTime());
            l = l + calibrationStatistics.getExecutionCount();
            time2 = calibrationStatistics.getCycleTime();
        }
        return new CalibrationTimeSummaryRecord(time, l, time2);
    }

    public SchedBlock getSchedBlock() {
        return this.schedBlock;
    }

    public String[] getObservingGroupNames() {
        return this.groups.keySet().toArray(new String[this.groups.keySet().size()]);
    }

    public static enum GroupType {
        CALIBRATORS(new String[]{"Calibrators", "One time calibrators"}),
        SCIENCE(new String[]{"Science", "Tuning Group"});

        private String[] groupLabelPrefixes;

        private GroupType(String[] stringArray) {
            this.groupLabelPrefixes = stringArray;
        }

        public String[] getObservingGroupLabelPrefixes() {
            return this.groupLabelPrefixes;
        }

        public static GroupType getGroupType(String string) throws UnknownObservingGroupTypeException {
            for (GroupType groupType : GroupType.values()) {
                for (String string2 : groupType.getObservingGroupLabelPrefixes()) {
                    if (!string.startsWith(string2)) continue;
                    return groupType;
                }
            }
            throw new UnknownObservingGroupTypeException("Unable to find group type " + string);
        }
    }

    private class CalibrationStatistics {
        private Time executionTime;
        private Time cycleTime;
        private Long executionCount;

        public CalibrationStatistics(Time time, Time time2, Long l) {
            this.executionTime = time;
            this.cycleTime = time2;
            this.executionCount = l;
        }

        public Time getExecutionTime() {
            return this.executionTime;
        }

        public Time getCycleTime() {
            return this.cycleTime;
        }

        public Long getExecutionCount() {
            return this.executionCount;
        }

        public String toString() {
            return "Scan time " + this.executionTime + " cycle time " + this.cycleTime + " execution count " + this.executionCount;
        }
    }

    public class CalibrationTimeSummaryRecord {
        Time totalExecutionTime = Time.createTime();
        Long totalNumberOfExecutions = 0L;
        Time cycleTime = Time.createTime();

        public CalibrationTimeSummaryRecord(Time time, Long l, Time time2) {
            this.totalExecutionTime = time;
            this.totalNumberOfExecutions = l;
            this.cycleTime = time2;
        }

        public Time getTotalExecutionTime() {
            return this.totalExecutionTime;
        }

        public Long getTotalNumberOfExecutions() {
            return this.totalNumberOfExecutions;
        }

        public Time getCycleTime() {
            return this.cycleTime;
        }
    }

    public static class UnknownObservingGroupTypeException
    extends Exception {
        public UnknownObservingGroupTypeException(String string) {
            super(string);
        }
    }
}

