/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ReceiverTemperature;
import alma.obsprep.util.Convert;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class ExposureTimeCalculator {
    private static CacheAccess<String, Double> sensitivityCache = JCS.getInstance((String)"sensitivityCache");
    private static CacheAccess<String, Double> exposureCache = JCS.getInstance((String)"exposureCache");
    private static final double AMBIENT_TEMP_K = 270.0;
    public static final double UNABLE_TO_PERFORM_ATM_LOOKUP = 1.0E9;
    public static final double LO1_UNDEFINED = Double.NaN;
    public static final boolean INTERFEROMETRY = true;
    public static final boolean SINGLEDISH = false;
    static final double BOLTZMANN = 1380.0000000000002;
    static final double PLANCK = 6.626E-34;
    static final double LIGHTSPEED = 2.99792458E8;
    private static final Log.Logger logger = Log.logger(ExposureTimeCalculator.class);
    public static final double ZENITH_LIMIT = 90.0;
    public static final double SENSITIVITY_EFFICIENCY_FACTOR = 1.11;
    public static final double TIME_FACTOR = 1.2321000000000002;

    public static Time pointSourceExposureTime(Sensitivity sensitivity, Frequency frequency, Frequency frequency2, double d, SkyCoordinates skyCoordinates, int n, Array array, Latitude latitude, int n2, double d2, double d3, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d4 = ExposureTimeCalculator.pointSourceExposureTime(sensitivity.getContentInUnits(Sensitivity.UNIT_JY), frequency.getContentInGHz(), frequency2.getContentInGHz(), d, skyCoordinates, n, array.antenna.getDiameter(), latitude.getContentInUnits(Latitude.UNIT_DEG), n2, array.isInterferometry(), d2, d3, optional);
        return Time.createTimeSec(d4);
    }

    public static double pointSourceExposureTime(double d, double d2, double d3, double d4, SkyCoordinates skyCoordinates, int n, double d5, double d6, int n2, boolean bl, double d7, double d8, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d9;
        double d10;
        Double d11;
        double d12 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        Integer n3 = new Integer(Objects.hash(d, d2, d3, d4, d12, n, ExposureTimeCalculator.isLO1Defined(d7) ? d7 : 0.233, d5, d6, n2, bl, d8));
        if (!Double.isNaN(n3.intValue()) && (d11 = (Double)exposureCache.get((Object)n3.toString())) != null) {
            return d11;
        }
        double d13 = ExposureTimeCalculator.antennaEfficiency(d5, d2, d8);
        double d14 = ExposureTimeCalculator.getTsys(skyCoordinates, d6, d2, n2, d7, optional);
        double d15 = d3 * 1.0E9;
        if (bl) {
            d10 = d13 * d14 / (d4 * ExposureTimeCalculator.instrumentDecor() * ExposureTimeCalculator.atmosphericDecor() * d);
            d9 = d10 * d10 / ((double)(n * (n - 1)) * d15);
        } else {
            d10 = d13 * d14 / (d4 * d);
            d9 = d10 * d10 / ((double)n * d15);
        }
        d9 *= 1.2321000000000002;
        if (logger.finest()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("#Jy=" + d);
            stringBuilder.append(",fGHz=" + d2);
            stringBuilder.append(",wGHz=" + d3);
            stringBuilder.append(",corrEff=" + d4);
            stringBuilder.append(",coords=" + skyCoordinates);
            stringBuilder.append(",nAnt=" + n);
            stringBuilder.append(",diam=" + d5);
            stringBuilder.append(",obsLat=" + d6);
            stringBuilder.append(",wv=" + n2);
            stringBuilder.append(",intrf=" + bl);
            logger.finest("sec=" + String.format("%.3f", d9) + stringBuilder.toString());
        }
        exposureCache.put((Object)n3.toString(), (Object)d9);
        return d9;
    }

    public static Sensitivity pointSourceSensitivity(Time time, Frequency frequency, Frequency frequency2, double d, SkyCoordinates skyCoordinates, int n, Array array, Latitude latitude, int n2, double d2, double d3, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d4 = ExposureTimeCalculator.pointSourceSensitivity(time.getContentInUnits(Time.UNIT_S), frequency.getContentInGHz(), frequency2.getContentInGHz(), d, skyCoordinates, n, array.antenna.getDiameter(), latitude.getContentInUnits(Latitude.UNIT_DEG), n2, array.isInterferometry(), d2, d3, optional);
        return Sensitivity.createSensitivity((double)(d4 * 1000.0), (String)Sensitivity.UNIT_MJY);
    }

    public static double pointSourceSensitivity(double d, double d2, double d3, double d4, SkyCoordinates skyCoordinates, int n, double d5, double d6, int n2, boolean bl, double d7, double d8, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d9;
        Double d10;
        Log.logger(ExposureTimeCalculator.class).finest("For this sensitivity calculation shadowing multiplier is :" + d8);
        double d11 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        Double d12 = new Double(d * 17.0 + d2 * 31.0 + d3 * 7.0 + d4 + d11 * 5.0 + (double)n * d5 * d8 * 37.0 + d6 + (double)n2 + (ExposureTimeCalculator.isLO1Defined(d7) ? d7 : 0.0) + (bl ? 123123.17 : 6512735.31));
        if (!Double.isNaN(d12) && (d10 = (Double)sensitivityCache.get((Object)d12.toString())) != null) {
            return d10;
        }
        double d13 = ExposureTimeCalculator.antennaEfficiency(d5, d2, d8);
        double d14 = ExposureTimeCalculator.getTsys(skyCoordinates, d6, d2, n2, d7, optional);
        double d15 = d3 * 1.0E9;
        if (bl) {
            double d16 = d13 * d14 / (d4 * ExposureTimeCalculator.instrumentDecor() * ExposureTimeCalculator.atmosphericDecor());
            d9 = d16 / Math.sqrt((double)(n * (n - 1)) * d15 * d);
        } else {
            d9 = d13 * d14 / d4 / Math.sqrt((double)n * d15 * d);
        }
        logger.finest("Result before efficiency adjustment =" + d9);
        logger.finest("Efficiency factor (nu_r)            =1.11");
        logger.finest("Result after efficiency adjustment =" + (d9 *= 1.11));
        if (logger.finest()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("#sec=" + d);
            stringBuilder.append(",fGHz=" + d2);
            stringBuilder.append(",wGHz=" + d3);
            stringBuilder.append(",corrEff=" + d4);
            stringBuilder.append(",coords=" + skyCoordinates);
            stringBuilder.append(",nAnt=" + n);
            stringBuilder.append(",diam=" + d5);
            stringBuilder.append(",obsLat=" + d6);
            stringBuilder.append(",wv=" + n2);
            stringBuilder.append(",intrf=" + bl);
            stringBuilder.append(",lo1GHz=" + d7);
            logger.finest("result=" + d9 + stringBuilder.toString());
        }
        sensitivityCache.put((Object)d12.toString(), (Object)d9);
        return d9;
    }

    public static double extendedSourceExposureTime(double d, double d2, double d3, double d4, double d5, SkyCoordinates skyCoordinates, int n, double d6, double d7, int n2, boolean bl, double d8, double d9, Optional<ReceiverBand> optional) throws SourceNeverVisibleException, InvalidFrequencyException {
        double d10;
        if (bl) {
            d10 = ExposureTimeCalculator.toFluxDensity(d, d3, d2);
        } else {
            Antenna antenna = d6 == 7.0 ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
            double d11 = antenna.getBeamSize(Frequency.createFrequencyGHZ(d3)).getContentInUnits(Angle.UNIT_ARCSEC);
            d10 = ExposureTimeCalculator.toFluxDensity(d, d3, d11);
        }
        double d12 = ExposureTimeCalculator.pointSourceExposureTime(d10, d3, d4, d5, skyCoordinates, n, d6, d7, n2, bl, d8, d9, optional);
        return d12;
    }

    public static double extendedSourceBrightnessTemp(double d, double d2, double d3, double d4, double d5, SkyCoordinates skyCoordinates, int n, double d6, double d7, int n2, boolean bl, double d8, double d9, Optional<ReceiverBand> optional) throws SourceNeverVisibleException, InvalidFrequencyException {
        double d10;
        double d11 = ExposureTimeCalculator.pointSourceSensitivity(d, d3, d4, d5, skyCoordinates, n, d6, d7, n2, bl, d8, d9, optional);
        if (bl) {
            d10 = ExposureTimeCalculator.toBrightnessTemp(d11, d3, d2);
        } else {
            Antenna antenna = d6 == 7.0 ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
            double d12 = antenna.getBeamSize(Frequency.createFrequencyGHZ(d3)).getContentInUnits(Angle.UNIT_ARCSEC);
            d10 = ExposureTimeCalculator.toBrightnessTemp(d11, d3, d12);
        }
        return d10;
    }

    public static double toFluxDensity(double d, double d2, double d3) {
        double d4 = 2.99792458E8 / (d2 * 1.0E9);
        double d5 = Math.PI * d3 / 3600.0 / 180.0;
        double d6 = Math.PI * d5 * d5 / 4.0 / Math.log(2.0);
        double d7 = d * d6 * 2.0 * 1380.0000000000002 / (d4 * d4);
        return d7;
    }

    public static double toBrightnessTemp(double d, double d2, double d3) {
        double d4 = 2.99792458E8 / (d2 * 1.0E9);
        double d5 = d * d4 * d4 / 2760.0000000000005;
        double d6 = Math.PI * d3 / 3600.0 / 180.0;
        double d7 = Math.PI * d6 * d6 / 4.0 / Math.log(2.0);
        return d5 /= d7;
    }

    public static double antennaEfficiency(double d, double d2, double d3) {
        double d4 = d / 2.0;
        double d5 = Math.PI * d4 * d4 * d3;
        double d6 = 2760.0000000000005 / d5;
        double d7 = ExposureTimeCalculator.apertureEfficiency(d, d2);
        return d6 / d7;
    }

    public static double apertureEfficiency(double d, double d2) {
        double d3 = d < 10.0 ? 20.0 : 25.0;
        double d4 = 299792.458 / d2;
        double d5 = Math.PI * 4 * d3 / d4;
        double d6 = ExposureTimeCalculator.illuminationEfficiency() * Math.exp(-d5 * d5);
        return d6;
    }

    public static double apertureEfficiency(double d) {
        return ExposureTimeCalculator.apertureEfficiency(12.0, d);
    }

    private static void checkSourceVisible(double d, double d2) throws SourceNeverVisibleException {
        if (Math.abs(d - d2) >= 90.0) {
            String string;
            try {
                string = "Source at declination " + Convert.degToDDMMSS(d) + " is not visible";
                SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
                if (siteCharacteristics != null) {
                    string = string + " to " + siteCharacteristics.getObsName();
                }
                string = string + ".";
            }
            catch (OutOfRangeException outOfRangeException) {
                string = "The source is not visible.";
            }
            catch (InvalidCoordException invalidCoordException) {
                string = "The source is not visible.";
            }
            throw new SourceNeverVisibleException(string);
        }
    }

    public static double getTsys(SkyCoordinates skyCoordinates, double d, double d2, int n, double d3, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d4;
        boolean bl;
        if (optional == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: receiverBand");
        }
        double d5 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        ExposureTimeCalculator.checkSourceVisible(d5, d);
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        assert (atmosphereTable != null);
        double d6 = Math.toRadians(d);
        double d7 = Math.toRadians(d5);
        double d8 = Math.sin(d7);
        double d9 = Math.sin(d6);
        double d10 = Math.cos(d7);
        double d11 = Math.cos(d6);
        double d12 = d8 * d9 + d10 * d11;
        double d13 = 1.0 / d12;
        double d14 = optional.isPresent() ? ReceiverTemperature.getReceiverTemperatureForReceiverBand(optional.get()) : ReceiverTemperature.getReceiverTemperature(d2);
        AtmosphereTable.Data data = atmosphereTable.lookup((float)d2, n);
        if (data == null) {
            return 1.0E9;
        }
        double d15 = data.getTsky();
        double d16 = ExposureTimeCalculator.planck(d2, d15);
        double d17 = data.getTau();
        double d18 = ExposureTimeCalculator.tskyElevationCorrection(d16, d17, skyCoordinates, d);
        double d19 = ExposureTimeCalculator.planck(d2, 270.0);
        double d20 = Math.exp(d17 * d13);
        ReceiverBand receiverBand = optional.orElseGet(() -> ReceiverBand.getReceiverBand(d2));
        boolean bl2 = bl = "DSB".equals(receiverBand.getType()) && ExposureTimeCalculator.isLO1Defined(d3);
        if (bl) {
            double d21 = 2.0 * d3 - d2;
            double d22 = ExposureTimeCalculator.planck(d21, 270.0);
            data = atmosphereTable.lookup((float)d21, n);
            if (data == null) {
                return 1.0E9;
            }
            double d23 = data.getTsky();
            double d24 = ExposureTimeCalculator.planck(d21, d23);
            double d25 = data.getTau();
            double d26 = ExposureTimeCalculator.tskyElevationCorrection(d24, d25, skyCoordinates, d);
            d4 = 2.0 * d14 + (d18 + d26) * 0.95 + (d19 + d22) * 0.050000000000000044;
            d4 = d20 / 0.95 * d4;
            if (logger.finest()) {
                logger.finest(String.format("Tsys: %.7gK RF: %.7g GHz ImageFreq: %.7g GHz LO1 %.7g GHz (DSB case)", d4, d2, d21, d3));
            }
        } else {
            d4 = d14 + d18 * 0.95 + d19 * 0.050000000000000044;
            d4 = d20 / 0.95 * d4;
            d4 *= 1.0 + receiverBand.getSidebandGainRatio();
            if (logger.finest()) {
                logger.finest(String.format("Tsys: %.7gK RF: %.7g GHz LO1 %.7g GHz (SSB case)", d4, d2, d3));
            }
        }
        assert (d4 > 0.0);
        return d4;
    }

    private static boolean isLO1Defined(double d) {
        return !Double.isNaN(d);
    }

    public static double tskyElevationCorrection(double d, double d2, SkyCoordinates skyCoordinates, double d3) {
        double d4 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInUnits(Latitude.UNIT_DEG);
        double d5 = Math.toRadians(Math.abs(d4 - d3));
        double d6 = 1.0 / Math.cos(d5);
        double d7 = d * (1.0 - Math.exp(-d2 * d6)) / (1.0 - Math.exp(-d2));
        return d7;
    }

    public static double planck(double d, double d2) {
        double d3 = d * 1.0E9;
        double d4 = 6.626E-34 * d3 / 1.38E-23;
        double d5 = d4 / (Math.exp(d4 / d2) - 1.0);
        return d5;
    }

    public static Temperature getTsys(SkyCoordinates skyCoordinates, Latitude latitude, Frequency frequency, int n, double d, Optional<ReceiverBand> optional) throws InvalidFrequencyException, SourceNeverVisibleException {
        double d2 = ExposureTimeCalculator.getTsys(skyCoordinates, latitude.getContentInUnits(Latitude.UNIT_DEG), frequency.getContentInGHz(), n, d, optional);
        return Temperature.createTemperature((double)d2, (String)Temperature.UNIT_K);
    }

    private static double illuminationEfficiency() {
        return 0.72;
    }

    public static double mainBeamEfficiency(double d) {
        return 1.0 * ExposureTimeCalculator.apertureEfficiency(d);
    }

    private static double instrumentDecor() {
        return 1.0;
    }

    private static double atmosphericDecor() {
        return 1.0;
    }
}

