/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.DataRateCalculation;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.AmplitudeCalObs;
import alma.obsprep.services.calibration.AtmosphericCalObs;
import alma.obsprep.services.calibration.BandpassCalObs;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.CheckSourceCalObs;
import alma.obsprep.services.calibration.DelayCalObs;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.services.calibration.PointingCalObs;
import alma.obsprep.services.calibration.PolarizationCalObs;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.calibration.SidebandRatioCalObs;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculatorInterface;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.obsparams.AtmosphericTimer;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public class ObservingTimeCalculator
extends ETCTimeCalculator
implements ObservingTimeCalculatorInterface {
    private static final int POINTING_CAL_EXECUTION_TIME_S = 120;
    private static CacheAccess<Integer, ObsUnitSet> sbOutputCache = JCS.getInstance((String)"obsUnitSetCache");
    private static CacheAccess<Integer, Time> scienceGoalTimeCache = JCS.getInstance((String)"scienceGoalTimeCache");
    private static CacheAccess<Integer, Time> requestedTimeCache = JCS.getInstance((String)"requestedTimeCache");
    private boolean noSBGeneration = false;
    private Time timeToExecuteObservingGroupOne = Time.createTimeSec(0.0);
    private static final Time SUBSCAN_LATENCY = Time.createTimeSec(1.5);
    private static final Time SCAN_LATENCY = Time.createTimeSec(10.0);
    private static Time SB_EXEC_OVERHEAD = Time.createTimeSec(300.0);
    private Time overheadTimeCalObs = Time.createTimeSec(0.0);
    private final Map<CalType, TimeSummary> calibrationSummaryTimeEstimates = new LinkedHashMap<CalType, TimeSummary>();
    private Time totalCalibrationSlewTimes = Time.createTime();
    private static final double FWHM = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
    private static final Time ATM_CAL_TIME = CalObsProperties.getInstance().getAtmosphericCalTime();

    public ObservingTimeCalculator(ScienceGoal scienceGoal) {
        this(scienceGoal, Antenna.BEAMSIZE_FACTOR);
        try {
            scienceGoal.setKeyTargetParameters(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public ObservingTimeCalculator(Builder builder) {
        this.scienceGoal = builder.scienceGoal;
        this.obsUnitSet = builder.obsUnitSet;
        this.noSBGeneration = builder.noSBGeneration;
        if (this.noSBGeneration && this.obsUnitSet == null) {
            throw new NullPointerException("obsUnitSet must not be null if no SB generation is requested");
        }
        this.beamsizeFactor = builder.beamsize_factor != 0.0 ? builder.beamsize_factor : Antenna.BEAMSIZE_FACTOR;
        this.sigma = this.beamsizeFactor / FWHM;
    }

    ObservingTimeCalculator(ScienceGoal scienceGoal, double d) {
        this.obsUnitSet = null;
        this.scienceGoal = scienceGoal;
        this.beamsizeFactor = d;
        this.sigma = d / FWHM;
    }

    public int getNumberOfAntennaConfigurations(RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        SchedBlockExpert.RequiredConfigurations requiredConfigurations;
        int n = 1;
        if (RequestedArray.SEVEN_M.equals((Object)requestedArray)) {
            return 1;
        }
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky().deepCopy();
        try {
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(this.scienceGoal, frequency);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        if (requiredConfigurations.has12mCompactConfiguration()) {
            ++n;
        }
        return n;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl) throws InvalidObsProgramParametersException {
        return this.getTimeForSecond12mCompactArray(time, bl, true);
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        try {
            if (this.scienceGoal.getObsProposal().isVLBI()) {
                return Time.createTime();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        double d = 0.0;
        this.getTotalRequestedTime(Array.ARRAY_12M);
        d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, this.scienceGoal);
        if (d == 0.0) {
            return Time.createTimeSec(0.0);
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        boolean bl3 = performanceParameters.getIsSimultaneous12and7();
        if (bl3) {
            return Time.createTimeSec(0.0);
        }
        boolean bl4 = performanceParameters.getNeedsMoreTime();
        if (bl4 && performanceParameters.getDesiredTime() == null) {
            throw new InvalidObsProgramParametersException("Time override time has not been defined but requested");
        }
        Time time2 = bl4 ? performanceParameters.getDesiredTime() : time;
        Time time3 = (Time)time2.multiply(d);
        if (time3.isLessThan((AbstractDoubleWithUnit)this.timeToExecuteObservingGroupOne) && !bl4) {
            if (bl) {
                return bl2 ? this.adjustForFullPolarization(this.timeToExecuteObservingGroupOne) : this.factorInTimeConstrainedObserving(this.adjustForFullPolarization(this.timeToExecuteObservingGroupOne), Array.ARRAY_12M);
            }
            return bl2 ? this.timeToExecuteObservingGroupOne : this.factorInTimeConstrainedObserving(this.timeToExecuteObservingGroupOne, Array.ARRAY_12M);
        }
        if (bl) {
            return bl2 ? this.adjustForFullPolarization(time3) : this.factorInTimeConstrainedObserving(this.adjustForFullPolarization(time3), Array.ARRAY_12M);
        }
        return bl2 ? time3 : this.factorInTimeConstrainedObserving(time3, Array.ARRAY_12M);
    }

    @Override
    public Time getRequestedTimeForAllConfigurations(Array array, boolean bl) throws InvalidObsProgramParametersException {
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        if (array.equals((Object)Array.ARRAY_12M)) {
            Time time = Time.createTimeSec(0.0);
            time = performanceParameters.getNeedsMoreTime() ? performanceParameters.getDesiredTime().deepCopy() : this.getTotalRequestedTime(Array.ARRAY_12M, true, false, bl);
            Time time2 = this.getTimeForSecond12mCompactArray(time, true, true);
            Time time3 = (Time)this.adjustForFullPolarization(time).plus((AbstractDoubleWithUnit)this.adjustForFullPolarization(time2));
            return this.factorInTimeConstrainedObserving(time3, array);
        }
        return this.factorInTimeConstrainedObserving(this.getTotalRequestedTime(array, true, false, bl), array);
    }

    @Override
    public Time adjustForFullPolarization(Time time) {
        Time time2 = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        if (time.isGreaterThan((AbstractDoubleWithUnit)Time.createTimeSec(0.0)) && this.scienceGoal.getSpectralSetupParameters().isFullPolarisation().booleanValue() && time.isLessThan((AbstractDoubleWithUnit)time2)) {
            return time2.deepCopy();
        }
        return time;
    }

    @Override
    public Time getOnTheoreticalOnSourceTimeForArray(Array array) throws InvalidObsProgramParametersException {
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Time time = Time.createTimeSec(0.0);
        time = performanceParameters.getNeedsMoreTime() ? performanceParameters.getDesiredTime().deepCopy() : this.getTotalOnSourceTime(array, true);
        return this.factorInTimeConstrainedObserving(time, array);
    }

    private Time factorInTimeConstrainedObserving(Time time, Array array) {
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Integer n = 1;
        Integer n2 = 0;
        Time time2 = Time.createTimeSec(0.0);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint monitoringConstraint : performanceParameters.getMonitoringConstraint()) {
                    time2.aggregate(this.adjustForFullPolarization(monitoringConstraint.getMonitoringLength()));
                }
                n2 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        if (n > 1) {
            time = (Time)time.multiply(n.intValue());
        } else if (n2 > 0) {
            time = time2;
        }
        return time;
    }

    @Override
    ObsUnitSet generateSBs(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (this.noSBGeneration) {
            if (this.obsUnitSet == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
            }
            return this.obsUnitSet;
        }
        Integer n = Objects.hash(scienceGoal.toXml());
        this.obsUnitSet = (ObsUnitSet)sbOutputCache.get((Object)n);
        if (this.obsUnitSet != null) {
            this.logger.fine("Using cached SBs");
            return this.obsUnitSet;
        }
        this.logger.fine("Cache miss - generating SBs");
        this.logger.fine("Generating SBs for " + System.identityHashCode(this));
        this.obsUnitSet = ObsUnitSet.createObsUnitSet();
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, this.obsUnitSet, false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            this.logger.warning("Unable to create SBs in OTC: " + wizardSBGenerationException.getMessage());
            throw new InvalidObsProgramParametersException(wizardSBGenerationException);
        }
        if (this.logger.fine()) {
            try {
                int n2 = 0;
                this.logger.fine("SBs generated for " + System.identityHashCode(this));
                this.logger.fine("No of sched-blocks created : " + this.obsUnitSet.findSchedBlocks().size());
                for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                    if (!schedBlock.is12mExtendedArraySB()) continue;
                    ++n2;
                    this.logger.fine("12m schedblock executed : " + schedBlock.getSchedBlockControl().getExecutionCount() + " times");
                }
                this.logger.fine("Total number of 12m sched blocks : " + n2 + "\n---------------------");
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        sbOutputCache.put((Object)n, (Object)this.obsUnitSet);
        return this.obsUnitSet;
    }

    @Override
    public Time getOnSourceOverheadsTime(Boolean bl, Array array) throws InvalidObsProgramParametersException {
        Integer n = 0;
        Integer n2 = 0;
        this.generateSBs(this.scienceGoal);
        Time time = Time.createTimeSec(0.0);
        try {
            block8: for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                switch (array) {
                    case ARRAY_7M: {
                        if (schedBlock.isACA7mArraySB()) break;
                        continue block8;
                    }
                    case ARRAY_12M: {
                        if (schedBlock.is12mExtendedArraySB()) break;
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                    }
                }
                n2 = n2 + schedBlock.getSchedBlockControl().getExecutionCount();
                for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                    SBTimeEstimateHelper.GroupType groupType;
                    try {
                        groupType = SBTimeEstimateHelper.getGroupType(observingGroup.getName());
                    }
                    catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                        throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                    }
                    if (!groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) continue;
                    for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                        Target target = orderedTarget.getTarget();
                        for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                            double d = scienceParameters.getSubScanDuration().getContentInDefaultUnits();
                            int n3 = schedBlock.getSchedBlockControl().getExecutionCount();
                            n = n + (int)Math.ceil(((IntTimeSource)((IntTimeSource)scienceParameters.getIntegrationTime().multiply(n3)).divide(d)).getContent());
                            time.aggregate(((IntTimeSource)scienceParameters.getIntegrationTime().multiply(n3)).getTime());
                        }
                    }
                }
                if (!bl.booleanValue()) continue;
                break;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        this.logger.fine("Total subscan latency overhead time : " + SUBSCAN_LATENCY.multiply(n.intValue()));
        this.logger.fine("Total SB exec overheads : " + SB_EXEC_OVERHEAD.multiply(n2.intValue()));
        this.logger.fine("Total onsource overheads : " + ((Time)SUBSCAN_LATENCY.multiply(n.intValue())).plus(SB_EXEC_OVERHEAD.multiply(n2.intValue())));
        this.logger.fine("Total on source time is : " + time);
        return (Time)((Time)SUBSCAN_LATENCY.multiply(n.intValue())).plus(SB_EXEC_OVERHEAD.multiply(n2.intValue()));
    }

    private Time getTotalOnSourceTimeForTarget(Array array, TargetParameters targetParameters, boolean bl) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array has not been defined");
        }
        if (targetParameters == null) {
            throw new NullPointerException("tp has not been defined");
        }
        Array array2 = array.equals((Object)Array.ARRAY_12M) ? array : Array.ARRAY_7M;
        Integer n = targetParameters.getNumberOfPointings(array2);
        Time time = this.getSinglePointOnSourceTime(array, targetParameters, bl);
        Time time2 = (Time)time.multiply(n.intValue());
        return time2;
    }

    public Time getTotalArraySBScienceIntegrationTime(Boolean bl, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        this.generateSBs(this.scienceGoal);
        ObsUnitSet obsUnitSet = this.obsUnitSet;
        if (bl.booleanValue() && !this.noSBGeneration) {
            if (this.obsUnitSet.getObsUnitSetCount() == 0) {
                throw new InvalidObsProgramParametersException("Unable to locate the OUS containing the first visit");
            }
            obsUnitSet = this.obsUnitSet.getObsUnitSet(0).getObsUnitSet(0);
        }
        this.logger.fine("Number of sched-blocks found in OUS : " + obsUnitSet.findSchedBlocks().size());
        block4: for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            switch (array) {
                case ARRAY_7M: {
                    if (schedBlock.isACA7mArraySB()) break;
                    continue block4;
                }
                case ARRAY_12M: {
                    if (schedBlock.is12mExtendedArraySB()) break;
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                }
            }
            for (Target target : schedBlock.getScienceTargets()) {
                time.aggregate((Time)target.getScienceParametersList()[0].getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount(), true));
            }
        }
        return time;
    }

    @Override
    public Time getTotalOnSourceTime(Array array, boolean bl) throws InvalidObsProgramParametersException {
        Object object;
        if (array == null) {
            throw new NullPointerException("array is set to null");
        }
        Time time = Time.createTime();
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            time.aggregate(this.getTotalOnSourceTimeForTarget(array, targetParameters, bl));
        }
        if (this.scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
            try {
                object = this.scienceGoal.getSpectralSetupParameters().getSpectralScan().getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                throw new InvalidObsProgramParametersException("Cannot determine spectral scan solution", unableToFindSolutionException);
            }
            time = (Time)time.multiply(((SpectralScan.SpectralScanTunings)object).getNumberOfTunings().intValue());
        }
        object = AlmaPolicies.getInstance().getMinTimeOnSourcePerSB();
        if (bl && time.isLessThan((AbstractDoubleWithUnit)object)) {
            time = ((Time)object).convertToFriendlyUnit();
        }
        return time;
    }

    @Override
    public Time getTotalRequestedTime(Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: array");
        }
        try {
            boolean bl = this.scienceGoal.isSolarScienceGoal();
            if (!this.scienceGoal.getObsProposal().isVLBI() && !bl) {
                PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
                switch (array) {
                    case ARRAY_12M: {
                        if (!(performanceParameters.getDesiredSensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                    case ARRAY_7M: {
                        if (!(performanceParameters.getDesiredACASensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                    case ARRAY_TP: {
                        if (!(performanceParameters.getDesiredTPSensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                }
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to check that project is a VLBI project ");
            throw new InvalidObsProgramParametersException("Unable to check that project is a VLBI project ");
        }
        return this.getTotalRequestedTime(array, false, false, true);
    }

    @Override
    public Time getOverheadTimes(Boolean bl, EnumSet<Overheads> enumSet, Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        if (enumSet.isEmpty()) {
            return Time.createTimeSec(0.0);
        }
        Array array2 = this.getArrayTypeForTimeEstimate(array, this.scienceGoal);
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time2 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time3 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time4 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        if (enumSet.contains((Object)Overheads.CALIBRATIONEXECTIMES)) {
            try {
                time = this.getCalibrationExecutionTimeStats(bl, array2, targetParameters, false);
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {}
        } else {
            try {
                this.getCalibrationExecutionTimeStats(bl, array2, targetParameters, false);
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                // empty catch block
            }
        }
        if (enumSet.contains((Object)Overheads.ONSOURCEOVERHEADS)) {
            time2 = this.getOnSourceOverheadsTime(bl, array2);
        }
        if (enumSet.contains((Object)Overheads.CALIBRATIONOVERHEADS)) {
            time3 = this.getOverheadTimeForCalObs();
        }
        if (enumSet.contains((Object)Overheads.CALIBRATIONSLEWTIME)) {
            time4 = this.getCalibrationSlewTimes();
        }
        Time time5 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        time5 = (Time)((Time)((Time)((Time)time5.plus((AbstractDoubleWithUnit)time2)).plus((AbstractDoubleWithUnit)time)).plus((AbstractDoubleWithUnit)time3)).plus((AbstractDoubleWithUnit)time4);
        return time5;
    }

    private Time getCalibrationSlewTimes() {
        return this.totalCalibrationSlewTimes;
    }

    @Override
    public Time getTotalRequestedTime(Array array, Boolean bl, Boolean bl2, Boolean bl3) throws InvalidObsProgramParametersException {
        Integer n = Objects.hash(new Object[]{array, bl, bl2, bl3, this.scienceGoal.toXml().hashCode()});
        Time time = (Time)requestedTimeCache.get((Object)n);
        if (time != null && !this.calibrationSummaryTimeEstimates.isEmpty()) {
            return time.deepCopy();
        }
        Time time2 = Time.createTime();
        if (!array.equals((Object)Array.ARRAY_12M) && bl2.booleanValue()) {
            throw new IllegalArgumentException("Cannot request the 12-m compact time if the array is not set to 12-m");
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: performanceParameters");
        }
        boolean bl4 = performanceParameters.getNeedsMoreTime();
        Time time3 = null;
        if (bl4 && (time3 = performanceParameters.getDesiredTime()) == null) {
            throw new InvalidObsProgramParametersException("Override time is not specified when expected");
        }
        boolean bl5 = this.scienceGoal.isStandAloneACA();
        if (Array.ARRAY_7M == array && !bl5) {
            if (!performanceParameters.getUseACA()) {
                return Time.createTime();
            }
            Time time4 = null;
            time4 = bl4 ? time3.deepCopy() : this.getTotalRequestedTime(Array.ARRAY_12M, bl, bl2, bl3);
            assert (time4 != null);
            time2 = (Time)time4.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, this.scienceGoal));
        } else if (Array.ARRAY_TP == array && !bl5) {
            if (!performanceParameters.getUseACA() || !performanceParameters.getUseTP()) {
                return Time.createTime();
            }
            Time time5 = null;
            time5 = bl4 ? time3.deepCopy() : this.getTotalRequestedTime(Array.ARRAY_12M, bl, bl2, bl3);
            assert (time5 != null);
            time2 = (Time)time5.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, this.scienceGoal));
        } else {
            Array array2 = this.getArrayTypeForTimeEstimate(array, this.scienceGoal);
            if (bl5 && array.equals((Object)Array.ARRAY_TP) && !performanceParameters.getUseTP()) {
                return Time.createTime();
            }
            if (!bl4) {
                try {
                    time2 = this.getTotalArraySBScienceIntegrationTime(bl, array2);
                    this.logger.fine("Total time on source from OTC is " + this.getTotalOnSourceTime(array2, true) + " - Total time on source from SB generator is " + time2);
                }
                catch (UnknownEntityException unknownEntityException) {
                    this.logger.warning("Unable to established the TOS for the " + (Object)((Object)array2) + " array");
                }
                EnumSet<Overheads> enumSet = EnumSet.of(Overheads.CALIBRATIONEXECTIMES, Overheads.CALIBRATIONOVERHEADS, Overheads.ONSOURCEOVERHEADS, Overheads.CALIBRATIONSLEWTIME);
                if (!bl3.booleanValue()) {
                    enumSet = EnumSet.of(Overheads.CALIBRATIONEXECTIMES);
                }
                Time time6 = this.getOverheadTimes(bl, enumSet, array2, this.scienceGoal.getSoleTargetParameters());
                time2 = (Time)time2.plus((AbstractDoubleWithUnit)time6);
            } else {
                assert (time3 != null);
                time2 = time3.deepCopy();
            }
            if (bl2.booleanValue()) {
                time2 = this.getTimeForSecond12mCompactArray(time2, true, true);
            }
            assert (time2 != null);
            time2 = this.adjustForFullPolarization(time2);
            if (bl5 && array.equals((Object)Array.ARRAY_TP)) {
                time2 = (Time)time2.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, this.scienceGoal));
            }
        }
        requestedTimeCache.put((Object)n, (Object)time2.deepCopy());
        return time2;
    }

    public Map<CalType, TimeSummary> getCalibrationTimeSummary() {
        return Collections.unmodifiableMap(this.calibrationSummaryTimeEstimates);
    }

    public int getNumRetunings() {
        return this.numRetunings;
    }

    @Override
    public Time getOverheadTimeForCalObs() {
        return this.overheadTimeCalObs;
    }

    List<SBTimeEstimateHelper> getCalibrationObservationListForPrincipalArray(boolean bl, Array array) throws InvalidObsProgramParametersException {
        if (!EnumSet.of(Array.ARRAY_7M, Array.ARRAY_12M).contains((Object)array)) {
            throw new IllegalArgumentException("array can only be for the 12-m and the ACA 7-m");
        }
        PointingCalObs pointingCalObs = this.getPointingCalibration();
        ArrayList<SBTimeEstimateHelper> arrayList = new ArrayList<SBTimeEstimateHelper>(100);
        int n = this.getNoOfTunings();
        this.obsUnitSet = this.generateSBs(this.scienceGoal);
        int n2 = 0;
        try {
            this.logger.fine("Number of sched-blocks : " + this.obsUnitSet.findSchedBlocks().size());
            block12: for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                switch (array) {
                    case ARRAY_7M: {
                        if (schedBlock.isACA7mArraySB()) break;
                        continue block12;
                    }
                    case ARRAY_12M: {
                        if (schedBlock.is12mExtendedArraySB()) break;
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                    }
                }
                ++n2;
                SBTimeEstimateHelper sBTimeEstimateHelper = new SBTimeEstimateHelper(schedBlock);
                int n3 = this.getNoOfPointingCalibrations(sBTimeEstimateHelper, this.scienceGoal, SBTimeEstimateHelper.GroupType.CALIBRATORS, n);
                int n4 = this.getNoOfPointingCalibrations(sBTimeEstimateHelper, this.scienceGoal, SBTimeEstimateHelper.GroupType.SCIENCE, n);
                arrayList.add(sBTimeEstimateHelper);
                for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                    int n5;
                    SBTimeEstimateHelper.GroupType groupType;
                    String string = observingGroup.getName();
                    this.logger.fine("Group > " + string);
                    try {
                        groupType = SBTimeEstimateHelper.getGroupType(string);
                    }
                    catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                        this.logger.warning("Unable to determine the OG type for " + string);
                        throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                    }
                    switch (groupType) {
                        case CALIBRATORS: {
                            for (n5 = 0; n5 < n3; ++n5) {
                                sBTimeEstimateHelper.addCalibrationToGroup(string, pointingCalObs);
                            }
                            break;
                        }
                        case SCIENCE: {
                            for (n5 = 0; n5 < n4; ++n5) {
                                sBTimeEstimateHelper.addCalibrationToGroup(string, pointingCalObs);
                            }
                            break;
                        }
                    }
                    n5 = 0;
                    for (int i = 0; i < n5; ++i) {
                        SidebandRatioCalObs sidebandRatioCalObs = new SidebandRatioCalObs(this.scienceGoal);
                        sidebandRatioCalObs.setExecutedRepeatedly(false);
                        sBTimeEstimateHelper.addCalibrationToGroup(string, sidebandRatioCalObs);
                    }
                    for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                        Target target = orderedTarget.getTarget();
                        this.logger.fine("Target > " + target.briefDescription());
                        if (target.hasAmplitudeCalParameters()) {
                            this.recordCalibration(string, false, sBTimeEstimateHelper, new AmplitudeCalObs(), (CalibratorParameters)((Object)target.getFirstAmplitudeCalParameters().get()));
                            continue;
                        }
                        if (target.hasBandpassCalParameters()) {
                            this.recordCalibration(string, false, sBTimeEstimateHelper, new BandpassCalObs(), (CalibratorParameters)((Object)target.getFirstBandpassCalParameters().get()));
                            continue;
                        }
                        if (target.hasDelayCalParameters()) {
                            this.recordCalibration(string, true, sBTimeEstimateHelper, new DelayCalObs(), (CalibratorParameters)((Object)target.getFirstDelayCalParameters().get()));
                            continue;
                        }
                        if (target.hasCheckSourceCalParameters()) {
                            this.recordCalibration(string, true, sBTimeEstimateHelper, new CheckSourceCalObs(), (CalibratorParameters)((Object)target.getFirstCheckSourceCalParameters().get()));
                            continue;
                        }
                        if (target.hasPhaseCalParameters()) {
                            this.recordCalibration(string, true, sBTimeEstimateHelper, new PhaseCalObs(), (CalibratorParameters)((Object)target.getFirstPhaseCalParameters().get()));
                            continue;
                        }
                        if (!target.hasPolarizationCalParameters()) continue;
                        this.recordCalibration(string, false, sBTimeEstimateHelper, new PolarizationCalObs(), (CalibratorParameters)((Object)target.getFirstPolarizationCalParameters().get()));
                    }
                }
                if (this.scienceGoal.getCalibrationSetupParameters().getSelection().equals(CalibrationSetupParameters.SELECTION_USER)) {
                    int n6;
                    int n7 = this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType.CALIBRATORS);
                    int n8 = this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType.SCIENCE);
                    for (n6 = 0; n6 < n7; ++n6) {
                        sBTimeEstimateHelper.addCalibrationToGroup("Calibrators", pointingCalObs);
                    }
                    for (n6 = 0; n6 < n8; ++n6) {
                        sBTimeEstimateHelper.addCalibrationToGroup("Science", pointingCalObs);
                    }
                }
                if (!bl) continue;
                break;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        this.logger.fine("No of 12m extended SBs processed : " + n2);
        this.logger.finer("Size of generated SB calibs " + arrayList.size());
        return arrayList;
    }

    private PointingCalObs getPointingCalibration() {
        PointingCalObs pointingCalObs = new PointingCalObs(this.scienceGoal);
        pointingCalObs.setSBSuggestedDefaultIntegrationTime(Time.createTimeSec(120.0));
        pointingCalObs.setExecutedRepeatedly(false);
        return pointingCalObs;
    }

    private int getNoOfPointingCalibrationsForUserDefinedStrategy(SBTimeEstimateHelper sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType groupType) {
        EnumSet<CalType> enumSet = EnumSet.of(CalType.Amplitude, CalType.Bandpass, CalType.Phase);
        int n = 0;
        for (CalObs[] calObsArray : sBTimeEstimateHelper.getCalibrationsForGroup(groupType)) {
            for (CalObs calObs : calObsArray) {
                for (CalType calType : enumSet) {
                    if (!calType.equals((Object)calObs.getCalType())) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    private void recordCalibration(String string, Boolean bl, SBTimeEstimateHelper sBTimeEstimateHelper, CalObs calObs, CalibratorParameters calibratorParameters) {
        calObs.setExecutedRepeatedly(bl);
        calObs.setSBSuggestedDefaultIntegrationTime(calibratorParameters.getDefaultIntegrationTime());
        calObs.setSBSuggestedCycleTime(calibratorParameters.getCycleTime());
        sBTimeEstimateHelper.addCalibrationToGroup(string, calObs);
    }

    @Override
    public Time getCalibrationExecutionTimeStats(Boolean bl, Array array, TargetParameters targetParameters, boolean bl2) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        assert (this.scienceGoal != null);
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        boolean bl3 = this.scienceGoal.getCalibrationSetupParameters().isSystemDefinedCalibration();
        boolean bl4 = !bl2 && this.isSBToBeExecutedUsingSessions();
        Time time = Time.createTime();
        List<TimeOnSourceData> list = this.getSBOnSourceData();
        this.numRetunings = this.getNoOfTunings();
        this.calibrationSummaryTimeEstimates.clear();
        this.overheadTimeCalObs.setContent(0.0);
        this.totalCalibrationSlewTimes.setContent(0.0);
        this.timeToExecuteObservingGroupOne.setContent(0.0);
        Optional<Time> optional = Optional.empty();
        Time time2 = Time.createTimeSec(0.0);
        long l = 0L;
        boolean bl5 = true;
        for (SBTimeEstimateHelper object2 : this.getCalibrationObservationListForPrincipalArray(bl, array)) {
            long atmCalList = 1L;
            TimeOnSourceData timeOnSourceData = null;
            for (TimeOnSourceData timeSummary : list) {
                if (!timeSummary.getSchedBlock().getEntityID().equals(object2.getSchedBlock().getEntityID())) continue;
                timeOnSourceData = timeSummary;
                atmCalList = timeSummary.getNoOfSBExecutions().longValue();
                break;
            }
            this.logger.fine("No of SB execs (adjusted) " + atmCalList + " for object " + System.identityHashCode(this));
            for (String string : object2.getObservingGroupNames()) {
                CalObs[] calObsArray;
                SBTimeEstimateHelper.GroupType groupType;
                try {
                    groupType = SBTimeEstimateHelper.getGroupType(string);
                    calObsArray = object2.getCalibrationsForGroup(string);
                }
                catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                    throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                }
                for (CalObs calObs : calObsArray) {
                    Time invalidFrequencyException;
                    Time time3;
                    if (calObs == null) continue;
                    Time time4 = (Time)calObs.onewayMotionTime().multiply(2.0);
                    calObs.setSourceCoordinates(skyCoordinates);
                    try {
                        calObs.setWvChoice(-1);
                        time3 = calObs.calTime();
                    }
                    catch (InvalidFrequencyException sourceNeverVisibleException) {
                        throw new InvalidObsProgramParametersException(sourceNeverVisibleException);
                    }
                    catch (SourceNeverVisibleException sourceNeverVisibleException) {
                        throw new InvalidObsProgramParametersException(sourceNeverVisibleException);
                    }
                    assert (time3 != null);
                    CalType invalidFrequencyException2 = calObs.getCalType();
                    Long l2 = 0L;
                    Time time5 = calObs.cycleTime().deepCopy();
                    if (calObs.executesRepeatedly()) {
                        invalidFrequencyException = AlmaPolicies.getInstance().getNominalSbLength();
                        if (time5.isGreaterThan((AbstractDoubleWithUnit)invalidFrequencyException)) {
                            l2 = bl2 ? Long.valueOf(1L) : Long.valueOf(atmCalList);
                        } else {
                            int n;
                            l2 = 1L;
                            if (timeOnSourceData == null) {
                                this.logger.warning("Could not match SB when determining repeating calibrations.");
                                return Time.createTimeSec(0.0);
                            }
                            try {
                                n = (int)timeOnSourceData.getTimeOnSourceForObservingGroup(string).getSecs();
                            }
                            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                            }
                            l2 = (long)Math.ceil((double)n / time5.getSecs());
                            if (calObs instanceof PhaseCalObs && l2 == 1L) {
                                l2 = 2L;
                            }
                            if (!bl2) {
                                l2 = l2 * atmCalList;
                            }
                            this.logger.fine("onSourceTimeSecsPerOG - " + n + " Calib. type- " + (Object)((Object)invalidFrequencyException2) + " Cycle time - " + time5 + " Calib Execs - " + l2);
                        }
                    } else {
                        l2 = bl2 ? 1L : atmCalList;
                    }
                    if (!(calObs instanceof PhaseCalObs) && !(invalidFrequencyException = calObs.atmCalTime(object2.getSchedBlock())).isZero()) {
                        if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.CALIBRATORS) && bl5) {
                            this.timeToExecuteObservingGroupOne.aggregate((Time)invalidFrequencyException.multiply(l2.longValue()));
                        }
                        time2.aggregate((Time)invalidFrequencyException.multiply(l2.longValue()));
                        l += l2.longValue();
                    }
                    if (calObs instanceof PhaseCalObs) {
                        try {
                            optional = Optional.of(calObs.calTime());
                        }
                        catch (InvalidFrequencyException invalidFrequencyException3) {
                            throw new InvalidObsProgramParametersException(invalidFrequencyException3);
                        }
                    }
                    object2.addCalibrationExecutionStats(invalidFrequencyException2, time3, time5, l2);
                    invalidFrequencyException = (Time)time3.multiply(l2.longValue());
                    this.totalCalibrationSlewTimes.aggregate((Time)time4.multiply(l2.longValue()));
                    if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.CALIBRATORS)) {
                        this.logger.fine("Group one " + (Object)((Object)invalidFrequencyException2) + " requires a total scan time of " + invalidFrequencyException);
                        if (bl5) {
                            this.timeToExecuteObservingGroupOne.aggregate(invalidFrequencyException);
                            this.timeToExecuteObservingGroupOne.aggregate((Time)SCAN_LATENCY.multiply(l2.longValue()));
                            this.timeToExecuteObservingGroupOne.aggregate((Time)calObs.onewayMotionTime().multiply(l2.longValue()));
                        }
                        this.overheadTimeCalObs.aggregate((Time)SCAN_LATENCY.multiply(l2.longValue()));
                        this.logger.fine("Group one : calibration - " + (Object)((Object)invalidFrequencyException2) + " no of calibration executions - " + l2 + " intrasource overheads : " + SCAN_LATENCY.multiply(l2.longValue()));
                    } else {
                        this.overheadTimeCalObs.aggregate((Time)((Time)SCAN_LATENCY.multiply(l2.longValue())).multiply(2.0));
                        this.logger.fine("Group two : calibration " + (Object)((Object)invalidFrequencyException2) + " no of calibration executions " + l2 + " scan latency overheads : " + SCAN_LATENCY.multiply(l2.longValue()));
                    }
                    time.aggregate(invalidFrequencyException);
                    if (!this.calibrationSummaryTimeEstimates.containsKey((Object)calObs.getCalType())) {
                        this.calibrationSummaryTimeEstimates.put(invalidFrequencyException2, new TimeSummary(invalidFrequencyException2));
                    }
                    TimeSummary n = this.calibrationSummaryTimeEstimates.get((Object)invalidFrequencyException2);
                    n.setStandardSystemCalibrationStrategyUsed(bl3);
                    n.addNumExec(l2);
                    n.addTime(invalidFrequencyException);
                }
            }
            if (bl4 && atmCalList > 1L) {
                time = (Time)time.minus(((Time)this.timeToExecuteObservingGroupOne.divide(atmCalList)).multiply(atmCalList - 1L));
            }
            bl5 = false;
        }
        Log.logger(ObservingTimeCalculator.class).fine("totalCalculatedCalibrationTime (no atm cals) : " + time);
        Object object3 = new AtmosphericCalObs().getCalType();
        AtmCalList atmCalList = this.getNumberOfAtmCalsForScienceTargets(bl, bl2);
        AtmCalList atmCalList2 = this.getNumberOfAtmCalsForPhaseCalibrations(bl, bl2);
        long l3 = 0L;
        Time time6 = Time.createTimeSec(0.0);
        l3 = atmCalList2.getTotalNumberOfAtmCals() + atmCalList.getTotalNumberOfAtmCals() + l;
        time6.aggregate((Time)atmCalList.getTotalAmountOfTimeForAmtCals().plus((AbstractDoubleWithUnit)time2));
        time6.aggregate(atmCalList2.getTotalAmountOfTimeForAmtCals());
        if (l3 > 0L) {
            time.aggregate(time6);
            if (!this.calibrationSummaryTimeEstimates.containsKey(object3)) {
                this.calibrationSummaryTimeEstimates.put((CalType)((Object)object3), new TimeSummary((CalType)((Object)object3)));
            }
            TimeSummary timeSummary = this.calibrationSummaryTimeEstimates.get(object3);
            timeSummary.addNumExec(l3);
            timeSummary.addTime(time6);
            Log.logger(ObservingTimeCalculator.class).fine(String.format("Number of atmcals is %d and will take %s to execute", l3, time6));
        }
        this.logger.fine("Total amount of time required for the group one calibrations " + this.timeToExecuteObservingGroupOne);
        this.timeToExecuteObservingGroupOne = (Time)((Time)this.timeToExecuteObservingGroupOne.plus((AbstractDoubleWithUnit)Time.createTime((double)5.0, (String)Time.UNIT_MIN))).plus(optional.orElse(Time.createTimeSec(0.0)).multiply(2.0));
        Log.logger(ObservingTimeCalculator.class).fine("totalCalculatedCalibrationTime (with atm cals) : " + time);
        return time;
    }

    @Override
    public boolean isSBToBeExecutedUsingSessions() {
        if (this.scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument scienceGoal cannot be null");
        }
        return this.scienceGoal.getSpectralSetupParameters().isFullPolarisation();
    }

    public int getWaterVapourContentUsed() {
        return this.scienceGoal.getRecommendedWVCIndex();
    }

    @Override
    public StorageVolume getDataVolume(Array array) throws InvalidObsProgramParametersException {
        Object object;
        Object object2;
        DataRate dataRate;
        if (array == null) {
            throw new NullPointerException("Illegal argument - the argument array cannot be null");
        }
        try {
            dataRate = this.getAverageDataRate(array);
        }
        catch (UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            throw new InvalidObsProgramParametersException(unableToDetermineInstantaneousDataRateException);
        }
        double d = 1.0;
        int n = 0;
        double d2 = 0.0;
        switch (array) {
            case ARRAY_12M: {
                d = 1.0;
                object2 = Configuration.getConfigurationsToBeScheduled(this.scienceGoal);
                assert (object2 != null);
                n = ((ScienceGoalConfigurations)object2).getCompactConfigurations().size();
                d2 = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, this.scienceGoal) * (double)n;
                break;
            }
            case ARRAY_7M: {
                d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, this.scienceGoal);
                break;
            }
            case ARRAY_TP: {
                d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, this.scienceGoal);
                break;
            }
            default: {
                throw new RuntimeException("Unknown array requested");
            }
        }
        object2 = Time.createTime();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        if (performanceParameters.getNeedsMoreTime()) {
            ((Time)object2).aggregate(performanceParameters.getDesiredTime().deepCopy());
        } else {
            object = this.scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
            ((Time)object2).aggregate(this.getTotalRequestedTime((Array)((Object)object), true, false, false));
        }
        if (Array.ARRAY_12M.equals((Object)array)) {
            ((Time)object2).aggregate((Time)object2.multiply(d2));
        } else {
            object2 = (Time)object2.multiply(d);
        }
        object = dataRate.getStorageVolume((Time)object2);
        Log.logger(ObservingTimeCalculator.class).fine(String.format("Estimated storage volume %s (based over %s using a data rate of %s)", new Object[]{object, object2, dataRate}));
        return object;
    }

    @Override
    public DataRate getPeakDataRate(Array array, boolean bl) throws UnableToDetermineInstantaneousDataRateException {
        Object object;
        Time time;
        DataRateCalculation dataRateCalculation = new DataRateCalculation(array);
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        String string = spectralSetupParameters.getType();
        boolean bl2 = spectralSetupParameters.isPureTDM();
        try {
            time = this.getCorrelatorIntegrationDuration(array);
        }
        catch (UnableToDetermineCorrelatorIntegrationTimeException unableToDetermineCorrelatorIntegrationTimeException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to determine correlator integration time : " + unableToDetermineCorrelatorIntegrationTimeException.getMessage());
            return DataRate.createDataRate();
        }
        boolean bl3 = false;
        if (spectralSetupParameters.isWalshSwitching()) {
            try {
                object = Configuration.getConfigurationsToBeScheduled(this.scienceGoal).getConfigurationRequiringMostTime(RequestedArray.TWELVE_M);
                bl3 = bl && ((ConfigurationSet)object).getTM1Configuration().map(configuration -> configuration.isLongBaselineConfiguration()).orElse(false) != false;
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                // empty catch block
            }
        }
        if (spectralSetupParameters.isSpectralScan()) {
            StorageVolume storageVolume;
            object = null;
            SpectralScan spectralScan = spectralSetupParameters.getAbstractScienceSpectralWindowSpectralScan()[0];
            CorrConfigMode corrConfigMode = spectralScan.getCorrConfigMode();
            if (corrConfigMode == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                throw new RuntimeException("Unable to determine the correlator mode");
            }
            try {
                object = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return DataRate.createDataRate();
            }
            if (object == null || ((SpectralScan.SpectralScanTunings)object).getNumberOfTunings() == 0) {
                return DataRate.createDataRate();
            }
            try {
                storageVolume = dataRateCalculation.getSpectralWindowDataVolumePerInteg(corrConfigMode, spectralScan.getAdvancedWindowSetup(), spectralSetupParameters);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                throw new UnableToDetermineInstantaneousDataRateException(receiverNotFoundException);
            }
            int n = 0;
            try {
                n = ((SpectralScan.SpectralScanTunings)object).getNumberOfSPWs();
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                return DataRate.createDataRate();
            }
            StorageVolume storageVolume2 = storageVolume.times(n);
            this.logger.fine("Data rate = " + storageVolume2.divide(time).getContentInUnits(DataRate.UNIT_MB_S));
            Time time2 = time;
            if (bl3) {
                time2 = bl2 ? Time.createTimeSec(2.048) : Time.createTimeSec(4.096);
            }
            return storageVolume2.divide(time2);
        }
        if (string.equals(SpectralSetupParameters.TYPE_FULL) || string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            object = StorageVolume.createStorageVolume();
            Time time3 = time;
            if (bl3) {
                time3 = bl2 ? Time.createTimeSec(2.048) : Time.createTimeSec(4.096);
            }
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                StorageVolume storageVolume;
                try {
                    storageVolume = dataRateCalculation.getSpectralWindowDataVolumePerInteg(scienceSpectralWindow.getCorrConfigMode(), scienceSpectralWindow.getAdvancedWindowSetup(), spectralSetupParameters);
                }
                catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                    throw new UnableToDetermineInstantaneousDataRateException(receiverNotFoundException);
                }
                ((StorageVolume)((Object)object)).aggregate(storageVolume);
            }
            return ((StorageVolume)((Object)object)).divide(time3);
        }
        throw new RuntimeException("Unexpected SpectralSetupType : " + string);
    }

    private Time getCorrelatorIntegrationDuration(Array array) throws UnableToDetermineCorrelatorIntegrationTimeException {
        try {
            for (SchedBlock schedBlock : this.generateSBs(this.scienceGoal).findSchedBlocks()) {
                if (!(array.equals((Object)Array.ARRAY_TP) && schedBlock.isTotalPowerScienceSB() || array.equals((Object)Array.ARRAY_12M) && schedBlock.is12mExtendedArraySB()) && (!array.equals((Object)Array.ARRAY_7M) || !schedBlock.isACA7mArraySB())) continue;
                for (Target target : schedBlock.getTarget()) {
                    if (!target.hasScienceParameters()) continue;
                    AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target.getSpectralSpec().getAbstractCorrelatorConfiguration();
                    return abstractCorrelatorConfiguration.getIntegrationDuration().deepCopy();
                }
            }
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new UnableToDetermineCorrelatorIntegrationTimeException("Unable to find SBs for array:" + (Object)((Object)array));
        }
        throw new UnableToDetermineCorrelatorIntegrationTimeException("Unable to find SBs for the array " + (Object)((Object)array));
    }

    @Override
    public Time getTotalTimeForScienceGoal(Boolean bl) throws UnableToCalculateTimeEstimateException {
        return this.getTotalTimeForScienceGoal(false, bl, false, true);
    }

    @Override
    public Time getTotalTimeForScienceGoal(Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) throws UnableToCalculateTimeEstimateException {
        Integer n = Objects.hash(bl, bl2, bl3, bl4, this.scienceGoal.toXml().hashCode());
        Time time = (Time)scienceGoalTimeCache.get((Object)n);
        if (time != null) {
            return time.deepCopy();
        }
        Time time2 = Time.createTimeSec(0.0);
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0 && !spectralSetupParameters.isSpectralScan()) {
            throw new UnableToCalculateTimeEstimateException("No Spectral Window/Element is set.");
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(performanceParameters.getDesiredSensitivityFrequencyMeasure()) && performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContent() <= 0.0) {
            throw new UnableToCalculateTimeEstimateException("Positive \"Frequency Width\" value must be set in choosing \"User\" type as \"Bandwidth used for Sensitivity\".");
        }
        Time time3 = Time.createTime();
        boolean bl5 = this.scienceGoal.isStandAloneACA();
        if (!bl5) {
            try {
                time3 = performanceParameters.getNeedsMoreTime() ? performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit() : this.getTotalRequestedTime(Array.ARRAY_12M, true, false, true).convertToFriendlyUnit();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
            }
        }
        Time time4 = Time.createTime();
        Time time5 = Time.createTime();
        boolean bl6 = performanceParameters.gettrueUseACA();
        boolean bl7 = performanceParameters.gettrueUseTP();
        if (bl5) {
            bl = false;
        }
        if (!bl.booleanValue() && Boolean.TRUE.equals(bl6)) {
            try {
                time4 = this.getTotalRequestedTime(Array.ARRAY_7M, true, false, true).convertToFriendlyUnit().convertToFriendlyUnit();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
            }
            if (Boolean.TRUE.equals(bl7)) {
                try {
                    time5 = this.getTotalRequestedTime(Array.ARRAY_TP, true, false, true).convertToFriendlyUnit();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
                }
            }
        }
        if (bl4.booleanValue()) {
            time2.aggregate(this.adjustForFullPolarization(time3));
        } else {
            time2.aggregate(time3);
        }
        try {
            Time time6;
            Time time7 = time6 = time4.isGreaterThan((AbstractDoubleWithUnit)time5) ? time4 : time5;
            if (bl3.booleanValue()) {
                time2.aggregate(time6);
            } else if (bl5) {
                time2.aggregate(time6);
            } else {
                time2.aggregate((Time)this.getTimeForSecond12mCompactArray(time3, bl4, true).plus((AbstractDoubleWithUnit)time6));
            }
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
        }
        if (!bl2.booleanValue()) {
            time2 = this.factorInTimeConstrainedObserving(time2, bl5 ? Array.ARRAY_7M : Array.ARRAY_12M);
        }
        scienceGoalTimeCache.put((Object)n, (Object)time2);
        return time2;
    }

    private List<TimeOnSourceData> getSBOnSourceData() throws InvalidObsProgramParametersException {
        ArrayList<TimeOnSourceData> arrayList = new ArrayList<TimeOnSourceData>(30);
        this.generateSBs(this.scienceGoal);
        boolean bl = this.scienceGoal.isStandAloneACA();
        try {
            for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                HashMap<String, Time> hashMap = new HashMap<String, Time>(50);
                Time time = Time.createTimeSec(0.0);
                Time time2 = Time.createTimeSec(0.0);
                int n = schedBlock.getSchedBlockControl().getExecutionCount();
                this.logger.fine("Number of executions of this SB is " + n);
                if (bl ? !schedBlock.isACA7mArraySB() : !schedBlock.is12mExtendedArraySB()) continue;
                for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                    SBTimeEstimateHelper.GroupType groupType;
                    Time time3 = Time.createTimeSec(0.0);
                    try {
                        groupType = SBTimeEstimateHelper.GroupType.getGroupType(observingGroup.getName());
                    }
                    catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                        throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                    }
                    if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) {
                        time2.setContent(0.0);
                        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                            orderedTarget.getTarget().getFirstScienceParameters().ifPresent(scienceParameters -> {
                                Time time3 = scienceParameters.getIntegrationTime().getTime();
                                time2.aggregate(time3);
                                time3.aggregate(time3);
                            });
                        }
                    }
                    hashMap.put(observingGroup.getName(), time3);
                }
                TimeOnSourceData timeOnSourceData = new TimeOnSourceData(schedBlock, n);
                for (String string : hashMap.keySet()) {
                    this.logger.fine("TOS for OG " + string + " is " + hashMap.get(string));
                    timeOnSourceData.addTimeOnSourceForObservingGroup(string, (Time)hashMap.get(string));
                }
                arrayList.add(timeOnSourceData);
                this.logger.fine("Total on-source time recorded for SB (including intrascan latencies and " + n + " executions) " + schedBlock.getEntityID() + " is " + time);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        return arrayList;
    }

    private static TimeOnSourceData getSBOnSourceData(SchedBlock schedBlock) throws InvalidObsProgramParametersException {
        HashMap<String, Time> hashMap = new HashMap<String, Time>(40);
        Time time = Time.createTimeSec(0.0);
        Integer n = schedBlock.getSchedBlockControl().getExecutionCount();
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            SBTimeEstimateHelper.GroupType groupType;
            Time time2 = Time.createTimeSec(0.0);
            try {
                groupType = SBTimeEstimateHelper.GroupType.getGroupType(observingGroup.getName());
            }
            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
            }
            if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) {
                time.setContent(0.0);
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    Target target = orderedTarget.getTarget();
                    target.getFirstScienceParameters().ifPresent(scienceParameters -> {
                        Time time3 = scienceParameters.getIntegrationTime().getTime();
                        time.aggregate(time3);
                        time2.aggregate(time3);
                    });
                }
            }
            hashMap.put(observingGroup.getName(), time2);
        }
        TimeOnSourceData timeOnSourceData = new TimeOnSourceData(schedBlock, n);
        for (String string : hashMap.keySet()) {
            timeOnSourceData.addTimeOnSourceForObservingGroup(string, (Time)hashMap.get(string));
        }
        return timeOnSourceData;
    }

    private AtmCalList getNumberOfAtmCalsForPhaseCalibrations(boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        AtmCalList atmCalList = new AtmCalList();
        this.generateSBs(this.scienceGoal);
        boolean bl3 = this.scienceGoal.isStandAloneACA();
        try {
            for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                AtmCalsForSB atmCalsForSB = new AtmCalsForSB();
                if (!bl3 ? !schedBlock.is12mExtendedArraySB() : !schedBlock.isACA7mArraySB()) continue;
                if (schedBlock.getScienceTargets().size() == 1) {
                    if (!bl) continue;
                    return atmCalList;
                }
                List list = Arrays.stream(schedBlock.getTarget()).filter(target -> target.hasPhaseCalParameters()).collect(Collectors.toList());
                if (list.size() == 0) continue;
                Time time = ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution();
                Target target2 = (Target)list.get(0);
                PhaseCalParameters phaseCalParameters = target2.getPhaseCalParametersList()[0];
                assert (phaseCalParameters != null);
                long l = (long)AtmosphericTimer.getCycleTime(target2.getSpectralSpec().getReceiverBand()).getSecs();
                Log.logger(ObservingTimeCalculator.class).fine("Atm cal cycleTime used: " + l + " for " + target2.getSpectralSpec().getReceiverBand());
                long l2 = (long)phaseCalParameters.getCycleTime().getSecs();
                long l3 = 0L;
                long l4 = 0L;
                int n = 0;
                while ((double)n < time.getSecs()) {
                    if ((l3 -= l2) <= 0L) {
                        ++l4;
                        l3 = l;
                    }
                    n = (int)((long)n + l2);
                }
                atmCalsForSB.add(l4);
                atmCalsForSB.setSbExecutionCount(bl2 ? 1 : schedBlock.getSchedBlockControl().getExecutionCount());
                atmCalList.add(atmCalsForSB);
            }
            if (bl) {
                return atmCalList;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to determine the number of phase cal atm cals.");
        }
        return atmCalList;
    }

    private AtmCalList getNumberOfAtmCalsForScienceTargets(boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        AtmCalList atmCalList = new AtmCalList();
        this.generateSBs(this.scienceGoal);
        boolean bl3 = this.scienceGoal.isStandAloneACA();
        try {
            for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                if (!bl3 ? !schedBlock.is12mExtendedArraySB() : !schedBlock.isACA7mArraySB()) continue;
                List<Target> list = schedBlock.getScienceTargets();
                if (list == null || list.size() == 0) {
                    Log.logger(ObservingTimeCalculator.class).warning("No science targets found in SB");
                    continue;
                }
                if (list.size() > 1) {
                    if (!bl) continue;
                    return atmCalList;
                }
                ObservingTimeCalculator.getAtmCalsForScienceTargetsForSB(bl2, atmCalList, schedBlock);
                if (!bl) continue;
                return atmCalList;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to determine the number of atm cals.");
        }
        return atmCalList;
    }

    public static void getAtmCalsForScienceTargetsForSB(boolean bl, AtmCalList atmCalList, SchedBlock schedBlock) {
        AtmCalsForSB atmCalsForSB = new AtmCalsForSB();
        List<Target> list = schedBlock.getScienceTargets();
        for (Target target : list) {
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            assert (scienceParameters != null);
            Time time = AtmosphericTimer.getCycleTime(target.getSpectralSpec().getReceiverBand());
            Log.logger(ObservingTimeCalculator.class).fine("Atm cal cycleTime used: " + time + " for " + target.getSpectralSpec().getReceiverBand());
            assert (time != null && !time.isZero());
            long l = (long)Math.ceil(scienceParameters.getIntegrationTime().getSecs() / time.getSecs());
            atmCalsForSB.add(l);
            atmCalsForSB.setSbExecutionCount(bl ? 1 : schedBlock.getSchedBlockControl().getExecutionCount());
        }
        atmCalList.add(atmCalsForSB);
    }

    private static Time getCalibrationTimesEstimateFromSB(SchedBlock schedBlock, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        int n = 0;
        int n2 = 0;
        Time time = Time.createTime();
        TimeOnSourceData timeOnSourceData = ObservingTimeCalculator.getSBOnSourceData(schedBlock);
        Time time2 = Time.createTimeSec(0.0);
        try {
            enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal, schedBlock);
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        double d = SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet);
        Time time3 = (Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(d);
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            Time time4 = timeOnSourceData.getTimeOnSourceForObservingGroup(observingGroup.getName());
            String string = null;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target = orderedTarget.getTarget();
                ObservingParameters observingParameters = target.getObservingParameters()[0];
                if (observingParameters.isScienceParameters()) continue;
                CalibratorParameters calibratorParameters = (CalibratorParameters)((Object)observingParameters);
                Time time5 = calibratorParameters.getDefaultIntegrationTime().deepCopy();
                Time time6 = calibratorParameters.getCycleTime();
                if (observingParameters.isPointingCalParameters()) {
                    time5 = Time.createTimeSec(120.0);
                }
                int n3 = 1;
                if (!observingParameters.isPhaseCalParameters()) {
                    time5.aggregate(ATM_CAL_TIME);
                }
                if (observingGroup.getIndex() == ObservingGroupManager.ObservingGroupType.CALIBRATOR.getNominalObservingGroup().intValue()) {
                    if (string == null || !string.equals(target.getSpectralSpec().getEntityPartId())) {
                        ++n2;
                        string = target.getSpectralSpec().getEntityPartId();
                    }
                } else {
                    if (time6.isLessThan((AbstractDoubleWithUnit)time3)) {
                        n3 = (int)Math.ceil(time4.getSecs() / time6.getSecs());
                    }
                    n2 += n3;
                }
                if (target.hasPhaseCalParameters() && n3 == 1) {
                    n3 = 2;
                    ++n2;
                }
                time.aggregate((Time)time5.multiply(n3));
            }
        }
        boolean bl = schedBlock.getObservingGroupCount() > 2 || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN);
        int n4 = bl ? schedBlock.getObservingGroupCount() * 3 : 3;
        time.aggregate((Time)Time.createTimeSec(120.0).multiply(n4));
        if (bl) {
            n2 += n4;
        } else {
            n2 += 2;
            ++n;
        }
        AtmCalList atmCalList = new AtmCalList();
        ObservingTimeCalculator.getAtmCalsForScienceTargetsForSB(true, atmCalList, schedBlock);
        long l = atmCalList.getTotalNumberOfAtmCals();
        time.aggregate((Time)ATM_CAL_TIME.multiply(l));
        time2.aggregate((Time)SCAN_LATENCY.multiply(l * 2L, true));
        time2.aggregate((Time)SCAN_LATENCY.multiply(n));
        time2.aggregate((Time)((Time)SCAN_LATENCY.multiply(n2)).multiply(2.0));
        Log.logger(ObservingTimeCalculator.class).fine("Total intrasource overhead for group one is " + SCAN_LATENCY.multiply(n) + " for " + n + " calibrations");
        Log.logger(ObservingTimeCalculator.class).fine("Total intrasource overhead for all science groups is " + SCAN_LATENCY.multiply(n2) + " for " + n2 + " calibrations");
        time.aggregate(time2);
        return time;
    }

    private int getNoOfPointingCalibrations(SBTimeEstimateHelper sBTimeEstimateHelper, ScienceGoal scienceGoal, SBTimeEstimateHelper.GroupType groupType, int n) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (groupType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observingGroup");
        }
        boolean bl = scienceGoal.getSpectralSetupParameters().isSpectralScan() || n > 1;
        String string = scienceGoal.getCalibrationSetupParameters().getSelection();
        switch (groupType) {
            case CALIBRATORS: {
                if (bl) {
                    return 0;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEM)) {
                    return 1;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
                    return 2;
                }
                return this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, groupType);
            }
            case SCIENCE: {
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEM)) {
                    return bl ? 2 : 1;
                }
                if (string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE)) {
                    return bl ? 3 : 1;
                }
                return this.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, groupType);
            }
        }
        throw new RuntimeException("observingGroup not recognised " + (Object)((Object)groupType));
    }

    private static Time getOnSourceOverheadsTime(SchedBlock schedBlock) throws InvalidObsProgramParametersException {
        Integer n = 0;
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            SBTimeEstimateHelper.GroupType groupType;
            try {
                groupType = SBTimeEstimateHelper.getGroupType(observingGroup.getName());
            }
            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
            }
            if (!groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) continue;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                    double d = scienceParameters.getSubScanDuration().getContentInDefaultUnits();
                    n = n + (int)Math.ceil(((IntTimeSource)scienceParameters.getIntegrationTime().divide(d)).getContent());
                }
            }
        }
        return (Time)((Time)SUBSCAN_LATENCY.multiply(n.intValue())).plus((AbstractDoubleWithUnit)SB_EXEC_OVERHEAD);
    }

    public static Time getTotalTOSTimeForSB(SchedBlock schedBlock, boolean bl) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Time time = Time.createTimeSec(0.0);
        time.aggregate(ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
        if (!bl) {
            time = (Time)time.multiply(schedBlock.getSchedBlockControl().getExecutionCount());
        }
        return time;
    }

    public static Time getExecutionTimeForSB(SchedBlock schedBlock, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Time time = Time.createTimeSec(0.0);
        time.aggregate(ObservingTimeCalculator.getCalibrationTimesEstimateFromSB(schedBlock, scienceGoal));
        time.aggregate(ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
        time.aggregate(ObservingTimeCalculator.getOnSourceOverheadsTime(schedBlock));
        if (Log.logger(ObservingTimeCalculator.class).fine()) {
            Log.logger(ObservingTimeCalculator.class).fine("Execution time (mins) for a single SB execution is : " + time.getContentInUnits(Time.UNIT_MIN));
            Log.logger(ObservingTimeCalculator.class).fine("Calibration times : " + ObservingTimeCalculator.getCalibrationTimesEstimateFromSB(schedBlock, scienceGoal));
            Log.logger(ObservingTimeCalculator.class).fine("On-source time : " + ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
            Log.logger(ObservingTimeCalculator.class).fine("Total on source time : " + ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution().multiply(schedBlock.getSchedBlockControl().getExecutionCount()));
            Log.logger(ObservingTimeCalculator.class).fine("On-source overheads : " + ObservingTimeCalculator.getOnSourceOverheadsTime(schedBlock));
            Log.logger(ObservingTimeCalculator.class).fine("Total calculated SB execution time is : " + time.multiply(schedBlock.getSchedBlockControl().getExecutionCount()));
        }
        return (Time)time.multiply(schedBlock.getSchedBlockControl().getExecutionCount());
    }

    public int getSBExecutionCount(Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        this.generateSBs(this.scienceGoal);
        ObsUnitSet obsUnitSet = this.obsUnitSet.getObsUnitSet(0).getObsUnitSet(0);
        block4: for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            switch (array) {
                case ARRAY_12M: {
                    if (!schedBlock.is12mExtendedArraySB()) continue block4;
                    return schedBlock.getSchedBlockControl().getExecutionCount();
                }
                case ARRAY_7M: {
                    if (!schedBlock.isACA7mArraySB()) continue block4;
                    return schedBlock.getSchedBlockControl().getExecutionCount();
                }
            }
            throw new RuntimeException("Unable to process array type " + (Object)((Object)array));
        }
        return 0;
    }

    public DataRate getAverageDataRate(Array array) throws UnableToDetermineInstantaneousDataRateException {
        try {
            boolean bl = array.equals((Object)Array.ARRAY_12M);
            Time time = this.getTotalRequestedTime(array, true, false, false);
            Time time2 = this.getTotalRequestedTime(array, true, false, true);
            if (bl) {
                time.aggregate(this.getTotalRequestedTime(array, true, true, false));
                time2.aggregate(this.getTotalRequestedTime(array, true, true, true));
            }
            DataRate dataRate = this.getPeakDataRate(array, false);
            DataRate dataRate2 = (DataRate)((DataRate)dataRate.multiply(time.getSecs())).divide(time2.getSecs());
            double d = dataRate2.getContentInUnits(DataRate.UNIT_MB_S);
            if (this.scienceGoal.getSpectralSetupParameters().isWalshSwitching() && d > AlmaPolicies.getInstance().getWarningDataRateMBPS()) {
                dataRate = this.getPeakDataRate(array, true);
                dataRate2 = (DataRate)((DataRate)dataRate.multiply(time.getSecs())).divide(time2.getSecs());
            }
            Log.logger(ObservingTimeCalculator.class).fine(String.format("Average data rate for %s is %s (peak %s). Data taking time %s (total requested time %s)", new Object[]{StringUtils.trim((String)array.toString()), dataRate2, dataRate, time, time2}));
            return dataRate2;
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to calculate the average data rate " + invalidObsProgramParametersException.getMessage());
            return DataRate.createDataRate();
        }
    }

    public List<DataRate> getInstantaneousDataRates(RequestedArray requestedArray) throws UnableToDetermineInstantaneousDataRateException {
        List list;
        ImmutableSet immutableSet;
        ObsUnitSet obsUnitSet;
        ArrayList<DataRate> arrayList = new ArrayList<DataRate>();
        if (this.scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        try {
            obsUnitSet = this.generateSBs(this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToDetermineInstantaneousDataRateException(invalidObsProgramParametersException);
        }
        switch (requestedArray) {
            case SEVEN_M: {
                ImmutableSet immutableSet2 = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.ACA7M));
                throw new RuntimeException("The 7-m is not supported");
            }
            case TP: {
                ImmutableSet immutableSet3 = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE));
                throw new RuntimeException("TP is not supported");
            }
            case TWELVE_M: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION), (Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected array type : " + (Object)((Object)requestedArray));
            }
        }
        assert (immutableSet != null);
        try {
            list = obsUnitSet.findSchedBlocks().stream().filter(arg_0 -> ObservingTimeCalculator.lambda$getInstantaneousDataRates$109((Set)immutableSet, arg_0)).collect(Collectors.toList());
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new UnableToDetermineInstantaneousDataRateException((Exception)((Object)unknownEntityException));
        }
        for (SchedBlock schedBlock : list) {
            for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
                abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, RequestedArray.TWELVE_M.getControlBlockArray());
                arrayList.add(spectralSpec.getInstantaneousDataRate());
            }
        }
        return arrayList;
    }

    private static /* synthetic */ boolean lambda$getInstantaneousDataRates$109(Set set, SchedBlock schedBlock) {
        return set.contains((Object)schedBlock.getSbGenerationContext().getSBType());
    }

    public static class Builder {
        private ScienceGoal scienceGoal;
        private double beamsize_factor = 0.0;
        private ObsUnitSet obsUnitSet;
        private boolean noSBGeneration = false;

        public Builder scienceGoal(ScienceGoal scienceGoal) {
            this.scienceGoal = scienceGoal;
            return this;
        }

        public Builder noSBGeneration(boolean bl) {
            this.noSBGeneration = bl;
            return this;
        }

        public Builder beamsize_factor(double d) {
            this.beamsize_factor = d;
            return this;
        }

        public Builder obsUnitSet(ObsUnitSet obsUnitSet) {
            this.obsUnitSet = obsUnitSet;
            return this;
        }

        public ObservingTimeCalculator build() {
            return new ObservingTimeCalculator(this);
        }
    }

    private static class TimeOnSourceData {
        private SchedBlock schedBlock;
        private Integer noOfSBExecutions;
        private Map<String, Time> onSourceTimePerObservingGroup = new HashMap<String, Time>(30);

        public TimeOnSourceData(SchedBlock schedBlock, Integer n) {
            this.schedBlock = schedBlock;
            this.setNoOfSBExecutions(n);
        }

        public void addTimeOnSourceForObservingGroup(String string, Time time) {
            this.onSourceTimePerObservingGroup.put(string, time);
        }

        public Time getTimeOnSourceForObservingGroup(String string) throws SBTimeEstimateHelper.UnknownObservingGroupTypeException {
            if (!this.onSourceTimePerObservingGroup.containsKey(string)) {
                throw new SBTimeEstimateHelper.UnknownObservingGroupTypeException("Unknown OG " + string + " found ");
            }
            return this.onSourceTimePerObservingGroup.get(string);
        }

        public SchedBlock getSchedBlock() {
            return this.schedBlock;
        }

        public Time getTimeOnSourcePerSBExecution() {
            Time time = Time.createTimeSec(0.0);
            for (Time time2 : this.onSourceTimePerObservingGroup.values()) {
                time.aggregate(time2);
            }
            return time;
        }

        public Integer getNoOfSBExecutions() {
            return this.noOfSBExecutions;
        }

        public String toString() {
            return new String("Time on source per SB exec is " + this.getTimeOnSourcePerSBExecution() + " no of SB execs is " + this.getNoOfSBExecutions());
        }

        public void setNoOfSBExecutions(Integer n) {
            this.noOfSBExecutions = n;
        }
    }

    public static class TimeSummary {
        private Long numExec = 0L;
        private final CalType type;
        private Time time = Time.createTimeSec(0.0);
        private boolean atmCalIncluded = false;
        private boolean isStandardSystemCalibrationStrategyUsed = false;

        public TimeSummary(CalType calType) {
            this.type = calType;
        }

        public void addTime(Time time) {
            this.time.aggregate(time);
        }

        public Time getTotalTime() {
            return this.time.deepCopy();
        }

        public CalType getType() {
            return this.type;
        }

        public void addNumExec(Long l) {
            this.numExec = this.numExec + l;
        }

        public Long getNumExec() {
            return this.numExec;
        }

        public void setAtmCalIncluded() {
            this.atmCalIncluded = true;
        }

        public boolean isAtmCalIncluded() {
            return this.atmCalIncluded;
        }

        public String toString() {
            return "Caltype =  " + (Object)((Object)this.getType()) + "Time to execute " + this.time + " Num of execs = " + this.numExec;
        }

        public boolean isStandardSystemCalibrationStrategyUsed() {
            return this.isStandardSystemCalibrationStrategyUsed;
        }

        public void setStandardSystemCalibrationStrategyUsed(boolean bl) {
            this.isStandardSystemCalibrationStrategyUsed = bl;
        }
    }

    public class UnableToCalculateTimeEstimateException
    extends Exception {
        public UnableToCalculateTimeEstimateException(String string) {
            super(string);
        }

        public UnableToCalculateTimeEstimateException(Exception exception) {
            super(exception);
        }
    }

    public static enum Overheads {
        CALIBRATIONEXECTIMES,
        ONSOURCEOVERHEADS,
        CALIBRATIONOVERHEADS,
        CALIBRATIONSLEWTIME;

    }

    private static class AtmCalList
    extends ArrayList<AtmCalsForSB> {
        private AtmCalList() {
        }

        public long getTotalNumberOfAtmCals() {
            long l = 0L;
            for (AtmCalsForSB atmCalsForSB : this) {
                l += atmCalsForSB.getTotalNumberOfAtmCals();
            }
            return l;
        }

        public Time getTotalAmountOfTimeForAmtCals() {
            Time time = Time.createTimeSec(0.0);
            for (AtmCalsForSB atmCalsForSB : this) {
                time.aggregate(atmCalsForSB.getTotalAmountOfAtmCalTime());
            }
            return time;
        }
    }

    private static class AtmCalsForSB {
        final List<Long> atmCals = new ArrayList<Long>();
        int sbExecutionCount = 0;

        private AtmCalsForSB() {
        }

        final void setSbExecutionCount(int n) {
            this.sbExecutionCount = n;
        }

        public void add(long l) {
            this.atmCals.add(l);
        }

        public long getTotalNumberOfAtmCals() {
            if (this.sbExecutionCount == 0) {
                throw new IllegalArgumentException("Illegal argument: sbExecutionCount  (" + this.sbExecutionCount + ") " + "did not pass the test: sbExecutionCount  == 0");
            }
            long l = 0L;
            for (Long l2 : this.atmCals) {
                l += l2.longValue();
            }
            Log.logger(AtmCalList.class).fine("Total number of atm cals for science targets is: " + (l *= (long)this.sbExecutionCount));
            return l;
        }

        public Time getTotalAmountOfAtmCalTime() {
            if (this.sbExecutionCount == 0) {
                throw new IllegalArgumentException("Illegal argument: sbExecutionCount  (" + this.sbExecutionCount + ") " + "did not pass the test: sbExecutionCount  == 0");
            }
            Time time = Time.createTimeSec(0.0);
            time.aggregate((Time)ATM_CAL_TIME.multiply(this.getTotalNumberOfAtmCals()));
            Log.logger(AtmCalList.class).fine("Total amount of atm cal time for science targets: " + time);
            return time;
        }
    }

    public class UnableToDetermineCorrelatorIntegrationTimeException
    extends Exception {
        public UnableToDetermineCorrelatorIntegrationTimeException(String string) {
            super(string);
        }
    }

    public class UnableToDetermineInstantaneousDataRateException
    extends Exception {
        public UnableToDetermineInstantaneousDataRateException(Exception exception) {
            super(exception);
        }
    }
}

