/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculatorInterface;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SchedBlockObservingTimeCalculator
implements ObservingTimeCalculatorInterface {
    private final ScienceGoal scienceGoal;
    private Collection<ScienceGoal> scienceGoalsWithClusters;
    private Map<ScienceGoal, ObservingTimeCalculator> otcMap = new HashMap<ScienceGoal, ObservingTimeCalculator>();

    public Collection<ScienceGoal> getScienceGoalsWithClusters() {
        return this.scienceGoalsWithClusters;
    }

    public SchedBlockObservingTimeCalculator(Builder builder) throws InvalidObsProgramParametersException {
        assert (builder.scienceGoal != null);
        this.scienceGoal = builder.scienceGoal;
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(this.scienceGoal);
        this.scienceGoalsWithClusters = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        assert (this.scienceGoalsWithClusters != null && this.scienceGoalsWithClusters.size() > 0);
        for (ScienceGoal scienceGoal : this.scienceGoalsWithClusters) {
            this.otcMap.put(scienceGoal, new ObservingTimeCalculator(scienceGoal));
        }
        assert (this.otcMap.size() > 0);
    }

    @Override
    public Time getTotalTimeForScienceGoal(Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getTotalTimeForScienceGoal(bl, bl2, bl3, bl4));
        }
        return time;
    }

    @Override
    public Time getTotalTimeForScienceGoal(Boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTotalTimeForScienceGoal(false, bl, false, true);
    }

    @Override
    public Time getCalibrationExecutionTimeStats(Boolean bl, Array array, TargetParameters targetParameters, boolean bl2) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getCalibrationExecutionTimeStats(bl, array, targetParameters, bl2));
        }
        return time;
    }

    @Override
    public DataRate getPeakDataRate(Array array, boolean bl) throws ObservingTimeCalculator.UnableToDetermineInstantaneousDataRateException {
        DataRate dataRate = DataRate.createDataRate();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            dataRate.aggregate(observingTimeCalculator.getPeakDataRate(array, false));
        }
        return dataRate;
    }

    @Override
    public StorageVolume getDataVolume(Array array) throws InvalidObsProgramParametersException, ToBeSupportedException {
        StorageVolume storageVolume = StorageVolume.createStorageVolume();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            storageVolume.aggregate(observingTimeCalculator.getDataVolume(array));
        }
        return storageVolume;
    }

    @Override
    public Time getOnSourceOverheadsTime(Boolean bl, Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getOnSourceOverheadsTime(bl, array));
        }
        return time;
    }

    @Override
    public Time getOnTheoreticalOnSourceTimeForArray(Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getOnTheoreticalOnSourceTimeForArray(array));
        }
        return time;
    }

    @Override
    public Time getOverheadTimeForCalObs() {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getOverheadTimeForCalObs());
        }
        return time;
    }

    @Override
    public Time getOverheadTimes(Boolean bl, EnumSet<ObservingTimeCalculator.Overheads> enumSet, Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getOverheadTimes(bl, enumSet, array, targetParameters));
        }
        return time;
    }

    @Override
    public Time getRequestedTimeForAllConfigurations(Array array, boolean bl) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getRequestedTimeForAllConfigurations(array, true));
        }
        return time;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl) throws InvalidObsProgramParametersException {
        Time time2 = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time2.aggregate(observingTimeCalculator.getTimeForSecond12mCompactArray(time, bl));
        }
        return time2;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        Time time2 = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time2.aggregate(observingTimeCalculator.getTimeForSecond12mCompactArray(time, bl, bl2));
        }
        return time2;
    }

    public Time getTotal12mExtendedArraySBScienceIntegrationTime(Boolean bl, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        return this.getTotalExtendedArraySBScienceIntegrationTime(bl, scienceGoal, Array.ARRAY_12M);
    }

    public Time getTotalExtendedArraySBScienceIntegrationTime(Boolean bl, ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        assert (this.otcMap != null);
        ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
        assert (observingTimeCalculator != null);
        return observingTimeCalculator.getTotalArraySBScienceIntegrationTime(bl, array);
    }

    @Override
    public Time getTotalOnSourceTime(Array array, boolean bl) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getTotalOnSourceTime(array, bl));
        }
        return time;
    }

    @Override
    public Time getTotalRequestedTime(Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getTotalRequestedTime(array));
        }
        return time;
    }

    public Time getTotalRequestedTime(Array array, boolean bl, boolean bl2, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument sgCluster cannot be null");
        }
        Time time = Time.createTime();
        assert (this.otcMap != null);
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Clustered science goal not found");
        }
        ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
        assert (observingTimeCalculator != null);
        time.aggregate(observingTimeCalculator.getTotalRequestedTime(array, bl, bl2, true));
        return time;
    }

    @Override
    public boolean isSBToBeExecutedUsingSessions() {
        Iterator<ScienceGoal> iterator = this.otcMap.keySet().iterator();
        if (iterator.hasNext()) {
            ScienceGoal scienceGoal = iterator.next();
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            return observingTimeCalculator.isSBToBeExecutedUsingSessions();
        }
        throw new IllegalArgumentException("Unable to find an OTC to use");
    }

    public Time getTotalTimeForScienceGoal(ScienceGoal scienceGoal, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalTimeForScienceGoal(bl, bl2, bl3, bl4);
    }

    public Time getTotalTimeForScienceGoal(ScienceGoal scienceGoal, Boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalTimeForScienceGoal(bl);
    }

    public Time getCalibrationExecutionTimeStats(ScienceGoal scienceGoal, Boolean bl, Array array, TargetParameters targetParameters, boolean bl2) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getCalibrationExecutionTimeStats(bl, array, targetParameters, bl2);
    }

    public StorageVolume getDataVolume(ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException, ToBeSupportedException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getDataVolume(array);
    }

    public Time getOnSourceOverheadsTime(ScienceGoal scienceGoal, Boolean bl, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOnSourceOverheadsTime(bl, array);
    }

    public Time getOnSourceTimeFor12mExtendedConfiguration(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOnTheoreticalOnSourceTimeForArray(Array.ARRAY_12M);
    }

    public Time getOverheadTimeForCalObs(ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOverheadTimeForCalObs();
    }

    public Time getOverheadTimes(ScienceGoal scienceGoal, Boolean bl, EnumSet<ObservingTimeCalculator.Overheads> enumSet, Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOverheadTimes(bl, enumSet, array, targetParameters);
    }

    public Time getRequestedTimeForAllConfigurations(ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getRequestedTimeForAllConfigurations(array, true);
    }

    public Time getTimeForSecond12mCompactArray(ScienceGoal scienceGoal, Time time, boolean bl) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTimeForSecond12mCompactArray(time, bl);
    }

    public Time getTimeForSecond12mCompactArray(ScienceGoal scienceGoal, Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTimeForSecond12mCompactArray(time, bl, bl2);
    }

    public Map<CalType, ObservingTimeCalculator.TimeSummary> getTimeSummary(ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getCalibrationTimeSummary();
    }

    public Time getTotalArraySBScienceIntegrationTime(ScienceGoal scienceGoal, Boolean bl, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalArraySBScienceIntegrationTime(bl, array);
    }

    public Time getTotalOnSourceTime(ScienceGoal scienceGoal, Array array, boolean bl) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalOnSourceTime(array, bl);
    }

    public Time getTotalRequestedTime(ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalRequestedTime(array);
    }

    public Time getTotalRequestedTime(ScienceGoal scienceGoal, Array array, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalRequestedTime(array, bl, bl2, true);
    }

    public Time singlePointOnSourceTime(ScienceGoal scienceGoal, Array array, TargetParameters targetParameters, boolean bl) throws InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).singlePointOnSourceTime(array, targetParameters, bl);
    }

    public Time singlePointOnSourceTimeFromSB(ScienceGoal scienceGoal, TargetParameters targetParameters, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).singlePointOnSourceTimeFromSB(targetParameters, array);
    }

    @Override
    public Time adjustForFullPolarization(Time time) {
        Iterator<ScienceGoal> iterator = this.otcMap.keySet().iterator();
        if (iterator.hasNext()) {
            ScienceGoal scienceGoal = iterator.next();
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
            return observingTimeCalculator.adjustForFullPolarization(time);
        }
        throw new IllegalArgumentException("Unable to find an OTC to use");
    }

    public int getSBExecutionCount(ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getSBExecutionCount(array);
    }

    public int getWaterVapourContentUsed(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getWaterVapourContentUsed();
    }

    public int getNumRetunings(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getNumRetunings();
    }

    public int getNumberOfAntennaConfigurations(ScienceGoal scienceGoal, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument scienceGoalForCluster cannot be null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Science goal not found in map");
        }
        return this.otcMap.get(scienceGoal).getNumberOfAntennaConfigurations(requestedArray);
    }

    @Override
    public Time getTotalRequestedTime(Array array, Boolean bl, Boolean bl2, Boolean bl3) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        for (ScienceGoal scienceGoal : this.otcMap.keySet()) {
            time.aggregate(this.otcMap.get(scienceGoal).getTotalRequestedTime(array, bl, bl2, bl3));
        }
        return time;
    }

    public static class Builder {
        private ScienceGoal scienceGoal;

        public Builder scienceGoal(ScienceGoal scienceGoal) {
            if (scienceGoal == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
            }
            this.scienceGoal = scienceGoal;
            return this;
        }

        public SchedBlockObservingTimeCalculator build() throws InvalidObsProgramParametersException {
            return new SchedBlockObservingTimeCalculator(this);
        }
    }
}

