/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.CompleteLinkageStrategy;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jsky.coords.WorldCoords;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class SourceClusterDetector {
    private static CacheAccess<Integer, Collection<ScienceGoal>> sourceClusterCache = JCS.getInstance((String)"sourceClusterCache");
    private ScienceGoal originalScienceGoal;

    public SourceClusterDetector(ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: primaryScienceGoal");
        }
        this.originalScienceGoal = scienceGoal;
    }

    public Collection<ScienceGoal> splitScienceGoalIntoSourceClusters() throws InvalidObsProgramParametersException {
        List<ScienceGoal> list;
        List<Set<TargetParameters>> list2;
        Object object;
        boolean bl = true;
        Object object2 = this.originalScienceGoal.getTargetParameters();
        int n = ((TargetParameters[])object2).length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            if (!object.getNonSiderealMotion()) continue;
            bl = false;
            break;
        }
        if ((object2 = this.getSiderealFieldCentresForAllSources(this.originalScienceGoal)).isEmpty()) {
            bl = false;
        }
        if (bl) {
            object = AlmaPolicies.getInstance();
            list2 = this.divideSourcesIntoClusters((List<ScienceGoal.SourcePoint>)object2, ((AlmaPolicies)object).getMaxConeDiameter());
            list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2);
            if (this.isLongBaselineScheduledInClusteredSGs(list)) {
                list2 = this.divideSourcesIntoClusters((List<ScienceGoal.SourcePoint>)object2, ((AlmaPolicies)object).getMaxConeDiameterLongBaseline());
                list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2);
            }
        } else {
            object = new HashSet<TargetParameters>(50);
            for (TargetParameters targetParameters : this.originalScienceGoal.getTargetParameters()) {
                object.add(targetParameters);
            }
            list2 = new ArrayList<Set<TargetParameters>>(50);
            list2.add((Set<TargetParameters>)object);
            list = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list2);
        }
        if (list != null && !list.isEmpty()) {
            for (ScienceGoal scienceGoal : list) {
                if (!this.originalScienceGoal.isStandAloneACA() || !scienceGoal.isStandAloneACA()) {
                    // empty if block
                }
                ScienceGoal.determineACAScheduling(scienceGoal);
            }
        }
        return list;
    }

    private boolean isLongBaselineScheduledInClusteredSGs(List<ScienceGoal> list) {
        if (list == null || list.isEmpty()) {
            throw new NullPointerException("Illegal argument. The argument cannot be null or empty : clusteredScienceGoals");
        }
        Optional<ScienceGoal> optional = list.stream().filter(scienceGoal -> scienceGoal.isStandAloneACA()).findFirst();
        if (optional.isPresent()) {
            return false;
        }
        return list.stream().filter(scienceGoal -> {
            try {
                return this.isLongBaselineScheduled((ScienceGoal)scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(SourceClusterDetector.class).warning("Unable to determine if science goal use a long baseline configuration " + invalidObsProgramParametersException.getMessage());
                return false;
            }
        }).findFirst().isPresent();
    }

    private boolean isLongBaselineScheduled(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (scienceGoal.isStandAloneACA()) {
            return false;
        }
        ConfigurationSet configurationSet = Configuration.getConfigurationsToBeScheduled(scienceGoal).getConfigurationRequiringMostTime(RequestedArray.TWELVE_M);
        return configurationSet.getTM1Configuration().map(configuration -> configuration.isLongBaselineConfiguration()).orElse(false);
    }

    private List<ScienceGoal.SourcePoint> getSiderealFieldCentresForAllSources(ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: originalScienceGoal2");
        }
        ArrayList<ScienceGoal.SourcePoint> arrayList = new ArrayList<ScienceGoal.SourcePoint>();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            if (targetParameters.getNonSiderealMotion()) continue;
            if (targetParameters.isPointingPattern()) {
                PointingPatternI pointingPatternI = targetParameters.getPointingPattern();
                assert (pointingPatternI.getPhaseCenterCoordinatesCount() > 0);
                SkyCoordinates skyCoordinates = pointingPatternI.getPhaseCenterCoordinates(0);
                SkyPoint skyPoint = targetParameters.isAbsolutePointingPattern() ? skyCoordinates.getAbsoluteSkyPointInICRSDeg() : skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates()).getAbsoluteSkyPointInICRSDeg();
                arrayList.add(new ScienceGoal.SourcePoint(targetParameters, skyPoint));
            } else {
                arrayList.add(new ScienceGoal.SourcePoint(targetParameters, targetParameters.getFieldCenterCoordinates().getAbsoluteSkyPointInICRSDeg()));
            }
            assert (!arrayList.isEmpty());
        }
        return arrayList;
    }

    private synchronized List<ScienceGoal> groupSpatiallyAdjacentSourcesIntoScienceGoals(List<Set<TargetParameters>> list) {
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>(30);
        if (list == null) {
            throw new NullPointerException("Illegal argument - the argument clustersOfSpatiallyAdjacentSources cannot be null");
        }
        if (this.originalScienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument scienceGoal cannot be null");
        }
        PerformanceParameters performanceParameters = this.originalScienceGoal.getPerformanceParameters();
        if (list.size() == 1) {
            ScienceGoal scienceGoal = this.originalScienceGoal.deepCopy();
            scienceGoal.getSpectralSetupParameters().setRepresentativeFrequency(this.originalScienceGoal.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setRepresentativeFrequency(performanceParameters.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setDesiredSensitivityReferenceFrequencyWidth(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().deepCopy());
            scienceGoal.setObsUnitSet(null);
            arrayList.add(scienceGoal);
            return arrayList;
        }
        assert (list.size() > 1);
        int n = 1;
        for (Set<TargetParameters> set : list) {
            ScienceGoal scienceGoal = this.originalScienceGoal.deepCopy();
            scienceGoal.setObsUnitSet(null);
            scienceGoal.setSchedBlockExpert(null);
            scienceGoal.getSpectralSetupParameters().setRepresentativeFrequency(this.originalScienceGoal.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setRepresentativeFrequency(performanceParameters.getRepresentativeFrequency().deepCopy());
            scienceGoal.getPerformanceParameters().setDesiredSensitivityReferenceFrequencyWidth(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().deepCopy());
            scienceGoal.setName(this.originalScienceGoal.getName() + " cluster " + n);
            TargetParameters[] targetParametersArray = new TargetParameters[set.size()];
            set.toArray(targetParametersArray);
            TargetParameters targetParameters = this.originalScienceGoal.getKeyTargetParameters();
            assert (targetParametersArray.length > 0);
            for (int i = 0; i < targetParametersArray.length; ++i) {
                TargetParameters targetParameters2 = targetParametersArray[i];
                if (!targetParameters2.equals(targetParameters)) continue;
                if (i == 0) break;
                TargetParameters targetParameters3 = targetParametersArray[0];
                targetParametersArray[0] = targetParameters;
                targetParametersArray[i] = targetParameters3;
                break;
            }
            TargetParameters[] targetParametersArray2 = new TargetParameters[targetParametersArray.length];
            for (int i = 0; i < targetParametersArray.length; ++i) {
                targetParametersArray2[i] = targetParametersArray[i].deepCopy();
            }
            scienceGoal.setTargetParameters(targetParametersArray2);
            scienceGoal.setKeyTargetParameters(0);
            scienceGoal.setClusterIndex(n++);
            arrayList.add(scienceGoal);
        }
        assert (arrayList.size() > 0);
        return arrayList;
    }

    private List<Set<TargetParameters>> divideSourcesIntoClusters(List<ScienceGoal.SourcePoint> list, Angle angle) throws InvalidObsProgramParametersException {
        Cloneable cloneable;
        Object object;
        if (list == null) {
            throw new NullPointerException("Illegal argument - the argument allSiderealSkyPointsInSG cannot be null");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: allSiderealSkyPointsInSG.size() (" + list.size() + ") " + "did not pass the test: allSiderealSkyPointsInSG.size() == 0");
        }
        String[] stringArray = new String[list.size()];
        double[][] dArray = new double[list.size()][list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i).getSkyPoint();
            for (int j = 0; j < list.size(); ++j) {
                cloneable = list.get(j).getSkyPoint();
                dArray[i][j] = WorldCoords.dist((double)((SkyPoint)object).getX(), (double)((SkyPoint)object).getY(), (double)((SkyPoint)cloneable).getX(), (double)((SkyPoint)cloneable).getY()) / 60.0;
            }
            stringArray[i] = list.get(i).getTargetParameters().getSourceName();
        }
        DefaultClusteringAlgorithm defaultClusteringAlgorithm = new DefaultClusteringAlgorithm();
        try {
            object = defaultClusteringAlgorithm.performClustering(dArray, stringArray, new CompleteLinkageStrategy());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObsProgramParametersException("Unable to execute the source clustering algorithm : " + illegalArgumentException.getMessage());
        }
        assert (object != null);
        cloneable = new ArrayList(10);
        return this.groupOutputOfClusteringAlgorithm((List<Set<TargetParameters>>)((Object)cloneable), (Cluster)object, angle);
    }

    private List<Set<TargetParameters>> groupOutputOfClusteringAlgorithm(List<Set<TargetParameters>> list, Cluster cluster, Angle angle) {
        double d = angle.getContentInUnits(Angle.UNIT_DEG);
        double d2 = cluster.getMaxDistance();
        Log.logger(SourceClusterDetector.class).fine("Cluster maximum distance : " + d2);
        if (d2 > d) {
            for (Cluster cluster2 : cluster.getChildren()) {
                this.groupOutputOfClusteringAlgorithm(list, cluster2, angle);
            }
        } else {
            TargetParameters[] targetParametersArray = this.originalScienceGoal.getTargetParameters();
            assert (targetParametersArray != null && targetParametersArray.length > 0);
            HashSet<TargetParameters> hashSet = new HashSet<TargetParameters>();
            list.add(this.addTargetParametersToSourceCluster(targetParametersArray, hashSet, cluster));
        }
        return list;
    }

    private Set<TargetParameters> addTargetParametersToSourceCluster(TargetParameters[] targetParametersArray, Set<TargetParameters> set, Cluster cluster) {
        boolean bl = false;
        if (cluster.getChildren().size() == 0) {
            for (TargetParameters targetParameters : targetParametersArray) {
                if (!targetParameters.getSourceName().equals(cluster.getName())) continue;
                set.add(targetParameters);
                bl = true;
                break;
            }
            if (!bl) {
                throw new WizardSBGenerationException("Unable to locate target parameters in cluster tree");
            }
        }
        for (Cluster cluster2 : cluster.getChildren()) {
            this.addTargetParametersToSourceCluster(targetParametersArray, set, cluster2);
        }
        return set;
    }
}

